/*
 * Decompiled with CFR 0.152.
 */
package thread;

import control.SRSOutput;
import gui.Gui_TablePanel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import misc.Stream;

public class Thread_UpdateName
extends Thread {
    private String i = "";
    private Stream stream;
    private int row;
    private Gui_TablePanel tablePanel;
    private Boolean isDead = false;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Process streamProcess;
    private BufferedReader b;
    private BufferedReader c;

    public Thread_UpdateName(Stream astream, int arow, Gui_TablePanel tablePanel) {
        this.stream = astream;
        this.row = arow;
        this.tablePanel = tablePanel;
    }

    public void killMe() {
        SRSOutput.getInstance().log("Kill update names in cells for stream: " + this.stream.name);
        this.isDead = true;
    }

    @Override
    public void run() {
        this.streamProcess = this.stream.getProcess();
        if (!this.isDead.booleanValue() && this.streamProcess != null) {
            try {
                boolean streamG = false;
                boolean serverG = false;
                boolean bitrateG = false;
                boolean metaG = false;
                String[] metaData = new String[]{"-", "-", "-", "-"};
                this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("receivMeta"), this.row, true);
                this.b = new BufferedReader(new InputStreamReader(this.streamProcess.getInputStream()));
                this.c = new BufferedReader(new InputStreamReader(this.streamProcess.getErrorStream()));
                while (!(this.isDead.booleanValue() || streamG && serverG && bitrateG && metaG || this.streamProcess == null)) {
                    this.testErrorstream();
                    String tmpo = this.b.readLine();
                    if (tmpo == null) {
                        this.isDead = true;
                        continue;
                    }
                    if ((tmpo = tmpo.toLowerCase()).startsWith("error") && !this.isDead.booleanValue()) {
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(tmpo, this.row, true);
                        int sleepTime = 0;
                        while (!this.isDead.booleanValue() && sleepTime <= 8000) {
                            Thread.sleep(100L);
                            sleepTime += 100;
                        }
                        this.isDead = true;
                    }
                    if (tmpo.startsWith("connecting") && !this.isDead.booleanValue()) {
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("connecting"), this.row, true);
                    }
                    if (tmpo.startsWith("stream:") && !this.isDead.booleanValue()) {
                        metaData[0] = tmpo.substring(7).trim();
                        streamG = true;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("streamReceived"), this.row, true);
                    }
                    if (tmpo.startsWith("server name") && !this.isDead.booleanValue()) {
                        metaData[1] = tmpo.substring(12).trim();
                        serverG = true;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("serverNameReceived"), this.row, true);
                    }
                    if (tmpo.contains("bitrate:") && !tmpo.startsWith("server name") && !this.isDead.booleanValue()) {
                        metaData[2] = String.valueOf(tmpo.substring(8).replace("bitrate", "").replace(":", "").trim()) + " kbit/s";
                        bitrateG = true;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("bitrateReceived"), this.row, true);
                    }
                    if (tmpo.startsWith("meta interval:") && !this.isDead.booleanValue()) {
                        metaData[3] = tmpo.substring(14).trim();
                        metaG = true;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("metaIntervallReceived"), this.row, true);
                    }
                    if (tmpo.startsWith("[skipping") && !this.isDead.booleanValue()) {
                        metaG = true;
                        streamG = true;
                        bitrateG = true;
                        serverG = true;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("skipBefore"), this.row, true);
                    }
                    if (!tmpo.startsWith("[ripping") || this.isDead.booleanValue()) continue;
                    metaG = true;
                    streamG = true;
                    bitrateG = true;
                    serverG = true;
                }
                this.stream.setMetaData(metaData);
                while (!this.isDead.booleanValue() && this.stream.getProcess() != null && (this.i = this.b.readLine()) != null) {
                    this.testErrorstream();
                    if (!this.stream.name.equals(this.tablePanel.getNameFromRow(this.row))) {
                        int row2 = this.tablePanel.getNewRowForNameForUpdate(this.stream.name);
                        this.tablePanel.setSelectedCurrentNameCellAndTitle("", this.row, false);
                        this.row = row2;
                    }
                    if (this.i.startsWith("Time to stop")) {
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.i, this.row, true);
                        continue;
                    }
                    if (this.i.startsWith("[ripping...")) {
                        if (this.i.length() < 17) continue;
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.i.substring(17), this.row, true);
                        continue;
                    }
                    if (this.i.startsWith("[buffering")) {
                        this.tablePanel.setSelectedCurrentNameCellAndTitle(this.trans.getString("buffering"), this.row, true);
                        continue;
                    }
                    if (!this.i.startsWith("[skipping") || this.i.length() < 16) continue;
                    this.tablePanel.setSelectedCurrentNameCellAndTitle(this.i.substring(16), this.row, true);
                }
            }
            catch (IOException e) {
                SRSOutput.getInstance().logE("Controlled IOException: " + e.getMessage());
                this.stream.setStatus(false);
            }
            catch (InterruptedException f) {
                SRSOutput.getInstance().logE("Controlled InterruptedException: " + f.getMessage());
                this.stream.setStatus(false);
            }
        }
        if (this.stream.getStatus().booleanValue()) {
            this.stream.setStop(false);
        }
        this.tablePanel.setSelectedCurrentNameCellAndTitle("", this.row, false);
    }

    public void testErrorstream() {
        try {
            if (this.streamProcess.getErrorStream().available() != 0) {
                String tmpe;
                while ((tmpe = this.c.readLine()) != null && !this.isDead.booleanValue()) {
                    if (tmpe == null || this.isDead.booleanValue() || !tmpe.toLowerCase().startsWith("error")) continue;
                    this.tablePanel.setSelectedCurrentNameCellAndTitle(tmpe, this.row, true);
                    int sleepTime = 0;
                    while (!this.isDead.booleanValue() && sleepTime <= 8000) {
                        Thread.sleep(100L);
                        sleepTime += 100;
                    }
                    this.isDead = true;
                }
            }
        }
        catch (InterruptedException f) {
            SRSOutput.getInstance().logE(f.getMessage());
            this.stream.setStatus(false);
        }
        catch (IOException e) {
            SRSOutput.getInstance().logE(e.getMessage());
            this.stream.setStatus(false);
        }
    }
}

