/*
 * Decompiled with CFR 0.152.
 */
package thread;

import control.Control_GetPath;
import control.Control_Threads;
import control.SRSOutput;
import gui.Gui_StreamRipStar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import misc.SchedulJob;
import misc.Stream;

public class Thread_Control_Schedules
extends Thread {
    private Vector<SchedulJob> schedulVector = new Vector(0, 1);
    private Gui_StreamRipStar mainGui = null;
    private Boolean stop = false;
    private Boolean updateView = false;
    private Control_Threads controlThread = null;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");

    public Thread_Control_Schedules(Gui_StreamRipStar mainGui, Control_Threads controlThread) {
        this.mainGui = mainGui;
        this.controlThread = controlThread;
    }

    @Override
    public void run() {
        while (!this.controlThread.askForLoadingScheduls()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                SRSOutput.getInstance().logE("Error while waiting for starting the scheduls : Thread_Control_Scheduls");
            }
        }
        this.loadScheduleJobsOnStart();
        this.setNextTimeForAllJobs();
        this.startAllAtStartJobs();
        while (!this.stop.booleanValue()) {
            try {
                Calendar now = Calendar.getInstance();
                int i = 0;
                while (i < this.schedulVector.capacity()) {
                    SchedulJob job = this.schedulVector.get(i);
                    SRSOutput.getInstance().logD("For Job " + job.getSchedulID() + "\" :");
                    String date = DateFormat.getDateInstance(3).format(new Date(now.getTimeInMillis()));
                    String time = DateFormat.getTimeInstance(3).format(new Date(now.getTimeInMillis()));
                    SRSOutput.getInstance().logD("Now is: " + date + " - " + time);
                    SRSOutput.getInstance().logD("Starttime is: " + job.getStartTimeAsLocaleTime());
                    SRSOutput.getInstance().logD("Stoptime is: " + job.getStopTimeAsLocaleTime());
                    if (!(!job.isJobenabled() || job.getstatus() && !this.mainGui.getControlStream().getStreamByID(job.getStreamID()).getStatus().booleanValue() && this.mainGui.getControlStream().getStreamByID(job.getStreamID()).userStoppedRecording() || this.mainGui.getControlStream().getStreamByID(job.getStreamID()).getStatus().booleanValue() || job.getStartTime() > now.getTimeInMillis() || job.getStopTime() <= now.getTimeInMillis() || job.getJobCount() == 3)) {
                        SRSOutput.getInstance().logD("Thread Control Schedules: start ripping scheduled job");
                        Stream stream = this.mainGui.getControlStream().getStreamByID(job.getStreamID());
                        this.mainGui.startRippingUnselected(stream);
                        String message = String.valueOf(this.trans.getString("conSched.StreamStarted")) + " " + stream.name;
                        this.mainGui.showMessageInTray(message);
                        job.setStatus(true);
                    }
                    if (job.getStopTime() <= now.getTimeInMillis() && job.getstatus() && job.getJobCount() != 3) {
                        SRSOutput.getInstance().logD("Thread Control Schedules: stop recording job");
                        this.mainGui.stopRippingUnselected(this.mainGui.getControlStream().getStreamByID(job.getStreamID()), false);
                        this.calculateNextJobTime(job, false);
                        this.updateView = true;
                        this.saveScheduleVector();
                        job.setStatus(false);
                    }
                    if (job.isOnceJob().booleanValue() && job.getStopTime() <= now.getTimeInMillis() && !this.mainGui.getControlStream().getStreamByID(job.getStreamID()).getStatus().booleanValue()) {
                        SRSOutput.getInstance().logD("Thread Control Schedules: delete old job");
                        this.removeJobFromVector(job.getSchedulID());
                        String message = String.valueOf(this.trans.getString("conSched.StreamStopped")) + " " + this.mainGui.getControlStream().getStreamByID((int)job.getStreamID()).name;
                        this.mainGui.showMessageInTray(message);
                        this.saveScheduleVector();
                        this.updateView = true;
                    } else if (!job.isOnceJob().booleanValue() && !job.isAtStartJob() && (job.getStopTime() <= now.getTimeInMillis() || !this.mainGui.getControlStream().getStreamByID(job.getStreamID()).getStatus().booleanValue() && this.mainGui.getControlStream().getStreamByID(job.getStreamID()).userStoppedRecording())) {
                        SRSOutput.getInstance().logD("Thread Control Schedules: old job recognized - update it to next date");
                        this.calculateNextJobTime(job, true);
                        this.updateView = true;
                        this.saveScheduleVector();
                        this.mainGui.getControlStream().getStreamByID(job.getStreamID()).setStop(false);
                    }
                    ++i;
                }
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopScheduler() {
        this.stop = true;
    }

    public void addToSchedulVector(SchedulJob job) {
        this.schedulVector.add(job);
    }

    public void loadScheduleJobsOnStart() {
        GregorianCalendar gc = new GregorianCalendar();
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Scheduls.xml"), "UTF-8");
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Scheduls.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        int streamID = 0;
                        int schedulID = 0;
                        long startTime = 0L;
                        long stopTime = 0L;
                        int howOftenID = 0;
                        boolean enableJob = true;
                        String comment = "";
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (parser.getAttributeLocalName(i).equals("lastID")) {
                                SchedulJob.lastID = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("streamID")) {
                                streamID = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("schedulID")) {
                                schedulID = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("startTime")) {
                                startTime = this.mainGui.getDaylightChangeTimeCalculated().booleanValue() ? Long.valueOf(parser.getAttributeValue(i)) + (long)gc.get(16) : Long.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("stopTime")) {
                                stopTime = this.mainGui.getDaylightChangeTimeCalculated().booleanValue() ? Long.valueOf(parser.getAttributeValue(i)) + (long)gc.get(16) : Long.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("howOftenID")) {
                                howOftenID = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("enableJob")) {
                                enableJob = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("comment")) {
                                comment = parser.getAttributeValue(i);
                            }
                            ++i;
                        }
                        if (schedulID <= 0) break;
                        SchedulJob job = new SchedulJob(schedulID, streamID, startTime, stopTime, howOftenID, enableJob, comment);
                        this.schedulVector.add(job);
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Scheduls.xml");
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Vector<SchedulJob> getScheduleVector() {
        return this.schedulVector;
    }

    public SchedulJob getSchedulJobByID(int id) {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            if (this.schedulVector.get(i).getSchedulID() == id) {
                return this.schedulVector.get(i);
            }
            ++i;
        }
        return null;
    }

    public void removeJobFromVector(int id) {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            if (this.schedulVector.get(i).getSchedulID() == id) {
                this.schedulVector.remove(i);
                this.schedulVector.trimToSize();
                System.gc();
                break;
            }
            ++i;
        }
    }

    public void calculateNextJobTime(SchedulJob job, Boolean forceUpdate) {
        long nowMills = Calendar.getInstance().getTimeInMillis();
        long oldStartTime = job.getStartTime();
        long timeDiff = job.getStopTime() - job.getStartTime();
        boolean older = false;
        boolean newer = false;
        if (!job.isOnceJob().booleanValue()) {
            if (job.getStopTime() < nowMills) {
                forceUpdate = true;
            }
            if (job.getJobCount() == 0) {
                if (oldStartTime <= nowMills && forceUpdate.booleanValue()) {
                    older = false;
                    while (older || !newer) {
                        older = newer;
                        newer = (oldStartTime += 86400000L) > nowMills;
                    }
                    job.setStartTime(oldStartTime);
                    job.setStopTime(oldStartTime + timeDiff);
                }
            } else if (job.getJobCount() == 1 && oldStartTime <= nowMills && forceUpdate.booleanValue()) {
                older = false;
                while (older || !newer) {
                    older = newer;
                    newer = (oldStartTime += 604800000L) > nowMills;
                }
                job.setStartTime(oldStartTime);
                job.setStopTime(oldStartTime + timeDiff);
            }
        }
    }

    public void setNextTimeForAllJobs() {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            this.calculateNextJobTime(this.schedulVector.get(i), false);
            ++i;
        }
    }

    public void setUpdateView(Boolean update) {
        this.updateView = update;
    }

    public Boolean shouldUpdate() {
        return this.updateView;
    }

    public Boolean jobStillExist(int ID) {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            if (this.schedulVector.get(i).getSchedulID() == ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void deleteAllJobsFromStream(int id) {
        int i = this.schedulVector.capacity() - 1;
        while (i >= 0) {
            if (this.schedulVector.get(i).getStreamID() == id) {
                this.schedulVector.remove(i);
            }
            --i;
        }
        this.schedulVector.trimToSize();
        System.gc();
    }

    private void startAllAtStartJobs() {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            if (this.schedulVector.get(i).getJobCount() == 3 && this.schedulVector.get(i).isJobenabled()) {
                Stream stream = this.mainGui.getControlStream().getStreamByID(this.schedulVector.get(i).getStreamID());
                this.mainGui.startRippingUnselected(stream);
                String message = String.valueOf(this.trans.getString("conSched.StreamStarted")) + " " + stream.name;
                this.mainGui.showMessageInTray(message);
                this.schedulVector.get(i).setStatus(true);
            }
            ++i;
        }
    }

    public void saveScheduleVector() {
        GregorianCalendar gc = new GregorianCalendar();
        String savePath = new Control_GetPath().getStreamRipStarPath();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(new FileOutputStream(String.valueOf(savePath) + "/Scheduls.xml"), "UTF-8");
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            StartDocument header = eventFactory.createStartDocument();
            StartElement startRootSettings = eventFactory.createStartElement("", "", "SchdedulJobs");
            Attribute lastID = eventFactory.createAttribute("lastID", String.valueOf(SchedulJob.lastID));
            writer.add(header);
            writer.add(startRootSettings);
            writer.add(lastID);
            int i = 0;
            while (i < this.schedulVector.capacity()) {
                StartElement Job = eventFactory.createStartElement("", "", "SchedulJob");
                Attribute streamID = eventFactory.createAttribute("streamID", String.valueOf(this.schedulVector.get(i).getStreamID()));
                Attribute schedulID = eventFactory.createAttribute("schedulID", String.valueOf(this.schedulVector.get(i).getSchedulID()));
                Attribute startTime = this.mainGui.getDaylightChangeTimeCalculated() != false ? eventFactory.createAttribute("startTime", String.valueOf(this.schedulVector.get(i).getStartTime() - (long)gc.get(16))) : eventFactory.createAttribute("startTime", String.valueOf(this.schedulVector.get(i).getStartTime()));
                Attribute stopTime = this.mainGui.getDaylightChangeTimeCalculated() != false ? eventFactory.createAttribute("stopTime", String.valueOf(this.schedulVector.get(i).getStopTime() - (long)gc.get(16))) : eventFactory.createAttribute("stopTime", String.valueOf(this.schedulVector.get(i).getStopTime()));
                Attribute howOftenID = eventFactory.createAttribute("howOftenID", String.valueOf(this.schedulVector.get(i).getJobCount()));
                Attribute enableJob = eventFactory.createAttribute("enableJob", String.valueOf(this.schedulVector.get(i).isJobenabled()));
                Attribute comment = eventFactory.createAttribute("comment", String.valueOf(this.schedulVector.get(i).getComment()));
                writer.add(Job);
                writer.add(streamID);
                writer.add(schedulID);
                writer.add(startTime);
                writer.add(stopTime);
                writer.add(howOftenID);
                writer.add(enableJob);
                writer.add(comment);
                ++i;
            }
            EndElement endRoot = eventFactory.createEndElement("", "", "Settings");
            EndDocument endDocument = eventFactory.createEndDocument();
            writer.add(endRoot);
            writer.add(endDocument);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public boolean testOverlappingRecordTime(int streamID, long startTime, long endTime) {
        int i = 0;
        while (i < this.schedulVector.capacity()) {
            if (this.schedulVector.get(i).getStreamID() == streamID && (startTime >= this.schedulVector.get(i).getStartTime() && startTime <= this.schedulVector.get(i).getStopTime() || endTime >= this.schedulVector.get(i).getStartTime() && endTime < this.schedulVector.get(i).getStopTime() || startTime <= this.schedulVector.get(i).getStartTime() && endTime > this.schedulVector.get(i).getStopTime())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

