/*
 * Decompiled with CFR 0.152.
 */
package thread;

import control.SRSOutput;
import gui.Gui_StreamRipStar;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import misc.Stream;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.TagList;
import org.freedesktop.gstreamer.elements.PlayBin;

public class AudioPlayer
extends Thread {
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Stream stream;
    private Gui_StreamRipStar mainGui;
    private PlayBin playbin;
    private SRSOutput lg = SRSOutput.getInstance();

    public AudioPlayer(Stream stream, Gui_StreamRipStar mainGui) {
        this.stream = stream;
        this.mainGui = mainGui;
        try {
            this.playbin = new PlayBin("AudioPlayer");
            this.playbin.setVolume(mainGui.getVolumeManager().getVolume() / 100.0);
            this.lg.logD("AudioPlayer: Player created");
        }
        catch (UnsatisfiedLinkError e) {
            mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n\n" + e.getMessage());
            this.lg.logE("AudioPlayer: No gstreamer on System installed\n" + e.getMessage());
            mainGui.setUseInternalAudioPlayer(false);
        }
    }

    public AudioPlayer(Gui_StreamRipStar mainGui) {
        try {
            Gst.init();
        }
        catch (UnsatisfiedLinkError e) {
            mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n\n" + e.getMessage());
            this.lg.logE("AudioPlayer: No gstreamer on System installed\n" + e.getMessage());
            mainGui.setUseInternalAudioPlayer(false);
        }
    }

    @Override
    public void run() {
        if (this.mainGui != null) {
            this.mainGui.showMessageInTray(this.trans.getString("audioplayer.loadingStream"));
        }
        try {
            try {
                if (this.stream.getStatus().booleanValue() && this.stream.connectToRelayCB) {
                    this.playbin.setURI(new URI("http://127.0.0.1:" + this.stream.relayServerPortTF));
                } else {
                    this.playbin.setURI(new URI(this.stream.address));
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            this.playbin.getBus().connect(new Bus.TAG(){

                @Override
                public void tagsFound(GstObject source, TagList tagList) {
                    for (String tagName : tagList.getTagNames()) {
                        for (Object tagData : tagList.getValues(tagName)) {
                            AudioPlayer.this.mainGui.setTitleForAudioPlayer(((AudioPlayer)AudioPlayer.this).stream.name, tagData.toString(), false);
                        }
                    }
                }
            });
            this.playbin.getBus().connect(new Bus.ERROR(){

                @Override
                public void errorMessage(GstObject source, int errorCode, String errorMessage) {
                    if (errorCode == 1) {
                        SRSOutput.getInstance().log(errorMessage);
                    } else {
                        AudioPlayer.this.mainGui.setTitleForAudioPlayer("", errorMessage, false);
                    }
                    AudioPlayer.this.lg.logD("The Errorcode was:" + errorCode);
                    AudioPlayer.this.lg.log("The Errormessage was:" + errorMessage);
                }
            });
            this.playbin.getBus().connect(new Bus.BUFFERING(){

                @Override
                public void bufferingData(GstObject arg0, int arg1) {
                    AudioPlayer.this.mainGui.showMessageInTray("Buffering... (" + arg1 + ")");
                }
            });
            this.lg.logD("AudioPlayer: Loading stream");
            this.playbin.setState(State.PLAYING);
            this.lg.logD("AudioPlayer: Start Playing");
            Gst.main();
        }
        catch (UnsatisfiedLinkError e) {
            this.mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n" + e.getMessage());
            this.lg.logD("AudioPlayer: UnsatisfiedLinkError\n" + e.getMessage());
        }
        catch (ExceptionInInitializerError e) {
            this.mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n" + e.getMessage());
            this.lg.logD("AudioPlayer: ExceptionInInitializerError\n" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n" + e.getMessage());
            this.lg.logD("AudioPlayer: IllegalArgumentException\n" + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            this.mainGui.showErrorMessageInPopUp(String.valueOf(this.trans.getString("audioplayer.noGstreamerInstalled")) + "\n" + e.getMessage());
            this.lg.logD("AudioPlayer: NoClassDefFoundError\n" + e.getMessage());
        }
    }

    public void stopPlaying() {
        if (this.stream != null) {
            this.lg.logD("AudioPlayer: Try to stop the audio player with the stream: " + this.stream.name);
        }
        if (this.playbin != null && this.playbin.getState(200L) != State.NULL) {
            while (this.playbin.getState(200L) != State.NULL) {
                this.playbin.setState(State.NULL);
            }
            this.mainGui.showMessageInTray("");
        }
        if (this.stream != null) {
            this.lg.logD("AudioPlayer: Audio Player with stream: " + this.stream.name + "has been stopped");
        }
    }

    public void setAudioVolum(double volumePercent) {
        if (this.playbin != null) {
            this.lg.logD("AudioPlayer: set new volume to " + volumePercent);
            this.playbin.setVolume(volumePercent / 100.0);
        }
    }
}

