/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.lowlevel;

import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.gstreamer.event.BufferSizeEvent;
import org.freedesktop.gstreamer.event.CapsEvent;
import org.freedesktop.gstreamer.event.EOSEvent;
import org.freedesktop.gstreamer.event.Event;
import org.freedesktop.gstreamer.event.EventType;
import org.freedesktop.gstreamer.event.FlushStartEvent;
import org.freedesktop.gstreamer.event.FlushStopEvent;
import org.freedesktop.gstreamer.event.LatencyEvent;
import org.freedesktop.gstreamer.event.NavigationEvent;
import org.freedesktop.gstreamer.event.QOSEvent;
import org.freedesktop.gstreamer.event.ReconfigureEvent;
import org.freedesktop.gstreamer.event.SeekEvent;
import org.freedesktop.gstreamer.event.SegmentEvent;
import org.freedesktop.gstreamer.event.StepEvent;
import org.freedesktop.gstreamer.event.StreamStartEvent;
import org.freedesktop.gstreamer.event.TagEvent;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstEventAPI;
import org.freedesktop.gstreamer.lowlevel.GstMessageAPI;
import org.freedesktop.gstreamer.lowlevel.GstQueryAPI;
import org.freedesktop.gstreamer.message.BufferingMessage;
import org.freedesktop.gstreamer.message.DurationChangedMessage;
import org.freedesktop.gstreamer.message.EOSMessage;
import org.freedesktop.gstreamer.message.ErrorMessage;
import org.freedesktop.gstreamer.message.InfoMessage;
import org.freedesktop.gstreamer.message.LatencyMessage;
import org.freedesktop.gstreamer.message.Message;
import org.freedesktop.gstreamer.message.MessageType;
import org.freedesktop.gstreamer.message.SegmentDoneMessage;
import org.freedesktop.gstreamer.message.StateChangedMessage;
import org.freedesktop.gstreamer.message.TagMessage;
import org.freedesktop.gstreamer.message.WarningMessage;
import org.freedesktop.gstreamer.query.AllocationQuery;
import org.freedesktop.gstreamer.query.ConvertQuery;
import org.freedesktop.gstreamer.query.DurationQuery;
import org.freedesktop.gstreamer.query.FormatsQuery;
import org.freedesktop.gstreamer.query.LatencyQuery;
import org.freedesktop.gstreamer.query.PositionQuery;
import org.freedesktop.gstreamer.query.Query;
import org.freedesktop.gstreamer.query.QueryType;
import org.freedesktop.gstreamer.query.SeekingQuery;
import org.freedesktop.gstreamer.query.SegmentQuery;

public class SubtypeMapper {
    public static <T extends NativeObject> Class<?> subtypeFor(Class<T> defaultClass, Pointer ptr) {
        Mapper mapper = MapHolder.mappers.get(defaultClass);
        Class<? extends NativeObject> cls = mapper != null ? mapper.subtypeFor(ptr) : null;
        return cls != null ? cls : defaultClass;
    }

    private static class QueryMapper
    implements Mapper {
        private QueryMapper() {
        }

        @Override
        public Class<? extends NativeObject> subtypeFor(Pointer ptr) {
            return MapHolder.subtypeFor(ptr);
        }

        static class MapHolder {
            private static final Map<QueryType, Class<? extends Query>> typeMap = new HashMap<QueryType, Class<? extends Query>>(){
                {
                    this.put(QueryType.ALLOCATION, AllocationQuery.class);
                    this.put(QueryType.CONVERT, ConvertQuery.class);
                    this.put(QueryType.DURATION, DurationQuery.class);
                    this.put(QueryType.FORMATS, FormatsQuery.class);
                    this.put(QueryType.LATENCY, LatencyQuery.class);
                    this.put(QueryType.POSITION, PositionQuery.class);
                    this.put(QueryType.SEEKING, SeekingQuery.class);
                    this.put(QueryType.SEGMENT, SegmentQuery.class);
                }
            };

            MapHolder() {
            }

            public static Class<? extends NativeObject> subtypeFor(Pointer ptr) {
                GstQueryAPI.QueryStruct struct = new GstQueryAPI.QueryStruct(ptr);
                QueryType type = (QueryType)struct.readField("type");
                Class<? extends Query> queryClass = typeMap.get(type);
                return queryClass != null ? queryClass : Query.class;
            }
        }
    }

    private static class MessageMapper
    implements Mapper {
        private MessageMapper() {
        }

        @Override
        public Class<? extends NativeObject> subtypeFor(Pointer ptr) {
            return MapHolder.subtypeFor(ptr);
        }

        static class MapHolder {
            private static final Map<MessageType, Class<? extends Message>> typeMap = new HashMap<MessageType, Class<? extends Message>>(){
                {
                    this.put(MessageType.EOS, EOSMessage.class);
                    this.put(MessageType.ERROR, ErrorMessage.class);
                    this.put(MessageType.BUFFERING, BufferingMessage.class);
                    this.put(MessageType.DURATION_CHANGED, DurationChangedMessage.class);
                    this.put(MessageType.INFO, InfoMessage.class);
                    this.put(MessageType.LATENCY, LatencyMessage.class);
                    this.put(MessageType.SEGMENT_DONE, SegmentDoneMessage.class);
                    this.put(MessageType.STATE_CHANGED, StateChangedMessage.class);
                    this.put(MessageType.TAG, TagMessage.class);
                    this.put(MessageType.WARNING, WarningMessage.class);
                }
            };

            MapHolder() {
            }

            public static Class<? extends NativeObject> subtypeFor(Pointer ptr) {
                GstMessageAPI.MessageStruct struct = new GstMessageAPI.MessageStruct(ptr);
                MessageType type = (MessageType)struct.readField("type");
                Class<? extends Message> messageClass = typeMap.get(type);
                return messageClass != null ? messageClass : Message.class;
            }
        }
    }

    private static class EventMapper
    implements Mapper {
        private EventMapper() {
        }

        @Override
        public Class<? extends NativeObject> subtypeFor(Pointer ptr) {
            return MapHolder.subtypeFor(ptr);
        }

        static class MapHolder {
            private static final Map<EventType, Class<? extends Event>> typeMap = new HashMap<EventType, Class<? extends Event>>(){
                {
                    this.put(EventType.BUFFERSIZE, BufferSizeEvent.class);
                    this.put(EventType.EOS, EOSEvent.class);
                    this.put(EventType.CAPS, CapsEvent.class);
                    this.put(EventType.RECONFIGURE, ReconfigureEvent.class);
                    this.put(EventType.STREAM_START, StreamStartEvent.class);
                    this.put(EventType.LATENCY, LatencyEvent.class);
                    this.put(EventType.FLUSH_START, FlushStartEvent.class);
                    this.put(EventType.FLUSH_STOP, FlushStopEvent.class);
                    this.put(EventType.NAVIGATION, NavigationEvent.class);
                    this.put(EventType.SEGMENT, SegmentEvent.class);
                    this.put(EventType.SEEK, SeekEvent.class);
                    this.put(EventType.TAG, TagEvent.class);
                    this.put(EventType.QOS, QOSEvent.class);
                    this.put(EventType.STEP, StepEvent.class);
                }
            };

            MapHolder() {
            }

            public static Class<? extends NativeObject> subtypeFor(Pointer ptr) {
                GstEventAPI.EventStruct struct = new GstEventAPI.EventStruct(ptr);
                EventType type = (EventType)struct.readField("type");
                Class<? extends Event> eventClass = typeMap.get(type);
                return eventClass != null ? eventClass : Event.class;
            }
        }
    }

    private static interface Mapper {
        public Class<? extends NativeObject> subtypeFor(Pointer var1);
    }

    private static final class MapHolder {
        public static final Map<Class<?>, Mapper> mappers = new HashMap<Class<?>, Mapper>(){
            {
                this.put(Event.class, new EventMapper());
                this.put(Message.class, new MessageMapper());
                this.put(Query.class, new QueryMapper());
            }
        };

        private MapHolder() {
        }
    }
}

