/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.lowlevel;

import com.sun.jna.CallbackParameterContext;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.GQuark;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.EnumMapper;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.IntPtr;
import org.freedesktop.gstreamer.lowlevel.annotations.CallerOwnsReturn;
import org.freedesktop.gstreamer.lowlevel.annotations.ConstField;
import org.freedesktop.gstreamer.lowlevel.annotations.FreeReturnValue;
import org.freedesktop.gstreamer.lowlevel.annotations.IncRef;
import org.freedesktop.gstreamer.lowlevel.annotations.Invalidate;

public class GTypeMapper
extends DefaultTypeMapper {
    private static ToNativeConverter interfaceConverter = new ToNativeConverter(){

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            return arg != null ? Natives.getRawPointer(((GObject.GInterface)arg).getGObject()) : null;
        }

        @Override
        public Class<?> nativeType() {
            return Void.class;
        }
    };
    private static TypeConverter nativeObjectConverter = new TypeConverter(){

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            if (arg == null) {
                return null;
            }
            Pointer ptr = Natives.getRawPointer((NativeObject)arg);
            if (context instanceof MethodParameterContext) {
                Annotation[][] parameterAnnotations;
                MethodParameterContext mcontext = (MethodParameterContext)context;
                Method method = mcontext.getMethod();
                int index = mcontext.getParameterIndex();
                if (index < (parameterAnnotations = method.getParameterAnnotations()).length) {
                    Annotation[] annotations = parameterAnnotations[index];
                    for (int i = 0; i < annotations.length; ++i) {
                        if (annotations[i] instanceof Invalidate) {
                            ((NativeObject)arg).invalidate();
                            break;
                        }
                        if (!(annotations[i] instanceof IncRef)) continue;
                        Natives.ref((RefCountedObject)arg);
                    }
                }
            }
            return ptr;
        }

        @Override
        public Object fromNative(Object result, FromNativeContext context) {
            if (result == null) {
                return null;
            }
            if (context instanceof MethodResultContext) {
                boolean ownsHandle = ((MethodResultContext)context).getMethod().isAnnotationPresent(CallerOwnsReturn.class);
                if (ownsHandle) {
                    return Natives.callerOwnsReturn((Pointer)result, context.getTargetType());
                }
                return Natives.objectFor((Pointer)result, context.getTargetType(), false, false);
            }
            if (context instanceof CallbackParameterContext) {
                return Natives.objectFor((Pointer)result, context.getTargetType(), true, true);
            }
            if (context instanceof StructureReadContext) {
                StructureReadContext sctx = (StructureReadContext)context;
                boolean ownsHandle = sctx.getField().getAnnotation(ConstField.class) == null;
                return Natives.objectFor((Pointer)result, context.getTargetType(), true, true);
            }
            throw new IllegalStateException("Cannot convert to NativeObject from " + context);
        }

        @Override
        public Class<?> nativeType() {
            return Pointer.class;
        }
    };
    private static TypeConverter enumConverter = new TypeConverter(){

        @Override
        public Object fromNative(Object value, FromNativeContext context) {
            return EnumMapper.getInstance().valueOf((Integer)value, context.getTargetType());
        }

        @Override
        public Class<?> nativeType() {
            return Integer.class;
        }

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            if (arg == null) {
                return null;
            }
            return EnumMapper.getInstance().intValue((Enum)arg);
        }
    };
    private TypeConverter stringConverter = new TypeConverter(){

        @Override
        public Object fromNative(Object result, FromNativeContext context) {
            if (result == null) {
                return null;
            }
            if (context instanceof MethodResultContext) {
                MethodResultContext functionContext = (MethodResultContext)context;
                Method method = functionContext.getMethod();
                Pointer ptr = (Pointer)result;
                String s = ptr.getString(0L);
                if (method.isAnnotationPresent(FreeReturnValue.class) || method.isAnnotationPresent(CallerOwnsReturn.class)) {
                    GlibAPI.GLIB_API.g_free(ptr);
                }
                return s;
            }
            return ((Pointer)result).getString(0L);
        }

        @Override
        public Class<?> nativeType() {
            return Pointer.class;
        }

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            return arg;
        }
    };
    private TypeConverter booleanConverter = new TypeConverter(){

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            return Boolean.TRUE.equals(arg) ? 1 : 0;
        }

        @Override
        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return (Integer)arg0 != 0;
        }

        @Override
        public Class<?> nativeType() {
            return Integer.class;
        }
    };
    private TypeConverter gquarkConverter = new TypeConverter(){

        @Override
        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return new GQuark((Integer)arg0);
        }

        @Override
        public Class<?> nativeType() {
            return Integer.class;
        }

        @Override
        public Object toNative(Object arg0, ToNativeContext arg1) {
            return ((GQuark)arg0).intValue();
        }
    };
    private TypeConverter intptrConverter = new TypeConverter(){

        @Override
        public Object toNative(Object arg, ToNativeContext context) {
            return ((IntPtr)arg).value;
        }

        @Override
        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return new IntPtr(((Number)arg0).intValue());
        }

        @Override
        public Class<?> nativeType() {
            return Native.POINTER_SIZE == 8 ? Long.class : Integer.class;
        }
    };
    private static ToNativeConverter uriConverter = new ToNativeConverter(){

        @Override
        public Object toNative(Object arg0, ToNativeContext arg1) {
            URI uri = (URI)arg0;
            String uriString = uri.toString();
            if ("file".equals(uri.getScheme()) && uri.getHost() == null) {
                String path = uri.getRawPath();
                uriString = Platform.isWindows() ? "file:/" + path : "file://" + path;
            }
            return uriString;
        }

        @Override
        public Class<?> nativeType() {
            return String.class;
        }
    };

    public GTypeMapper() {
        this.addToNativeConverter(URI.class, uriConverter);
    }

    public FromNativeConverter getFromNativeConverter(Class type) {
        if (Enum.class.isAssignableFrom(type)) {
            return enumConverter;
        }
        if (NativeObject.class.isAssignableFrom(type)) {
            return nativeObjectConverter;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return this.booleanConverter;
        }
        if (String.class == type) {
            return this.stringConverter;
        }
        if (IntPtr.class == type) {
            return this.intptrConverter;
        }
        if (GQuark.class == type) {
            return this.gquarkConverter;
        }
        return super.getFromNativeConverter(type);
    }

    public ToNativeConverter getToNativeConverter(Class type) {
        if (NativeObject.class.isAssignableFrom(type)) {
            return nativeObjectConverter;
        }
        if (GObject.GInterface.class.isAssignableFrom(type)) {
            return interfaceConverter;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return enumConverter;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return this.booleanConverter;
        }
        if (String.class == type) {
            return this.stringConverter;
        }
        if (IntPtr.class == type) {
            return this.intptrConverter;
        }
        if (GQuark.class == type) {
            return this.gquarkConverter;
        }
        return super.getToNativeConverter(type);
    }
}

