/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.lowlevel;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.gstreamer.lowlevel.GObjectAPI;

public class GType
extends IntegerType {
    public static final int SIZE = Native.SIZE_T_SIZE;
    private static final int G_TYPE_FUNDAMENTAL_SHIFT = 2;
    private static final Map<Long, GType> gTypeByValues = new ConcurrentHashMap<Long, GType>();
    private static final Map<String, GType> gTypeByNames = new ConcurrentHashMap<String, GType>();
    public static final GType INVALID = GType.init(0);
    public static final GType NONE = GType.init(1);
    public static final GType INTERFACE = GType.init(2);
    public static final GType CHAR = GType.init(3);
    public static final GType UCHAR = GType.init(4);
    public static final GType BOOLEAN = GType.init(5);
    public static final GType INT = GType.init(6);
    public static final GType UINT = GType.init(7);
    public static final GType LONG = GType.init(8);
    public static final GType ULONG = GType.init(9);
    public static final GType INT64 = GType.init(10);
    public static final GType UINT64 = GType.init(11);
    public static final GType ENUM = GType.init(12);
    public static final GType FLAGS = GType.init(13);
    public static final GType FLOAT = GType.init(14);
    public static final GType DOUBLE = GType.init(15);
    public static final GType STRING = GType.init(16);
    public static final GType POINTER = GType.init(17);
    public static final GType BOXED = GType.init(18);
    public static final GType PARAM = GType.init(19);
    public static final GType OBJECT = GType.init(20);
    public static final GType VARIANT = GType.init(21);
    private GType parent;
    private String name;

    private static GType init(int value) {
        return GType.valueOf(value << 2);
    }

    protected GType(long t) {
        super(SIZE, t);
    }

    public GType() {
        this(0L);
    }

    public static GType valueOf(long value) {
        GType result = gTypeByValues.get(value);
        if (result == null) {
            result = new GType(value);
            gTypeByValues.put(value, result);
        }
        return result;
    }

    public static GType valueOf(String typeName) {
        GType result = gTypeByNames.get(typeName);
        if (result == null && !(result = GObjectAPI.GOBJECT_API.g_type_from_name(typeName)).equals(INVALID)) {
            gTypeByNames.put(typeName, result);
            result.name = typeName;
        }
        return result;
    }

    public static GType valueOf(Class<?> javaType) {
        if (Integer.class == javaType || Integer.TYPE == javaType) {
            return INT;
        }
        if (Long.class == javaType || Long.TYPE == javaType) {
            return INT64;
        }
        if (Float.class == javaType || Float.TYPE == javaType) {
            return FLOAT;
        }
        if (Double.class == javaType || Double.TYPE == javaType) {
            return DOUBLE;
        }
        if (String.class == javaType) {
            return STRING;
        }
        throw new IllegalArgumentException("No GType for " + javaType);
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        return GType.valueOf(((Number)nativeValue).longValue());
    }

    public GType getParentType() {
        if (this.parent == null) {
            this.parent = GObjectAPI.GOBJECT_API.g_type_parent(this);
        }
        return this.parent;
    }

    public String getTypeName() {
        if (this.name == null) {
            this.name = GObjectAPI.GOBJECT_API.g_type_name(this);
            gTypeByNames.put(this.name, this);
        }
        return this.name;
    }

    @Override
    public String toString() {
        return "[" + this.getTypeName() + ":" + super.longValue() + "]";
    }
}

