/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.glib;

import com.sun.jna.Pointer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GTypedPtr;
import org.freedesktop.gstreamer.lowlevel.GstTypes;

public abstract class NativeObject
implements AutoCloseable {
    private static final Level LIFECYCLE = Level.FINE;
    private static final Logger LOG = Logger.getLogger(NativeObject.class.getName());
    private static final ConcurrentMap<Pointer, NativeRef> INSTANCES = new ConcurrentHashMap<Pointer, NativeRef>();
    final Handle handle;
    private final Pointer ptr;

    protected NativeObject(Handle handle) {
        this.handle = Objects.requireNonNull(handle);
        this.ptr = ((GPointer)handle.ptrRef.get()).getPointer();
        if (handle.isCacheable()) {
            INSTANCES.put(this.ptr, new NativeRef(this, handle));
        }
    }

    public void disown() {
        LOG.log(LIFECYCLE, "Disowning " + this.getRawPointer());
        this.handle.ownsReference.set(false);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        LOG.log(LIFECYCLE, "Disposing object " + this.getClass().getName() + " = " + this.handle);
        this.handle.dispose();
    }

    public boolean equals(Object o) {
        return o instanceof NativeObject && ((NativeObject)o).ptr.equals(this.ptr);
    }

    protected GPointer getPointer() {
        GPointer ptr = (GPointer)this.handle.ptrRef.get();
        if (ptr == null) {
            throw new IllegalStateException("Native object has been disposed");
        }
        return ptr;
    }

    protected Pointer getRawPointer() {
        GPointer ptr = (GPointer)this.handle.ptrRef.get();
        if (ptr == null) {
            throw new IllegalStateException("Native object has been disposed");
        }
        return ptr.getPointer();
    }

    public int hashCode() {
        return this.ptr.hashCode();
    }

    public void invalidate() {
        LOG.log(LIFECYCLE, () -> "Invalidating object " + this + " = " + this.getRawPointer());
        this.handle.invalidate();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getRawPointer() + ")";
    }

    static <T extends NativeObject> T objectFor(GPointer gptr, Class<T> cls, int refAdjust, boolean ownsHandle) {
        TypeRegistration<?> reg;
        GType gtype;
        if (gptr == null) {
            return null;
        }
        NativeObject obj = NativeObject.instanceFor(gptr.getPointer());
        if (obj != null && cls.isInstance(obj)) {
            if (refAdjust < 0) {
                ((RefCountedObject.Handle)obj.handle).unref();
            }
            return (T)((NativeObject)cls.cast(obj));
        }
        GType gType = gtype = gptr instanceof GTypedPtr ? ((GTypedPtr)gptr).getGType() : null;
        if (gtype != null && (reg = GstTypes.registrationFor(gtype)) != null) {
            return (T)((NativeObject)cls.cast(((TypeRegistration)reg).factory.apply(new Initializer(gptr, refAdjust > 0, ownsHandle))));
        }
        LOG.log(Level.FINE, () -> String.format("Unregistered type requested : %s", cls.getSimpleName()));
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(Initializer.class);
            constructor.setAccessible(true);
            NativeObject retVal = (NativeObject)constructor.newInstance(new Initializer(gptr, refAdjust > 0, ownsHandle));
            return (T)retVal;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    static NativeObject instanceFor(Pointer ptr) {
        WeakReference ref = (WeakReference)INSTANCES.get(ptr);
        if (ref != null && ref.get() == null) {
            INSTANCES.remove(ptr);
        }
        return ref != null ? (NativeObject)ref.get() : null;
    }

    public static interface TypeProvider {
        public Stream<TypeRegistration<?>> types();
    }

    public static class TypeRegistration<T extends NativeObject> {
        private final Class<T> javaType;
        private final String gTypeName;
        private final Function<Initializer, ? extends T> factory;

        TypeRegistration(Class<T> javaType, String gTypeName, Function<Initializer, ? extends T> factory) {
            this.javaType = javaType;
            this.gTypeName = gTypeName;
            this.factory = factory;
        }

        public Class<T> getJavaType() {
            return this.javaType;
        }

        public String getGTypeName() {
            return this.gTypeName;
        }

        public Function<Initializer, ? extends T> getFactory() {
            return this.factory;
        }
    }

    protected static abstract class Handle {
        private final AtomicReference<GPointer> ptrRef;
        private final AtomicBoolean ownsReference;

        public Handle(GPointer ptr, boolean ownsReference) {
            this.ptrRef = new AtomicReference<GPointer>(ptr);
            this.ownsReference = new AtomicBoolean(ownsReference);
        }

        public void disown() {
            this.ownsReference.set(false);
        }

        public void invalidate() {
            GPointer ptr = this.ptrRef.getAndSet(null);
            this.ownsReference.set(false);
            if (ptr != null) {
                INSTANCES.remove(ptr.getPointer());
            }
        }

        public void dispose() {
            GPointer ptr = this.ptrRef.getAndSet(null);
            if (ptr != null) {
                INSTANCES.remove(ptr.getPointer());
                if (this.ownsReference.compareAndSet(true, false)) {
                    this.disposeNativeHandle(ptr);
                }
            }
        }

        public boolean isCacheable() {
            return true;
        }

        protected abstract void disposeNativeHandle(GPointer var1);

        protected GPointer getPointer() {
            return this.ptrRef.get();
        }

        protected boolean ownsReference() {
            return this.ownsReference.get();
        }
    }

    private static final class NativeRef
    extends WeakReference<NativeObject> {
        private static final boolean REAP_ON_EDT = Boolean.getBoolean("glib.reapOnEDT");
        private static final ReferenceQueue<NativeObject> QUEUE = new ReferenceQueue();
        private static final ExecutorService REAPER = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "NativeObject Reaper");
            t.setDaemon(true);
            return t;
        });
        private final Handle handle;
        private final String type;

        private NativeRef(NativeObject obj, Handle handle) {
            super(obj, QUEUE);
            this.type = obj.getClass().getSimpleName();
            this.handle = handle;
        }

        static {
            REAPER.submit(() -> {
                while (true) {
                    try {
                        while (true) {
                            NativeRef ref = (NativeRef)QUEUE.remove();
                            LOG.log(LIFECYCLE, () -> "Disposing of " + ref.type + " : " + ref.handle.ptrRef.get());
                            if (REAP_ON_EDT) {
                                Gst.invokeLater(ref.handle::dispose);
                                continue;
                            }
                            ref.handle.dispose();
                        }
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Reaper thread exception", t);
                        continue;
                    }
                    break;
                }
            });
        }
    }

    public static final class Initializer {
        public final GPointer ptr;
        public final boolean needRef;
        public final boolean ownsHandle;

        Initializer(GPointer ptr, boolean needRef, boolean ownsHandle) {
            this.ptr = ptr;
            this.needRef = needRef;
            this.ownsHandle = ownsHandle;
        }
    }
}

