/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.glib;

import com.sun.jna.Pointer;
import org.freedesktop.gstreamer.glib.GCancellable;
import org.freedesktop.gstreamer.glib.GInetSocketAddress;
import org.freedesktop.gstreamer.glib.GLibException;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.GSocketFamily;
import org.freedesktop.gstreamer.glib.GSocketProtocol;
import org.freedesktop.gstreamer.glib.GSocketType;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GioAPI;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;

public class GSocket
extends GObject {
    public static final String GTYPE_NAME = "GSocket";

    public GSocket(GSocketFamily family, GSocketType type, GSocketProtocol protocol) throws GLibException {
        this(GSocket.makeRawSocket(family, type, protocol));
    }

    GSocket(NativeObject.Initializer init) {
        super(init);
    }

    public GSocket bind(String address, int port) {
        GInetSocketAddress boundAddress = new GInetSocketAddress(address, port);
        GstAPI.GErrorStruct reference = new GstAPI.GErrorStruct();
        GstAPI.GErrorStruct[] errorArray = (GstAPI.GErrorStruct[])reference.toArray(1);
        if (!GioAPI.g_socket_bind(this.getRawPointer(), Natives.getRawPointer(boundAddress), true, reference.getPointer())) {
            throw new GLibException(GSocket.extractAndClearError(errorArray[0]));
        }
        return this;
    }

    public void connect(String address, int port) {
        GInetSocketAddress connectedAddress = new GInetSocketAddress(address, port);
        GstAPI.GErrorStruct reference = new GstAPI.GErrorStruct();
        GstAPI.GErrorStruct[] errorArray = (GstAPI.GErrorStruct[])reference.toArray(1);
        if (!GioAPI.g_socket_connect(this.getRawPointer(), Natives.getRawPointer(connectedAddress), Natives.getRawPointer(new GCancellable()), reference.getPointer())) {
            throw new GLibException(GSocket.extractAndClearError(errorArray[0]));
        }
    }

    public int getFD() {
        return (Integer)this.get("fd");
    }

    public GInetSocketAddress getLocalAddress() {
        return (GInetSocketAddress)this.get("local-address");
    }

    public GInetSocketAddress getRemoteAddress() {
        return (GInetSocketAddress)this.get("remote-address");
    }

    public GSocketFamily getSocketFamily() {
        return GSocketFamily.fromGioValue((Integer)this.get("family"));
    }

    public GSocketProtocol getSocketProtocol() {
        return GSocketProtocol.fromGioValue((Integer)this.get("protocol"));
    }

    public GSocketType getSocketType() {
        return GSocketType.fromGioValue((Integer)this.get("type"));
    }

    public boolean isBlocking() {
        return (Boolean)this.get("blocking");
    }

    private static String extractAndClearError(GstAPI.GErrorStruct struct) {
        struct.read();
        String err = struct.getMessage();
        GlibAPI.GLIB_API.g_error_free(struct);
        return err;
    }

    private static NativeObject.Initializer makeRawSocket(GSocketFamily family, GSocketType type, GSocketProtocol protocol) throws GLibException {
        GstAPI.GErrorStruct reference = new GstAPI.GErrorStruct();
        GstAPI.GErrorStruct[] errorArray = (GstAPI.GErrorStruct[])reference.toArray(1);
        Pointer socketPointer = GioAPI.g_socket_new(family.toGioValue(), type.toGioValue(), protocol.toGioValue(), reference.getPointer());
        if (socketPointer == null) {
            throw new GLibException(GSocket.extractAndClearError(errorArray[0]));
        }
        return Natives.initializer(socketPointer);
    }
}

