/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.glib;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.GObjectAPI;
import org.freedesktop.gstreamer.lowlevel.GObjectPtr;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GSignalAPI;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GstMiniObjectPtr;
import org.freedesktop.gstreamer.lowlevel.GstTypes;
import org.freedesktop.gstreamer.lowlevel.IntPtr;

public abstract class GObject
extends RefCountedObject {
    private static final Level LIFECYCLE = Level.FINE;
    private static final Logger LOG = Logger.getLogger(GObject.class.getName());
    private static final CallbackThreadInitializer GCALLBACK_THREAD_INIT = new CallbackThreadInitializer(true, Boolean.getBoolean("glib.detachCallbackThreads"), "GCallback");
    private static final Map<GObject, Boolean> STRONG_REFS = new ConcurrentHashMap<GObject, Boolean>();
    private static final GObjectAPI.GToggleNotify TOGGLE_NOTIFY = new ToggleNotify();
    private final Handle handle;
    private Map<Class<?>, Map<Object, GCallback>> callbackListeners;

    protected GObject(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GObjectPtr.class, GObjectPtr::new), init.ownsHandle), init.needRef);
    }

    protected GObject(Handle handle, boolean needRef) {
        super(handle);
        this.handle = handle;
        if (handle.ownsReference()) {
            boolean is_floating = GObjectAPI.GOBJECT_API.g_object_is_floating(handle.getPointer());
            LOG.log(LIFECYCLE, () -> String.format("Initialising owned handle for %s floating = %b refs = %d need ref = %b", this.getClass().getName(), is_floating, this.getRefCount(), needRef));
            if (!needRef && is_floating) {
                handle.sink();
            }
            if (this.getRefCount() >= 1) {
                STRONG_REFS.put(this, Boolean.TRUE);
            }
            GObjectAPI.GOBJECT_API.g_object_add_toggle_ref(handle.getPointer(), TOGGLE_NOTIFY, handle.objectID);
            if (!needRef) {
                handle.unref();
            }
        }
    }

    public <T> void connect(Class<T> listenerClass, T listener, Callback cb) {
        String signal = listenerClass.getSimpleName().toLowerCase().replaceAll("_", "-");
        this.connect(signal, listenerClass, listener, cb);
    }

    public synchronized <T> void connect(String signal, Class<T> listenerClass, T listener, Callback cb) {
        Native.setCallbackThreadInitializer(cb, GCALLBACK_THREAD_INIT);
        this.addCallback(listenerClass, listener, new SignalCallback(signal, cb));
    }

    public synchronized <T> void disconnect(Class<T> listenerClass, T listener) {
        this.removeCallback(listenerClass, listener);
    }

    public synchronized void emit(String signal, Object ... arguments) {
        GSignalAPI.GSIGNAL_API.g_signal_emit_by_name(this, signal, arguments);
    }

    public synchronized <T extends NativeObject> T emit(Class<T> resultType, String signal, Object ... arguments) {
        PointerByReference pointerToResult = new PointerByReference(null);
        Object[] fullArguments = Arrays.copyOf(arguments, arguments.length + 1);
        fullArguments[arguments.length] = pointerToResult;
        this.emit(signal, fullArguments);
        Pointer result = pointerToResult.getValue();
        if (result == null) {
            return null;
        }
        return Natives.objectFor(result, resultType, false, true);
    }

    public Object get(String property) {
        Class<? extends NativeObject> cls;
        LOG.entering("GObject", "get", new Object[]{property});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        GObjectAPI.GOBJECT_API.g_object_get_property(this, property, propValue);
        if (propType.equals(GType.INT)) {
            return GValueAPI.GVALUE_API.g_value_get_int(propValue);
        }
        if (propType.equals(GType.UINT)) {
            return GValueAPI.GVALUE_API.g_value_get_uint(propValue);
        }
        if (propType.equals(GType.CHAR)) {
            return (int)GValueAPI.GVALUE_API.g_value_get_char(propValue);
        }
        if (propType.equals(GType.UCHAR)) {
            return (int)GValueAPI.GVALUE_API.g_value_get_uchar(propValue);
        }
        if (propType.equals(GType.LONG)) {
            return GValueAPI.GVALUE_API.g_value_get_long(propValue).longValue();
        }
        if (propType.equals(GType.ULONG)) {
            return GValueAPI.GVALUE_API.g_value_get_ulong(propValue).longValue();
        }
        if (propType.equals(GType.INT64)) {
            return GValueAPI.GVALUE_API.g_value_get_int64(propValue);
        }
        if (propType.equals(GType.UINT64)) {
            return GValueAPI.GVALUE_API.g_value_get_uint64(propValue);
        }
        if (propType.equals(GType.BOOLEAN)) {
            return GValueAPI.GVALUE_API.g_value_get_boolean(propValue);
        }
        if (propType.equals(GType.FLOAT)) {
            return Float.valueOf(GValueAPI.GVALUE_API.g_value_get_float(propValue));
        }
        if (propType.equals(GType.DOUBLE)) {
            return GValueAPI.GVALUE_API.g_value_get_double(propValue);
        }
        if (propType.equals(GType.STRING)) {
            return GValueAPI.GVALUE_API.g_value_get_string(propValue);
        }
        if (propType.equals(GType.OBJECT)) {
            return GValueAPI.GVALUE_API.g_value_dup_object(propValue);
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.OBJECT)) {
            return GValueAPI.GVALUE_API.g_value_dup_object(GObject.transform(propValue, GType.OBJECT));
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.INT)) {
            return GValueAPI.GVALUE_API.g_value_get_int(GObject.transform(propValue, GType.INT));
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.INT64)) {
            return GValueAPI.GVALUE_API.g_value_get_int64(GObject.transform(propValue, GType.INT64));
        }
        if (propValue.checkHolds(GType.BOXED) && (cls = GstTypes.classFor(propType)) != null) {
            Pointer ptr = GValueAPI.GVALUE_API.g_value_get_boxed(propValue);
            GObjectPtr gptr = GObject.class.isAssignableFrom(cls) ? new GObjectPtr(ptr) : (MiniObject.class.isAssignableFrom(cls) ? new GstMiniObjectPtr(ptr) : new GPointer(ptr));
            return GObject.objectFor(gptr, cls, -1, true);
        }
        throw new IllegalArgumentException("Unknown conversion from GType=" + propType);
    }

    public Object getPropertyDefaultValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getDefault();
    }

    public Object getPropertyMaximumValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getMaximum();
    }

    public Object getPropertyMinimumValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getMinimum();
    }

    public int getRefCount() {
        GObjectPtr ptr = this.handle.getPointer();
        if (ptr != null) {
            int count = ptr.getPointer().getInt(Native.POINTER_SIZE);
            return count;
        }
        return 0;
    }

    public String getTypeName() {
        return this.handle.getPointer().getGType().getTypeName();
    }

    public List<String> listPropertyNames() {
        GObjectAPI.GParamSpec[] lst = this.listProperties();
        ArrayList<String> result = new ArrayList<String>(lst.length);
        for (int i = 0; i < lst.length; ++i) {
            result.add(lst[i].g_name);
        }
        return result;
    }

    public void set(String property, Object data) {
        LOG.entering("GObject", "set", new Object[]{property, data});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        if (propType.equals(GType.INT)) {
            GValueAPI.GVALUE_API.g_value_set_int(propValue, GObject.intValue(data));
        } else if (propType.equals(GType.UINT)) {
            GValueAPI.GVALUE_API.g_value_set_uint(propValue, GObject.intValue(data));
        } else if (propType.equals(GType.CHAR)) {
            GValueAPI.GVALUE_API.g_value_set_char(propValue, (byte)GObject.intValue(data));
        } else if (propType.equals(GType.UCHAR)) {
            GValueAPI.GVALUE_API.g_value_set_uchar(propValue, (byte)GObject.intValue(data));
        } else if (propType.equals(GType.LONG)) {
            GValueAPI.GVALUE_API.g_value_set_long(propValue, new NativeLong(GObject.longValue(data)));
        } else if (propType.equals(GType.ULONG)) {
            GValueAPI.GVALUE_API.g_value_set_ulong(propValue, new NativeLong(GObject.longValue(data)));
        } else if (propType.equals(GType.INT64)) {
            GValueAPI.GVALUE_API.g_value_set_int64(propValue, GObject.longValue(data));
        } else if (propType.equals(GType.UINT64)) {
            GValueAPI.GVALUE_API.g_value_set_uint64(propValue, GObject.longValue(data));
        } else if (propType.equals(GType.BOOLEAN)) {
            GValueAPI.GVALUE_API.g_value_set_boolean(propValue, GObject.booleanValue(data));
        } else if (propType.equals(GType.FLOAT)) {
            GValueAPI.GVALUE_API.g_value_set_float(propValue, GObject.floatValue(data));
        } else if (propType.equals(GType.DOUBLE)) {
            GValueAPI.GVALUE_API.g_value_set_double(propValue, GObject.doubleValue(data));
        } else if (propType.equals(GType.STRING)) {
            if (data instanceof URI) {
                URI uri = (URI)data;
                String uriString = uri.toString();
                if ("file".equals(uri.getScheme()) && uri.getHost() == null) {
                    String path = uri.getRawPath();
                    uriString = "file://" + path;
                }
                GValueAPI.GVALUE_API.g_value_set_string(propValue, uriString);
            } else {
                GValueAPI.GVALUE_API.g_value_set_string(propValue, data.toString());
            }
        } else if (propType.equals(GType.OBJECT)) {
            GValueAPI.GVALUE_API.g_value_set_object(propValue, (GObject)data);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.INT64, propType)) {
            GObject.transform(data, GType.INT64, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.LONG, propType)) {
            GObject.transform(data, GType.LONG, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.INT, propType)) {
            GObject.transform(data, GType.INT, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.DOUBLE, propType)) {
            GObject.transform(data, GType.DOUBLE, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.FLOAT, propType)) {
            GObject.transform(data, GType.FLOAT, propValue);
        } else {
            GObjectAPI.GOBJECT_API.g_object_set(this, property, data);
            return;
        }
        GObjectAPI.GOBJECT_API.g_param_value_validate(propertySpec, propValue);
        GObjectAPI.GOBJECT_API.g_object_set_property(this, property, propValue);
        GValueAPI.GVALUE_API.g_value_unset(propValue);
    }

    protected synchronized <T> void addCallback(Class<T> listenerClass, T listener, GCallback cb) {
        Map<Class<?>, Map<Object, GCallback>> signals = this.getCallbackMap();
        Map<Object, GCallback> map = signals.get(listenerClass);
        if (map == null) {
            map = new HashMap<Object, GCallback>();
            signals.put(listenerClass, map);
        }
        map.put(listener, cb);
    }

    @Override
    public void dispose() {
        super.dispose();
        STRONG_REFS.remove(this);
    }

    @Override
    public void invalidate() {
        try {
            if (this.handle.ownsReference()) {
                this.handle.ref();
                GObjectAPI.GOBJECT_API.g_object_remove_toggle_ref(this.handle.getPointer(), TOGGLE_NOTIFY, this.handle.objectID);
            }
            STRONG_REFS.remove(this);
        }
        finally {
            super.invalidate();
        }
    }

    protected synchronized <T> void removeCallback(Class<T> listenerClass, T listener) {
        Map<Class<?>, Map<Object, GCallback>> signals = this.getCallbackMap();
        Map<Object, GCallback> map = signals.get(listenerClass);
        if (map != null) {
            GCallback cb = map.remove(listener);
            if (cb != null) {
                cb.remove();
            }
            if (map.isEmpty()) {
                signals.remove(listenerClass);
                if (this.callbackListeners.isEmpty()) {
                    this.callbackListeners = null;
                }
            }
        }
    }

    private GObjectAPI.GParamSpec findProperty(String propertyName) {
        Pointer ptr = GObjectAPI.GOBJECT_API.g_object_class_find_property(this.getRawPointer().getPointer(0L), propertyName);
        if (ptr == null) {
            return null;
        }
        return new GObjectAPI.GParamSpec(ptr);
    }

    private GObjectAPI.GParamSpecTypeSpecific findProperty(String propertyName, GType type) {
        Pointer ptr = GObjectAPI.GOBJECT_API.g_object_class_find_property(this.getRawPointer().getPointer(0L), propertyName);
        if (type.equals(GType.INT)) {
            return new GObjectAPI.GParamSpecInt(ptr);
        }
        if (type.equals(GType.UINT)) {
            return new GObjectAPI.GParamSpecUInt(ptr);
        }
        if (type.equals(GType.CHAR)) {
            return new GObjectAPI.GParamSpecChar(ptr);
        }
        if (type.equals(GType.UCHAR)) {
            return new GObjectAPI.GParamSpecUChar(ptr);
        }
        if (type.equals(GType.BOOLEAN)) {
            return new GObjectAPI.GParamSpecBoolean(ptr);
        }
        if (type.equals(GType.LONG)) {
            return new GObjectAPI.GParamSpecLong(ptr);
        }
        if (type.equals(GType.ULONG)) {
            return new GObjectAPI.GParamSpecLong(ptr);
        }
        if (type.equals(GType.INT64)) {
            return new GObjectAPI.GParamSpecInt64(ptr);
        }
        if (type.equals(GType.UINT64)) {
            return new GObjectAPI.GParamSpecInt64(ptr);
        }
        if (type.equals(GType.FLOAT)) {
            return new GObjectAPI.GParamSpecFloat(ptr);
        }
        if (type.equals(GType.DOUBLE)) {
            return new GObjectAPI.GParamSpecDouble(ptr);
        }
        if (type.equals(GType.STRING)) {
            return new GObjectAPI.GParamSpecString(ptr);
        }
        throw new IllegalArgumentException("Unknown conversion from GType=" + type);
    }

    private final synchronized Map<Class<?>, Map<Object, GCallback>> getCallbackMap() {
        if (this.callbackListeners == null) {
            this.callbackListeners = new ConcurrentHashMap();
        }
        return this.callbackListeners;
    }

    private GObjectAPI.GParamSpec[] listProperties() {
        IntByReference len = new IntByReference();
        Pointer ptrs = GObjectAPI.GOBJECT_API.g_object_class_list_properties(this.getRawPointer().getPointer(0L), len);
        if (ptrs == null) {
            return null;
        }
        GObjectAPI.GParamSpec[] props = new GObjectAPI.GParamSpec[len.getValue()];
        int offset = 0;
        for (int i = 0; i < len.getValue(); ++i) {
            props[i] = new GObjectAPI.GParamSpec(ptrs.getPointer(offset));
            offset += Native.POINTER_SIZE;
        }
        return props;
    }

    private static boolean booleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Expected boolean value, not " + value.getClass());
    }

    private static double doubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new IllegalArgumentException("Expected double value, not " + value.getClass());
    }

    private static float floatValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new IllegalArgumentException("Expected float value, not " + value.getClass());
    }

    private static int intValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException("Expected integer value, not " + value.getClass());
    }

    private static long longValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new IllegalArgumentException("Expected long value, not " + value.getClass());
    }

    private static boolean setGValue(GValueAPI.GValue value, GType type, Object data) {
        if (type.equals(GType.INT)) {
            GValueAPI.GVALUE_API.g_value_set_int(value, GObject.intValue(data));
        } else if (type.equals(GType.UINT)) {
            GValueAPI.GVALUE_API.g_value_set_uint(value, GObject.intValue(data));
        } else if (type.equals(GType.CHAR)) {
            GValueAPI.GVALUE_API.g_value_set_char(value, (byte)GObject.intValue(data));
        } else if (type.equals(GType.UCHAR)) {
            GValueAPI.GVALUE_API.g_value_set_uchar(value, (byte)GObject.intValue(data));
        } else if (type.equals(GType.LONG)) {
            GValueAPI.GVALUE_API.g_value_set_long(value, new NativeLong(GObject.longValue(data)));
        } else if (type.equals(GType.ULONG)) {
            GValueAPI.GVALUE_API.g_value_set_ulong(value, new NativeLong(GObject.longValue(data)));
        } else if (type.equals(GType.INT64)) {
            GValueAPI.GVALUE_API.g_value_set_int64(value, GObject.longValue(data));
        } else if (type.equals(GType.UINT64)) {
            GValueAPI.GVALUE_API.g_value_set_uint64(value, GObject.longValue(data));
        } else if (type.equals(GType.BOOLEAN)) {
            GValueAPI.GVALUE_API.g_value_set_boolean(value, GObject.booleanValue(data));
        } else if (type.equals(GType.FLOAT)) {
            GValueAPI.GVALUE_API.g_value_set_float(value, GObject.floatValue(data));
        } else if (type.equals(GType.DOUBLE)) {
            GValueAPI.GVALUE_API.g_value_set_double(value, GObject.doubleValue(data));
        } else {
            return false;
        }
        return true;
    }

    private static GValueAPI.GValue transform(GValueAPI.GValue src, GType dstType) {
        GValueAPI.GValue dst = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(dst, dstType);
        GValueAPI.GVALUE_API.g_value_transform(src, dst);
        return dst;
    }

    private static void transform(Object data, GType type, GValueAPI.GValue dst) {
        GValueAPI.GValue src = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(src, type);
        GObject.setGValue(src, type, data);
        GValueAPI.GVALUE_API.g_value_transform(src, dst);
    }

    private static final class ToggleNotify
    implements GObjectAPI.GToggleNotify {
        private ToggleNotify() {
        }

        @Override
        public void callback(Pointer data, Pointer ptr, boolean is_last_ref) {
            GObject o = (GObject)NativeObject.instanceFor(ptr);
            if (o == null) {
                return;
            }
            LOG.log(LIFECYCLE, "toggle_ref " + o.getClass().getSimpleName() + " (" + ptr + ") last_ref=" + is_last_ref);
            if (is_last_ref) {
                STRONG_REFS.remove(o);
            } else {
                STRONG_REFS.put(o, Boolean.TRUE);
            }
        }
    }

    protected static class Handle
    extends RefCountedObject.Handle {
        private final IntPtr objectID = new IntPtr(System.identityHashCode(this));
        private final Set<NativeLong> signals = new HashSet<NativeLong>();

        public Handle(GObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        private synchronized NativeLong connectSignal(String signal, Callback cb) {
            NativeLong id = GObjectAPI.GOBJECT_API.g_signal_connect_data(this.getPointer(), signal, cb, null, null, 0);
            if (id.longValue() != 0L) {
                this.signals.add(id);
            }
            return id;
        }

        private synchronized void disconnectSignal(NativeLong id) {
            if (this.signals.remove(id)) {
                GObjectAPI.GOBJECT_API.g_signal_handler_disconnect(this.getPointer(), id);
            }
        }

        private synchronized void clearSignals() {
            this.signals.forEach(id -> GObjectAPI.GOBJECT_API.g_signal_handler_disconnect(this.getPointer(), (NativeLong)id));
            this.signals.clear();
        }

        @Override
        public void invalidate() {
            this.clearSignals();
            super.dispose();
        }

        @Override
        public void dispose() {
            this.clearSignals();
            super.dispose();
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GObjectAPI.GOBJECT_API.g_object_remove_toggle_ref((GObjectPtr)ptr, TOGGLE_NOTIFY, this.objectID);
        }

        @Override
        protected void ref() {
            GObjectAPI.GOBJECT_API.g_object_ref(this.getPointer());
        }

        protected void sink() {
            GObjectAPI.GOBJECT_API.g_object_ref_sink(this.getPointer());
        }

        @Override
        protected void unref() {
            GObjectAPI.GOBJECT_API.g_object_unref(this.getPointer());
        }

        @Override
        protected GObjectPtr getPointer() {
            return (GObjectPtr)super.getPointer();
        }

        public String toString() {
            GObjectPtr ptr = this.getPointer();
            if (ptr != null) {
                return ptr.getGType().getTypeName() + " : " + this.objectID;
            }
            return "Disposed handle";
        }
    }

    private final class SignalCallback
    extends GCallback {
        protected SignalCallback(String signal, Callback cb) {
            super(GObject.this.handle.connectSignal(signal, cb), cb);
            if (!this.connected) {
                throw new IllegalArgumentException(String.format("Failed to connect signal '%s'", signal));
            }
        }

        @Override
        protected synchronized void disconnect() {
            GObject.this.handle.disconnectSignal(this.id);
        }
    }

    public static interface GInterface {
        public GObject getGObject();
    }

    protected abstract class GCallback {
        protected final Callback cb;
        protected final NativeLong id;
        volatile boolean connected = false;

        protected GCallback(NativeLong id, Callback cb) {
            this.id = id != null ? id : new NativeLong(0L);
            this.cb = cb;
            this.connected = this.id.intValue() != 0;
        }

        void remove() {
            if (this.connected) {
                this.disconnect();
                this.connected = false;
            }
        }

        protected abstract void disconnect();
    }
}

