/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.glib;

import com.sun.jna.Pointer;
import org.freedesktop.gstreamer.glib.GInetAddress;
import org.freedesktop.gstreamer.glib.GLibException;
import org.freedesktop.gstreamer.glib.GSocketAddress;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GioAPI;

public class GInetSocketAddress
extends GSocketAddress {
    public static final String GTYPE_NAME = "GInetSocketAddress";

    public GInetSocketAddress(String address, int port) {
        this(GInetSocketAddress.createRawAddress(address, port));
    }

    GInetSocketAddress(NativeObject.Initializer init) {
        super(init);
    }

    public GInetAddress getAddress() {
        return (GInetAddress)this.get("address");
    }

    public int getPort() {
        return (Integer)this.get("port");
    }

    private static NativeObject.Initializer createRawAddress(String address, int port) {
        Pointer nativePointer = GioAPI.g_inet_socket_address_new_from_string(address, port);
        if (nativePointer == null) {
            throw new GLibException("Can not create " + GInetSocketAddress.class.getSimpleName() + " for " + address + ":" + port + ", please check that the IP address is valid, with format x.x.x.x");
        }
        return Natives.initializer(nativePointer);
    }
}

