/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

public class Version {
    public static final Version BASELINE = new Version(1, 8);
    private final int major;
    private final int minor;
    private final int micro;
    private final int nano;

    public Version(int major, int minor) {
        this(major, minor, 0, 0);
    }

    public Version(int major, int minor, int micro, int nano) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.nano = nano;
    }

    public String toString() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.micro, this.nano == 1 ? " (CVS)" : (this.nano >= 2 ? " (Pre-release)" : ""));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getNano() {
        return this.nano;
    }

    public boolean checkSatisfies(Version required) {
        return this.major == required.major && this.minor > required.minor || this.major == required.major && this.minor == required.minor && this.micro >= required.micro;
    }
}

