/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.util.HashSet;
import java.util.Set;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.PadDirection;
import org.freedesktop.gstreamer.PadLinkException;
import org.freedesktop.gstreamer.PadLinkReturn;
import org.freedesktop.gstreamer.PadProbeReturn;
import org.freedesktop.gstreamer.PadTemplate;
import org.freedesktop.gstreamer.event.Event;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.lowlevel.GstPadAPI;
import org.freedesktop.gstreamer.lowlevel.GstPadProbeInfo;
import org.freedesktop.gstreamer.lowlevel.GstPadPtr;

public class Pad
extends GstObject {
    public static final String GTYPE_NAME = "GstPad";
    private final Handle handle;

    Pad(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstPadPtr.class, GstPadPtr::new), init.ownsHandle), init.needRef);
    }

    private Pad(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    public Pad(String name, PadDirection direction) {
        this(Natives.initializer(GstPadAPI.GSTPAD_API.ptr_gst_pad_new(name, direction), false));
    }

    public Pad(PadTemplate template, String name) {
        this(Natives.initializer(GstPadAPI.GSTPAD_API.ptr_gst_pad_new_from_template(template, name), false));
    }

    public Caps queryCaps(Caps filter) {
        return GstPadAPI.GSTPAD_API.gst_pad_query_caps(this, filter);
    }

    public Caps getAllowedCaps() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_allowed_caps(this);
    }

    public Caps getCurrentCaps() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_current_caps(this);
    }

    public Pad getPeer() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_peer(this);
    }

    public Caps peerQueryCaps(Caps filter) {
        return GstPadAPI.GSTPAD_API.gst_pad_peer_query_caps(this, filter);
    }

    public boolean queryAcceptCaps(Caps caps) {
        return GstPadAPI.GSTPAD_API.gst_pad_query_accept_caps(this, caps);
    }

    public boolean peerQueryAcceptCaps(Caps caps) {
        return GstPadAPI.GSTPAD_API.gst_pad_peer_query_accept_caps(this, caps);
    }

    public void link(Pad sink) throws PadLinkException {
        PadLinkReturn result = GstPadAPI.GSTPAD_API.gst_pad_link(this, sink);
        if (result != PadLinkReturn.OK) {
            throw new PadLinkException(result);
        }
    }

    public boolean unlink(Pad pad) {
        return GstPadAPI.GSTPAD_API.gst_pad_unlink(this, pad);
    }

    public boolean isLinked() {
        return GstPadAPI.GSTPAD_API.gst_pad_is_linked(this);
    }

    public PadDirection getDirection() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_direction(this);
    }

    public Element getParentElement() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_parent_element(this);
    }

    public boolean setActive(boolean active) {
        return GstPadAPI.GSTPAD_API.gst_pad_set_active(this, active);
    }

    public boolean isBlocked() {
        return GstPadAPI.GSTPAD_API.gst_pad_is_blocked(this);
    }

    public void block(final Runnable callback) {
        this.addEventProbe(new EVENT_PROBE(){

            @Override
            public PadProbeReturn eventReceived(Pad pad, Event event) {
                callback.run();
                pad.removeCallback(EVENT_PROBE.class, this);
                return PadProbeReturn.DROP;
            }
        }, 67);
    }

    public boolean isBlocking() {
        return GstPadAPI.GSTPAD_API.gst_pad_is_blocking(this);
    }

    public void connect(final LINKED listener) {
        this.connect(LINKED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Pad peer) {
                listener.linked(pad, peer);
                return true;
            }
        });
    }

    public void disconnect(LINKED listener) {
        this.disconnect(LINKED.class, listener);
    }

    public void connect(final UNLINKED listener) {
        this.connect(UNLINKED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Pad peer) {
                listener.unlinked(pad, peer);
                return true;
            }
        });
    }

    public void disconnect(UNLINKED listener) {
        this.disconnect(UNLINKED.class, listener);
    }

    public void addEventProbe(EVENT_PROBE listener) {
        int mask = 448;
        this.addEventProbe(listener, 448);
    }

    void addEventProbe(final EVENT_PROBE listener, final int mask) {
        GstPadAPI.PadProbeCallback probe = new GstPadAPI.PadProbeCallback(){

            @Override
            public PadProbeReturn callback(Pad pad, GstPadProbeInfo probeInfo, Pointer user_data) {
                if ((probeInfo.padProbeType & mask) != 0) {
                    Event event = GstPadAPI.GSTPAD_API.gst_pad_probe_info_get_event(probeInfo);
                    return listener.eventReceived(pad, event);
                }
                return PadProbeReturn.OK;
            }
        };
        GObject.GCallback cb = new GObject.GCallback(this.handle.addProbe(mask, probe), (Callback)probe){

            @Override
            protected void disconnect() {
                Pad.this.handle.removeProbe(this.id);
            }
        };
        this.addCallback(EVENT_PROBE.class, listener, cb);
    }

    public void removeEventProbe(EVENT_PROBE listener) {
        this.removeCallback(EVENT_PROBE.class, listener);
    }

    public synchronized void addDataProbe(final DATA_PROBE listener) {
        GstPadAPI.PadProbeCallback probe = new GstPadAPI.PadProbeCallback(){

            @Override
            public PadProbeReturn callback(Pad pad, GstPadProbeInfo probeInfo, Pointer user_data) {
                if ((probeInfo.padProbeType & 0x10) != 0) {
                    Buffer buffer = GstPadAPI.GSTPAD_API.gst_pad_probe_info_get_buffer(probeInfo);
                    return listener.dataReceived(pad, buffer);
                }
                return PadProbeReturn.OK;
            }
        };
        GObject.GCallback cb = new GObject.GCallback(this.handle.addProbe(16, probe), (Callback)probe){

            @Override
            protected void disconnect() {
                Pad.this.handle.removeProbe(this.id);
            }
        };
        this.addCallback(DATA_PROBE.class, listener, cb);
    }

    public void removeDataProbe(DATA_PROBE listener) {
        this.removeCallback(DATA_PROBE.class, listener);
    }

    public boolean sendEvent(Event event) {
        return GstPadAPI.GSTPAD_API.gst_pad_send_event(this, event);
    }

    public boolean pushEvent(Event event) {
        return GstPadAPI.GSTPAD_API.gst_pad_push_event(this, event);
    }

    public FlowReturn chain(Buffer buffer) {
        return GstPadAPI.GSTPAD_API.gst_pad_chain(this, buffer);
    }

    public FlowReturn getRange(long offset, int size, Buffer[] buffer) {
        return GstPadAPI.GSTPAD_API.gst_pad_get_range(this, offset, size, buffer);
    }

    public FlowReturn pullRange(long offset, int size, Buffer[] buffer) {
        return GstPadAPI.GSTPAD_API.gst_pad_pull_range(this, offset, size, buffer);
    }

    public FlowReturn push(Buffer buffer) {
        return GstPadAPI.GSTPAD_API.gst_pad_push(this, buffer);
    }

    public PadTemplate getTemplate() {
        return GstPadAPI.GSTPAD_API.gst_pad_get_pad_template(this);
    }

    public boolean hasCurrentCaps() {
        return GstPadAPI.GSTPAD_API.gst_pad_has_current_caps(this);
    }

    private static class Handle
    extends GstObject.Handle {
        private final Set<NativeLong> probes = new HashSet<NativeLong>();

        private Handle(GstPadPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected GstPadPtr getPointer() {
            return (GstPadPtr)super.getPointer();
        }

        private synchronized NativeLong addProbe(int mask, GstPadAPI.PadProbeCallback probe) {
            NativeLong id = GstPadAPI.GSTPAD_API.gst_pad_add_probe(this.getPointer(), mask, probe, null, null);
            if (id.longValue() != 0L) {
                this.probes.add(id);
            }
            return id;
        }

        private synchronized void removeProbe(NativeLong id) {
            if (this.probes.remove(id)) {
                GstPadAPI.GSTPAD_API.gst_pad_remove_probe(this.getPointer(), id);
            }
        }

        private synchronized void clearProbes() {
            this.probes.forEach(id -> GstPadAPI.GSTPAD_API.gst_pad_remove_probe(this.getPointer(), (NativeLong)id));
            this.probes.clear();
        }

        @Override
        public void invalidate() {
            this.clearProbes();
            super.invalidate();
        }

        @Override
        public void dispose() {
            this.clearProbes();
            super.dispose();
        }
    }

    public static interface DATA_PROBE {
        public PadProbeReturn dataReceived(Pad var1, Buffer var2);
    }

    public static interface EVENT_PROBE {
        public PadProbeReturn eventReceived(Pad var1, Event var2);
    }

    public static interface UNLINKED {
        public void unlinked(Pad var1, Pad var2);
    }

    public static interface LINKED {
        public void linked(Pad var1, Pad var2);
    }
}

