/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import java.util.logging.Logger;
import org.freedesktop.gstreamer.ControlBinding;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstControlBindingPtr;
import org.freedesktop.gstreamer.lowlevel.GstObjectAPI;
import org.freedesktop.gstreamer.lowlevel.GstObjectPtr;

public class GstObject
extends GObject {
    private static Logger LOG = Logger.getLogger(GstObject.class.getName());
    private final Handle handle;

    protected GstObject(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstObjectPtr.class, GstObjectPtr::new), init.ownsHandle), init.needRef);
    }

    protected GstObject(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    public boolean setName(String name) {
        LOG.entering("GstObject", "setName", name);
        return GstObjectAPI.GSTOBJECT_API.gst_object_set_name(this, name);
    }

    public String getName() {
        LOG.entering("GstObject", "getName");
        return GstObjectAPI.GSTOBJECT_API.gst_object_get_name(this);
    }

    public GstObject getParent() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_get_parent(this);
    }

    public long suggestNextSync() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_suggest_next_sync(this.handle.getPointer());
    }

    public boolean syncValues(long timestamp) {
        return GstObjectAPI.GSTOBJECT_API.gst_object_sync_values(this.handle.getPointer(), timestamp);
    }

    public boolean hasActiveControlBindings() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_has_active_control_bindings(this.handle.getPointer());
    }

    public void setControlBindingsDisabled(boolean disabled) {
        GstObjectAPI.GSTOBJECT_API.gst_object_set_control_bindings_disabled(this.handle.getPointer(), disabled);
    }

    public void setControlBindingDisabled(String propertyName, boolean disabled) {
        GstObjectAPI.GSTOBJECT_API.gst_object_set_control_binding_disabled(this.handle.getPointer(), propertyName, disabled);
    }

    public void addControlBinding(ControlBinding binding) {
        GstControlBindingPtr bindingPtr = Natives.getPointer(binding).as(GstControlBindingPtr.class, GstControlBindingPtr::new);
        boolean ok = GstObjectAPI.GSTOBJECT_API.gst_object_add_control_binding(this.handle.getPointer(), bindingPtr);
        if (!ok) {
            throw new IllegalStateException();
        }
    }

    public ControlBinding getControlBinding(String propertyName) {
        GstControlBindingPtr ptr = GstObjectAPI.GSTOBJECT_API.gst_object_get_control_binding(this.handle.getPointer(), propertyName);
        return ptr == null ? null : Natives.callerOwnsReturn(ptr, ControlBinding.class);
    }

    public boolean removeControlBinding(ControlBinding binding) {
        GstControlBindingPtr bindingPtr = Natives.getPointer(binding).as(GstControlBindingPtr.class, GstControlBindingPtr::new);
        return GstObjectAPI.GSTOBJECT_API.gst_object_remove_control_binding(this.handle.getPointer(), bindingPtr);
    }

    @Override
    public String toString() {
        return String.format("%s: [%s]", this.getClass().getSimpleName(), this.getName());
    }

    protected static class Handle
    extends GObject.Handle {
        public Handle(GstObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void ref() {
            GstObjectAPI.GSTOBJECT_API.gst_object_ref(this.getPointer());
        }

        @Override
        protected void sink() {
            GstObjectAPI.GSTOBJECT_API.gst_object_ref_sink(this.getPointer());
        }

        @Override
        protected void unref() {
            GstObjectAPI.GSTOBJECT_API.gst_object_unref(this.getPointer());
        }

        @Override
        protected GstObjectPtr getPointer() {
            return (GstObjectPtr)super.getPointer();
        }
    }
}

