/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GstIteratorAPI;
import org.freedesktop.gstreamer.lowlevel.GstTypes;

class GstIterator<T extends NativeObject>
extends NativeObject
implements Iterable<T> {
    private final GType gtype;

    GstIterator(Pointer ptr, Class<T> cls) {
        super(new Handle(new GPointer(ptr), true));
        this.gtype = GstTypes.typeFor(cls);
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    public List<T> asList() {
        LinkedList<NativeObject> list = new LinkedList<NativeObject>();
        for (NativeObject t : this) {
            list.add(t);
        }
        return Collections.unmodifiableList(list);
    }

    private static final class Handle
    extends NativeObject.Handle {
        public Handle(GPointer ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GstIteratorAPI.GSTITERATOR_API.gst_iterator_free(ptr.getPointer());
        }
    }

    class IteratorImpl
    implements Iterator<T> {
        final GValueAPI.GValue gValue;
        T next;

        IteratorImpl() {
            this.gValue = new GValueAPI.GValue(GstIterator.this.gtype);
            this.next = this.getNext();
        }

        private T getNext() {
            if (GstIteratorAPI.GSTITERATOR_API.gst_iterator_next(GstIterator.this.getRawPointer(), this.gValue) == 1) {
                NativeObject result = (NativeObject)this.gValue.getValue();
                this.gValue.reset();
                return result;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object result = this.next;
            this.next = this.getNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Items cannot be removed.");
        }
    }
}

