/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.BusSyncHandler;
import org.freedesktop.gstreamer.BusSyncReply;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.TagList;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.lowlevel.GstBusAPI;
import org.freedesktop.gstreamer.lowlevel.GstMessageAPI;
import org.freedesktop.gstreamer.message.Message;
import org.freedesktop.gstreamer.message.MessageType;

public class Bus
extends GstObject {
    public static final String GTYPE_NAME = "GstBus";
    private static final Logger LOG = Logger.getLogger(Bus.class.getName());
    private final Object lock = new Object();
    private Map<Class<?>, Map<Object, MessageProxy>> signalListeners;
    private List<MessageProxy> messageProxies = new CopyOnWriteArrayList<MessageProxy>();
    private boolean watchAdded = false;
    private BusSyncHandler syncHandler = new BusSyncHandler(){

        @Override
        public BusSyncReply syncMessage(Message msg) {
            return BusSyncReply.PASS;
        }
    };
    private static final GstBusAPI.BusSyncHandler syncCallback = new GstBusAPI.BusSyncHandler(){
        {
            Native.setCallbackThreadInitializer(this, new CallbackThreadInitializer(true, Boolean.getBoolean("glib.detachCallbackThreads"), Bus.GTYPE_NAME));
        }

        @Override
        public BusSyncReply callback(final Bus bus, final Message msg, Pointer userData) {
            BusSyncReply reply;
            if (bus.syncHandler != null && (reply = bus.syncHandler.syncMessage(msg)) != BusSyncReply.DROP) {
                Gst.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        bus.dispatchMessage(msg);
                    }
                });
            }
            Natives.unref(msg);
            return BusSyncReply.DROP;
        }
    };

    Bus(NativeObject.Initializer init) {
        super(init);
        GstBusAPI.GSTBUS_API.gst_bus_set_sync_handler(this, null, null, null);
        GstBusAPI.GSTBUS_API.gst_bus_set_sync_handler(this, syncCallback, null, null);
    }

    public void setFlushing(boolean flushing) {
        GstBusAPI.GSTBUS_API.gst_bus_set_flushing(this, flushing ? 1 : 0);
    }

    public void connect(final EOS listener) {
        this.connect(EOS.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.endOfStream(msg.getSource());
                return true;
            }
        });
    }

    public void disconnect(EOS listener) {
        this.disconnect(EOS.class, listener);
    }

    public void connect(final ERROR listener) {
        this.connect(ERROR.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_error(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.errorMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(ERROR listener) {
        this.disconnect(ERROR.class, listener);
    }

    public void connect(final WARNING listener) {
        this.connect(WARNING.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_warning(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.warningMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(WARNING listener) {
        this.disconnect(WARNING.class, listener);
    }

    public void connect(final INFO listener) {
        this.connect(INFO.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_info(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.infoMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(INFO listener) {
        this.disconnect(INFO.class, listener);
    }

    public void connect(final STATE_CHANGED listener) {
        this.connect(STATE_CHANGED.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                State[] o = new State[1];
                State[] n = new State[1];
                State[] p = new State[1];
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_state_changed(msg, o, n, p);
                listener.stateChanged(msg.getSource(), o[0], n[0], p[0]);
                return true;
            }
        });
    }

    public void disconnect(STATE_CHANGED listener) {
        this.disconnect(STATE_CHANGED.class, listener);
    }

    public void connect(final TAG listener) {
        this.connect(TAG.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference list = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_tag(msg, list);
                TagList tl = new TagList(Natives.initializer(list.getValue()));
                listener.tagsFound(msg.getSource(), tl);
                return true;
            }
        });
    }

    public void disconnect(TAG listener) {
        this.disconnect(TAG.class, listener);
    }

    public void connect(final BUFFERING listener) {
        this.connect(BUFFERING.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                int[] percent = new int[]{0};
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_buffering(msg, percent);
                listener.bufferingData(msg.getSource(), percent[0]);
                return true;
            }
        });
    }

    public void disconnect(BUFFERING listener) {
        this.disconnect(BUFFERING.class, listener);
    }

    public void connect(final DURATION_CHANGED listener) {
        this.connect(DURATION_CHANGED.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.durationChanged(msg.getSource());
                return true;
            }
        });
    }

    public void disconnect(DURATION_CHANGED listener) {
        this.disconnect(DURATION_CHANGED.class, listener);
    }

    public void connect(final SEGMENT_START listener) {
        this.connect(SEGMENT_START.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                Format[] format = new Format[1];
                long[] position = new long[]{0L};
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_segment_start(msg, format, position);
                listener.segmentStart(msg.getSource(), format[0], position[0]);
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_START listener) {
        this.disconnect(SEGMENT_START.class, listener);
    }

    public void connect(final SEGMENT_DONE listener) {
        this.connect(SEGMENT_DONE.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                Format[] format = new Format[1];
                long[] position = new long[]{0L};
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_segment_done(msg, format, position);
                listener.segmentDone(msg.getSource(), format[0], position[0]);
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_DONE listener) {
        this.disconnect(SEGMENT_DONE.class, listener);
    }

    public void connect(final ASYNC_DONE listener) {
        this.connect(ASYNC_DONE.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.asyncDone(msg.getSource());
                return true;
            }
        });
    }

    public void disconnect(ASYNC_DONE listener) {
        this.disconnect(ASYNC_DONE.class, listener);
    }

    public void connect(final MESSAGE listener) {
        this.connect(MESSAGE.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.busMessage(bus, msg);
                return true;
            }
        });
    }

    public void connect(String signal, final MESSAGE listener) {
        if (signal.contains("::")) {
            signal = signal.substring(signal.lastIndexOf("::") + 2);
        }
        this.connect(signal, MESSAGE.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.busMessage(bus, msg);
                return true;
            }
        });
    }

    public void disconnect(MESSAGE listener) {
        this.disconnect(MESSAGE.class, listener);
    }

    public boolean post(Message message) {
        return GstBusAPI.GSTBUS_API.gst_bus_post(this, message);
    }

    public BusSyncHandler getSyncHandler() {
        return this.syncHandler;
    }

    public void setSyncHandler(BusSyncHandler handler) {
        this.syncHandler = handler;
    }

    private <T> void connect(Class<T> listenerClass, T listener, GstBusAPI.BusCallback callback) {
        String signal = listenerClass.getSimpleName().toLowerCase(Locale.ROOT).replace('_', '-');
        this.connect(signal, listenerClass, listener, callback);
    }

    @Override
    public synchronized <T> void connect(String signal, Class<T> listenerClass, T listener, Callback callback) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.connect(signal, listenerClass, listener, callback);
            return;
        }
        MessageType type = "message".equals(signal) ? MessageType.ANY : MessageType.valueOf(signal.toUpperCase(Locale.ROOT).replace('-', '_'));
        Map<Class<?>, Map<Object, MessageProxy>> signals = this.getListenerMap();
        Map<Object, MessageProxy> m = signals.get(listenerClass);
        if (m == null) {
            m = new HashMap<Object, MessageProxy>();
            signals.put(listenerClass, m);
        }
        MessageProxy proxy = new MessageProxy(type, (GstBusAPI.BusCallback)callback);
        m.put(listener, proxy);
        this.messageProxies.add(proxy);
        this.addWatch();
    }

    @Override
    public synchronized <T> void disconnect(Class<T> listenerClass, T listener) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.disconnect(listenerClass, listener);
            return;
        }
        Map<Class<?>, Map<Object, MessageProxy>> signals = this.getListenerMap();
        Map<Object, MessageProxy> m = signals.get(listenerClass);
        if (m != null) {
            MessageProxy proxy = m.remove(listener);
            if (proxy != null) {
                this.messageProxies.remove(proxy);
            }
            if (m.isEmpty()) {
                this.removeWatch();
                signals.remove(listenerClass);
            }
        }
    }

    private void dispatchMessage(Message msg) {
        this.messageProxies.forEach(listener -> {
            try {
                listener.busMessage(this, msg);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception thrown by bus message handler", t);
            }
        });
    }

    private final Map<Class<?>, Map<Object, MessageProxy>> getListenerMap() {
        if (this.signalListeners == null) {
            this.signalListeners = new ConcurrentHashMap();
        }
        return this.signalListeners;
    }

    @Override
    public void dispose() {
        this.removeWatch();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWatch() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.watchAdded) {
                LOG.fine("Add watch");
                GstBusAPI.GSTBUS_API.gst_bus_add_signal_watch(this);
                this.watchAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWatch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.watchAdded) {
                LOG.fine("Remove watch");
                GstBusAPI.GSTBUS_API.gst_bus_remove_signal_watch(this);
                this.watchAdded = false;
            }
        }
    }

    private static class MessageProxy
    implements MESSAGE {
        private final MessageType type;
        private final GstBusAPI.BusCallback callback;

        public MessageProxy(MessageType type, GstBusAPI.BusCallback callback) {
            this.type = type;
            this.callback = callback;
        }

        @Override
        public void busMessage(Bus bus, Message msg) {
            if ((this.type.intValue() & msg.getType().intValue()) != 0) {
                this.callback.callback(bus, msg, null);
            }
        }
    }

    public static interface MESSAGE {
        public void busMessage(Bus var1, Message var2);
    }

    public static interface ASYNC_DONE {
        public void asyncDone(GstObject var1);
    }

    public static interface SEGMENT_DONE {
        public void segmentDone(GstObject var1, Format var2, long var3);
    }

    public static interface SEGMENT_START {
        public void segmentStart(GstObject var1, Format var2, long var3);
    }

    public static interface DURATION_CHANGED {
        public void durationChanged(GstObject var1);
    }

    public static interface BUFFERING {
        public void bufferingData(GstObject var1, int var2);
    }

    public static interface STATE_CHANGED {
        public void stateChanged(GstObject var1, State var2, State var3, State var4);
    }

    public static interface TAG {
        public void tagsFound(GstObject var1, TagList var2);
    }

    public static interface INFO {
        public void infoMessage(GstObject var1, int var2, String var3);
    }

    public static interface WARNING {
        public void warningMessage(GstObject var1, int var2, String var3);
    }

    public static interface ERROR {
        public void errorMessage(GstObject var1, int var2, String var3);
    }

    public static interface EOS {
        public void endOfStream(GstObject var1);
    }
}

