/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.freedesktop.gstreamer.BufferFlags;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.glib.NativeFlags;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstBufferAPI;

public class Buffer
extends MiniObject {
    public static final String GTYPE_NAME = "GstBuffer";
    private final GstBufferAPI.MapInfoStruct mapInfo = new GstBufferAPI.MapInfoStruct();
    private final GstBufferAPI.BufferStruct struct = new GstBufferAPI.BufferStruct(this.getRawPointer());

    public Buffer() {
        this(Natives.initializer(GstBufferAPI.GSTBUFFER_API.ptr_gst_buffer_new()));
    }

    public Buffer(int size) {
        this(Natives.initializer(Buffer.allocBuffer(size)));
    }

    Buffer(NativeObject.Initializer init) {
        super(init);
    }

    private static Pointer allocBuffer(int size) {
        Pointer ptr = GstBufferAPI.GSTBUFFER_API.ptr_gst_buffer_new_allocate(null, size, null);
        if (ptr == null) {
            throw new OutOfMemoryError("Could not allocate Buffer of size " + size);
        }
        return ptr;
    }

    public ByteBuffer map(boolean writable) {
        boolean ok = GstBufferAPI.GSTBUFFER_API.gst_buffer_map(this, this.mapInfo, writable ? 2 : 1);
        if (ok && this.mapInfo.data != null) {
            return this.mapInfo.data.getByteBuffer(0L, this.mapInfo.size.intValue());
        }
        return null;
    }

    public void unmap() {
        GstBufferAPI.GSTBUFFER_API.gst_buffer_unmap(this, this.mapInfo);
    }

    public long getDecodeTimestamp() {
        return (Long)this.struct.readField("dts");
    }

    public void setDecodeTimestamp(long val) {
        this.struct.writeField("dts", val);
    }

    public long getPresentationTimestamp() {
        return (Long)this.struct.readField("pts");
    }

    public void setPresentationTimestamp(long val) {
        this.struct.writeField("pts", val);
    }

    public long getDuration() {
        return (Long)this.struct.readField("duration");
    }

    public void setDuration(long val) {
        this.struct.writeField("duration", val);
    }

    public long getOffset() {
        return (Long)this.struct.readField("offset");
    }

    public void setOffset(long val) {
        this.struct.writeField("offset", val);
    }

    public long getOffsetEnd() {
        return (Long)this.struct.readField("offset_end");
    }

    public void setOffsetEnd(long val) {
        this.struct.writeField("offset_end", val);
    }

    @Gst.Since(minor=10)
    public EnumSet<BufferFlags> getFlags() {
        Gst.checkVersion(1, 10);
        int nativeInt = GstBufferAPI.GSTBUFFER_API.gst_buffer_get_flags(this);
        return NativeFlags.fromInt(BufferFlags.class, nativeInt);
    }

    @Gst.Since(minor=10)
    public boolean setFlags(EnumSet<BufferFlags> flags) {
        Gst.checkVersion(1, 10);
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_set_flags(this, NativeFlags.toInt(flags));
    }

    @Gst.Since(minor=10)
    public boolean unsetFlags(EnumSet<BufferFlags> flags) {
        Gst.checkVersion(1, 10);
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_unset_flags(this, NativeFlags.toInt(flags));
    }
}

