/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.util.EnumSet;
import java.util.List;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstIterator;
import org.freedesktop.gstreamer.glib.NativeFlags;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.lowlevel.GstBinAPI;
import org.freedesktop.gstreamer.lowlevel.GstObjectPtr;

public class Bin
extends Element {
    public static final String GST_NAME = "bin";
    public static final String GTYPE_NAME = "GstBin";

    protected Bin(NativeObject.Initializer init) {
        super(init);
    }

    Bin(Handle handle, boolean needRef) {
        super(handle, needRef);
    }

    public Bin() {
        this(Natives.initializer(GstBinAPI.GSTBIN_API.ptr_gst_bin_new(null), false, true));
    }

    public Bin(String name) {
        this(Natives.initializer(GstBinAPI.GSTBIN_API.ptr_gst_bin_new(name), false, true));
    }

    public boolean add(Element element) {
        return GstBinAPI.GSTBIN_API.gst_bin_add(this, element);
    }

    public void addMany(Element ... elements) {
        GstBinAPI.GSTBIN_API.gst_bin_add_many(this, elements);
    }

    public boolean remove(Element element) {
        return GstBinAPI.GSTBIN_API.gst_bin_remove(this, element);
    }

    public void removeMany(Element ... elements) {
        GstBinAPI.GSTBIN_API.gst_bin_remove_many(this, elements);
    }

    private List<Element> elementList(Pointer iter) {
        return new GstIterator<Element>(iter, Element.class).asList();
    }

    public List<Element> getElements() {
        return this.elementList(GstBinAPI.GSTBIN_API.gst_bin_iterate_elements(this));
    }

    public List<Element> getElementsSorted() {
        return this.elementList(GstBinAPI.GSTBIN_API.gst_bin_iterate_sorted(this));
    }

    public List<Element> getElementsRecursive() {
        return this.elementList(GstBinAPI.GSTBIN_API.gst_bin_iterate_recurse(this));
    }

    public List<Element> getSinks() {
        return this.elementList(GstBinAPI.GSTBIN_API.gst_bin_iterate_sinks(this));
    }

    public List<Element> getSources() {
        return this.elementList(GstBinAPI.GSTBIN_API.gst_bin_iterate_sources(this));
    }

    public Element getElementByName(String name) {
        return GstBinAPI.GSTBIN_API.gst_bin_get_by_name(this, name);
    }

    public Element getElementByNameRecurseUp(String name) {
        return GstBinAPI.GSTBIN_API.gst_bin_get_by_name_recurse_up(this, name);
    }

    public void debugToDotFile(EnumSet<DebugGraphDetails> details, String fileName) {
        GstBinAPI.GSTBIN_API.gst_debug_bin_to_dot_file(this, NativeFlags.toInt(details), fileName);
    }

    public void debugToDotFileWithTS(EnumSet<DebugGraphDetails> details, String fileName) {
        GstBinAPI.GSTBIN_API.gst_debug_bin_to_dot_file_with_ts(this, NativeFlags.toInt(details), fileName);
    }

    public void connect(final ELEMENT_ADDED listener) {
        this.connect(ELEMENT_ADDED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Element elem) {
                listener.elementAdded(bin, elem);
            }
        });
    }

    public void disconnect(ELEMENT_ADDED listener) {
        this.disconnect(ELEMENT_ADDED.class, listener);
    }

    public void connect(final ELEMENT_REMOVED listener) {
        this.connect(ELEMENT_REMOVED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Element elem) {
                listener.elementRemoved(bin, elem);
            }
        });
    }

    public void disconnect(ELEMENT_REMOVED listener) {
        this.disconnect(ELEMENT_REMOVED.class, listener);
    }

    @Gst.Since(minor=10)
    public void connect(final DEEP_ELEMENT_ADDED listener) {
        Gst.checkVersion(1, 10);
        this.connect(DEEP_ELEMENT_ADDED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Bin sub_bin, Element elem) {
                listener.elementAdded(bin, sub_bin, elem);
            }
        });
    }

    @Gst.Since(minor=10)
    public void disconnect(DEEP_ELEMENT_ADDED listener) {
        this.disconnect(DEEP_ELEMENT_ADDED.class, listener);
    }

    @Gst.Since(minor=10)
    public void connect(final DEEP_ELEMENT_REMOVED listener) {
        Gst.checkVersion(1, 10);
        this.connect(DEEP_ELEMENT_REMOVED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Bin sub_bin, Element elem) {
                listener.elementRemoved(bin, sub_bin, elem);
            }
        });
    }

    @Gst.Since(minor=10)
    public void disconnect(DEEP_ELEMENT_REMOVED listener) {
        this.disconnect(DEEP_ELEMENT_REMOVED.class, listener);
    }

    public void connect(final DO_LATENCY listener) {
        this.connect(DO_LATENCY.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin) {
                listener.doLatency(bin);
            }
        });
    }

    public void disconnect(DO_LATENCY listener) {
        this.disconnect(DO_LATENCY.class, listener);
    }

    static class Handle
    extends Element.Handle {
        public Handle(GstObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }
    }

    public static enum DebugGraphDetails implements NativeFlags<DebugGraphDetails>
    {
        SHOW_MEDIA_TYPE(1),
        SHOW_CAPS_DETAILS(2),
        SHOW_NON_DEFAULT_PARAMS(4),
        SHOW_STATES(8);

        public static final EnumSet<DebugGraphDetails> SHOW_ALL;
        private final int value;

        private DebugGraphDetails(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        static {
            SHOW_ALL = EnumSet.allOf(DebugGraphDetails.class);
        }
    }

    public static interface DO_LATENCY {
        public void doLatency(Bin var1);
    }

    @Gst.Since(minor=10)
    public static interface DEEP_ELEMENT_REMOVED {
        public void elementRemoved(Bin var1, Bin var2, Element var3);
    }

    @Gst.Since(minor=10)
    public static interface DEEP_ELEMENT_ADDED {
        public void elementAdded(Bin var1, Bin var2, Element var3);
    }

    public static interface ELEMENT_REMOVED {
        public void elementRemoved(Bin var1, Element var2);
    }

    public static interface ELEMENT_ADDED {
        public void elementAdded(Bin var1, Element var2);
    }
}

