/*
 * Decompiled with CFR 0.152.
 */
package misc;

import control.Control_GetPath;
import control.SRSOutput;
import gui.Gui_StreamRipStar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import misc.Commandline;

public class StreamRipStar {
    public static final int releaseRevision = 613;
    public static final String releaseVersion = "0.6.10";
    private static boolean noConfiFileFound = false;
    private static String lang = "";
    private static String reg = "";
    private static String lnfClassName = null;

    public static void main(String[] args) {
        StreamRipStar.start(args);
    }

    private static void start(String[] args) {
        Commandline cmd = new Commandline(args);
        if (!cmd.requestHelpMessage()) {
            Short langs = StreamRipStar.getPrefsFromFile();
            if (langs == 0) {
                lang = "en";
            } else if (langs == 1) {
                lang = "de";
                reg = "DE";
            } else if (langs == 2) {
                lang = "system";
            } else if (langs == 3) {
                lang = "fr";
                reg = "FR";
            } else {
                lang = "system";
            }
            StreamRipStar.setLookAndFeel();
            if (lang == null || noConfiFileFound) {
                new Gui_StreamRipStar(true, cmd);
            } else if (lang.equals("system")) {
                new Gui_StreamRipStar(false, cmd);
            } else {
                if (reg.equals("")) {
                    Locale.setDefault(new Locale(lang));
                } else {
                    Locale.setDefault(new Locale(lang, reg));
                }
                new Gui_StreamRipStar(false, cmd);
            }
        }
    }

    public static void setLookAndFeel() {
        if (lnfClassName != null) {
            try {
                UIManager.setLookAndFeel(lnfClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
        }
    }

    private static Short getPrefsFromFile() {
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        Short tmpShort = -1;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Settings-StreamRipStar.xml"));
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Settings-StreamRipStar.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (parser.getAttributeLocalName(i).equals("langMenu_index")) {
                                tmpShort = Short.valueOf(parser.getAttributeValue(i));
                                if (tmpShort == 0) {
                                    lang = "en";
                                } else if (tmpShort == 1) {
                                    lang = "de";
                                    reg = "DE";
                                } else {
                                    lang = "system";
                                }
                            } else if (parser.getAttributeLocalName(i).equals("LookAndFeelBox_className")) {
                                String tmp = parser.getAttributeValue(i);
                                lnfClassName = tmp.equals("null") ? null : parser.getAttributeValue(i);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Settings-StreamRipStar.xml");
            noConfiFileFound = true;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return tmpShort;
    }
}

