/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.text.DateFormat;
import java.util.Date;

public class SchedulJob {
    private int streamID = 0;
    private int schedulID = 0;
    private long startTime = 0L;
    private long stopTime = 0L;
    private long oldStopTime = 0L;
    private boolean useOldStopTime = false;
    private boolean daily = false;
    private boolean weekly = false;
    private boolean monthly = false;
    private boolean enableJob = false;
    private boolean isRecording = false;
    private boolean atStart = false;
    private String comment = "";
    public static int lastID = 1;

    public SchedulJob(int schedulJobID, int streamID, long startTime, long stopTime, int howOftenID, boolean enable, String comment) {
        this.schedulID = schedulJobID;
        this.streamID = streamID;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.enableJob = enable;
        this.comment = comment;
        if (howOftenID == 0) {
            this.daily = true;
        } else if (howOftenID == 1) {
            this.weekly = true;
        } else if (howOftenID == 2) {
            this.monthly = true;
        } else if (howOftenID == 3) {
            this.atStart = true;
        }
    }

    public static int getNewID() {
        return ++lastID - 1;
    }

    public void setSchedulJobID(int newSchedulID) {
        this.schedulID = newSchedulID;
    }

    public void setStreamID(int newStreamID) {
        this.streamID = newStreamID;
    }

    public void setStartTime(long newStartTime) {
        this.startTime = newStartTime;
    }

    public void setStopTime(long newStopTime) {
        this.stopTime = newStopTime;
    }

    public void setOldStopTime(long oldStopTime) {
        this.oldStopTime = oldStopTime;
    }

    public void setJobEnabled(boolean enable) {
        this.enableJob = enable;
    }

    public void setJobCounts(int howOftenID) {
        if (howOftenID == 0) {
            this.clearJobCounts();
            this.daily = true;
        } else if (howOftenID == 1) {
            this.clearJobCounts();
            this.weekly = true;
        } else if (howOftenID == 2) {
            this.clearJobCounts();
            this.monthly = true;
        }
    }

    private void clearJobCounts() {
        this.daily = false;
        this.weekly = false;
        this.monthly = false;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
    }

    public int getStreamID() {
        return this.streamID;
    }

    public int getSchedulID() {
        return this.schedulID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getOldStopTime() {
        return this.oldStopTime;
    }

    public String getStartTimeAsLocaleTime() {
        String date = DateFormat.getDateInstance(3).format(new Date(this.startTime));
        String time = DateFormat.getTimeInstance(3).format(new Date(this.startTime));
        return String.valueOf(date) + " - " + time;
    }

    public String getStopTimeAsLocaleTime() {
        String date = DateFormat.getDateInstance(3).format(new Date(this.stopTime));
        String time = DateFormat.getTimeInstance(3).format(new Date(this.stopTime));
        return String.valueOf(date) + " - " + time;
    }

    public int getJobCount() {
        int count = -1;
        if (this.daily) {
            count = 0;
        } else if (this.weekly) {
            count = 1;
        } else if (this.monthly) {
            count = 2;
        } else if (this.atStart) {
            count = 3;
        }
        return count;
    }

    public boolean isJobenabled() {
        return this.enableJob;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean isOnceJob() {
        if (this.daily || this.weekly || this.monthly || this.atStart) {
            return false;
        }
        return true;
    }

    public boolean isAtStartJob() {
        return this.atStart;
    }

    public boolean useOldStopTime() {
        return this.useOldStopTime;
    }

    public void setUseOldStopTime(boolean use) {
        this.useOldStopTime = use;
    }

    public void setStatus(boolean newStatus) {
        this.isRecording = newStatus;
    }

    public boolean getstatus() {
        return this.isRecording;
    }

    public void toggleEnableJob() {
        this.enableJob = !this.enableJob;
    }
}

