/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.VolumeManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VolumeControlGUI
extends JPanel
implements MouseMotionListener,
ChangeListener {
    private static final long serialVersionUID = -838962312550616576L;
    private VolumeManager vm;
    private JSlider audioSlider;

    public VolumeControlGUI(VolumeManager vm) {
        this.vm = vm;
        this.audioSlider = new JSlider(0, 0, 100, 50);
        this.audioSlider.setMajorTickSpacing(10);
        this.audioSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(25), new JLabel("25"));
        labelTable.put(new Integer(50), new JLabel("50"));
        labelTable.put(new Integer(75), new JLabel("75"));
        labelTable.put(new Integer(100), new JLabel("100"));
        this.audioSlider.setLabelTable(labelTable);
        this.audioSlider.setPaintLabels(true);
        this.add(this.audioSlider);
        this.addMouseMotionListener(this);
        this.audioSlider.addChangeListener(this);
        this.addMouseWheelListener(new MouseWheelVolumeChangeListener());
        vm.addVolumeControl(this);
    }

    public int getVolume() {
        return this.audioSlider.getValue();
    }

    public void setVolume(int newVolume) {
        if (newVolume >= 0 && newVolume <= 100) {
            this.audioSlider.setValue(newVolume);
            this.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.vm.changeVolume(this, this.audioSlider.getValue());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    class MouseWheelVolumeChangeListener
    implements MouseWheelListener {
        MouseWheelVolumeChangeListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent arg0) {
            int howMuch = arg0.getWheelRotation();
            int percentage = VolumeControlGUI.this.audioSlider.getValue();
            if (howMuch < 0 && (percentage += 10) > 100) {
                percentage = 100;
            }
            if (howMuch > 0 && (percentage -= 10) < 0) {
                percentage = 0;
            }
            VolumeControlGUI.this.audioSlider.setValue(percentage);
        }
    }
}

