/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_GetPath;
import control.SRSOutput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ViewLog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private JButton OKButton = new JButton("OK");
    private JButton deleteButton = new JButton("Delete File");
    private JPanel buttonPanel = new JPanel();
    private JTextArea logField = new JTextArea();
    private JScrollPane logSP = new JScrollPane(this.logField);

    public ViewLog(JFrame mainWindow) {
        super(mainWindow);
        this.setLayout(new BorderLayout());
        this.add((Component)this.logSP, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.OKButton.addActionListener(new OKListener());
        this.deleteButton.addActionListener(new DeleteListener());
        this.buttonPanel.add(this.OKButton);
        this.buttonPanel.add(this.deleteButton);
        this.setLanguage();
        this.logField.setEditable(false);
        this.loadLogFromFile();
        Dimension frameDim = new Dimension(600, 600);
        this.setSize(frameDim);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void setLanguage() {
        try {
            this.setTitle(this.trans.getString("ViewLog.title"));
            this.OKButton.setText(this.trans.getString("ViewLog.okButton"));
            this.deleteButton.setText(this.trans.getString("ViewLog.deleteButton"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    private void loadLogFromFile() {
        BufferedReader reader = null;
        String txt = "";
        this.logField.setText("");
        try {
            try {
                String path = String.valueOf(new Control_GetPath().getStreamRipStarPath()) + "/output.log";
                reader = new BufferedReader(new FileReader(path));
                while ((txt = reader.readLine()) != null) {
                    this.logField.append(String.valueOf(txt) + "\n");
                }
            }
            catch (FileNotFoundException e) {
                SRSOutput.getInstance().log("No logfile found");
                JOptionPane.showConfirmDialog(this, this.trans.getString("ViewLog.FileNotFound"));
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                SRSOutput.getInstance().logE("IOException when reading the error log file\n" + e.getMessage());
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class DeleteListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SRSOutput.getInstance().deleteLogFile();
            ViewLog.this.loadLogFromFile();
        }
    }

    public class OKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ViewLog.this.dispose();
        }
    }
}

