/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.SRSOutput;
import control.VolumeManager;
import gui.Gui_StreamRipStar;
import gui.IconButton;
import gui.VolumeControlGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InternAudioControlPanel
extends JPanel {
    private static final long serialVersionUID = -1810951909523547564L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private ImageIcon lastStreamIcon = new ImageIcon(this.getClass().getResource("/Icons/audioplayer/back2.png"));
    private ImageIcon nextStreamIcon = new ImageIcon(this.getClass().getResource("/Icons/audioplayer/forward2.png"));
    private ImageIcon startStreamIcon = new ImageIcon(this.getClass().getResource("/Icons/audioplayer/play2.png"));
    private ImageIcon stopStreamIcon = new ImageIcon(this.getClass().getResource("/Icons/audioplayer/stop2.png"));
    private IconButton startPlayingButton = new IconButton("Start Playing", this.startStreamIcon);
    private IconButton stopPlayingButton = new IconButton("Stop Playing", this.stopStreamIcon);
    private IconButton lastStreamButton = new IconButton("Play previous Stream", this.lastStreamIcon);
    private IconButton nextPlayingButton = new IconButton("Play Next Stream", this.nextStreamIcon);
    private JTextField titleArea = new JTextField();
    private VolumeControlGUI audioSlider2;
    private VolumeManager vm;
    private JToolBar panel = new JToolBar();
    private Gui_StreamRipStar mainGui = null;

    public InternAudioControlPanel(Gui_StreamRipStar mainGui, VolumeManager vm) {
        this.mainGui = mainGui;
        this.vm = vm;
        this.audioSlider2 = new VolumeControlGUI(this.vm);
        this.setLayout(new BorderLayout());
        this.panel.add(this.lastStreamButton);
        this.panel.add(this.startPlayingButton);
        this.panel.add(this.stopPlayingButton);
        this.panel.add(this.nextPlayingButton);
        this.titleArea.setEditable(false);
        this.panel.setBackground(new Color(238, 238, 238, 255));
        this.panel.setFloatable(false);
        this.setTextUnderIcons(mainGui.showTextUnderIcons());
        this.setFontsAll(mainGui.getFontForTextUnderIcons());
        this.startPlayingButton.addActionListener(new PlayMusikListener());
        this.stopPlayingButton.addActionListener(new StopPlayMusikListener());
        this.lastStreamButton.addActionListener(new PlayPreviousStreamListener());
        this.nextPlayingButton.addActionListener(new PlayNextStreamListener());
        this.add((Component)this.panel, "West");
        this.repaint();
        this.add((Component)this.audioSlider2, "East");
        this.add((Component)this.titleArea, "South");
    }

    public void setTextUnderIcons(boolean textEnabled) {
        if (textEnabled) {
            try {
                this.startPlayingButton.setText(this.trans.getString("internAudioCP.startPlaying"));
                this.stopPlayingButton.setText(this.trans.getString("internAudioCP.stopPlaying"));
                this.lastStreamButton.setText(this.trans.getString("internAudioCP.lastStream"));
                this.nextPlayingButton.setText(this.trans.getString("internAudioCP.nextStream"));
            }
            catch (MissingResourceException e) {
                SRSOutput.getInstance().logE("Translation Error: Error while setting the translation in InternAudioControlPanel");
                SRSOutput.getInstance().logE(e.getMessage());
            }
        } else {
            this.startPlayingButton.setText(null);
            this.stopPlayingButton.setText(null);
            this.lastStreamButton.setText(null);
            this.nextPlayingButton.setText(null);
        }
    }

    public void setToolTipsAll() {
        this.audioSlider2.setToolTipText(this.trans.getString("toolTip.audioSlider"));
        this.stopPlayingButton.setToolTipText(this.trans.getString("toolTip.stopHearMusicButton"));
    }

    public void setFontsAll(Font newFont) {
        this.startPlayingButton.setFont(newFont);
        this.stopPlayingButton.setFont(newFont);
        this.lastStreamButton.setFont(newFont);
        this.nextPlayingButton.setFont(newFont);
    }

    public int getAudioVolume() {
        return this.audioSlider2.getVolume();
    }

    public void setAudioVolume(int newVolume) {
        this.audioSlider2.setVolume(newVolume);
    }

    public void setTitle(String title, boolean isErrorMessage) {
        if (!isErrorMessage) {
            this.titleArea.setForeground(Color.BLACK);
        } else {
            this.titleArea.setForeground(Color.RED);
        }
        this.titleArea.setText(title);
    }

    public class PlayMusikListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            InternAudioControlPanel.this.mainGui.playSelectedStream();
        }
    }

    class PlayNextStreamListener
    implements ActionListener {
        PlayNextStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InternAudioControlPanel.this.mainGui.playNextStream();
        }
    }

    class PlayPreviousStreamListener
    implements ActionListener {
        PlayPreviousStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InternAudioControlPanel.this.mainGui.playPreviousStream();
        }
    }

    class StopPlayMusikListener
    implements ActionListener {
        StopPlayMusikListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InternAudioControlPanel.this.mainGui.getTabel().stopInternalAudioPlayer();
        }
    }

    public class VolumeChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent arg0) {
            InternAudioControlPanel.this.mainGui.setVolume(InternAudioControlPanel.this.audioSlider2.getVolume());
        }
    }
}

