/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_PlayList;
import control.Control_Stream;
import control.SRSOutput;
import gui.Gui_JTTable;
import gui.Gui_StreamOptions;
import gui.Gui_StreamRipStar;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class Import_Streams
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private JPanel mainPanel = new JPanel();
    private Object[] importHeader = new Object[]{"import", "Stream Name", "Address", "Website"};
    private String[][] allData = new String[0][];
    private DefaultTableModel importModel = new DefaultTableModel(this.allData, this.importHeader){
        private static final long serialVersionUID = 1L;

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }
    };
    private Gui_JTTable importTable = new Gui_JTTable(this.importModel);
    private JScrollPane importPane = new JScrollPane(this.importTable);
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/abort_small.png"));
    private ImageIcon browseIcon = new ImageIcon(this.getClass().getResource("/Icons/open_small.png"));
    private ImageIcon importIcon = new ImageIcon(this.getClass().getResource("/Icons/import_small.png"));
    private ImageIcon loadIcon = new ImageIcon(this.getClass().getResource("/Icons/load_small.png"));
    private JButton browseButton = new JButton(this.browseIcon);
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JButton importButton = new JButton("Import", this.importIcon);
    private JButton loadButton = new JButton("Load", this.loadIcon);
    private JButton selectAllButton = new JButton("Select All");
    private JButton unselectAllButton = new JButton("Unselect All");
    private JLabel destLabel = new JLabel("Source :");
    private JTextField importPathField = new JTextField("myImport.pls");
    private JFileChooser dirChooser = new JFileChooser();
    private String[][] importableStreams = null;
    private Gui_StreamRipStar mainGui = null;
    private Control_Stream controlStreams = null;

    public Import_Streams(Gui_StreamRipStar gui, Control_Stream controlStreams) {
        super((Frame)gui, "importiere Stream");
        this.mainGui = gui;
        this.controlStreams = controlStreams;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLanguage();
        this.init();
    }

    public Import_Streams(Gui_StreamRipStar gui, Control_Stream controlStreams, String url) {
        super((Frame)gui, "importiere Stream");
        this.mainGui = gui;
        this.controlStreams = controlStreams;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLanguage();
        this.importPathField.setText(url);
        this.load();
        this.init();
    }

    private void init() {
        this.importTable.getColumn(this.importHeader[0]).setMaxWidth(50);
        this.importTable.getTableHeader().setReorderingAllowed(false);
        this.mainPanel.setLayout(new GridBagLayout());
        this.add(this.mainPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridx = 0;
        this.mainPanel.add((Component)this.destLabel, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.mainPanel.add((Component)this.importPathField, c);
        c.insets = new Insets(5, 0, 5, 5);
        c.gridx = 4;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.browseButton, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 5;
        this.mainPanel.add((Component)this.loadButton, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 6;
        this.mainPanel.add((Component)this.importPane, c);
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridy = 2;
        c.gridx = 0;
        this.mainPanel.add((Component)this.importButton, c);
        c.gridx = 1;
        c.anchor = 10;
        this.mainPanel.add((Component)this.selectAllButton, c);
        c.gridx = 2;
        this.mainPanel.add((Component)this.unselectAllButton, c);
        c.gridx = 4;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.mainPanel.add((Component)this.abortButton, c);
        this.browseButton.addActionListener(new BrowseListener());
        this.abortButton.addActionListener(new AbortListener());
        this.loadButton.addActionListener(new LoadListener());
        this.dirChooser.setFileFilter(new PlayListFilter());
        this.importButton.addActionListener(new ImportListener());
        this.selectAllButton.addActionListener(new SelectAllListener());
        this.unselectAllButton.addActionListener(new UnselectAllListener());
        this.setDefaultCloseOperation(2);
        this.pack();
        Dimension frameDim = this.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().registerKeyboardAction(new AbortListener(), escStroke, 2);
        this.setVisible(true);
    }

    private void setLanguage() {
        try {
            this.setTitle(this.trans.getString("importStream"));
            this.abortButton.setText(this.trans.getString("abortButton"));
            this.importButton.setText(this.trans.getString("import"));
            this.loadButton.setText(this.trans.getString("load"));
            this.selectAllButton.setText(this.trans.getString("selectAll"));
            this.unselectAllButton.setText(this.trans.getString("unselectAll"));
            this.destLabel.setText(this.trans.getString("source"));
            this.importPathField.setText(this.trans.getString("myPlayList"));
            this.importHeader[0] = this.trans.getString("import");
            this.importHeader[1] = this.trans.getString("streamname");
            this.importHeader[2] = this.trans.getString("address");
            this.importHeader[3] = this.trans.getString("website");
            this.importModel.setColumnIdentifiers(this.importHeader);
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    private void fillListTable() {
        if (this.importableStreams != null) {
            int i = 0;
            while (i < this.importableStreams.length) {
                Object[] tmp = new Object[]{new Boolean(false), this.importableStreams[i][1], this.importableStreams[i][0], this.importableStreams[i][2]};
                this.importModel.addRow(tmp);
                ++i;
            }
        }
    }

    private Import_Streams getMe() {
        return this;
    }

    private void removeAllFromTable() {
        int rowCount;
        int i = rowCount = this.importModel.getRowCount();
        while (i > 0) {
            this.importModel.removeRow(i - 1);
            --i;
        }
    }

    private void load() {
        String pathPlayList = this.importPathField.getText().toLowerCase().trim();
        if (pathPlayList.endsWith(".pls") || pathPlayList.endsWith(".m3u")) {
            this.removeAllFromTable();
            this.importableStreams = new Control_PlayList().anlyseFile(this.importPathField.getText());
            this.fillListTable();
            this.selectAll();
        }
    }

    public void selectAll() {
        int i = 0;
        while (i < this.importTable.getRowCount()) {
            this.importTable.setValueAt(true, i, 0);
            ++i;
        }
    }

    public void unselectAll() {
        int i = 0;
        while (i < this.importTable.getRowCount()) {
            this.importTable.setValueAt(false, i, 0);
            ++i;
        }
    }

    class AbortListener
    implements ActionListener {
        AbortListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Import_Streams.this.dispose();
        }
    }

    class BrowseListener
    implements ActionListener {
        BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Import_Streams.this.dirChooser.setFileSelectionMode(0);
            int i = Import_Streams.this.dirChooser.showOpenDialog(Import_Streams.this.getMe());
            if (i == 0) {
                Import_Streams.this.importPathField.setText(Import_Streams.this.dirChooser.getSelectedFile().toString());
            }
            Import_Streams.this.load();
            Import_Streams.this.selectAll();
        }
    }

    class ImportListener
    implements ActionListener {
        ImportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int importStreamCount = Import_Streams.this.importModel.getRowCount();
            Vector<Integer> toImportLines = new Vector<Integer>(0, 1);
            Boolean errorAcc = false;
            Boolean ignoreAll = false;
            int i = 0;
            while (i < importStreamCount) {
                if (!errorAcc.booleanValue() && Import_Streams.this.importModel.getValueAt(i, 1).toString().trim().equals("")) {
                    JOptionPane.showMessageDialog(Import_Streams.this.getMe(), Import_Streams.this.trans.getString("Import.everyName"));
                    errorAcc = true;
                } else if (!errorAcc.booleanValue() && ((Boolean)Import_Streams.this.importModel.getValueAt(i, 0)).booleanValue()) {
                    if (Import_Streams.this.mainGui.getControlStream().existURL(Import_Streams.this.importModel.getValueAt(i, 2).toString().trim()).booleanValue()) {
                        if (!ignoreAll.booleanValue()) {
                            Object[] options = new Object[]{Import_Streams.this.trans.getString("import.Options0"), Import_Streams.this.trans.getString("import.Options1"), Import_Streams.this.trans.getString("import.Options2")};
                            int choose = JOptionPane.showOptionDialog(Import_Streams.this.getMe(), String.valueOf(Import_Streams.this.trans.getString("import.URLExist")) + Import_Streams.this.importModel.getValueAt(i, 2).toString().trim() + Import_Streams.this.trans.getString("import.WhatDo"), Import_Streams.this.trans.getString("import.URLExistHeader"), -1, 2, null, options, options[0]);
                            if (choose == 0) {
                                errorAcc = true;
                            } else if (choose != 1 && choose == 2) {
                                ignoreAll = true;
                            }
                        }
                    } else {
                        toImportLines.add(i);
                    }
                }
                ++i;
            }
            if (!errorAcc.booleanValue()) {
                i = 0;
                while (i < toImportLines.capacity()) {
                    String[] stream = new String[4];
                    stream[1] = Import_Streams.this.importModel.getValueAt((Integer)toImportLines.get(i), 1).toString();
                    stream[0] = Import_Streams.this.importModel.getValueAt((Integer)toImportLines.get(i), 2).toString();
                    stream[2] = Import_Streams.this.importModel.getValueAt((Integer)toImportLines.get(i), 3).toString();
                    Gui_StreamOptions addStream = new Gui_StreamOptions(null, Import_Streams.this.mainGui, true, false, false);
                    addStream.setBasics(stream);
                    addStream.save();
                    ++i;
                }
                JOptionPane.showMessageDialog(Import_Streams.this.getMe(), String.valueOf(toImportLines.capacity()) + " " + Import_Streams.this.trans.getString("addedStreams"));
                Import_Streams.this.controlStreams.saveStreamVector();
                Import_Streams.this.dispose();
            }
        }
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Import_Streams.this.load();
        }
    }

    class PlayListFilter
    extends FileFilter {
        PlayListFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".pls") || f.getName().toLowerCase().endsWith(".m3u");
        }

        @Override
        public String getDescription() {
            return ".pls .m3u";
        }
    }

    class SelectAllListener
    implements ActionListener {
        SelectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Import_Streams.this.selectAll();
        }
    }

    class UnselectAllListener
    implements ActionListener {
        UnselectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Import_Streams.this.unselectAll();
        }
    }
}

