/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_Stream;
import gui.Gui_searchUpdateWin;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import thread.SearchUpdate;

public class Gui_searchUpdatePanel
extends JPanel {
    private static final long serialVersionUID = 4165135034469872266L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Control_Stream controlStream;
    private SearchUpdate searchUpdate;
    private Gui_searchUpdateWin updateWin;
    private ImageIcon loadingIcon = new ImageIcon(this.getClass().getResource("/Icons/update_loading.png"));
    private ImageIcon okIcon = new ImageIcon(this.getClass().getResource("/Icons/update_ok.png"));
    private ImageIcon availableIcon = new ImageIcon(this.getClass().getResource("/Icons/update_available.png"));
    private ImageIcon failIcon = new ImageIcon(this.getClass().getResource("/Icons/update_fail.png"));
    private JPanel panel = new JPanel();
    private JLabel iconLabel = new JLabel(this.loadingIcon);
    private JLabel infoLabel = new JLabel("Searching for new Version. Please wait...");
    private boolean quiteSearch = false;

    public Gui_searchUpdatePanel(Control_Stream controlStream, boolean quiteSearch) {
        this.controlStream = controlStream;
        this.quiteSearch = quiteSearch;
        this.init();
    }

    public Gui_searchUpdatePanel(Control_Stream controlStream, Gui_searchUpdateWin updateWin, boolean quiteSearch) {
        this.controlStream = controlStream;
        this.quiteSearch = quiteSearch;
        this.updateWin = updateWin;
        this.init();
    }

    private void init() {
        this.searchUpdate = new SearchUpdate(this, this.quiteSearch);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 3;
        c.gridy = 0;
        c.gridx = 0;
        this.panel.add((Component)this.iconLabel, c);
        c.gridy = 1;
        c.insets = new Insets(10, 5, 15, 5);
        this.panel.add((Component)this.infoLabel, c);
        this.add(this.panel);
        this.searchUpdate.start();
    }

    public void setAllOk() {
        this.iconLabel.setIcon(this.okIcon);
        this.infoLabel.setText(this.trans.getString("searchUpdate.infoLabel_alreadyNewest"));
    }

    public void setNewVersion() {
        this.iconLabel.setIcon(this.okIcon);
        this.infoLabel.setText(this.trans.getString("searchUpdate.infoLabel_newer"));
    }

    public void setNewVersionAvailable(String revision, String version, String url) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 3;
        this.iconLabel.setIcon(this.availableIcon);
        this.infoLabel.setText(this.trans.getString("searchUpdate.infoLabel_foundNewVersion"));
        JTextField downloadTF = new JTextField(url, 20);
        JTextField versionTF = new JTextField(version);
        JTextField revisionTF = new JTextField(revision);
        downloadTF.setEditable(false);
        versionTF.setEditable(false);
        revisionTF.setEditable(false);
        downloadTF.addMouseListener(new WebsiteListener(url));
        this.iconLabel.addMouseListener(new WebsiteListener(url));
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        this.panel.add((Component)new JLabel(this.trans.getString("searchUpdate.version")), c);
        c.gridx = 1;
        this.panel.add((Component)versionTF, c);
        c.gridx = 0;
        c.gridy = 3;
        this.panel.add((Component)new JLabel(this.trans.getString("searchUpdate.revision")), c);
        c.gridx = 1;
        this.panel.add((Component)revisionTF, c);
        c.gridx = 0;
        c.gridy = 4;
        this.panel.add((Component)new JLabel(this.trans.getString("searchUpdate.download")), c);
        c.gridx = 1;
        this.panel.add((Component)downloadTF, c);
        if (this.quiteSearch && this.updateWin != null) {
            this.updateWin.setVisible(true);
        }
    }

    public void setFailedToFetchInformation() {
        this.iconLabel.setIcon(this.failIcon);
        this.infoLabel.setText(this.trans.getString("searchUpdate.infoLabel_failedToLoad"));
    }

    class WebsiteListener
    extends MouseAdapter {
        String url;

        public WebsiteListener(String url) {
            this.url = url;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            Gui_searchUpdatePanel.this.controlStream.startWebBrowser(this.url);
        }
    }
}

