/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_Stream;
import control.SRSOutput;
import gui.Gui_JTTable;
import gui.Gui_StreamRipStar;
import gui.Import_Streams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import misc.Stream;
import thread.AudioPlayer;

public class Gui_TablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Object[] tableheader = new Object[]{"Rec", "Stream", "Current Title", "Genre"};
    private String[][] Daten = new String[0][];
    private DefaultTableModel model = new DefaultTableModel(this.Daten, this.tableheader){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return col == 0 ? ImageIcon.class : Object.class;
        }
    };
    private Control_Stream controlStreams;
    private Gui_JTTable table = new Gui_JTTable(this.model);
    private ImageIcon recordSmallIcon = new ImageIcon(this.getClass().getResource("/Icons/record_middle.png"));
    private JLabel columnLabel0 = new JLabel(this.recordSmallIcon, 0);
    private JLabel columnLabel1 = new JLabel(this.tableheader[1].toString(), 0);
    private JLabel columnLabel2 = new JLabel(this.tableheader[2].toString(), 0);
    private JLabel columnLabel3 = new JLabel(this.tableheader[3].toString(), 0);
    private TableCellRenderer renderer = new JComponentTableCellRenderer();
    private TableColumnModel columnModel = this.table.getColumnModel();
    private TableColumn column0 = this.columnModel.getColumn(0);
    private TableColumn column1 = this.columnModel.getColumn(1);
    private TableColumn column2 = this.columnModel.getColumn(2);
    private TableColumn column3 = this.columnModel.getColumn(3);
    private Gui_StreamRipStar mainGui = null;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private ImageIcon recordIcon = new ImageIcon(this.getClass().getResource("/Icons/record_middle.png"));
    private JPopupMenu popup;
    private AudioPlayer player;

    public Gui_TablePanel(Control_Stream controlStreams, Gui_StreamRipStar mainGui) {
        this.controlStreams = controlStreams;
        this.mainGui = mainGui;
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        this.setSize(new Dimension(650, 400));
        this.columnLabel0.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.columnLabel1.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.columnLabel2.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.columnLabel3.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.column0.setHeaderRenderer(this.renderer);
        this.column0.setHeaderValue(this.columnLabel0);
        this.column1.setHeaderRenderer(this.renderer);
        this.column1.setHeaderValue(this.columnLabel1);
        this.column2.setHeaderRenderer(this.renderer);
        this.column2.setHeaderValue(this.columnLabel2);
        this.column3.setHeaderRenderer(this.renderer);
        this.column3.setHeaderValue(this.columnLabel3);
        this.table.setSelectionMode(2);
        this.table.changeSelection(0, 0, true, false);
        this.table.setAutoCreateRowSorter(true);
        this.table.addMouseListener(new CellMouseListener());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.column0.setMaxWidth(this.recordIcon.getIconWidth());
        this.column0.setPreferredWidth(this.recordIcon.getIconWidth());
        this.setLanguage();
        DropTargetListener dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    int i = 0;
                    while (i < flavors.length) {
                        if (flavors[i].isFlavorJavaFileListType()) {
                            e.acceptDrop(1);
                            List files = (List)tr.getTransferData(flavors[i]);
                            String url = files.get(0).toString();
                            if (url.endsWith(".pls") || url.endsWith(".m3u")) {
                                SRSOutput.getInstance().log("Right extension");
                                new Import_Streams(Gui_TablePanel.this.getMainGui(), Gui_TablePanel.this.getControlStreams(), url);
                            } else {
                                SRSOutput.getInstance().log("Wrong extension");
                            }
                            e.dropComplete(true);
                            return;
                        }
                        if (flavors[i].isFlavorTextType()) {
                            String tmp = "";
                            e.acceptDrop(1);
                            Vector<InputStreamReader> x = new Vector<InputStreamReader>(0, 1);
                            x.add((InputStreamReader)tr.getTransferData(flavors[i]));
                            BufferedReader br = new BufferedReader((Reader)x.get(0));
                            while ((tmp = br.readLine()) != null) {
                                URI fileURI = new URI(tmp);
                                String url = URLDecoder.decode(fileURI.getPath(), "UTF-8");
                                if (url.endsWith(".pls") || url.endsWith(".m3u")) {
                                    SRSOutput.getInstance().log("Right extension");
                                    new Import_Streams(Gui_TablePanel.this.getMainGui(), Gui_TablePanel.this.getControlStreams(), url);
                                    continue;
                                }
                                SRSOutput.getInstance().log("Wrong extension");
                            }
                            br.close();
                            e.dropComplete(true);
                            return;
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                e.rejectDrop();
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
            }
        };
        new DropTarget(this.table, dropTargetListener);
        new DropTarget(this, dropTargetListener);
        this.table.getRowSorter().toggleSortOrder(1);
    }

    private void setLanguage() {
        try {
            this.columnLabel1.setText(this.trans.getString("streamname"));
            this.columnLabel2.setText(this.trans.getString("curTitle"));
            this.columnLabel3.setText(this.trans.getString("Gui_TablePanel.ColumnGenre"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void setGenreColumnVisible(Boolean setVisible) {
        if (setVisible.booleanValue()) {
            this.table.removeColumn(this.column3);
        } else {
            this.table.addColumn(this.column3);
        }
    }

    public int[] getColumnWidths() {
        int[] widths = new int[]{this.column0.getWidth(), this.column1.getWidth(), this.column2.getWidth(), this.column3.getWidth()};
        return widths;
    }

    public void setColumWidths(int[] widths) {
        if (widths.length >= 4) {
            this.column0.setPreferredWidth(widths[0]);
            this.column1.setPreferredWidth(widths[1]);
            this.column2.setPreferredWidth(widths[2]);
            this.column3.setPreferredWidth(widths[3]);
        } else {
            SRSOutput.getInstance().logE("Gui_TablePanel: SetColumWidths. The length of the given array is wrong: " + widths.length);
        }
    }

    public void removeStreamfromTable() {
        int[] rows = this.table.getSelectedRows();
        int i = rows.length - 1;
        while (i >= 0) {
            this.model.removeRow(this.table.convertRowIndexToModel(rows[i]));
            --i;
        }
    }

    public void fillTableWithStreams() {
        Vector<Stream> tmp = this.controlStreams.getStreamVector();
        int i = 0;
        while (i < tmp.capacity()) {
            this.model.addRow(tmp.get(i).getBase());
            ++i;
        }
    }

    public boolean isStreamSelected() {
        return this.table.getSelectedRow() != -1;
    }

    public void selectNextStream() {
        int selectedRow = this.table.getSelectedRow();
        int numberOfStreams = this.controlStreams.getStreamVector().size();
        selectedRow = selectedRow == -1 && numberOfStreams > 0 ? 0 : (selectedRow >= numberOfStreams - 1 ? 0 : ++selectedRow);
        try {
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        catch (IllegalArgumentException e) {
            SRSOutput.getInstance().logE("Gui_TablePanel: Unable to select an row");
        }
    }

    public void selectPreviousStream() {
        int selectedRow = this.table.getSelectedRow();
        int numberOfStreams = this.controlStreams.getStreamVector().size();
        selectedRow = selectedRow == -1 && numberOfStreams > 0 ? numberOfStreams - 1 : (selectedRow >= numberOfStreams - 1 ? numberOfStreams - 1 : --selectedRow);
        try {
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        catch (IllegalArgumentException e) {
            SRSOutput.getInstance().logE("Gui_TablePanel: Unable to select an row");
        }
    }

    public void addLastStreamFromVector() {
        Vector<Stream> tmp = this.controlStreams.getStreamVector();
        int length = tmp.capacity();
        this.model.addRow(tmp.get(length - 1).getBase());
    }

    public void addData(Object[] data) {
        this.model.addRow(data);
    }

    public int getSelectedStreamID() {
        int id = 0;
        id = this.table.convertRowIndexToModel(this.table.getSelectedRow());
        id = this.controlStreams.getStreamVector().get((int)id).id;
        return id;
    }

    public Stream[] getSelectedStream() {
        try {
            int[] ids = this.table.getSelectedRows();
            Stream[] streams = new Stream[ids.length];
            int i = 0;
            while (i < ids.length) {
                int id = this.table.convertRowIndexToModel(ids[i]);
                streams[i] = this.controlStreams.getStreamVector().get(id);
                ++i;
            }
            return streams;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SRSOutput.getInstance().logE("No Stream in the table -> ArrayIndexOutOfBoundException");
            return null;
        }
    }

    public Stream getStreamByID(int id) {
        Vector<Stream> x = this.controlStreams.getStreamVector();
        int i = 0;
        while (i < x.capacity()) {
            if (x.get((int)i).id == id) {
                return x.get(i);
            }
            ++i;
        }
        return null;
    }

    public String getSelectedName() {
        if (this.table.getSelectedRow() < 0) {
            return null;
        }
        Object content = this.table.getValueAt(this.table.getSelectedRow(), 1);
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    public boolean isTHSelected() {
        return this.table.getSelectedRow() >= 0;
    }

    public void setSelectedCurrentNameCellAndTitle(String track, int row, boolean rec) {
        this.table.setValueAt(track, row, 2);
        if (rec) {
            this.table.setValueAt(this.recordIcon, row, 0);
        } else {
            this.table.setValueAt(null, row, 0);
        }
    }

    public void setNameValue(String newName, int row) {
        this.table.setValueAt(newName, row, 1);
    }

    public void setNameValueWithConvert(String newName, int row) {
        this.table.setValueAt(newName, this.table.convertRowIndexToView(row), 1);
    }

    public void setGenreValueWithConvert(String newGenre, int row) {
        if (this.table.getColumnCount() >= 4) {
            this.table.setValueAt(newGenre, this.table.convertRowIndexToView(row), 3);
        }
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public String getNameFromRow(int row) {
        return this.table.getValueAt(row, 1).toString();
    }

    public String getNameFromRowForUpdate(int row) {
        return this.model.getValueAt(row, 1).toString();
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public int getNewRowForName(String vName) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (this.model.getValueAt(i, 1).toString().equals(vName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getNewRowForNameForUpdate(String vName) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (this.table.getValueAt(i, 1).toString().equals(vName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void loadFirstAudioPlayer() {
        if (this.mainGui.useInternalAudioPlayer().booleanValue()) {
            this.player = new AudioPlayer(this.mainGui);
        }
    }

    public synchronized void startMusicPlayerWithSelectedStream() {
        Stream[] stream = this.getSelectedStream();
        if (stream != null) {
            if (stream[0].getStatus().booleanValue() && stream[0].connectToRelayCB) {
                if (this.mainGui.useInternalAudioPlayer().booleanValue()) {
                    this.stopInternalAudioPlayer();
                    this.player = new AudioPlayer(stream[0], this.mainGui);
                    this.player.start();
                } else {
                    this.controlStreams.startMp3Player("http://127.0.0.1:" + stream[0].relayServerPortTF);
                }
            } else if (stream[0].address != null && !stream[0].address.equals("")) {
                if (this.mainGui.useInternalAudioPlayer().booleanValue()) {
                    this.stopInternalAudioPlayer();
                    this.player = new AudioPlayer(stream[0], this.mainGui);
                    this.player.start();
                } else {
                    this.controlStreams.startMp3Player(stream[0].address);
                }
            } else {
                SRSOutput.getInstance().logE("error while fetching adress");
            }
        } else {
            SRSOutput.getInstance().log("Could not find a stream to play. Nullpointer");
        }
    }

    public synchronized void setAudioVolume(int percentage) {
        if (this.player != null && percentage >= 0 && percentage <= 100) {
            double val = 0.0;
            if (percentage != 0) {
                val = 100.0 * (Math.pow(2.0, Double.valueOf(percentage) / 100.0) - 1.0);
            }
            this.player.setAudioVolum(new Double(val).intValue());
            SRSOutput.getInstance().logD("Lautst\u00e4rke ist nun: " + val);
        }
    }

    public synchronized void startMusicPlayerWithUrl(String url, String name) {
        Stream stream = new Stream(name, 0);
        stream.address = url;
        if (stream.getStatus().booleanValue() && stream.connectToRelayCB) {
            if (this.mainGui.useInternalAudioPlayer().booleanValue()) {
                this.stopInternalAudioPlayer();
                this.player = new AudioPlayer(stream, this.mainGui);
                this.player.start();
            } else {
                this.controlStreams.startMp3Player("http://127.0.0.1:" + stream.relayServerPortTF);
            }
        } else if (stream.address != null && !stream.address.equals("")) {
            if (this.mainGui.useInternalAudioPlayer().booleanValue()) {
                this.stopInternalAudioPlayer();
                this.player = new AudioPlayer(stream, this.mainGui);
                this.player.start();
            } else {
                this.controlStreams.startMp3Player(stream.address);
            }
        } else {
            SRSOutput.getInstance().logE("error while fetching adress");
        }
    }

    public synchronized void stopInternalAudioPlayer() {
        if (this.player != null) {
            this.player.stopPlaying();
        }
    }

    public Gui_StreamRipStar getMainGui() {
        return this.mainGui;
    }

    public Control_Stream getControlStreams() {
        return this.controlStreams;
    }

    public void startAction() {
        int action = 0;
        int selCol = this.table.getSelectedColumn();
        if (selCol == 0) {
            action = this.mainGui.getAction(0);
        }
        if (selCol == 1) {
            action = this.mainGui.getAction(1);
        }
        if (selCol == 2 || selCol == 3) {
            action = this.mainGui.getAction(2);
        }
        if (action != 0) {
            Stream[] stream = this.getSelectedStream();
            if (stream[0] != null) {
                if (action == 1) {
                    if (stream[0].website != null && !stream[0].website.equals("")) {
                        this.controlStreams.startWebBrowser(stream[0].website);
                    } else {
                        JOptionPane.showMessageDialog(this.mainGui, this.trans.getString("setWebsite"));
                    }
                }
                if (action == 2) {
                    this.mainGui.editStream();
                }
                if (action == 3) {
                    if (stream[0].getStatus().booleanValue()) {
                        this.mainGui.stopRippingSelected();
                    } else {
                        this.mainGui.startRippingSelected();
                    }
                }
                if (action == 4) {
                    this.startMusicPlayerWithSelectedStream();
                }
            } else {
                SRSOutput.getInstance().logE("can't find stream in vector");
            }
        }
    }

    public void setTTablePopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public class CellMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Gui_TablePanel.this.startAction();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            if (e.getButton() == 3 && (row = Gui_TablePanel.this.table.rowAtPoint(e.getPoint())) >= 0) {
                Gui_TablePanel.this.table.setRowSelectionInterval(row, row);
                Gui_TablePanel.this.popup.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            }
        }
    }

    class JComponentTableCellRenderer
    implements TableCellRenderer {
        JComponentTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            return (JComponent)arg1;
        }
    }
}

