/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_GetPath;
import control.Control_RunExternProgram;
import control.Control_Stream;
import control.Control_Threads;
import control.SRSOutput;
import control.VolumeManager;
import gui.About_StreamRipStar;
import gui.Export_Streams;
import gui.Gui_Infodialog;
import gui.Gui_SchedulManager;
import gui.Gui_Settings2;
import gui.Gui_Stream4AllOptions;
import gui.Gui_StreamBrowser2;
import gui.Gui_StreamOptions;
import gui.Gui_TablePanel;
import gui.Gui_searchUpdateWin;
import gui.IconButton;
import gui.Import_Streams;
import gui.InternAudioControlPanel;
import gui.ViewLog;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import misc.Commandline;
import misc.Stream;
import thread.Thread_Control_Schedules;
import thread.Thread_FillTableWithStreams;
import thread.Thread_UpdateName;

public class Gui_StreamRipStar
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Control_Stream controlStreams = null;
    private Gui_TablePanel table = null;
    private Thread_Control_Schedules controlJob = null;
    private Gui_StreamBrowser2 streamBrowser = null;
    private InternAudioControlPanel audioPanel = null;
    private VolumeManager volumeManager = new VolumeManager(this);
    private Boolean tray = false;
    private Boolean startInvisibleInTray = false;
    private Boolean showText = false;
    private Boolean useInternalPlayer = true;
    private Boolean searchForUpdate = false;
    private Boolean hideAutoUpdateWindow = true;
    private int winAction = 1;
    private int action0 = -1;
    private int action1 = -1;
    private int action2 = -1;
    private Boolean daylightChangeTimeCalculated = false;
    private ImageIcon startRecordIcon = new ImageIcon(this.getClass().getResource("/Icons/record.png"));
    private ImageIcon stopRecordIcon = new ImageIcon(this.getClass().getResource("/Icons/stop.png"));
    private ImageIcon schudleIcon = new ImageIcon(this.getClass().getResource("/Icons/schedule.png"));
    private ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("/Icons/del.png"));
    private ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/Icons/add.png"));
    private ImageIcon hearMusicIcon = new ImageIcon(this.getClass().getResource("/Icons/player.png"));
    private ImageIcon openMusicFolderIcon = new ImageIcon(this.getClass().getResource("/Icons/m_open.png"));
    private ImageIcon exitIcon = new ImageIcon(this.getClass().getResource("/Icons/exit.png"));
    private ImageIcon configIcon = new ImageIcon(this.getClass().getResource("/Icons/config.png"));
    private ImageIcon editIcon = new ImageIcon(this.getClass().getResource("/Icons/edit.png"));
    private ImageIcon infoIcon = new ImageIcon(this.getClass().getResource("/Icons/info.png"));
    private ImageIcon browserIcon = new ImageIcon(this.getClass().getResource("/Icons/search.png"));
    private ImageIcon addMenu = new ImageIcon(this.getClass().getResource("/Icons/add_small.png"));
    private ImageIcon editMenu = new ImageIcon(this.getClass().getResource("/Icons/edit_small.png"));
    private ImageIcon deleteMenu = new ImageIcon(this.getClass().getResource("/Icons/delete_small.png"));
    private ImageIcon importMenu = new ImageIcon(this.getClass().getResource("/Icons/import_small.png"));
    private ImageIcon exportMenu = new ImageIcon(this.getClass().getResource("/Icons/export_small.png"));
    private ImageIcon tuneIntoMenu = new ImageIcon(this.getClass().getResource("/Icons/player_small.png"));
    private ImageIcon musicfolderMenu = new ImageIcon(this.getClass().getResource("/Icons/m_open_small.png"));
    private ImageIcon recordMenu = new ImageIcon(this.getClass().getResource("/Icons/record_small.png"));
    private ImageIcon stopMenu = new ImageIcon(this.getClass().getResource("/Icons/stop_small.png"));
    private ImageIcon settingsMenu = new ImageIcon(this.getClass().getResource("/Icons/settings_small.png"));
    private ImageIcon aboutStreamRipStarMenu = new ImageIcon(this.getClass().getResource("/Icons/streamRipStar_small.png"));
    private ImageIcon windowIcon = new ImageIcon(this.getClass().getResource("/Icons/streamRipStar.png"));
    private IconButton startRecordButton = new IconButton("Start", this.startRecordIcon);
    private IconButton stopRecordButton = new IconButton("Stop", this.stopRecordIcon);
    private IconButton scheduleButton = new IconButton("Schedule", this.schudleIcon);
    private IconButton deleteButton = new IconButton("Delete", this.deleteIcon);
    private IconButton editButton = new IconButton("Edit", this.editIcon);
    private IconButton addButton = new IconButton("Add", this.addIcon);
    private IconButton hearMusicButton = new IconButton("Hear", this.hearMusicIcon);
    private IconButton openMusicFolderButton = new IconButton("Musicfolder", this.openMusicFolderIcon);
    private IconButton exitButton = new IconButton("Exit", this.exitIcon);
    private IconButton configButton = new IconButton("Preferences", this.configIcon);
    private IconButton infoButton = new IconButton("Info", this.infoIcon);
    private IconButton browseGenreButton = new IconButton("Browser", this.browserIcon);
    private JMenuBar menu = new JMenuBar();
    private JMenu streamMenu = new JMenu("Stream");
    private JMenu programmMenu = new JMenu("Program");
    private JMenu viewMenu = new JMenu("View");
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem startRecordStream = new JMenuItem("Start Recording", this.recordMenu);
    private JMenuItem stopRecordStream = new JMenuItem("Stop Recording", this.stopMenu);
    private JMenuItem addStream = new JMenuItem("Add", this.addMenu);
    private JMenuItem editStream = new JMenuItem("Edit", this.editMenu);
    private JMenuItem delStream = new JMenuItem("Delete", this.deleteMenu);
    private JMenuItem importStream = new JMenuItem("Import", this.importMenu);
    private JMenuItem exportStream = new JMenuItem("Export", this.exportMenu);
    private JMenuItem streamBrowserItem = new JMenuItem("Streambrowser");
    private JMenuItem schedulManagerItem = new JMenuItem("Schedulmanager");
    private JMenuItem tuneInto = new JMenuItem("Listen To", this.tuneIntoMenu);
    private JMenuItem showInfo = new JMenuItem("Show Information");
    private JMenuItem openWebsite = new JMenuItem("Open Website");
    private JMenuItem streamRipStarPref = new JMenuItem("Preferences", this.settingsMenu);
    private JMenuItem openMusicFolder = new JMenuItem("Open Musicfolder", this.musicfolderMenu);
    private JMenuItem streamOptions = new JMenuItem("Options");
    private JMenuItem stream4AllOptions = new JMenuItem("Overwrite Options For Every Stream");
    private JMenuItem streamDefaultOptions = new JMenuItem("Edit The Default Options For A New Stream");
    private JMenuItem playNextStream = new JMenuItem("Play Next Stream");
    private JMenuItem playLastStream = new JMenuItem("Play Last Stream");
    private JCheckBoxMenuItem showGenreColumnAction = new JCheckBoxMenuItem("Show genre column", true);
    private JMenuItem onlineHelp = new JMenuItem("Online Help");
    private JMenuItem updateMenuItem = new JMenuItem("Look for an Update");
    private JMenuItem about = new JMenuItem("About StreamRipStar", this.aboutStreamRipStarMenu);
    private JMenuItem viewLog = new JMenuItem("Show log messages", this.aboutStreamRipStarMenu);
    private JMenuItem streamRipStarSite = new JMenuItem("Go to StreamRipStars Website");
    private JMenuItem exit = new JMenuItem("Exit");
    private JMenuItem startRecPopupIcon = new JMenuItem("Start Recording", this.recordMenu);
    private JMenuItem stopRecPopupIcon = new JMenuItem("Stop Recording", this.stopMenu);
    private JMenuItem tuneStreamPopupIcon = new JMenuItem("Listening", this.tuneIntoMenu);
    private JMenuItem optionPopupIcon = new JMenuItem("Optionen");
    private JPopupMenu tablePopup = new JPopupMenu();
    private Font textUnderIconsFont = new Font("Dialog", 0, 10);
    private TrayIcon trayIcon = null;
    private SystemTray sysTray = null;
    private JToolBar iconBar = new JToolBar();

    public Gui_StreamRipStar(Boolean openPreferences, Commandline cmd) {
        super("StreamRipStar");
        this.setIconImage(this.windowIcon.getImage());
        this.controlStreams = new Control_Stream(this);
        this.table = new Gui_TablePanel(this.controlStreams, this);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        Container contPane = this.getContentPane();
        BorderLayout mainLayout = new BorderLayout();
        contPane.setLayout(mainLayout);
        contPane.add((Component)this.iconBar, "First");
        contPane.add((Component)this.table, "Center");
        this.buildMenuBar();
        this.loadProp();
        if (cmd.isTmpEnableSystray()) {
            this.tray = true;
        }
        if (cmd.isTmpStartInSystray()) {
            this.startInvisibleInTray = true;
        }
        this.setLanguage();
        this.buildIconBar();
        this.setSystemTray();
        if (System.getProperty("os.name").equals("Windows XP")) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Gui_StreamRipStar.this.setSystemTray();
                }
            }, 30000L);
        }
        this.table.loadFirstAudioPlayer();
        if (this.useInternalPlayer.booleanValue()) {
            this.audioPanel = new InternAudioControlPanel(this, this.volumeManager);
            contPane.add((Component)this.audioPanel, "South");
            this.hearMusicButton.setEnabled(false);
        }
        Dimension frameDim = this.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        if (!this.startInvisibleInTray.booleanValue()) {
            this.setVisible(true);
        }
        Control_Threads controlThreads = new Control_Threads();
        Thread_FillTableWithStreams fill = new Thread_FillTableWithStreams(this.controlStreams, this.table, controlThreads);
        fill.start();
        this.controlJob = new Thread_Control_Schedules(this, controlThreads);
        this.controlJob.start();
        if (openPreferences.booleanValue()) {
            JOptionPane.showMessageDialog(this, this.trans.getString("firstTime"));
            new Gui_Settings2(this);
        }
        if (this.searchForUpdate.booleanValue()) {
            new Gui_searchUpdateWin(this.controlStreams, this, (boolean)this.hideAutoUpdateWindow);
        }
    }

    private void setSystemTray() {
        if (this.tray.booleanValue()) {
            if (SystemTray.isSupported()) {
                this.unsetSystemTray();
                this.setDefaultCloseOperation(1);
                this.sysTray = SystemTray.getSystemTray();
                Image image = new ImageIcon(this.getClass().getResource("/Icons/streamRipStar.png")).getImage();
                MouseAdapter mouseListener = new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (!e.isPopupTrigger()) {
                            Gui_StreamRipStar.this.changeStatus();
                        }
                    }
                };
                PopupMenu popup = new PopupMenu();
                MenuItem exitItem = new MenuItem(this.trans.getString("SystemTray.exit"));
                MenuItem mainWindowItem = new MenuItem(this.trans.getString("SystemTray.window"));
                exitItem.addActionListener(new ExitListener(this));
                mainWindowItem.addActionListener(new ShowStreamRipStarListener());
                popup.add(mainWindowItem);
                popup.addSeparator();
                popup.add(exitItem);
                this.trayIcon = new TrayIcon(image, "StreamRipStar", popup);
                this.trayIcon.setImageAutoSize(true);
                this.trayIcon.addMouseListener(mouseListener);
                try {
                    this.sysTray.add(this.trayIcon);
                }
                catch (AWTException e) {
                    SRSOutput.getInstance().logE("TrayIcon could not be added.");
                }
            }
        } else {
            this.unsetSystemTray();
        }
    }

    private void unsetSystemTray() {
        if (this.sysTray != null) {
            this.sysTray.remove(this.trayIcon);
            this.sysTray = null;
            this.trayIcon = null;
        }
    }

    public void showMessageInTray(String Message2) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage("StreamRipStar", Message2, TrayIcon.MessageType.INFO);
        }
    }

    public void buildIconBar() {
        this.iconBar.add(this.startRecordButton);
        this.iconBar.add(this.stopRecordButton);
        if (!this.useInternalPlayer.booleanValue()) {
            this.iconBar.addSeparator();
            this.iconBar.add(this.hearMusicButton);
        }
        this.iconBar.addSeparator();
        this.iconBar.add(this.scheduleButton);
        this.iconBar.add(this.infoButton);
        this.iconBar.addSeparator();
        this.iconBar.add(this.deleteButton);
        this.iconBar.add(this.editButton);
        this.iconBar.add(this.addButton);
        this.iconBar.add(this.browseGenreButton);
        this.iconBar.addSeparator();
        this.iconBar.add(this.openMusicFolderButton);
        this.iconBar.add(this.configButton);
        this.iconBar.addSeparator();
        this.iconBar.add(this.exitButton);
        this.iconBar.setBackground(new Color(238, 238, 238, 255));
        this.menu.setBackground(new Color(238, 238, 238, 255));
        this.startRecordButton.setToolTipText("Start ripping");
        this.stopRecordButton.setToolTipText("Stop ripping");
        this.scheduleButton.setToolTipText("Schedule");
        this.deleteButton.setToolTipText("Delete stream");
        this.editButton.setToolTipText("Edit stream");
        this.addButton.setToolTipText("Add stream");
        this.hearMusicButton.setToolTipText("Hear stream");
        this.exitButton.setToolTipText("Exit");
        this.configButton.setToolTipText("Preferences");
        this.openMusicFolderButton.setToolTipText("Open musicfolder");
        this.infoButton.setToolTipText("Show Information about this Stream");
        this.browseGenreButton.setToolTipText("Show stream browser");
        this.addButton.addActionListener(new AddStreamListener());
        this.configButton.addActionListener(new PreferencesListener());
        this.exitButton.addActionListener(new ExitListener(this));
        this.startRecordButton.addActionListener(new StartRecordListener());
        this.stopRecordButton.addActionListener(new StopRecordListener());
        this.deleteButton.addActionListener(new DeleteListener());
        this.editButton.addActionListener(new EditStreamListener());
        this.hearMusicButton.addActionListener(new PlayMusikListener());
        this.openMusicFolderButton.addActionListener(new OpenMusikFolder());
        this.scheduleButton.addActionListener(new ScheduleListener());
        this.infoButton.addActionListener(new ShowStatsListener());
        this.browseGenreButton.addActionListener(new StreamBrowserListener());
    }

    public void buildMenuBar() {
        this.setJMenuBar(this.menu);
        this.menu.add(this.programmMenu);
        this.menu.add(this.streamMenu);
        this.menu.add(this.viewMenu);
        this.menu.add(this.helpMenu);
        this.streamMenu.add(this.startRecordStream);
        this.streamMenu.add(this.stopRecordStream);
        this.streamMenu.addSeparator();
        this.streamMenu.add(this.addStream);
        this.streamMenu.add(this.editStream);
        this.streamMenu.add(this.delStream);
        this.streamMenu.addSeparator();
        this.streamMenu.add(this.tuneInto);
        this.streamMenu.add(this.streamOptions);
        this.streamMenu.add(this.showInfo);
        this.streamMenu.add(this.openWebsite);
        this.streamMenu.addSeparator();
        this.streamMenu.add(this.stream4AllOptions);
        this.streamMenu.addSeparator();
        this.streamMenu.add(this.streamDefaultOptions);
        this.streamMenu.addSeparator();
        this.streamMenu.add(this.playLastStream);
        this.streamMenu.add(this.playNextStream);
        this.programmMenu.add(this.streamRipStarPref);
        this.programmMenu.add(this.importStream);
        this.programmMenu.add(this.exportStream);
        this.programmMenu.add(this.streamBrowserItem);
        this.programmMenu.add(this.schedulManagerItem);
        this.programmMenu.add(this.openMusicFolder);
        this.programmMenu.addSeparator();
        this.programmMenu.add(this.exit);
        this.viewMenu.add(this.showGenreColumnAction);
        this.helpMenu.add(this.onlineHelp);
        this.helpMenu.add(this.streamRipStarSite);
        this.helpMenu.add(this.updateMenuItem);
        this.helpMenu.add(this.viewLog);
        this.helpMenu.add(this.about);
        this.addStream.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editStream.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.tuneInto.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.streamOptions.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.streamRipStarPref.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.openMusicFolder.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.startRecordStream.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.stopRecordStream.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.delStream.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.playLastStream.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.playNextStream.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.streamRipStarPref.addActionListener(new PreferencesListener());
        this.importStream.addActionListener(new ImportListener());
        this.exportStream.addActionListener(new ExportListener());
        this.schedulManagerItem.addActionListener(new ScheduleListener());
        this.streamBrowserItem.addActionListener(new StreamBrowserListener());
        this.addStream.addActionListener(new AddStreamListener());
        this.editStream.addActionListener(new EditStreamListener());
        this.delStream.addActionListener(new DeleteListener());
        this.tuneInto.addActionListener(new PlayMusikListener());
        this.showInfo.addActionListener(new ShowStatsListener());
        this.exit.addActionListener(new ExitListener(this));
        this.openMusicFolder.addActionListener(new OpenMusikFolder());
        this.openWebsite.addActionListener(new BrowserListener());
        this.about.addActionListener(new AboutDialogListener());
        this.viewLog.addActionListener(new ViewLogDialogListener());
        this.streamRipStarSite.addActionListener(new GoToWebSiteListener());
        this.startRecordStream.addActionListener(new StartRecordListener());
        this.stopRecordStream.addActionListener(new StopRecordListener());
        this.onlineHelp.addActionListener(new GoToHelpSiteListener());
        this.updateMenuItem.addActionListener(new SearchUpdateListener());
        this.streamOptions.addActionListener(new EditStreamListener());
        this.stream4AllOptions.addActionListener(new Edit4AllStreamListener());
        this.streamDefaultOptions.addActionListener(new EditDefaultStreamListener());
        this.playLastStream.addActionListener(new PlayPreviousStreamListener());
        this.playNextStream.addActionListener(new PlayNextStreamListener());
        this.startRecPopupIcon.addActionListener(new StartRecordListener());
        this.stopRecPopupIcon.addActionListener(new StopRecordListener());
        this.tuneStreamPopupIcon.addActionListener(new PlayMusikListener());
        this.optionPopupIcon.addActionListener(new EditStreamListener());
        this.showGenreColumnAction.addActionListener(new ShowGenreColumnListener());
        this.table.setTTablePopup(this.tablePopup);
        this.tablePopup.add(this.startRecPopupIcon);
        this.tablePopup.add(this.stopRecPopupIcon);
        this.tablePopup.add(this.tuneStreamPopupIcon);
        this.tablePopup.add(this.optionPopupIcon);
    }

    private void setTextUnderIcons() {
        if (!this.showText.booleanValue()) {
            this.startRecordButton.setText(null);
            this.stopRecordButton.setText(null);
            this.hearMusicButton.setText(null);
            this.scheduleButton.setText(null);
            this.infoButton.setText(null);
            this.deleteButton.setText(null);
            this.editButton.setText(null);
            this.addButton.setText(null);
            this.openMusicFolderButton.setText(null);
            this.configButton.setText(null);
            this.exitButton.setText(null);
            this.browseGenreButton.setText(null);
        } else {
            try {
                this.startRecordButton.setText(this.trans.getString("mainWin.startRecordButton"));
                this.stopRecordButton.setText(this.trans.getString("mainWin.stopRecordButton"));
                this.scheduleButton.setText(this.trans.getString("mainWin.scheduleButton"));
                this.deleteButton.setText(this.trans.getString("mainWin.deleteButton"));
                this.editButton.setText(this.trans.getString("mainWin.editButton"));
                this.addButton.setText(this.trans.getString("mainWin.addButton"));
                this.hearMusicButton.setText(this.trans.getString("mainWin.hearMusicButton"));
                this.openMusicFolderButton.setText(this.trans.getString("mainWin.openMusicFolderButton"));
                this.exitButton.setText(this.trans.getString("mainWin.exitButton"));
                this.configButton.setText(this.trans.getString("mainWin.configButton"));
                this.infoButton.setText(this.trans.getString("mainWin.infoButton"));
                this.browseGenreButton.setText(this.trans.getString("mainWin.browseGenreButton"));
            }
            catch (MissingResourceException e) {
                SRSOutput.getInstance().logE("Could not find an translation (Text under Icons)");
            }
            this.startRecordButton.setFont(this.textUnderIconsFont);
            this.stopRecordButton.setFont(this.textUnderIconsFont);
            this.scheduleButton.setFont(this.textUnderIconsFont);
            this.deleteButton.setFont(this.textUnderIconsFont);
            this.editButton.setFont(this.textUnderIconsFont);
            this.addButton.setFont(this.textUnderIconsFont);
            this.hearMusicButton.setFont(this.textUnderIconsFont);
            this.openMusicFolderButton.setFont(this.textUnderIconsFont);
            this.exitButton.setFont(this.textUnderIconsFont);
            this.configButton.setFont(this.textUnderIconsFont);
            this.infoButton.setFont(this.textUnderIconsFont);
            this.browseGenreButton.setFont(this.textUnderIconsFont);
        }
        if (this.useInternalPlayer.booleanValue() && this.audioPanel != null) {
            this.audioPanel.setTextUnderIcons(this.showText);
        }
    }

    private void setLanguage() {
        try {
            this.streamMenu.setText(this.trans.getString("stream"));
            this.programmMenu.setText(this.trans.getString("program"));
            this.helpMenu.setText(this.trans.getString("helpMenu"));
            this.viewMenu.setText(this.trans.getString("mainWin.MenuBar.ViewMenu"));
            this.streamRipStarPref.setText(this.trans.getString("pref"));
            this.importStream.setText(this.trans.getString("importStream"));
            this.exportStream.setText(this.trans.getString("exportStream"));
            this.streamBrowserItem.setText(this.trans.getString("mainWin.streamBrowserItem"));
            this.schedulManagerItem.setText(this.trans.getString("mainWin.schedulManagerItem"));
            this.openMusicFolder.setText(this.trans.getString("openMusic"));
            this.exit.setText(this.trans.getString("exit"));
            this.startRecordStream.setText(this.trans.getString("popup.startRec"));
            this.stopRecordStream.setText(this.trans.getString("popup.stopRec"));
            this.addStream.setText(this.trans.getString("add"));
            this.editStream.setText(this.trans.getString("edit"));
            this.delStream.setText(this.trans.getString("delete"));
            this.tuneInto.setText(this.trans.getString("tune"));
            this.showInfo.setText(this.trans.getString("mainWin.showInfo"));
            this.openWebsite.setText(this.trans.getString("stream_website"));
            this.streamOptions.setText(this.trans.getString("options"));
            this.stream4AllOptions.setText(this.trans.getString("4AllOptions"));
            this.streamDefaultOptions.setText(this.trans.getString("DefaultOptions"));
            this.showGenreColumnAction.setText(this.trans.getString("mainWin.MenuBar.ShowColumn4"));
            this.onlineHelp.setText(this.trans.getString("onlineHelp"));
            this.streamRipStarSite.setText(this.trans.getString("streamRipStarWebsite"));
            this.updateMenuItem.setText(this.trans.getString("checkUpdateItem"));
            this.about.setText(this.trans.getString("about"));
            this.viewLog.setText(this.trans.getString("mainWin.ViewLog"));
            this.playNextStream.setText(this.trans.getString("mainWin.PlayNextStream"));
            this.playLastStream.setText(this.trans.getString("mainWin.PlayerLastStream"));
            this.editButton.setToolTipText(this.trans.getString("toolTip.editButton"));
            this.startRecordButton.setToolTipText(this.trans.getString("toolTip.startRecordButton"));
            this.stopRecordButton.setToolTipText(this.trans.getString("toolTip.stopRecordButton"));
            this.scheduleButton.setToolTipText(this.trans.getString("toolTip.scheduleButton"));
            this.deleteButton.setToolTipText(this.trans.getString("toolTip.deleteButton"));
            this.addButton.setToolTipText(this.trans.getString("toolTip.addButton"));
            this.hearMusicButton.setToolTipText(this.trans.getString("toolTip.hearMusicButton"));
            this.exitButton.setToolTipText(this.trans.getString("toolTip.exitButton"));
            this.configButton.setToolTipText(this.trans.getString("toolTip.configButton"));
            this.openMusicFolderButton.setToolTipText(this.trans.getString("toolTip.openMusicFolderButton"));
            this.infoButton.setToolTipText(this.trans.getString("toolTip.info"));
            this.browseGenreButton.setToolTipText(this.trans.getString("toolTip.streambrowser"));
            this.startRecordButton.setText(this.trans.getString("mainWin.startRecordButton"));
            this.stopRecordButton.setText(this.trans.getString("mainWin.stopRecordButton"));
            this.scheduleButton.setText(this.trans.getString("mainWin.scheduleButton"));
            this.deleteButton.setText(this.trans.getString("mainWin.deleteButton"));
            this.editButton.setText(this.trans.getString("mainWin.editButton"));
            this.addButton.setText(this.trans.getString("mainWin.addButton"));
            this.hearMusicButton.setText(this.trans.getString("mainWin.hearMusicButton"));
            this.openMusicFolderButton.setText(this.trans.getString("mainWin.openMusicFolderButton"));
            this.exitButton.setText(this.trans.getString("mainWin.exitButton"));
            this.configButton.setText(this.trans.getString("mainWin.configButton"));
            this.infoButton.setText(this.trans.getString("mainWin.infoButton"));
            this.browseGenreButton.setText(this.trans.getString("mainWin.browseGenreButton"));
            this.startRecPopupIcon.setText(this.trans.getString("popup.startRec"));
            this.stopRecPopupIcon.setText(this.trans.getString("popup.stopRec"));
            this.tuneStreamPopupIcon.setText(this.trans.getString("popup.hear"));
            this.optionPopupIcon.setText(this.trans.getString("popup.options"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void showErrorMessageInPopUp(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, this.trans.getString("error"), 0, null);
    }

    public void setVolume(int newVolume) {
        this.getTabel().setAudioVolume(newVolume);
    }

    public Font getFontForTextUnderIcons() {
        return this.textUnderIconsFont;
    }

    public Boolean showTextUnderIcons() {
        return this.showText;
    }

    public Boolean useInternalAudioPlayer() {
        return this.useInternalPlayer;
    }

    public void setUseInternalAudioPlayer(Boolean useItNow) {
        this.useInternalPlayer = useItNow;
    }

    public void loadProp() {
        XMLStreamReader parser;
        XMLInputFactory factory;
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Prefs-MainWindow.xml"), "UTF-8");
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Prefs-MainWindow.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        int[] widths = new int[4];
                        int hight = 0;
                        int width = 0;
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (parser.getAttributeLocalName(i).equals("winSizeWidth")) {
                                width = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("winSizeHeight")) {
                                hight = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("tableCol1")) {
                                widths[0] = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("tableCol2")) {
                                widths[1] = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("tableCol3")) {
                                widths[2] = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("tableCol4")) {
                                widths[3] = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("tableCol4Vsisible")) {
                                Boolean tmp = Boolean.valueOf(parser.getAttributeValue(i));
                                if (!tmp.booleanValue()) {
                                    this.showGenreColumnAction.doClick();
                                }
                            } else if (parser.getAttributeLocalName(i).equals("DST_CORRECTION_ON")) {
                                this.daylightChangeTimeCalculated = Boolean.valueOf(parser.getAttributeValue(i));
                            }
                            ++i;
                        }
                        this.table.setColumWidths(widths);
                        this.setSize(new Dimension(width, hight));
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Prefs-MainWindow.xml");
            this.pack();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            this.pack();
        }
        loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Settings-StreamRipStar.xml"), "UTF-8");
            while (parser.hasNext()) {
                block7 : switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Settings-StreamRipStar.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        String[] path = new String[5];
                        int level = 0;
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (parser.getAttributeLocalName(i).equals("activeTrayIcon")) {
                                this.tray = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("startInSysTray")) {
                                this.startInvisibleInTray = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("showTextCB")) {
                                this.showText = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("useInternalAudioPlayerCB")) {
                                this.useInternalPlayer = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("ripperPathTF")) {
                                path[0] = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("shoutcastTF")) {
                                path[1] = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("generellPathTF")) {
                                path[2] = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("fileBrowserTF")) {
                                path[4] = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("webBrowserTF")) {
                                path[3] = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("statusBox_index")) {
                                this.action0 = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("nameBox_index")) {
                                this.action1 = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("currentTrackBox_index")) {
                                this.action2 = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("windowActionBox_index")) {
                                this.winAction = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("logLevel_index")) {
                                level = Integer.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("checkForUpdatesOnStartCB")) {
                                this.searchForUpdate = Boolean.valueOf(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("hideUpateWindowCB")) {
                                this.hideAutoUpdateWindow = Boolean.valueOf(parser.getAttributeValue(i));
                            }
                            ++i;
                        }
                        this.controlStreams.setPaths(path);
                        this.setTextUnderIcons();
                        switch (level) {
                            case 0: {
                                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Nothing);
                                break block7;
                            }
                            case 1: {
                                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Error);
                                break block7;
                            }
                            case 2: {
                                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Normal);
                                break block7;
                            }
                            case 3: {
                                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Debug);
                                break block7;
                            }
                        }
                        SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Normal);
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Settings-StreamRipStar.xml");
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Boolean getDaylightChangeTimeCalculated() {
        return this.daylightChangeTimeCalculated;
    }

    public void setDaylightChangeTimeCalculated(Boolean daylightChangeTimeCalculated) {
        this.daylightChangeTimeCalculated = daylightChangeTimeCalculated;
    }

    public void saveProp() {
        String savePath = new Control_GetPath().getStreamRipStarPath();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(new FileOutputStream(String.valueOf(savePath) + "/Prefs-MainWindow.xml"), "UTF-8");
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            StartDocument header = eventFactory.createStartDocument();
            StartElement startRootSettings = eventFactory.createStartElement("", "", "Prefs");
            Attribute winSizeWidth = eventFactory.createAttribute("winSizeWidth", String.valueOf(this.getSize().width));
            Attribute winSizeHeight = eventFactory.createAttribute("winSizeHeight", String.valueOf(this.getSize().height));
            Attribute tableCol1 = eventFactory.createAttribute("tableCol1", String.valueOf(this.table.getColumnWidths()[0]));
            Attribute tableCol2 = eventFactory.createAttribute("tableCol2", String.valueOf(this.table.getColumnWidths()[1]));
            Attribute tableCol3 = eventFactory.createAttribute("tableCol3", String.valueOf(this.table.getColumnWidths()[2]));
            Attribute tableCol4 = eventFactory.createAttribute("tableCol4", String.valueOf(this.table.getColumnWidths()[3]));
            Attribute tableCol4Visible = eventFactory.createAttribute("tableCol4Vsisible", String.valueOf(this.showGenreColumnAction.isSelected()));
            Attribute daylightChange = eventFactory.createAttribute("DST_CORRECTION_ON", String.valueOf(this.daylightChangeTimeCalculated));
            EndElement endRoot = eventFactory.createEndElement("", "", "Prefs");
            EndDocument endDocument = eventFactory.createEndDocument();
            writer.add(header);
            writer.add(startRootSettings);
            writer.add(winSizeWidth);
            writer.add(winSizeHeight);
            writer.add(tableCol1);
            writer.add(tableCol2);
            writer.add(tableCol3);
            writer.add(tableCol4);
            writer.add(tableCol4Visible);
            writer.add(daylightChange);
            writer.add(endRoot);
            writer.add(endDocument);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void closeAll() {
        if (Stream.activeStreams > 0) {
            int i = JOptionPane.showConfirmDialog(this, String.valueOf(this.trans.getString("countStream")) + " " + Stream.activeStreams + "\n" + this.trans.getString("realyExit"), "streamRipStarExit", 0);
            if (i == 0) {
                this.saveProp();
                this.controlStreams.stopAllStreams();
                this.controlStreams.saveStreamVector();
                this.controlJob.saveScheduleVector();
                this.unsetSystemTray();
                System.exit(0);
            }
        } else {
            this.saveProp();
            this.controlStreams.stopAllStreams();
            this.controlStreams.saveStreamVector();
            this.controlJob.saveScheduleVector();
            this.unsetSystemTray();
            System.exit(0);
        }
    }

    public Gui_TablePanel getTabel() {
        return this.table;
    }

    public Control_Stream getControlStream() {
        return this.controlStreams;
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public void setTitleForAudioPlayer(String streamName, String title, boolean isErrorMessage) {
        if (title != null && this.audioPanel != null) {
            String gesTitle = String.valueOf(streamName) + " : " + title;
            this.audioPanel.setTitle(gesTitle, isErrorMessage);
            if (title == null || title.equals("")) {
                this.editWindowTitle("StreamRipStar");
            } else {
                this.editWindowTitle(title);
            }
            if (this.streamBrowser != null) {
                this.streamBrowser.setStatusText(gesTitle, isErrorMessage);
            }
        }
    }

    public int getAction(int actionNumber) {
        if (actionNumber == 0) {
            return this.action0;
        }
        if (actionNumber == 1) {
            return this.action1;
        }
        if (actionNumber == 2) {
            return this.action2;
        }
        return -1;
    }

    public void setNewRuntimePrefs(int[] actions, Boolean newShowText, Boolean newTray, String newlnfClassName, boolean useInternalPlayer, boolean searchUpdatesOnStartUp, boolean quiteSearchUpdates) {
        this.action0 = actions[0];
        this.action1 = actions[1];
        this.action2 = actions[2];
        this.winAction = actions[3];
        this.searchForUpdate = searchUpdatesOnStartUp;
        this.hideAutoUpdateWindow = quiteSearchUpdates;
        this.showText = newShowText;
        this.useInternalPlayer = useInternalPlayer;
        this.tray = newTray;
        this.setSystemTray();
        this.setTextUnderIcons();
        if (newlnfClassName != null) {
            this.updateLookAndFeel(newlnfClassName);
        }
    }

    public void updateLookAndFeel(String newlnfClassName) {
        if (newlnfClassName != null) {
            try {
                UIManager.setLookAndFeel(newlnfClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    public void editStream() {
        if (this.getTabel().isTHSelected()) {
            if (this.table.getSelectedStream()[0].getStatus().booleanValue()) {
                JOptionPane.showMessageDialog(this, this.trans.getString("noEditRecord"));
            }
            new Gui_StreamOptions(this.table.getSelectedStream()[0], this, false, true, false);
        } else {
            JOptionPane.showMessageDialog(this, this.trans.getString("select"));
        }
    }

    public void stopRippingUnselected(Stream stream, boolean userStoppsRecording) {
        stream.setStop(userStoppsRecording);
    }

    public void stopRippingSelected() {
        Stream[] streamsToStop = this.table.getSelectedStream();
        int i = 0;
        while (i < streamsToStop.length) {
            if (streamsToStop[i] == null) {
                JOptionPane.showInputDialog(this.trans.getString("stopError"));
            } else {
                streamsToStop[i].setStop(true);
            }
            ++i;
        }
    }

    public void startRippingUnselected(Stream recStream) {
        if (!recStream.getStatus().booleanValue()) {
            Process p = this.getControlStream().startStreamripper(recStream);
            if (p == null) {
                JOptionPane.showMessageDialog(this, this.trans.getString("exeError"));
                SRSOutput.getInstance().logE("Error while exec streamripper");
            } else {
                recStream.setProcess(p);
                recStream.setStatus(true);
                recStream.increaseRippingCount();
                int row = this.getTabel().getNewRowForNameForUpdate(recStream.name);
                Thread_UpdateName updateName = new Thread_UpdateName(recStream, row, this.getTabel());
                updateName.start();
                recStream.setUpdateName(updateName);
            }
        }
    }

    public void startRippingSelected() {
        if (this.getTabel().isTHSelected()) {
            Stream[] streamsToRecord = this.table.getSelectedStream();
            int i = 0;
            while (i < streamsToRecord.length) {
                if (streamsToRecord[i] == null) {
                    JOptionPane.showInputDialog(this.trans.getString("exeError"));
                } else if (!streamsToRecord[i].getStatus().booleanValue()) {
                    Process p = this.getControlStream().startStreamripper(streamsToRecord[i]);
                    if (p == null) {
                        JOptionPane.showMessageDialog(this, this.trans.getString("exeError"));
                        SRSOutput.getInstance().logE("Error while exec streamripper");
                    } else {
                        streamsToRecord[i].increaseRippingCount();
                        streamsToRecord[i].setProcess(p);
                        streamsToRecord[i].setStatus(true);
                        Thread_UpdateName updateName = new Thread_UpdateName(streamsToRecord[i], this.getTabel().getSelectedRow(), this.getTabel());
                        updateName.start();
                        streamsToRecord[i].setUpdateName(updateName);
                    }
                }
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(this, this.trans.getString("select"));
        }
    }

    public void openExportGui() {
        new Export_Streams(this.controlStreams, this);
    }

    public void openImportGui() {
        new Import_Streams(this, this.controlStreams);
    }

    public void editWindowTitle(String newTitle) {
        if (newTitle != null) {
            this.setTitle(newTitle);
        }
    }

    public void changeStatus() {
        if (this.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.setExtendedState(0);
            this.toFront();
        }
    }

    public synchronized void playSelectedStream() {
        if (this.getTabel().isTHSelected()) {
            this.getTabel().startMusicPlayerWithSelectedStream();
        } else {
            JOptionPane.showMessageDialog(this, this.trans.getString("select"));
        }
    }

    public void deleteStreamPerID(int id) {
        this.table.removeStreamfromTable();
        this.controlStreams.removeStreamFromVector(id);
        this.controlStreams.saveStreamVector();
        this.controlJob.deleteAllJobsFromStream(id);
    }

    public synchronized void playPreviousStream() {
        this.getTabel().selectPreviousStream();
        if (this.getTabel().isStreamSelected()) {
            this.getTabel().startMusicPlayerWithSelectedStream();
        }
    }

    public synchronized void playNextStream() {
        this.getTabel().selectNextStream();
        if (this.getTabel().isStreamSelected()) {
            this.getTabel().startMusicPlayerWithSelectedStream();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.winAction == 0) {
            this.setDefaultCloseOperation(0);
        } else if (this.winAction == 1) {
            this.setDefaultCloseOperation(0);
            this.closeAll();
        } else if (this.winAction == 2) {
            this.setDefaultCloseOperation(1);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class AboutDialogListener
    implements ActionListener {
        AboutDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new About_StreamRipStar(Gui_StreamRipStar.this.controlStreams, Gui_StreamRipStar.this);
        }
    }

    class AddStreamListener
    implements ActionListener {
        AddStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_StreamOptions(null, Gui_StreamRipStar.this, true, true, false);
        }
    }

    class BrowserListener
    implements ActionListener {
        BrowserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamRipStar.this.getTabel().isTHSelected()) {
                String website = ((Gui_StreamRipStar)Gui_StreamRipStar.this).table.getSelectedStream()[0].website;
                if (website != null && !website.equals("")) {
                    Gui_StreamRipStar.this.controlStreams.startWebBrowser(website);
                } else {
                    JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("setBrowser"));
                }
            } else {
                JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("select"));
            }
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean stopDeleting = false;
            Stream[] toDeleteStreams = Gui_StreamRipStar.this.getTabel().getSelectedStream();
            if (toDeleteStreams != null && toDeleteStreams.length > 0) {
                int i = toDeleteStreams.length - 1;
                while (i >= 0) {
                    if (toDeleteStreams[i].getStatus().booleanValue()) {
                        stopDeleting = true;
                        break;
                    }
                    --i;
                }
                if (!stopDeleting) {
                    int selectedOption = JOptionPane.showConfirmDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("realyDelete").replace("%s", "" + toDeleteStreams.length), Gui_StreamRipStar.this.trans.getString("deleteStream"), 0);
                    if (selectedOption == 0) {
                        int i2 = toDeleteStreams.length - 1;
                        while (i2 >= 0) {
                            Gui_StreamRipStar.this.deleteStreamPerID(toDeleteStreams[i2].id);
                            --i2;
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("noDeleteRecord"));
                }
            }
        }
    }

    class Edit4AllStreamListener
    implements ActionListener {
        Edit4AllStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_Stream4AllOptions(Gui_StreamRipStar.this);
        }
    }

    class EditDefaultStreamListener
    implements ActionListener {
        EditDefaultStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_StreamOptions(Gui_StreamRipStar.this.controlStreams.getDefaultStream(), Gui_StreamRipStar.this, false, true, true);
        }
    }

    class EditStreamListener
    implements ActionListener {
        EditStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.editStream();
        }
    }

    class ExitListener
    implements ActionListener {
        Gui_StreamRipStar mainWindow;

        public ExitListener(Gui_StreamRipStar mainWindow) {
            this.mainWindow = mainWindow;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mainWindow.closeAll();
        }
    }

    class ExportListener
    implements ActionListener {
        ExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.openExportGui();
        }
    }

    class GoToHelpSiteListener
    implements ActionListener {
        GoToHelpSiteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.controlStreams.startWebBrowser("https://github.com/Eule/StreamRipStar/wiki");
        }
    }

    class GoToWebSiteListener
    implements ActionListener {
        GoToWebSiteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.controlStreams.startWebBrowser("http://streamripper.sourceforge.net");
        }
    }

    class ImportListener
    implements ActionListener {
        ImportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.openImportGui();
        }
    }

    class OpenMusikFolder
    implements ActionListener {
        OpenMusikFolder() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String browser = Gui_StreamRipStar.this.getControlStream().getFileBrowserPath();
            String musicpath = Gui_StreamRipStar.this.getControlStream().getGeneralPath();
            if (browser == null || browser.trim().equals("")) {
                JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("confiFileBrower"));
            } else if (musicpath == null || musicpath.trim().equals("")) {
                JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("configGenralPath"));
            } else {
                new Control_RunExternProgram(String.valueOf(browser) + " " + musicpath).run();
            }
        }
    }

    public class PlayMusikListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.playSelectedStream();
        }
    }

    class PlayNextStreamListener
    implements ActionListener {
        PlayNextStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.playNextStream();
        }
    }

    class PlayPreviousStreamListener
    implements ActionListener {
        PlayPreviousStreamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.playNextStream();
        }
    }

    class PreferencesListener
    implements ActionListener {
        PreferencesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_Settings2(Gui_StreamRipStar.this);
        }
    }

    class ScheduleListener
    implements ActionListener {
        ScheduleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_SchedulManager(Gui_StreamRipStar.this.controlStreams, Gui_StreamRipStar.this.controlJob);
        }
    }

    class SearchUpdateListener
    implements ActionListener {
        SearchUpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Gui_searchUpdateWin(Gui_StreamRipStar.this.controlStreams, Gui_StreamRipStar.this, false);
        }
    }

    public class ShowGenreColumnListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamRipStar.this.showGenreColumnAction.isSelected()) {
                Gui_StreamRipStar.this.table.setGenreColumnVisible(false);
            } else {
                Gui_StreamRipStar.this.table.setGenreColumnVisible(true);
            }
        }
    }

    class ShowStatsListener
    implements ActionListener {
        ShowStatsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamRipStar.this.getTabel().isTHSelected()) {
                Stream stream = Gui_StreamRipStar.this.table.getSelectedStream()[0];
                new Gui_Infodialog(Gui_StreamRipStar.this, stream);
            } else {
                JOptionPane.showMessageDialog(Gui_StreamRipStar.this, Gui_StreamRipStar.this.trans.getString("select"));
            }
        }
    }

    class ShowStreamRipStarListener
    implements ActionListener {
        ShowStreamRipStarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.changeStatus();
        }
    }

    class StartRecordListener
    implements ActionListener {
        StartRecordListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.startRippingSelected();
        }
    }

    class StopRecordListener
    implements ActionListener {
        StopRecordListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamRipStar.this.stopRippingSelected();
        }
    }

    class StreamBrowserListener
    implements ActionListener {
        StreamBrowserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamRipStar.this.streamBrowser == null) {
                Gui_StreamRipStar.this.streamBrowser = new Gui_StreamBrowser2(Gui_StreamRipStar.this);
            } else {
                Gui_StreamRipStar.this.streamBrowser.setVisible(true);
            }
        }
    }

    class ViewLogDialogListener
    implements ActionListener {
        ViewLogDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ViewLog(Gui_StreamRipStar.this);
        }
    }
}

