/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.SRSOutput;
import gui.Gui_StreamRipStar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import misc.Stream;

public class Gui_StreamOptions
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon saveAndExitIcon = new ImageIcon(this.getClass().getResource("/Icons/ok_small.png"));
    private ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/Icons/save_small.png"));
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/abort_small.png"));
    private ImageIcon findIcon = new ImageIcon(this.getClass().getResource("/Icons/open_small.png"));
    private JPanel mainOptionsPanel = new JPanel();
    private JPanel baseOptionsPanel = new JPanel();
    private JPanel fileOptionsPanel = new JPanel();
    private JPanel overWriteCompletePanel = new JPanel();
    private JPanel otherWriteRulesPanel = new JPanel();
    private JPanel moreOptionsPanel = new JPanel();
    private JPanel relayServerPanel = new JPanel();
    private JPanel otherOptionsPanel = new JPanel();
    private JPanel connectionSettingsPanel = new JPanel();
    private JPanel tab4Panel = new JPanel();
    private JPanel idTagPanel = new JPanel();
    private JPanel splitPointPanel = new JPanel();
    private JPanel codesetPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextField streamNameTF = new JTextField(30);
    private JTextField streamURLTF = new JTextField(30);
    private JTextField streamWebsiteTF = new JTextField(30);
    private JTextField streamCommentTF = new JTextField(30);
    private JTextField streamGenreTF = new JTextField(30);
    private JTextField allInOneSaveField = new JTextField(20);
    private JTextField lengthRecordHourField = new JTextField(2);
    private JTextField lengthRecordMinuteField = new JTextField(2);
    private JTextField lengthRecordSecondField = new JTextField(2);
    private JTextField maxSizeMBField = new JTextField();
    private JTextField useragentField = new JTextField();
    private JTextField runIndexField = new JTextField("000");
    private JTextField patternField = new JTextField("%X%/");
    private JTextField realyPortField = new JTextField("8000", 5);
    private JTextField realyConnectionsField = new JTextField("0", 5);
    private JTextField proxyField = new JTextField();
    private JTextField skipTracksField = new JTextField(4);
    private JTextField timeoutReconnectField = new JTextField(6);
    private JTextField codesetRelayTF = new JTextField(20);
    private JTextField codesetMetadataTF = new JTextField(20);
    private JTextField codesetID3TF = new JTextField(20);
    private JTextField codesetFilesysTF = new JTextField(20);
    private JTextField xsOffsetTF = new JTextField(6);
    private JTextField xsPadding1TF = new JTextField(6);
    private JTextField xsPadding2TF = new JTextField(6);
    private JTextField xsSearch1TF = new JTextField(6);
    private JTextField xsSearch2TF = new JTextField(6);
    private JTextField xsSilenceTF = new JTextField(6);
    private JTextField freeArgumentTF = new JTextField(20);
    private JTextField metaDataRuleFileTF = new JTextField();
    private JTextField interfaceTF = new JTextField();
    private JTextField externalCmdMetaDataTF = new JTextField();
    private JTextField createRelayFileTF = new JTextField();
    private JCheckBox allInOneCheckBox = new JCheckBox("Save in single file: ");
    private JCheckBox lengthRecordCheckBox = new JCheckBox("Max Length of the Rip [hh:MM:ss]");
    private JCheckBox maxSizeMBCheckBox = new JCheckBox("Max size of file [MB]");
    private JCheckBox useragentCheckBox = new JCheckBox("Useragent");
    private JCheckBox runIndexCheckBox = new JCheckBox("Add sequence number to output filenames");
    private JCheckBox patternCheckBox = new JCheckBox("Use a pattern to format the output file names");
    private JCheckBox relayServerCheckBox = new JCheckBox("Create a realy Server in port");
    private JCheckBox relayConnect = new JCheckBox("Play relaystream in medialplayer");
    private JCheckBox createRelayFileCB = new JCheckBox("Create a relay playlist file");
    private JCheckBox proxyCheckBox = new JCheckBox("Use HTTP proxy server. url: ");
    private JCheckBox skipTracksCheckBox = new JCheckBox("Number of skiped tracks before starting to rip");
    private JCheckBox timeoutReconnectCheckBox = new JCheckBox("Timeout to restart connection [second]");
    private JCheckBox dCreateInvTracksCheckBox = new JCheckBox("Don't create individual tracks");
    private JCheckBox overWriteAllCheckBox = new JCheckBox("Ever overwrite tracks in 'complete'");
    private JCheckBox overWriteNeverCheckBox = new JCheckBox("Never overwrite tracks in 'complete'");
    private JCheckBox overWriteLargerCheckBox = new JCheckBox("Overwrite tracks in 'complete' when new track is larger than the old");
    private JCheckBox overWriteVersionCheckBox = new JCheckBox("Don't overwrite tracks in 'complete'. Rename the old file instead");
    private JCheckBox dontOverCheckBox = new JCheckBox("Don't overwrite tracks in incomplete");
    private JCheckBox noDirForStreamCheckBox = new JCheckBox("Don't create a directory for each stream");
    private JCheckBox dontScanPortCheckBox = new JCheckBox("Don't scan for free ports if base port is not available");
    private JCheckBox truncateCheckBox = new JCheckBox("Truncate completed tracks in incomplete directory");
    private JCheckBox dontReconnectCheckBox = new JCheckBox("Don't auto-reconnect");
    private JCheckBox codesetRelayCB = new JCheckBox("Specify codeset for the relay stream");
    private JCheckBox codesetMetadataCB = new JCheckBox("Specify codeset for metadata");
    private JCheckBox codesetID3CB = new JCheckBox("Specify codeset for id3 tags");
    private JCheckBox codesetFilesysCB = new JCheckBox("Specify codeset for the file system");
    private JCheckBox xs2CB = new JCheckBox("Use new algorithm for silence detection (xs2)");
    private JCheckBox xsOffsetCB = new JCheckBox("Shift relative to metadata (msec)");
    private JCheckBox xsPaddingCB = new JCheckBox("Add extra to prev:next track (msec)");
    private JCheckBox xsSearchCB = new JCheckBox("Search window relative to metadata (msec)");
    private JCheckBox xsSilenceCB = new JCheckBox("Expected length of silence (msec)");
    private JCheckBox id3tagV1CB = new JCheckBox("add ID3V1 tags to output file");
    private JCheckBox id3tagV2CB = new JCheckBox("add ID3V2 tags to output file");
    private JCheckBox metaDataRuleFileCB = new JCheckBox("Parse metadata using rules in file");
    private JCheckBox interfaceCB = new JCheckBox("Rip from specified interface (e.g. eth0)");
    private JCheckBox externalCmdMetaDataCB = new JCheckBox("Run external command to fetch metadata");
    private JCheckBox freeArgumentCB = new JCheckBox("Add command arguments");
    private JLabel realyConnectionsLabel = new JLabel("     Maximum connections to relay stream");
    private JLabel StreamNameLabel = new JLabel("Streamname: ");
    private JLabel StreamURLLabel = new JLabel("Stream URL: ");
    private JLabel StreamWebsiteLabel = new JLabel("Stream Website: ");
    private JLabel StreamCommentLabel = new JLabel("Stream comment: ");
    private JLabel StreamGenreLabel = new JLabel("Stream Genre: ");
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JButton saveButton = new JButton("Save", this.saveIcon);
    private JButton saveAndExitButton = new JButton("OK", this.saveAndExitIcon);
    private JButton openRemotePlayList = new JButton(this.findIcon);
    private JButton metaFileChooser = new JButton(this.findIcon);
    private JButton exernProgramMeta = new JButton(this.findIcon);
    private TitledBorder codeSetTitle = BorderFactory.createTitledBorder("Codesets");
    private TitledBorder splitPointTitle = BorderFactory.createTitledBorder("Splitpoint Options (mp3 only)");
    private TitledBorder overWriteCompleteTitle = BorderFactory.createTitledBorder("Overwrite rules for 'complete'");
    private TitledBorder otherOverWriteTitle = BorderFactory.createTitledBorder("Other overwrite rules");
    private TitledBorder connectionTitle = BorderFactory.createTitledBorder("Connection settings");
    private TitledBorder idTagTitle = BorderFactory.createTitledBorder("ID3 tag");
    private TitledBorder baseOptionsTitle = BorderFactory.createTitledBorder("Basic options");
    private TitledBorder fileOptionsTitle = BorderFactory.createTitledBorder("File options");
    private TitledBorder relayServerTitle = BorderFactory.createTitledBorder("Relay server options");
    private TitledBorder otherOptionsTitle = BorderFactory.createTitledBorder("Other Options");
    private JFileChooser dirChooser = new JFileChooser();
    private Gui_StreamRipStar mainGui = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private ResourceBundle toolTips = ResourceBundle.getBundle("translations.ToolTips");
    private boolean createNewStream = true;
    private boolean setVisible = true;
    private boolean dontExit = false;
    private boolean defaultStream = false;
    private Stream stream = null;

    public Gui_StreamOptions(Stream stream, Gui_StreamRipStar mainGui, boolean createNewStream, boolean setVisible, boolean defaultStream) {
        this.stream = stream;
        this.setVisible = setVisible;
        this.mainGui = mainGui;
        this.createNewStream = createNewStream;
        this.defaultStream = defaultStream;
        Stream tmpStream = null;
        if (createNewStream && !defaultStream) {
            this.setTitle("Create New Stream");
            tmpStream = new Stream("", Stream.getNewStreamID());
            this.realyPortField.setText("" + (8000 + tmpStream.id));
        }
        this.init();
        this.setDefaults();
        if (createNewStream && !defaultStream) {
            this.stream = mainGui.getControlStream().getDefaultStream();
            if (this.stream != null) {
                this.load();
            }
            this.stream = tmpStream;
        }
        if (!createNewStream) {
            if (stream != null) {
                this.load();
            } else {
                this.stream = new Stream("defaultName", 0);
            }
            if (!defaultStream) {
                this.setTitle("Stream Options");
            } else {
                this.setTitle("Edit Default Options");
                this.streamNameTF.setEditable(false);
                this.streamURLTF.setEditable(false);
            }
        }
        this.setLanguage();
        this.repaintMainGui();
        this.repaintCodesetAndSplitpointPanel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
        Dimension frameDim = this.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.setDefaultCloseOperation(2);
        if (setVisible) {
            this.setVisible(true);
        }
    }

    private void init() {
        if (this.createNewStream) {
            this.streamNameTF.setBackground(Color.ORANGE);
            this.streamURLTF.setBackground(Color.ORANGE);
        }
        this.setLayout(new BorderLayout());
        this.tabbedPane.addTab("File & write rules", this.mainOptionsPanel);
        this.tabbedPane.addTab("Relay server & connection options", this.moreOptionsPanel);
        this.tabbedPane.addTab("Codeset & Splitpoints", this.tab4Panel);
        this.mainOptionsPanel.setLayout(new GridBagLayout());
        this.baseOptionsPanel.setLayout(new GridBagLayout());
        this.fileOptionsPanel.setLayout(new GridBagLayout());
        this.relayServerPanel.setLayout(new GridBagLayout());
        this.otherOptionsPanel.setLayout(new GridBagLayout());
        this.moreOptionsPanel.setLayout(new GridBagLayout());
        this.overWriteCompletePanel.setLayout(new GridBagLayout());
        this.otherWriteRulesPanel.setLayout(new GridBagLayout());
        this.connectionSettingsPanel.setLayout(new GridBagLayout());
        this.codesetPanel.setLayout(new GridBagLayout());
        this.splitPointPanel.setLayout(new GridBagLayout());
        this.tab4Panel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.idTagPanel.setLayout(new GridBagLayout());
        this.codesetPanel.setBorder(this.codeSetTitle);
        this.splitPointPanel.setBorder(this.splitPointTitle);
        this.overWriteCompletePanel.setBorder(this.overWriteCompleteTitle);
        this.otherWriteRulesPanel.setBorder(this.otherOverWriteTitle);
        this.connectionSettingsPanel.setBorder(this.connectionTitle);
        this.idTagPanel.setBorder(this.idTagTitle);
        this.baseOptionsPanel.setBorder(this.baseOptionsTitle);
        this.fileOptionsPanel.setBorder(this.fileOptionsTitle);
        this.relayServerPanel.setBorder(this.relayServerTitle);
        this.otherOptionsPanel.setBorder(this.otherOptionsTitle);
        ButtonGroup overWriteGroup = new ButtonGroup();
        overWriteGroup.add(this.overWriteAllCheckBox);
        overWriteGroup.add(this.overWriteNeverCheckBox);
        overWriteGroup.add(this.overWriteLargerCheckBox);
        overWriteGroup.add(this.overWriteVersionCheckBox);
        this.overWriteAllCheckBox.setSelected(true);
        this.overWriteNeverCheckBox.setSelected(true);
        this.overWriteLargerCheckBox.setSelected(true);
        if (this.setVisible) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.weightx = 0.0;
            c.gridy = 0;
            c.gridx = 0;
            this.baseOptionsPanel.add((Component)this.StreamNameLabel, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.baseOptionsPanel.add((Component)this.streamNameTF, c);
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 0.0;
            this.baseOptionsPanel.add((Component)this.StreamURLLabel, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.baseOptionsPanel.add((Component)this.streamURLTF, c);
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 0.0;
            this.baseOptionsPanel.add((Component)this.StreamWebsiteLabel, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.baseOptionsPanel.add((Component)this.streamWebsiteTF, c);
            c.gridx = 0;
            c.gridy = 3;
            c.weightx = 0.0;
            this.baseOptionsPanel.add((Component)this.StreamCommentLabel, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.baseOptionsPanel.add((Component)this.streamCommentTF, c);
            c.gridx = 0;
            c.gridy = 4;
            c.weightx = 0.0;
            this.baseOptionsPanel.add((Component)this.StreamGenreLabel, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.baseOptionsPanel.add((Component)this.streamGenreTF, c);
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.gridy = 0;
            c.gridx = 0;
            this.fileOptionsPanel.add((Component)this.allInOneCheckBox, c);
            c.weightx = 1.0;
            c.gridx = 1;
            c.gridwidth = 12;
            this.fileOptionsPanel.add((Component)this.allInOneSaveField, c);
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 1;
            this.fileOptionsPanel.add((Component)this.lengthRecordCheckBox, c);
            c.gridx = 1;
            this.fileOptionsPanel.add((Component)this.lengthRecordHourField, c);
            c.gridx = 3;
            this.fileOptionsPanel.add((Component)this.lengthRecordMinuteField, c);
            c.gridx = 5;
            this.fileOptionsPanel.add((Component)this.lengthRecordSecondField, c);
            c.gridx = 2;
            this.fileOptionsPanel.add((Component)new JLabel(":"), c);
            c.gridx = 4;
            this.fileOptionsPanel.add((Component)new JLabel(":"), c);
            c.gridx = 6;
            c.weightx = 1.0;
            this.fileOptionsPanel.add((Component)new JLabel(" "), c);
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 2;
            this.fileOptionsPanel.add((Component)this.maxSizeMBCheckBox, c);
            c.gridx = 1;
            c.gridwidth = 12;
            this.fileOptionsPanel.add((Component)this.maxSizeMBField, c);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 3;
            this.fileOptionsPanel.add((Component)this.runIndexCheckBox, c);
            c.gridwidth = 12;
            c.gridx = 1;
            this.fileOptionsPanel.add((Component)this.runIndexField, c);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 4;
            this.fileOptionsPanel.add((Component)this.patternCheckBox, c);
            c.gridwidth = 12;
            c.gridx = 1;
            this.fileOptionsPanel.add((Component)this.patternField, c);
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            this.overWriteCompletePanel.add((Component)this.overWriteVersionCheckBox, c);
            c.gridy = 1;
            this.overWriteCompletePanel.add((Component)this.overWriteAllCheckBox, c);
            c.gridy = 2;
            this.overWriteCompletePanel.add((Component)this.overWriteNeverCheckBox, c);
            c.gridy = 3;
            this.overWriteCompletePanel.add((Component)this.overWriteLargerCheckBox, c);
            c.gridy = 0;
            this.otherWriteRulesPanel.add((Component)this.truncateCheckBox, c);
            c.gridy = 1;
            this.otherWriteRulesPanel.add((Component)this.dontOverCheckBox, c);
            c.gridy = 2;
            this.otherWriteRulesPanel.add((Component)this.noDirForStreamCheckBox, c);
            c.gridy = 3;
            this.otherWriteRulesPanel.add((Component)this.dCreateInvTracksCheckBox, c);
            c.insets = new Insets(10, 5, 5, 5);
            c.weightx = 1.0;
            c.gridy = 0;
            c.gridx = 0;
            this.mainOptionsPanel.add((Component)this.baseOptionsPanel, c);
            c.insets = new Insets(2, 2, 2, 2);
            c.gridy = 1;
            this.mainOptionsPanel.add((Component)this.fileOptionsPanel, c);
            c.gridy = 2;
            this.mainOptionsPanel.add((Component)this.overWriteCompletePanel, c);
            c.gridy = 3;
            this.mainOptionsPanel.add((Component)this.otherWriteRulesPanel, c);
            c.weighty = 1.0;
            c.gridy = 4;
            this.mainOptionsPanel.add((Component)new JPanel(), c);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.codesetPanel.add((Component)this.codesetRelayCB, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.codesetPanel.add((Component)this.codesetRelayTF, c);
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 1;
            this.codesetPanel.add((Component)this.codesetMetadataCB, c);
            c.gridx = 1;
            this.codesetPanel.add((Component)this.codesetMetadataTF, c);
            c.gridx = 0;
            c.gridy = 2;
            this.codesetPanel.add((Component)this.codesetID3CB, c);
            c.gridx = 1;
            this.codesetPanel.add((Component)this.codesetID3TF, c);
            c.gridx = 0;
            c.gridy = 3;
            this.codesetPanel.add((Component)this.codesetFilesysCB, c);
            c.gridx = 1;
            this.codesetPanel.add((Component)this.codesetFilesysTF, c);
            c.gridx = 0;
            c.gridy = 0;
            this.splitPointPanel.add((Component)this.xs2CB, c);
            c.gridy = 1;
            this.splitPointPanel.add((Component)this.xsOffsetCB, c);
            c.gridx = 1;
            this.splitPointPanel.add((Component)this.xsOffsetTF, c);
            c.gridx = 0;
            c.gridy = 2;
            this.splitPointPanel.add((Component)this.xsPaddingCB, c);
            c.gridx = 1;
            this.splitPointPanel.add((Component)this.xsPadding1TF, c);
            c.gridx = 2;
            this.splitPointPanel.add((Component)new JLabel(":"), c);
            c.gridx = 3;
            this.splitPointPanel.add((Component)this.xsPadding2TF, c);
            c.gridx = 0;
            c.gridy = 3;
            this.splitPointPanel.add((Component)this.xsSearchCB, c);
            c.gridx = 1;
            this.splitPointPanel.add((Component)this.xsSearch1TF, c);
            c.gridx = 2;
            this.splitPointPanel.add((Component)new JLabel(":"), c);
            c.gridx = 3;
            this.splitPointPanel.add((Component)this.xsSearch2TF, c);
            c.gridx = 0;
            c.gridy = 4;
            this.splitPointPanel.add((Component)this.xsSilenceCB, c);
            c.gridx = 1;
            this.splitPointPanel.add((Component)this.xsSilenceTF, c);
            c.weightx = 1.0;
            c.gridx = 4;
            this.splitPointPanel.add((Component)new JLabel(), c);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            this.idTagPanel.add((Component)this.id3tagV1CB, c);
            c.gridy = 1;
            this.idTagPanel.add((Component)this.id3tagV2CB, c);
            c.insets = new Insets(10, 5, 5, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            this.tab4Panel.add((Component)this.codesetPanel, c);
            c.insets = new Insets(2, 2, 2, 2);
            c.gridy = 1;
            this.tab4Panel.add((Component)this.splitPointPanel, c);
            c.gridy = 2;
            this.tab4Panel.add((Component)this.idTagPanel, c);
            c.gridy = 3;
            c.weighty = 1.0;
            this.tab4Panel.add((Component)new JLabel(), c);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            this.relayServerPanel.add((Component)this.relayServerCheckBox, c);
            c.gridwidth = 2;
            c.gridx = 1;
            c.weightx = 1.0;
            this.relayServerPanel.add((Component)this.realyPortField, c);
            c.weightx = 0.0;
            c.gridy = 1;
            c.gridx = 0;
            c.gridwidth = 1;
            this.relayServerPanel.add((Component)this.realyConnectionsLabel, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.relayServerPanel.add((Component)this.realyConnectionsField, c);
            c.weightx = 0.0;
            c.gridy = 2;
            c.gridx = 0;
            this.relayServerPanel.add((Component)this.relayConnect, c);
            c.gridy = 3;
            c.gridx = 0;
            this.relayServerPanel.add((Component)this.createRelayFileCB, c);
            c.weightx = 1.0;
            c.gridx = 1;
            this.relayServerPanel.add((Component)this.createRelayFileTF, c);
            c.weightx = 0.0;
            c.gridx = 2;
            this.relayServerPanel.add((Component)this.openRemotePlayList, c);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridy = 0;
            c.gridx = 0;
            this.otherOptionsPanel.add((Component)this.skipTracksCheckBox, c);
            c.gridx = 1;
            this.otherOptionsPanel.add((Component)this.skipTracksField, c);
            c.weightx = 0.0;
            c.gridy = 1;
            c.gridx = 0;
            this.otherOptionsPanel.add((Component)this.metaDataRuleFileCB, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.otherOptionsPanel.add((Component)this.metaDataRuleFileTF, c);
            c.weightx = 0.0;
            c.gridx = 2;
            this.otherOptionsPanel.add((Component)this.metaFileChooser, c);
            c.gridy = 2;
            c.gridx = 0;
            this.otherOptionsPanel.add((Component)this.interfaceCB, c);
            c.gridx = 1;
            this.otherOptionsPanel.add((Component)this.interfaceTF, c);
            c.gridy = 3;
            c.gridx = 0;
            this.otherOptionsPanel.add((Component)this.externalCmdMetaDataCB, c);
            c.gridx = 1;
            c.gridwidth = 1;
            this.otherOptionsPanel.add((Component)this.externalCmdMetaDataTF, c);
            c.gridx = 2;
            c.gridwidth = 1;
            this.otherOptionsPanel.add((Component)this.exernProgramMeta, c);
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 1;
            this.otherOptionsPanel.add((Component)this.freeArgumentCB, c);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.otherOptionsPanel.add((Component)this.freeArgumentTF, c);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = 0;
            this.connectionSettingsPanel.add((Component)this.dontScanPortCheckBox, c);
            c.gridy = 1;
            this.connectionSettingsPanel.add((Component)this.dontReconnectCheckBox, c);
            c.gridwidth = 1;
            c.gridy = 2;
            this.connectionSettingsPanel.add((Component)this.timeoutReconnectCheckBox, c);
            c.gridx = 1;
            this.connectionSettingsPanel.add((Component)this.timeoutReconnectField, c);
            c.gridy = 3;
            c.gridx = 0;
            this.connectionSettingsPanel.add((Component)this.proxyCheckBox, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.connectionSettingsPanel.add((Component)this.proxyField, c);
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 4;
            this.connectionSettingsPanel.add((Component)this.useragentCheckBox, c);
            c.gridwidth = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            this.connectionSettingsPanel.add((Component)this.useragentField, c);
            c.insets = new Insets(10, 2, 2, 2);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridy = 0;
            this.moreOptionsPanel.add((Component)this.relayServerPanel, c);
            c.gridy = 1;
            this.moreOptionsPanel.add((Component)this.connectionSettingsPanel, c);
            c.gridy = 2;
            this.moreOptionsPanel.add((Component)this.otherOptionsPanel, c);
            c.gridy = 3;
            c.weighty = 1.0;
            this.moreOptionsPanel.add((Component)new JLabel(""), c);
            c.insets = new Insets(7, 7, 7, 7);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            this.buttonPanel.add((Component)this.saveAndExitButton, c);
            c.gridx = 1;
            this.buttonPanel.add((Component)this.saveButton, c);
            c.gridx = 4;
            c.weightx = 1.0;
            this.buttonPanel.add((Component)new JLabel("  "), c);
            c.gridx = 5;
            c.weightx = 0.0;
            this.buttonPanel.add((Component)this.abortButton, c);
            this.openRemotePlayList.addActionListener(new RemotePlayListListener());
            this.metaFileChooser.addActionListener(new MetaFileChooserListener());
            this.exernProgramMeta.addActionListener(new ExternProgramMetaListener());
            this.allInOneCheckBox.addActionListener(new RepaintMainListener());
            this.lengthRecordCheckBox.addActionListener(new RepaintMainListener());
            this.maxSizeMBCheckBox.addActionListener(new RepaintMainListener());
            this.useragentCheckBox.addActionListener(new RepaintMainListener());
            this.runIndexCheckBox.addActionListener(new RepaintMainListener());
            this.relayServerCheckBox.addActionListener(new RepaintMainListener());
            this.createRelayFileCB.addActionListener(new RepaintMainListener());
            this.proxyCheckBox.addActionListener(new RepaintMainListener());
            this.skipTracksCheckBox.addActionListener(new RepaintMainListener());
            this.timeoutReconnectCheckBox.addActionListener(new RepaintMainListener());
            this.patternCheckBox.addActionListener(new RepaintMainListener());
            this.saveButton.addActionListener(new SaveListener());
            this.saveAndExitButton.addActionListener(new SaveAndExitListener());
            this.abortButton.addActionListener(new ExitListener());
            this.codesetRelayCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.codesetMetadataCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.codesetID3CB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.codesetFilesysCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.xs2CB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.xsOffsetCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.xsPaddingCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.xsSearchCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.xsSilenceCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.freeArgumentCB.addActionListener(new FreeArgumentsListener());
            this.metaDataRuleFileCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.interfaceCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            this.externalCmdMetaDataCB.addActionListener(new RepaintCodesetAndSplitPointListener());
            ToolTipManager.sharedInstance().setInitialDelay(1000);
            ToolTipManager.sharedInstance().setReshowDelay(1000);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            this.allInOneSaveField.setToolTipText(this.toolTips.getString("singleFileField"));
            this.allInOneCheckBox.setToolTipText(this.toolTips.getString("singleFile"));
            this.maxSizeMBCheckBox.setToolTipText(this.toolTips.getString("maxSize"));
            this.maxSizeMBField.setToolTipText(this.toolTips.getString("maxSizeField"));
            this.lengthRecordCheckBox.setToolTipText(this.toolTips.getString("maxLength"));
            this.lengthRecordHourField.setToolTipText(this.toolTips.getString("maxLengthHours"));
            this.lengthRecordMinuteField.setToolTipText(this.toolTips.getString("maxLengthMinutes"));
            this.lengthRecordSecondField.setToolTipText(this.toolTips.getString("maxLengthSeconds"));
            this.useragentCheckBox.setToolTipText(this.toolTips.getString("useragent"));
            this.useragentField.setToolTipText(this.toolTips.getString("useragentField"));
            this.runIndexCheckBox.setToolTipText(this.toolTips.getString("runIndex"));
            this.runIndexField.setToolTipText(this.toolTips.getString("runIndexField"));
            this.patternCheckBox.setToolTipText(this.toolTips.getString("pattern"));
            this.patternField.setToolTipText(this.toolTips.getString("singleFileField"));
            this.relayServerCheckBox.setToolTipText(this.toolTips.getString("relayServer"));
            this.realyPortField.setToolTipText(this.toolTips.getString("relayServerField"));
            this.realyConnectionsLabel.setToolTipText(this.toolTips.getString("maxConnections"));
            this.realyConnectionsField.setToolTipText(this.toolTips.getString("maxConnectionsField"));
            this.relayConnect.setToolTipText(this.toolTips.getString("relayConnect"));
            this.proxyCheckBox.setToolTipText(this.toolTips.getString("proxy"));
            this.proxyField.setToolTipText(this.toolTips.getString("proxyField"));
            this.skipTracksCheckBox.setToolTipText(this.toolTips.getString("skipTrack"));
            this.skipTracksField.setToolTipText(this.toolTips.getString("skipTrackField"));
            this.timeoutReconnectCheckBox.setToolTipText(this.toolTips.getString("timeout"));
            this.timeoutReconnectField.setToolTipText(this.toolTips.getString("timeoutField"));
            this.overWriteAllCheckBox.setToolTipText(String.valueOf(this.toolTips.getString("overWrite")) + this.toolTips.getString("overWriteAlways"));
            this.overWriteNeverCheckBox.setToolTipText(String.valueOf(this.toolTips.getString("overWrite")) + this.toolTips.getString("overWriteNever"));
            this.overWriteLargerCheckBox.setToolTipText(String.valueOf(this.toolTips.getString("overWrite")) + this.toolTips.getString("overWriteLarger"));
            this.overWriteVersionCheckBox.setToolTipText(String.valueOf(this.toolTips.getString("overWrite")) + this.toolTips.getString("overWriteVersion"));
            this.dontOverCheckBox.setToolTipText(this.toolTips.getString("dontOverIncom"));
            this.truncateCheckBox.setToolTipText(this.toolTips.getString("truncate"));
            this.noDirForStreamCheckBox.setToolTipText(this.toolTips.getString("noStreamDir"));
            this.dontScanPortCheckBox.setToolTipText(this.toolTips.getString("dontScanPorts"));
            this.dontReconnectCheckBox.setToolTipText(this.toolTips.getString("dontReconnect"));
            this.dCreateInvTracksCheckBox.setToolTipText(this.toolTips.getString("dCInvTracks"));
            this.createRelayFileCB.setToolTipText(this.toolTips.getString("createRelayPlaylist"));
            this.createRelayFileTF.setToolTipText(this.toolTips.getString("createRelayPlaylistTF"));
            this.metaDataRuleFileCB.setToolTipText(this.toolTips.getString("metaDataRuleFileCB"));
            this.interfaceCB.setToolTipText(this.toolTips.getString("interfaceCB"));
            this.interfaceTF.setToolTipText(this.toolTips.getString("interfaceTF"));
            this.metaDataRuleFileTF.setToolTipText(this.toolTips.getString("metaDataRuleFileTF"));
            this.externalCmdMetaDataCB.setToolTipText(this.toolTips.getString("externalCmdMetaDataCB"));
            this.externalCmdMetaDataTF.setToolTipText(this.toolTips.getString("externalCmdMetaDataTF"));
            this.freeArgumentCB.setToolTipText(String.valueOf(this.toolTips.getString("freeArgumentATT")) + this.toolTips.getString("freeArgumentCB"));
            this.freeArgumentTF.setToolTipText(String.valueOf(this.toolTips.getString("freeArgumentATT")) + this.toolTips.getString("freeArgumentTF"));
            this.codesetRelayCB.setToolTipText(this.toolTips.getString("codeset"));
            this.codesetMetadataCB.setToolTipText(this.toolTips.getString("codeset"));
            this.codesetID3CB.setToolTipText(this.toolTips.getString("codeset"));
            this.codesetFilesysCB.setToolTipText(this.toolTips.getString("codeset"));
            this.codesetRelayTF.setToolTipText(this.toolTips.getString("codesetTF"));
            this.codesetMetadataTF.setToolTipText(this.toolTips.getString("codesetTF"));
            this.codesetID3TF.setToolTipText(this.toolTips.getString("codesetTF"));
            this.codesetFilesysTF.setToolTipText(this.toolTips.getString("codesetTF"));
            this.xs2CB.setToolTipText(this.toolTips.getString("xs2CB"));
            this.xsOffsetCB.setToolTipText(this.toolTips.getString("xs"));
            this.xsPaddingCB.setToolTipText(this.toolTips.getString("xs"));
            this.xsSearchCB.setToolTipText(this.toolTips.getString("xs"));
            this.xsSilenceCB.setToolTipText(this.toolTips.getString("xs"));
            this.xsOffsetTF.setToolTipText(this.toolTips.getString("xsTime"));
            this.xsPadding1TF.setToolTipText(this.toolTips.getString("xsTime"));
            this.xsPadding2TF.setToolTipText(this.toolTips.getString("xsTime"));
            this.xsSearch1TF.setToolTipText(this.toolTips.getString("xsTime"));
            this.xsSearch2TF.setToolTipText(this.toolTips.getString("xsTime"));
            this.xsSilenceTF.setToolTipText(this.toolTips.getString("xsTime"));
            this.id3tagV1CB.setToolTipText(this.toolTips.getString("id3tagV1CB"));
            this.id3tagV2CB.setToolTipText(this.toolTips.getString("id3tagV2CB"));
            this.add((Component)this.tabbedPane, "Center");
            this.add((Component)this.buttonPanel, "South");
            KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, true);
            this.getRootPane().registerKeyboardAction(new ExitListener(), escStroke, 2);
        }
    }

    private void setDefaults() {
        this.overWriteVersionCheckBox.setSelected(true);
        this.overWriteLargerCheckBox.setSelected(true);
        this.dontOverCheckBox.setSelected(true);
        this.id3tagV2CB.setSelected(true);
        this.patternCheckBox.setSelected(true);
    }

    public void setBasics(String[] basics) {
        this.streamNameTF.setText(basics[1]);
        this.streamURLTF.setText(basics[0]);
        this.streamGenreTF.setText(basics[2]);
        this.streamWebsiteTF.setText(basics[3]);
    }

    private void setLanguage() {
        try {
            if (this.createNewStream) {
                this.setTitle(this.trans.getString("newStream"));
            } else if (this.defaultStream) {
                this.setTitle(this.trans.getString("editDefaultOptions"));
            } else if (this.stream != null) {
                this.setTitle(String.valueOf(this.trans.getString("editStream")) + " " + this.stream.name);
            } else {
                this.setTitle(String.valueOf(this.trans.getString("editStream")) + " " + this.stream.name);
            }
            this.tabbedPane.setTitleAt(0, this.trans.getString("tab0"));
            this.tabbedPane.setTitleAt(1, this.trans.getString("tab1"));
            this.tabbedPane.setTitleAt(2, this.trans.getString("tab2"));
            this.baseOptionsTitle.setTitle(this.trans.getString("baseOption.title"));
            this.StreamNameLabel.setText(this.trans.getString("StreamNameLabel"));
            this.StreamURLLabel.setText(this.trans.getString("StreamURLLabel"));
            this.StreamWebsiteLabel.setText(this.trans.getString("StreamWebsiteLabel"));
            this.StreamCommentLabel.setText(this.trans.getString("StreamCommentLabel"));
            this.StreamGenreLabel.setText(this.trans.getString("StreamGenreLabel"));
            this.fileOptionsTitle.setTitle(this.trans.getString("fileOptionsPanel.title"));
            this.allInOneCheckBox.setText(this.trans.getString("fileOptionsPanel.saveSingleFile"));
            this.lengthRecordCheckBox.setText(this.trans.getString("fileOptionsPanel.maxLength"));
            this.maxSizeMBCheckBox.setText(this.trans.getString("fileOptionsPanel.maxSize"));
            this.runIndexCheckBox.setText(this.trans.getString("fileOptionsPanel.addSequence"));
            this.patternCheckBox.setText(this.trans.getString("fileOptionsPanel.usePattern"));
            this.overWriteCompleteTitle.setTitle(this.trans.getString("overWriteCompletePanel.title"));
            this.overWriteAllCheckBox.setText(this.trans.getString("overWriteCompletePanel.OverwriteEverComp"));
            this.overWriteNeverCheckBox.setText(this.trans.getString("overWriteCompletePanel.OverwriteNeverComp"));
            this.overWriteLargerCheckBox.setText(this.trans.getString("overWriteCompletePanel.OverwriteLargerComp"));
            this.overWriteVersionCheckBox.setText(this.trans.getString("overWriteCompletePanel.OverwriteVersionComp"));
            this.otherOverWriteTitle.setTitle(this.trans.getString("otherWriteRulesPanel.title"));
            this.truncateCheckBox.setText(this.trans.getString("otherWriteRulesPanel.Truncate"));
            this.dontOverCheckBox.setText(this.trans.getString("otherWriteRulesPanel.dontOverIncomp"));
            this.noDirForStreamCheckBox.setText(this.trans.getString("otherWriteRulesPanel.dontCreatDir"));
            this.dCreateInvTracksCheckBox.setText(this.trans.getString("otherWriteRulesPanel.dCreateInvTracks"));
            this.relayServerTitle.setTitle(this.trans.getString("relayServerPanel.title"));
            this.relayServerCheckBox.setText(this.trans.getString("relayServerPanel.realyServer"));
            this.realyConnectionsLabel.setText("      " + this.trans.getString("relayServerPanel.maxConnections"));
            this.relayConnect.setText(this.trans.getString("relayServerPanel.playReal"));
            this.createRelayFileCB.setText(this.trans.getString("relayServerPanel.createPlaylist"));
            this.otherOptionsTitle.setTitle(this.trans.getString("otherOptionsPanel.title"));
            this.skipTracksCheckBox.setText(this.trans.getString("otherOptionsPanel.skiptedTracks"));
            this.metaDataRuleFileCB.setText(this.trans.getString("otherOptionsPanel.metaDataRuleFile"));
            this.interfaceCB.setText(this.trans.getString("otherOptionsPanel.interface"));
            this.externalCmdMetaDataCB.setText(this.trans.getString("otherOptionsPanel.externalCmdMetaData"));
            this.freeArgumentCB.setText(this.trans.getString("otherOptionsPanel.freeArgument"));
            this.connectionTitle.setTitle(this.trans.getString("connectionSettingsPanel.title"));
            this.proxyCheckBox.setText(this.trans.getString("connectionSettingsPanel.httpProxy"));
            this.timeoutReconnectCheckBox.setText(this.trans.getString("connectionSettingsPanel.timeout"));
            this.useragentCheckBox.setText(this.trans.getString("connectionSettingsPanel.Useragent"));
            this.dontScanPortCheckBox.setText(this.trans.getString("connectionSettingsPanel.DontScan"));
            this.dontReconnectCheckBox.setText(this.trans.getString("connectionSettingsPanel.DontAutoReco"));
            this.codeSetTitle.setTitle(this.trans.getString("codesetPanel.title"));
            this.codesetRelayCB.setText(this.trans.getString("codesetPanel.codesetRelay"));
            this.codesetMetadataCB.setText(this.trans.getString("codesetPanel.codesetMetadata"));
            this.codesetID3CB.setText(this.trans.getString("codesetPanel.codesetID3"));
            this.codesetFilesysCB.setText(this.trans.getString("codesetPanel.codesetFilesys"));
            this.splitPointTitle.setTitle(this.trans.getString("splitPointPanel.title"));
            this.xs2CB.setText(this.trans.getString("splitPointTitle.xs2"));
            this.xsOffsetCB.setText(this.trans.getString("splitPointTitle.xsOffset"));
            this.xsPaddingCB.setText(this.trans.getString("splitPointTitle.xsPadding"));
            this.xsSearchCB.setText(this.trans.getString("splitPointTitle.xsSearch"));
            this.xsSilenceCB.setText(this.trans.getString("splitPointTitle.xsSilence"));
            this.idTagTitle.setTitle(this.trans.getString("idTagPanel.title"));
            this.id3tagV1CB.setText(this.trans.getString("idTagPanel.id3tagV1"));
            this.id3tagV2CB.setText(this.trans.getString("idTagPanel.id3tagV2"));
            this.abortButton.setText(this.trans.getString("abortButton"));
            this.saveButton.setText(this.trans.getString("save"));
            this.saveAndExitButton.setText(this.trans.getString("okButton"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void repaintCodesetAndSplitpointPanel() {
        if (this.codesetRelayCB.isSelected()) {
            this.codesetRelayTF.setEditable(true);
        } else {
            this.codesetRelayTF.setEditable(false);
        }
        if (this.codesetMetadataCB.isSelected()) {
            this.codesetMetadataTF.setEditable(true);
        } else {
            this.codesetMetadataTF.setEditable(false);
        }
        if (this.codesetID3CB.isSelected()) {
            this.codesetID3TF.setEditable(true);
        } else {
            this.codesetID3TF.setEditable(false);
        }
        if (this.codesetFilesysCB.isSelected()) {
            this.codesetFilesysTF.setEditable(true);
        } else {
            this.codesetFilesysTF.setEditable(false);
        }
        if (this.xsOffsetCB.isSelected()) {
            this.xsOffsetTF.setEditable(true);
        } else {
            this.xsOffsetTF.setEditable(false);
        }
        if (this.xsPaddingCB.isSelected()) {
            this.xsPadding1TF.setEditable(true);
            this.xsPadding2TF.setEditable(true);
        } else {
            this.xsPadding1TF.setEditable(false);
            this.xsPadding2TF.setEditable(false);
        }
        if (this.xsSearchCB.isSelected()) {
            this.xsSearch1TF.setEditable(true);
            this.xsSearch2TF.setEditable(true);
        } else {
            this.xsSearch1TF.setEditable(false);
            this.xsSearch2TF.setEditable(false);
        }
        if (this.xsSilenceCB.isSelected()) {
            this.xsSilenceTF.setEditable(true);
        } else {
            this.xsSilenceTF.setEditable(false);
        }
        if (this.freeArgumentCB.isSelected()) {
            this.freeArgumentTF.setEditable(true);
        } else {
            this.freeArgumentTF.setEditable(false);
        }
        if (this.metaDataRuleFileCB.isSelected()) {
            this.metaDataRuleFileTF.setEditable(true);
        } else {
            this.metaDataRuleFileTF.setEditable(false);
        }
        if (this.interfaceCB.isSelected()) {
            this.interfaceTF.setEditable(true);
        } else {
            this.interfaceTF.setEditable(false);
        }
        if (this.externalCmdMetaDataCB.isSelected()) {
            this.externalCmdMetaDataTF.setEditable(true);
        } else {
            this.externalCmdMetaDataTF.setEditable(false);
        }
    }

    public void repaintMainGui() {
        if (this.allInOneCheckBox.isSelected()) {
            this.allInOneSaveField.setEditable(true);
        } else {
            this.allInOneSaveField.setEditable(false);
        }
        if (this.lengthRecordCheckBox.isSelected()) {
            this.lengthRecordHourField.setEditable(true);
            this.lengthRecordMinuteField.setEditable(true);
            this.lengthRecordSecondField.setEditable(true);
        } else {
            this.lengthRecordHourField.setEditable(false);
            this.lengthRecordMinuteField.setEditable(false);
            this.lengthRecordSecondField.setEditable(false);
        }
        if (this.maxSizeMBCheckBox.isSelected()) {
            this.maxSizeMBField.setEditable(true);
        } else {
            this.maxSizeMBField.setEditable(false);
        }
        if (this.useragentCheckBox.isSelected()) {
            this.useragentField.setEditable(true);
        } else {
            this.useragentField.setEditable(false);
        }
        if (this.runIndexCheckBox.isSelected()) {
            this.runIndexField.setEditable(true);
        } else {
            this.runIndexField.setEditable(false);
        }
        if (this.relayServerCheckBox.isSelected()) {
            if (!this.createNewStream) {
                this.realyPortField.setEditable(true);
            }
            this.realyConnectionsLabel.setEnabled(true);
            this.realyConnectionsField.setEditable(true);
            this.relayConnect.setEnabled(true);
            this.createRelayFileCB.setEnabled(true);
        } else {
            this.realyPortField.setEditable(false);
            this.realyConnectionsLabel.setEnabled(false);
            this.realyConnectionsField.setEditable(false);
            this.relayConnect.setEnabled(false);
            this.createRelayFileCB.setEnabled(false);
        }
        if (this.createRelayFileCB.isSelected()) {
            this.createRelayFileTF.setEditable(true);
        } else {
            this.createRelayFileTF.setEditable(false);
        }
        if (this.patternCheckBox.isSelected()) {
            this.patternField.setEditable(true);
        } else {
            this.patternField.setEditable(false);
        }
        if (this.proxyCheckBox.isSelected()) {
            this.proxyField.setEditable(true);
        } else {
            this.proxyField.setEditable(false);
        }
        if (this.skipTracksCheckBox.isSelected()) {
            this.skipTracksField.setEditable(true);
        } else {
            this.skipTracksField.setEditable(false);
        }
        if (this.timeoutReconnectCheckBox.isSelected()) {
            this.timeoutReconnectField.setEditable(true);
        } else {
            this.timeoutReconnectField.setEditable(false);
        }
    }

    public void save() {
        if ((this.streamNameTF.getText().trim().equals("") || this.streamURLTF.getText().trim().equals("")) && !this.defaultStream) {
            this.dontExit = true;
            JOptionPane.showMessageDialog(this.getMe(), this.trans.getString("noNameOrUrl"));
        } else {
            this.dontExit = false;
            this.stream.singleFileCB = this.allInOneCheckBox.isSelected();
            this.stream.maxTimeCB = this.lengthRecordCheckBox.isSelected();
            this.stream.maxMBCB = this.maxSizeMBCheckBox.isSelected();
            this.stream.sequenzCB = this.runIndexCheckBox.isSelected();
            this.stream.patternCB = this.patternCheckBox.isSelected();
            this.stream.completeCB = this.overWriteVersionCheckBox.isSelected() ? (short)0 : (this.overWriteAllCheckBox.isSelected() ? (short)1 : (this.overWriteNeverCheckBox.isSelected() ? (short)2 : (short)3));
            this.stream.cutSongIncompleteCB = this.truncateCheckBox.isSelected();
            this.stream.neverOverIncompCB = this.dontOverCheckBox.isSelected();
            this.stream.noDirEveryStreamCB = this.noDirForStreamCheckBox.isSelected();
            this.stream.noIndiviSongsCB = this.dCreateInvTracksCheckBox.isSelected();
            this.stream.createReayCB = this.relayServerCheckBox.isSelected();
            this.stream.connectToRelayCB = this.relayConnect.isSelected();
            this.stream.createPlaylistRelayCB = this.createRelayFileCB.isSelected();
            this.stream.dontSearchAltPortCB = this.dontScanPortCheckBox.isSelected();
            this.stream.dontAutoReconnectCB = this.dontReconnectCheckBox.isSelected();
            this.stream.timeoutReconnectCB = this.timeoutReconnectCheckBox.isSelected();
            this.stream.proxyCB = this.proxyCheckBox.isSelected();
            this.stream.useragentCB = this.useragentCheckBox.isSelected();
            this.stream.countBeforStartCB = this.skipTracksCheckBox.isSelected();
            this.stream.metaDataCB = this.metaDataRuleFileCB.isSelected();
            this.stream.interfaceCB = this.interfaceCB.isSelected();
            this.stream.externMetaDataCB = this.externalCmdMetaDataCB.isSelected();
            this.stream.extraArgsCB = this.freeArgumentCB.isSelected();
            this.stream.CSRelayCB = this.codesetRelayCB.isSelected();
            this.stream.CSMetaCB = this.codesetMetadataCB.isSelected();
            this.stream.CSIDTagCB = this.codesetID3CB.isSelected();
            this.stream.CSFileSysCB = this.codesetFilesysCB.isSelected();
            this.stream.XS2CB = this.xs2CB.isSelected();
            this.stream.SPDelayCB = this.xsOffsetCB.isSelected();
            this.stream.SPExtraCB = this.xsPaddingCB.isSelected();
            this.stream.SPWindowCB = this.xsSearchCB.isSelected();
            this.stream.SPSilenceCB = this.xsSilenceCB.isSelected();
            this.stream.IDV1CB = this.id3tagV1CB.isSelected();
            this.stream.IDV2CB = this.id3tagV2CB.isSelected();
            this.stream.name = this.streamNameTF.getText();
            this.stream.address = this.streamURLTF.getText();
            this.stream.comment = this.streamCommentTF.getText();
            this.stream.website = this.streamWebsiteTF.getText();
            this.stream.genre = this.streamGenreTF.getText();
            this.stream.singleFileTF = this.allInOneSaveField.getText();
            this.stream.maxTimeHHTF = this.lengthRecordHourField.getText();
            this.stream.maxTimeMMTF = this.lengthRecordMinuteField.getText();
            this.stream.maxTimessTF = this.lengthRecordSecondField.getText();
            this.stream.maxMBTF = this.maxSizeMBField.getText();
            this.stream.sequenzTF = this.runIndexField.getText();
            this.stream.patternTF = this.patternField.getText();
            this.stream.relayServerPortTF = this.realyPortField.getText();
            this.stream.maxConnectRelayTF = this.realyConnectionsField.getText();
            this.stream.relayPlayListTF = this.createRelayFileTF.getText();
            this.stream.timeOutReonTF = this.timeoutReconnectField.getText();
            this.stream.proxyTF = this.proxyField.getText();
            this.stream.useragentTF = this.useragentField.getText();
            this.stream.sciptSongsTF = this.skipTracksField.getText();
            this.stream.metaDataFileTF = this.metaDataRuleFileTF.getText();
            this.stream.interfaceTF = this.interfaceTF.getText();
            this.stream.externTF = this.externalCmdMetaDataTF.getText();
            this.stream.extraArgsTF = this.freeArgumentTF.getText();
            this.stream.CSRelayTF = this.codesetRelayTF.getText();
            this.stream.CSMetaDataTF = this.codesetMetadataTF.getText();
            this.stream.CSIDTF = this.codesetID3TF.getText();
            this.stream.CSFileSysTF = this.codesetFilesysTF.getText();
            this.stream.SPDelayTF = this.xsOffsetTF.getText();
            this.stream.SPExtraTF1 = this.xsPadding1TF.getText();
            this.stream.SPExtraTF2 = this.xsPadding2TF.getText();
            this.stream.SPWindowTF1 = this.xsSearch1TF.getText();
            this.stream.SPWindowTF2 = this.xsSearch2TF.getText();
            this.stream.SPSilenceTF = this.xsSilenceTF.getText();
            if (this.defaultStream) {
                this.mainGui.getControlStream().setDefaultStream(this.stream);
                this.mainGui.getControlStream().saveDefaultStream();
            } else if (this.createNewStream) {
                this.mainGui.getControlStream().addStreamToVector(this.stream);
                this.mainGui.getTabel().addLastStreamFromVector();
                this.mainGui.getControlStream().saveStreamVector();
            } else {
                this.mainGui.getTabel().setNameValueWithConvert(this.streamNameTF.getText(), this.mainGui.getControlStream().getPlaceInStreamVector(this.stream.id));
                this.mainGui.getTabel().setGenreValueWithConvert(this.streamGenreTF.getText(), this.mainGui.getControlStream().getPlaceInStreamVector(this.stream.id));
            }
        }
    }

    public void load() {
        this.allInOneCheckBox.setSelected(this.stream.singleFileCB);
        this.lengthRecordCheckBox.setSelected(this.stream.maxTimeCB);
        this.maxSizeMBCheckBox.setSelected(this.stream.maxMBCB);
        this.runIndexCheckBox.setSelected(this.stream.sequenzCB);
        this.patternCheckBox.setSelected(this.stream.patternCB);
        if (this.stream.completeCB == 0) {
            this.overWriteVersionCheckBox.setSelected(true);
        } else if (this.stream.completeCB == 1) {
            this.overWriteAllCheckBox.setSelected(true);
        } else if (this.stream.completeCB == 2) {
            this.overWriteNeverCheckBox.setSelected(true);
        } else {
            this.overWriteLargerCheckBox.setSelected(true);
        }
        this.truncateCheckBox.setSelected(this.stream.cutSongIncompleteCB);
        this.dontOverCheckBox.setSelected(this.stream.neverOverIncompCB);
        this.noDirForStreamCheckBox.setSelected(this.stream.noDirEveryStreamCB);
        this.dCreateInvTracksCheckBox.setSelected(this.stream.noIndiviSongsCB);
        this.relayServerCheckBox.setSelected(this.stream.createReayCB);
        this.relayConnect.setSelected(this.stream.connectToRelayCB);
        this.createRelayFileCB.setSelected(this.stream.createPlaylistRelayCB);
        this.dontScanPortCheckBox.setSelected(this.stream.dontSearchAltPortCB);
        this.dontReconnectCheckBox.setSelected(this.stream.dontAutoReconnectCB);
        this.timeoutReconnectCheckBox.setSelected(this.stream.timeoutReconnectCB);
        this.proxyCheckBox.setSelected(this.stream.proxyCB);
        this.useragentCheckBox.setSelected(this.stream.useragentCB);
        this.skipTracksCheckBox.setSelected(this.stream.countBeforStartCB);
        this.metaDataRuleFileCB.setSelected(this.stream.metaDataCB);
        this.interfaceCB.setSelected(this.stream.interfaceCB);
        this.externalCmdMetaDataCB.setSelected(this.stream.externMetaDataCB);
        this.freeArgumentCB.setSelected(this.stream.extraArgsCB);
        this.codesetRelayCB.setSelected(this.stream.CSRelayCB);
        this.codesetMetadataCB.setSelected(this.stream.CSMetaCB);
        this.codesetID3CB.setSelected(this.stream.CSIDTagCB);
        this.codesetFilesysCB.setSelected(this.stream.CSFileSysCB);
        this.xs2CB.setSelected(this.stream.XS2CB);
        this.xsOffsetCB.setSelected(this.stream.SPDelayCB);
        this.xsPaddingCB.setSelected(this.stream.SPExtraCB);
        this.xsSearchCB.setSelected(this.stream.SPWindowCB);
        this.xsSilenceCB.setSelected(this.stream.SPSilenceCB);
        this.id3tagV1CB.setSelected(this.stream.IDV1CB);
        this.id3tagV2CB.setSelected(this.stream.IDV2CB);
        this.streamNameTF.setText(this.stream.name);
        this.streamURLTF.setText(this.stream.address);
        this.streamCommentTF.setText(this.stream.comment);
        this.streamWebsiteTF.setText(this.stream.website);
        this.streamGenreTF.setText(this.stream.genre);
        this.allInOneSaveField.setText(this.stream.singleFileTF);
        this.lengthRecordHourField.setText(this.stream.maxTimeHHTF);
        this.lengthRecordMinuteField.setText(this.stream.maxTimeMMTF);
        this.lengthRecordSecondField.setText(this.stream.maxTimessTF);
        this.maxSizeMBField.setText(this.stream.maxMBTF);
        this.runIndexField.setText(this.stream.sequenzTF);
        this.patternField.setText(this.stream.patternTF);
        if (!this.createNewStream) {
            this.realyPortField.setText(this.stream.relayServerPortTF);
        }
        this.realyConnectionsField.setText(this.stream.maxConnectRelayTF);
        this.createRelayFileTF.setText(this.stream.relayPlayListTF);
        this.timeoutReconnectField.setText(this.stream.timeOutReonTF);
        this.proxyField.setText(this.stream.proxyTF);
        this.useragentField.setText(this.stream.useragentTF);
        this.skipTracksField.setText(this.stream.sciptSongsTF);
        this.metaDataRuleFileTF.setText(this.stream.metaDataFileTF);
        this.interfaceTF.setText(this.stream.interfaceTF);
        this.externalCmdMetaDataTF.setText(this.stream.externTF);
        this.freeArgumentTF.setText(this.stream.extraArgsTF);
        this.codesetRelayTF.setText(this.stream.CSRelayTF);
        this.codesetMetadataTF.setText(this.stream.CSMetaDataTF);
        this.codesetID3TF.setText(this.stream.CSIDTF);
        this.codesetFilesysTF.setText(this.stream.CSFileSysTF);
        this.xsOffsetTF.setText(this.stream.SPDelayTF);
        this.xsPadding1TF.setText(this.stream.SPExtraTF1);
        this.xsPadding2TF.setText(this.stream.SPExtraTF2);
        this.xsSearch1TF.setText(this.stream.SPWindowTF1);
        this.xsSearch2TF.setText(this.stream.SPWindowTF2);
        this.xsSilenceTF.setText(this.stream.SPSilenceTF);
    }

    public Gui_StreamOptions getMe() {
        return this;
    }

    public Stream getStream() {
        return this.stream;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public class ExitListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.dispose();
        }
    }

    public class ExternProgramMetaListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.dirChooser.setFileSelectionMode(0);
            int i = Gui_StreamOptions.this.dirChooser.showOpenDialog(Gui_StreamOptions.this.getMe());
            if (i == 0) {
                Gui_StreamOptions.this.externalCmdMetaDataTF.setText(Gui_StreamOptions.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    private class FreeArgumentsListener
    implements ActionListener {
        private FreeArgumentsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamOptions.this.freeArgumentCB.isSelected()) {
                JOptionPane.showMessageDialog(Gui_StreamOptions.this.getMe(), "<html>" + Gui_StreamOptions.this.toolTips.getString("freeArgumentATT"));
            }
            Gui_StreamOptions.this.repaintCodesetAndSplitpointPanel();
        }
    }

    public class MetaFileChooserListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.dirChooser.setFileSelectionMode(0);
            int i = Gui_StreamOptions.this.dirChooser.showOpenDialog(Gui_StreamOptions.this.getMe());
            if (i == 0) {
                Gui_StreamOptions.this.metaDataRuleFileTF.setText(Gui_StreamOptions.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    public class RemotePlayListListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.dirChooser.setFileSelectionMode(0);
            int i = Gui_StreamOptions.this.dirChooser.showOpenDialog(Gui_StreamOptions.this.getMe());
            if (i == 0) {
                Gui_StreamOptions.this.createRelayFileTF.setText(Gui_StreamOptions.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    private class RepaintCodesetAndSplitPointListener
    implements ActionListener {
        private RepaintCodesetAndSplitPointListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.repaintCodesetAndSplitpointPanel();
        }
    }

    private class RepaintMainListener
    implements ActionListener {
        private RepaintMainListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.repaintMainGui();
        }
    }

    public class SaveAndExitListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.save();
            if (!Gui_StreamOptions.this.dontExit) {
                Gui_StreamOptions.this.mainGui.getControlStream().saveStreamVector();
                Gui_StreamOptions.this.dispose();
            }
        }
    }

    public class SaveListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamOptions.this.save();
            Gui_StreamOptions.this.createNewStream = false;
            if (!Gui_StreamOptions.this.dontExit) {
                Gui_StreamOptions.this.mainGui.getControlStream().saveStreamVector();
            }
        }
    }
}

