/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_GetPath;
import control.Control_http_Shoutcast_3;
import control.SRSOutput;
import control.Shoutcast2;
import gui.Gui_Filter;
import gui.Gui_JTTable;
import gui.Gui_StreamOptions;
import gui.Gui_StreamRipStar;
import gui.VolumeControlGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import misc.Stream;
import thread.Thread_GetStreams_FromShoutcast;

public class Gui_StreamBrowser2
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle toolTips = ResourceBundle.getBundle("translations.ToolTips");
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Boolean isOpen = false;
    private Control_http_Shoutcast_3 controlHttp = new Control_http_Shoutcast_3();
    private Object[] browseHeader = new Object[]{"ID", "Name", "Playing Now", "Genres", "Listeners", "Bitrate", "Type", "Website"};
    private String[][] allData = new String[0][];
    private DefaultTableModel browseModel = new DefaultTableModel(this.allData, this.browseHeader){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return Integer.class;
                }
            }
            return String.class;
        }
    };
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Shoutcast");
    private DefaultTreeCellRenderer renderer;
    private DefaultTreeModel treeModel;
    private JTree browseTree = new JTree();
    private JPanel mainPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private JPanel iconPanel = new JPanel();
    private Gui_JTTable browseTable = new Gui_JTTable(this.browseModel);
    private JScrollPane browsePane = new JScrollPane(this.browseTable);
    private JScrollPane genrePane = new JScrollPane(this.browseTree);
    private JSplitPane splitView = new JSplitPane(1, this.genrePane, this.browsePane);
    private JToolBar commonIconBar = new JToolBar();
    private ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/save.png"));
    private ImageIcon hearMusicIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/player_start.png"));
    private ImageIcon stopHearMusicIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/player_stop.png"));
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/cancel.png"));
    private ImageIcon addAndRecordIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/save_quick2.png"));
    private ImageIcon filterIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/filter.png"));
    private ImageIcon startRecordIcon = new ImageIcon(this.getClass().getResource("/Icons/record_small.png"));
    private ImageIcon hearMusicIconForPopUp = new ImageIcon(this.getClass().getResource("/Icons/player_small.png"));
    private ImageIcon saveIconForPopUp = new ImageIcon(this.getClass().getResource("/Icons/save_small.png"));
    private ImageIcon leafIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/leaf-24.png"));
    private ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/root.png"));
    private ImageIcon nextPageIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/nextPage.png"));
    private ImageIcon previousIcon = new ImageIcon(this.getClass().getResource("/Icons/streambrowser/previousPage.png"));
    private JButton addToStreamRipStarButton = new JButton("Add to StreamRipStar", this.saveIcon);
    private JButton listenToButton = new JButton("Hear it", this.hearMusicIcon);
    private JButton stopListeningToButton = new JButton("Stop playing", this.stopHearMusicIcon);
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JButton addAndRecButton = new JButton("Add and Record", this.addAndRecordIcon);
    private JButton filterButton = new JButton("Filter", this.filterIcon);
    private JButton nextPageButton = new JButton("Next Page", this.nextPageIcon);
    private JButton lastPageButton = new JButton("Previous Page", this.previousIcon);
    private JLabel pagesLabel = new JLabel("Page 0");
    private boolean lastSearchWasASearch = false;
    private JLabel stautsLabel = new JLabel("");
    private JPopupMenu selShowPopup = new JPopupMenu();
    private JPopupMenu tablePopup = new JPopupMenu();
    private JCheckBoxMenuItem showDescriptionColumn = new JCheckBoxMenuItem("Show Description Column");
    private JCheckBoxMenuItem showPlayNowColumn = new JCheckBoxMenuItem("Show Now Playing Column");
    private JCheckBoxMenuItem showListenersColumn = new JCheckBoxMenuItem("Show Listener Column");
    private JCheckBoxMenuItem showBitrateColumn = new JCheckBoxMenuItem("Show Bitrate Column");
    private JCheckBoxMenuItem showTypeColumn = new JCheckBoxMenuItem("Show Type Column");
    private JCheckBoxMenuItem showWebsiteColumn = new JCheckBoxMenuItem("Show Website Column");
    private JCheckBoxMenuItem showGenreColumn = new JCheckBoxMenuItem("Show Genre Column");
    private JMenuItem startRecordMenuItem = new JMenuItem("Start Recording (Save And Start)", this.startRecordIcon);
    private JMenuItem saveMenuItem = new JCheckBoxMenuItem("Save Stream", this.saveIconForPopUp);
    private JMenuItem hearMenuItem = new JMenuItem("Hear Stream In Media Player", this.hearMusicIconForPopUp);
    private boolean[] isColumnShow = new boolean[8];
    private VolumeControlGUI audioSlider;
    private Thread_GetStreams_FromShoutcast getStreams = null;
    private int[] columnWidths = new int[8];
    private Gui_StreamRipStar StreamRipStar = null;
    private Gui_Filter filter = new Gui_Filter(this, false);
    private int high = 530;
    private int width = 620;
    private int dividerLocation = 60;
    private boolean disableClick = false;
    private String selectedGenre = "";

    public Gui_StreamBrowser2(Gui_StreamRipStar StreamRipStar2) {
        super("StreamBrowser");
        this.StreamRipStar = StreamRipStar2;
        this.audioSlider = new VolumeControlGUI(StreamRipStar2.getVolumeManager());
        this.renderer = new DefaultTreeCellRenderer();
        this.renderer.setOpenIcon(this.openIcon);
        this.renderer.setClosedIcon(this.openIcon);
        this.renderer.setLeafIcon(this.leafIcon);
        this.browseTree.setCellRenderer(this.renderer);
        this.treeModel = new DefaultTreeModel(this.root);
        this.browseTree.setModel(this.treeModel);
        int i = 0;
        while (i < this.isColumnShow.length) {
            this.isColumnShow[i] = true;
            ++i;
        }
        i = 0;
        while (i < this.columnWidths.length) {
            this.columnWidths[i] = 70;
            ++i;
        }
        this.load();
        this.filter.updateGuis();
        this.setLanguage();
        this.showTextUnderIcons(StreamRipStar2.showTextUnderIcons(), StreamRipStar2.getFontForTextUnderIcons());
        this.sortColumns();
        this.createGui();
        this.setAllColumnWidths();
        this.createBrowseTree();
        this.setToolTips();
    }

    public void setToolTips() {
        this.listenToButton.setToolTipText(this.toolTips.getString("StreamBrowser.listen"));
        this.stopListeningToButton.setToolTipText(this.toolTips.getString("StreamBrowser.stopListening"));
        this.audioSlider.setToolTipText(this.toolTips.getString("StreamBrowser.audioSlider"));
        this.addToStreamRipStarButton.setToolTipText(this.toolTips.getString("StreamBrowser.addToStreamRipStar"));
        this.addAndRecButton.setToolTipText(this.toolTips.getString("StreamBrowser.addAndRecord"));
        this.abortButton.setToolTipText(this.toolTips.getString("StreamBrowser.abort"));
        this.filterButton.setToolTipText(this.toolTips.getString("StreamBrowser.filter"));
        this.lastPageButton.setToolTipText(this.toolTips.getString("StreamBrowser.lastPage"));
        this.nextPageButton.setToolTipText(this.toolTips.getString("StreamBrowser.nextPage"));
    }

    public void showTextUnderIcons(Boolean visibility, Font newFont) {
        if (visibility.booleanValue()) {
            this.listenToButton.setText(this.trans.getString("iconPanel.listenToButton"));
            this.stopListeningToButton.setText(this.trans.getString("iconPanel.stopListeningToButton"));
            this.addToStreamRipStarButton.setText(this.trans.getString("iconPanel.addToStreamRipStarButton"));
            this.addAndRecButton.setText(this.trans.getString("iconPanel.addAndRecButton"));
            this.abortButton.setText(this.trans.getString("iconPanel.abortButton"));
            this.filterButton.setText(this.trans.getString("iconPanel.filterButton"));
            this.lastPageButton.setText(this.trans.getString("iconPanel.lastPage"));
            this.nextPageButton.setText(this.trans.getString("iconPanel.nextPage"));
            if (newFont != null) {
                this.listenToButton.setFont(newFont);
                this.stopListeningToButton.setFont(newFont);
                this.addToStreamRipStarButton.setFont(newFont);
                this.addAndRecButton.setFont(newFont);
                this.abortButton.setFont(newFont);
                this.filterButton.setFont(newFont);
                this.lastPageButton.setFont(newFont);
                this.nextPageButton.setFont(newFont);
            }
        } else {
            this.listenToButton.setText(null);
            this.stopListeningToButton.setText(null);
            this.addToStreamRipStarButton.setText(null);
            this.addAndRecButton.setText(null);
            this.abortButton.setText(null);
            this.filterButton.setText(null);
            this.lastPageButton.setText(null);
            this.nextPageButton.setText(null);
        }
    }

    public void createGui() {
        this.browseTable.setAutoResizeMode(1);
        this.browseTable.getTableHeader().setReorderingAllowed(false);
        this.browseTable.setAutoCreateRowSorter(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.topPanel.setLayout(new GridBagLayout());
        FlowLayout fLayout = new FlowLayout();
        this.iconPanel.setLayout(fLayout);
        fLayout.setAlignment(0);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.topPanel, "Center");
        this.mainPanel.add((Component)this.iconPanel, "First");
        this.mainPanel.add((Component)this.stautsLabel, "South");
        this.mainPanel.add((Component)this.filter, "East");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.topPanel.add((Component)this.splitView, c);
        this.iconPanel.add(this.commonIconBar);
        this.buildIconBars();
        this.setDefaultCloseOperation(0);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - Integer.valueOf(this.width)) / 2;
        int y = (screenDim.height - Integer.valueOf(this.high)) / 2;
        this.setLocation(x, y);
        this.setSize(new Dimension(this.width, this.high));
        this.setVisible(true);
        this.browseTable.addMouseListener(new BrowseMouseListener());
        this.browseTable.getTableHeader().setComponentPopupMenu(this.selShowPopup);
        this.listenToButton.addActionListener(new PlayMusikListener());
        this.stopListeningToButton.addActionListener(new StopPlayingMusikListener());
        this.addToStreamRipStarButton.addActionListener(new AddToStreamRipStarListener());
        this.abortButton.addActionListener(new AbortThreadsListener());
        this.addAndRecButton.addActionListener(new AddAndStartRecordListener());
        this.filterButton.addActionListener(new FilterListener());
        this.nextPageButton.addActionListener(new NextPageListener());
        this.lastPageButton.addActionListener(new LastPageListener());
        this.addWindowListener(this);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new SearchKeyDispatcher());
        this.splitView.setResizeWeight(0.0);
        this.splitView.setDividerLocation(this.dividerLocation);
        this.browseTree.addMouseListener(new TreeListener());
        this.setAbortButtonEnable(false);
        this.updatePageBar();
    }

    private void setLanguage() {
        try {
            this.listenToButton.setText(this.trans.getString("iconPanel.listenToButton"));
            this.stopListeningToButton.setText(this.trans.getString("iconPanel.stopListeningToButton"));
            this.addToStreamRipStarButton.setText(this.trans.getString("iconPanel.addToStreamRipStarButton"));
            this.addAndRecButton.setText(this.trans.getString("iconPanel.addAndRecButton"));
            this.abortButton.setText(this.trans.getString("iconPanel.abortButton"));
            this.filterButton.setText(this.trans.getString("iconPanel.filterButton"));
            this.nextPageButton.setText(this.trans.getString("iconPanel.nextPage"));
            this.lastPageButton.setText(this.trans.getString("iconPanel.lastPage"));
            this.pagesLabel.setText(String.valueOf(this.trans.getString("iconPanel.page")) + " 0 " + this.trans.getString("iconPanel.of") + " 0");
            this.showDescriptionColumn.setText(this.trans.getString("ColumControl.showDescriptionColumn"));
            this.showPlayNowColumn.setText(this.trans.getString("ColumControl.showPlayNowColumn"));
            this.showListenersColumn.setText(this.trans.getString("ColumControl.showListenersColumn"));
            this.showBitrateColumn.setText(this.trans.getString("ColumControl.showBitrateColumn"));
            this.showTypeColumn.setText(this.trans.getString("ColumControl.showTypeColumn"));
            this.showGenreColumn.setText(this.trans.getString("ColumControl.showGenreColumn"));
            this.showWebsiteColumn.setText(this.trans.getString("ColumControl.showWebsitewColumn"));
            this.browseHeader[0] = this.trans.getString("Header.Nr");
            this.browseHeader[1] = this.trans.getString("Header.Description");
            this.browseHeader[2] = this.trans.getString("Header.PlayingNow");
            this.browseHeader[3] = this.trans.getString("Header.Genre");
            this.browseHeader[4] = this.trans.getString("Header.Listeners");
            this.browseHeader[5] = this.trans.getString("Header.Bitrate");
            this.browseHeader[6] = this.trans.getString("Header.Type");
            this.browseHeader[7] = this.trans.getString("Header.Website");
            this.browseModel.setColumnIdentifiers(this.browseHeader);
            this.startRecordMenuItem.setText(this.trans.getString("popup.startRecStreamBrowser"));
            this.saveMenuItem.setText(this.trans.getString("popup.save"));
            this.hearMenuItem.setText(this.trans.getString("popup.hear"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void createBrowseTree() {
        try {
            String[][] genres = new Shoutcast2().getGenres();
            this.root.add(new DefaultMutableTreeNode(this.trans.getObject("GetGenres.search")));
            int i = 0;
            while (i < genres.length) {
                if (genres[i].length > 0) {
                    DefaultMutableTreeNode tmp = new DefaultMutableTreeNode(genres[i][0]);
                    this.root.add(tmp);
                    int j = 1;
                    while (j < genres[i].length) {
                        tmp.add(new DefaultMutableTreeNode(genres[i][j]));
                        ++j;
                    }
                }
                ++i;
            }
            this.updateUITree();
        }
        catch (NullPointerException e) {
            SRSOutput.getInstance().logE("Failed to load genres");
            this.setStatusText("Failed to load genres", false);
        }
    }

    public DefaultMutableTreeNode getTreeRoot() {
        return this.root;
    }

    public JTree getTree() {
        return this.browseTree;
    }

    public Control_http_Shoutcast_3 getControlHttp() {
        return this.controlHttp;
    }

    public void setStatusText(String statusText, boolean isErrorMessage) {
        if (!isErrorMessage) {
            this.stautsLabel.setForeground(Color.BLACK);
        } else {
            this.stautsLabel.setForeground(Color.RED);
        }
        this.stautsLabel.setText(statusText);
    }

    public synchronized void updateUITree() {
        this.browseTree.expandRow(0);
        this.treeModel.reload();
    }

    public DefaultTableModel getBrowseModel() {
        return this.browseModel;
    }

    public JTable getBrowseTable() {
        return this.browseTable;
    }

    public void disableModelClick(boolean click) {
        this.disableClick = click;
    }

    public void setAbortButtonEnable(boolean enable) {
        this.abortButton.setEnabled(enable);
        this.nextPageButton.setEnabled(!enable);
        this.lastPageButton.setEnabled(!enable);
    }

    public void buildIconBars() {
        this.listenToButton.setHorizontalTextPosition(0);
        this.listenToButton.setVerticalTextPosition(3);
        this.listenToButton.setBorderPainted(false);
        this.stopListeningToButton.setHorizontalTextPosition(0);
        this.stopListeningToButton.setVerticalTextPosition(3);
        this.stopListeningToButton.setBorderPainted(false);
        this.addToStreamRipStarButton.setHorizontalTextPosition(0);
        this.addToStreamRipStarButton.setVerticalTextPosition(3);
        this.addToStreamRipStarButton.setBorderPainted(false);
        this.addAndRecButton.setHorizontalTextPosition(0);
        this.addAndRecButton.setVerticalTextPosition(3);
        this.addAndRecButton.setBorderPainted(false);
        this.abortButton.setHorizontalTextPosition(0);
        this.abortButton.setVerticalTextPosition(3);
        this.abortButton.setBorderPainted(false);
        this.filterButton.setHorizontalTextPosition(0);
        this.filterButton.setVerticalTextPosition(3);
        this.filterButton.setBorderPainted(false);
        this.nextPageButton.setHorizontalTextPosition(0);
        this.nextPageButton.setVerticalTextPosition(3);
        this.nextPageButton.setBorderPainted(false);
        this.lastPageButton.setHorizontalTextPosition(0);
        this.lastPageButton.setVerticalTextPosition(3);
        this.lastPageButton.setBorderPainted(false);
        this.commonIconBar.add(this.addToStreamRipStarButton);
        this.commonIconBar.add(this.addAndRecButton);
        this.commonIconBar.addSeparator();
        this.commonIconBar.add(this.listenToButton);
        this.commonIconBar.add(this.stopListeningToButton);
        this.commonIconBar.add(this.audioSlider);
        this.commonIconBar.addSeparator();
        this.commonIconBar.add(this.abortButton);
        this.commonIconBar.add(this.filterButton);
        this.commonIconBar.addSeparator();
        this.commonIconBar.add(this.lastPageButton);
        this.commonIconBar.add(this.nextPageButton);
        this.commonIconBar.add(this.pagesLabel);
        this.commonIconBar.addSeparator();
        this.commonIconBar.setBackground(new Color(238, 238, 238, 255));
        this.selShowPopup.add(this.showDescriptionColumn);
        this.selShowPopup.add(this.showPlayNowColumn);
        this.selShowPopup.add(this.showGenreColumn);
        this.selShowPopup.add(this.showListenersColumn);
        this.selShowPopup.add(this.showBitrateColumn);
        this.selShowPopup.add(this.showTypeColumn);
        this.selShowPopup.add(this.showWebsiteColumn);
        this.tablePopup.add(this.startRecordMenuItem);
        this.tablePopup.add(this.saveMenuItem);
        this.tablePopup.add(this.hearMenuItem);
        this.showDescriptionColumn.addActionListener(new ShowRightColumnOrder(1));
        this.showPlayNowColumn.addActionListener(new ShowRightColumnOrder(2));
        this.showGenreColumn.addActionListener(new ShowRightColumnOrder(3));
        this.showListenersColumn.addActionListener(new ShowRightColumnOrder(4));
        this.showBitrateColumn.addActionListener(new ShowRightColumnOrder(5));
        this.showTypeColumn.addActionListener(new ShowRightColumnOrder(6));
        this.showWebsiteColumn.addActionListener(new ShowRightColumnOrder(7));
        this.startRecordMenuItem.addActionListener(new AddAndStartRecordListener());
        this.saveMenuItem.addActionListener(new AddToStreamRipStarListener());
        this.hearMenuItem.addActionListener(new PlayMusikListener());
        this.showDescriptionColumn.setSelected(this.isColumnShow[1]);
        this.showPlayNowColumn.setSelected(this.isColumnShow[2]);
        this.showGenreColumn.setSelected(this.isColumnShow[3]);
        this.showListenersColumn.setSelected(this.isColumnShow[4]);
        this.showBitrateColumn.setSelected(this.isColumnShow[5]);
        this.showTypeColumn.setSelected(this.isColumnShow[6]);
        this.showWebsiteColumn.setSelected(this.isColumnShow[7]);
    }

    public synchronized void removeAllFromTable(DefaultTableModel model) {
        int rowCount;
        int i = rowCount = model.getRowCount();
        while (i > 0) {
            model.removeRow(i - 1);
            --i;
        }
    }

    public Gui_StreamBrowser2 getMe() {
        return this;
    }

    public String[] getStreamInfo() {
        String[] address = new String[4];
        if (this.browseTable.getSelectedRow() >= 0) {
            Vector<String[]> streams = null;
            Object content = this.browseTable.getValueAt(this.browseTable.getSelectedRow(), 0);
            int nr = Integer.valueOf(content.toString());
            if (this.filter.isFiltered()) {
                streams = this.filter.getFilteredStreamVector();
                SRSOutput.getInstance().log("Use Filtered StreamVector");
            } else {
                streams = this.controlHttp.getStreams();
                SRSOutput.getInstance().log("Use Normal StreamVector");
            }
            if (streams != null) {
                String url = streams.get(nr)[5];
                address[0] = this.controlHttp.getfirstStreamFromURL(url);
                address[1] = streams.get(nr)[0];
                address[2] = streams.get(nr)[6];
                address[3] = streams.get(nr)[7];
            } else {
                SRSOutput.getInstance().logE("Gets an empty FILTERED stream vector: can't get info");
            }
        }
        return address;
    }

    public void playStream() {
        if (this.browseTable.getSelectedRow() >= 0) {
            String url = this.getStreamInfo()[0];
            String name = this.getStreamInfo()[1];
            if (url == null || url.equals("")) {
                JOptionPane.showMessageDialog(this.getMe(), this.trans.getString("Message.emptyString"));
                SRSOutput.getInstance().logE(this.trans.getString("Message.emptyString"));
            } else {
                this.StreamRipStar.getTabel().startMusicPlayerWithUrl(url, name);
                SRSOutput.getInstance().log(url);
            }
        } else {
            JOptionPane.showMessageDialog(this.getMe(), this.trans.getString("select"));
        }
    }

    public void save() {
        String savePath = new Control_GetPath().getStreamRipStarPath();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        int[] intOptions = new int[12];
        String[] strOptions = new String[7];
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(new FileOutputStream(String.valueOf(savePath) + "/Streambrowser.xml"));
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            int i = 0;
            while (i < this.isColumnShow.length) {
                intOptions[i + 3] = this.isColumnShow[i] ? this.browseTable.getColumn(this.browseHeader[i]).getWidth() : 30;
                ++i;
            }
            String[] x = this.filter.getSaveSettings();
            int i2 = 0;
            while (i2 < x.length) {
                strOptions[i2] = x[i2];
                ++i2;
            }
            StartDocument header = eventFactory.createStartDocument();
            StartElement startRootSettings = eventFactory.createStartElement("", "", "Settings");
            Attribute height = eventFactory.createAttribute("height", String.valueOf(this.getSize().height));
            Attribute width = eventFactory.createAttribute("width", String.valueOf(this.getSize().width));
            Attribute divLocation = eventFactory.createAttribute("divLocation", String.valueOf(this.splitView.getDividerLocation()));
            Attribute i0 = eventFactory.createAttribute("i0", String.valueOf(intOptions[0]));
            Attribute i1 = eventFactory.createAttribute("i1", String.valueOf(intOptions[1]));
            Attribute i22 = eventFactory.createAttribute("i2", String.valueOf(intOptions[2]));
            Attribute i3 = eventFactory.createAttribute("i3", String.valueOf(intOptions[3]));
            Attribute i4 = eventFactory.createAttribute("i4", String.valueOf(intOptions[4]));
            Attribute i5 = eventFactory.createAttribute("i5", String.valueOf(intOptions[5]));
            Attribute i6 = eventFactory.createAttribute("i6", String.valueOf(intOptions[6]));
            Attribute i7 = eventFactory.createAttribute("i7", String.valueOf(intOptions[7]));
            Attribute i8 = eventFactory.createAttribute("i8", String.valueOf(intOptions[8]));
            Attribute i9 = eventFactory.createAttribute("i9", String.valueOf(intOptions[9]));
            Attribute i10 = eventFactory.createAttribute("i10", String.valueOf(intOptions[10]));
            Attribute i11 = eventFactory.createAttribute("i11", String.valueOf(intOptions[11]));
            Attribute s0 = eventFactory.createAttribute("s0", String.valueOf(strOptions[0]));
            Attribute s1 = eventFactory.createAttribute("s1", String.valueOf(strOptions[1]));
            Attribute s2 = eventFactory.createAttribute("s2", String.valueOf(strOptions[2]));
            Attribute s3 = eventFactory.createAttribute("s3", String.valueOf(strOptions[3]));
            Attribute s4 = eventFactory.createAttribute("s4", String.valueOf(strOptions[4]));
            Attribute s5 = eventFactory.createAttribute("s5", String.valueOf(strOptions[5]));
            Attribute s6 = eventFactory.createAttribute("s6", String.valueOf(strOptions[6]));
            Attribute b0 = eventFactory.createAttribute("b0", String.valueOf(this.isColumnShow[0]));
            Attribute b1 = eventFactory.createAttribute("b1", String.valueOf(this.isColumnShow[1]));
            Attribute b2 = eventFactory.createAttribute("b2", String.valueOf(this.isColumnShow[2]));
            Attribute b3 = eventFactory.createAttribute("b3", String.valueOf(this.isColumnShow[3]));
            Attribute b4 = eventFactory.createAttribute("b4", String.valueOf(this.isColumnShow[4]));
            Attribute b5 = eventFactory.createAttribute("b5", String.valueOf(this.isColumnShow[5]));
            Attribute b6 = eventFactory.createAttribute("b6", String.valueOf(this.isColumnShow[6]));
            Attribute b7 = eventFactory.createAttribute("b7", String.valueOf(this.isColumnShow[7]));
            EndElement endRoot = eventFactory.createEndElement("", "", "Settings");
            EndDocument endDocument = eventFactory.createEndDocument();
            writer.add(header);
            writer.add(startRootSettings);
            writer.add(height);
            writer.add(width);
            writer.add(divLocation);
            writer.add(i0);
            writer.add(i1);
            writer.add(i22);
            writer.add(i3);
            writer.add(i4);
            writer.add(i5);
            writer.add(i6);
            writer.add(i7);
            writer.add(i8);
            writer.add(i9);
            writer.add(i10);
            writer.add(i11);
            writer.add(s0);
            writer.add(s1);
            writer.add(s2);
            writer.add(s3);
            writer.add(s4);
            writer.add(s5);
            writer.add(s6);
            writer.add(b0);
            writer.add(b1);
            writer.add(b2);
            writer.add(b3);
            writer.add(b4);
            writer.add(b5);
            writer.add(b6);
            writer.add(b7);
            writer.add(endRoot);
            writer.add(endDocument);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        String[] strOptions = new String[7];
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Streambrowser.xml"));
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Streambrowser.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (!parser.getAttributeLocalName(i).equals("")) {
                                if (parser.getAttributeLocalName(i).equals("height")) {
                                    this.high = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("width")) {
                                    this.width = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("divLocation")) {
                                    this.dividerLocation = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i3")) {
                                    this.columnWidths[0] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i4")) {
                                    this.columnWidths[1] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i5")) {
                                    this.columnWidths[2] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i6")) {
                                    this.columnWidths[3] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i7")) {
                                    this.columnWidths[4] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i8")) {
                                    this.columnWidths[5] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("s0")) {
                                    strOptions[0] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s1")) {
                                    strOptions[1] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s2")) {
                                    strOptions[2] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s3")) {
                                    strOptions[3] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s4")) {
                                    strOptions[4] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s5")) {
                                    strOptions[5] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("s6")) {
                                    strOptions[6] = parser.getAttributeValue(i);
                                } else if (parser.getAttributeLocalName(i).equals("b0")) {
                                    this.isColumnShow[0] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b1")) {
                                    this.isColumnShow[1] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b2")) {
                                    this.isColumnShow[2] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b3")) {
                                    this.isColumnShow[3] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b4")) {
                                    this.isColumnShow[4] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b5")) {
                                    this.isColumnShow[5] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b6")) {
                                    this.isColumnShow[6] = Boolean.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("b7")) {
                                    this.isColumnShow[7] = Boolean.valueOf(parser.getAttributeValue(i));
                                }
                            }
                            ++i;
                        }
                        this.filter.loadSettings(strOptions);
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Streambrowser.xml");
        }
        catch (XMLStreamException e) {
            if (e.getMessage().startsWith("Message: Premature end of file.")) {
                SRSOutput.getInstance().logE("Error: Streambrowser: XML file had an unexpected end");
            }
            SRSOutput.getInstance().logE("Error while reading the streambrowser settings");
        }
    }

    public void setThreadToNull() {
        this.getStreams = null;
    }

    public void sortColumns() {
        int i = this.browseTable.getColumnCount();
        while (i > 0) {
            this.browseTable.removeColumn(this.browseTable.getColumnModel().getColumn(i - 1));
            --i;
        }
        int j = 0;
        while (j < this.isColumnShow.length) {
            if (this.isColumnShow[j]) {
                this.browseTable.addColumn(new TableColumn(j));
            }
            ++j;
        }
        this.setAllColumnWidths();
    }

    /*
     * Unable to fully structure code
     */
    public void setAllColumnWidths() {
        block5: {
            try {
                i = 0;
                while (i < this.columnWidths.length) {
                    if (this.isColumnShow[i]) {
                        this.browseTable.getColumn(this.browseHeader[i]).setPreferredWidth(this.columnWidths[i]);
                    }
                    ++i;
                }
                this.browseTable.getColumn(this.browseHeader[0]).setMaxWidth(50);
                break block5;
            }
            catch (IllegalArgumentException e) {
                i = 0;
                ** while (i < this.columnWidths.length)
            }
lbl-1000:
            // 1 sources

            {
                this.isColumnShow[i] = true;
                ++i;
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveColumnWidth() {
        block5: {
            try {
                i = 0;
                while (i < this.isColumnShow.length) {
                    if (this.isColumnShow[i]) {
                        this.columnWidths[i] = this.browseTable.getColumn(this.browseHeader[i]).getWidth();
                    }
                    ++i;
                }
                break block5;
            }
            catch (IllegalArgumentException e) {
                i = 0;
                ** while (i < this.isColumnShow.length)
            }
lbl-1000:
            // 1 sources

            {
                this.isColumnShow[i] = true;
                this.columnWidths[i] = 50;
                ++i;
                continue;
            }
        }
        this.save();
    }

    public Gui_Filter getFilterGui() {
        return this.filter;
    }

    public void abortLoadingGenresAndStreams() {
        if (this.getStreams != null) {
            this.getStreams.killMe();
            this.getStreams = null;
        }
    }

    public void updatePageBar() {
        this.pagesLabel.setText(String.valueOf(this.trans.getString("iconPanel.page")) + " " + this.controlHttp.getCurrentPage());
        if (this.controlHttp.getCurrentPage() <= 1) {
            this.lastPageButton.setEnabled(false);
        } else {
            this.lastPageButton.setEnabled(true);
        }
        if (this.controlHttp.getCurrentPage() >= this.controlHttp.getTotalPages()) {
            this.nextPageButton.setEnabled(false);
        } else {
            this.nextPageButton.setEnabled(true);
        }
    }

    public VolumeControlGUI getAudioSlider() {
        return this.audioSlider;
    }

    public void showSearchInputField() {
        this.isOpen = true;
        this.selectedGenre = JOptionPane.showInputDialog(this.getMe(), this.trans.getString("Message.search"), this.trans.getString("Message.searchHeader"), -1);
        this.isOpen = false;
        if (this.selectedGenre != null) {
            this.getStreams = new Thread_GetStreams_FromShoutcast(this.getMe(), "", this.selectedGenre, this.trans, false, false);
            this.lastSearchWasASearch = true;
            this.getStreams.start();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.getStreams != null) {
            this.getStreams.killMe();
        }
        this.saveColumnWidth();
        this.save();
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    class AbortThreadsListener
    implements ActionListener {
        AbortThreadsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamBrowser2.this.abortLoadingGenresAndStreams();
        }
    }

    class AddAndStartRecordListener
    implements ActionListener {
        AddAndStartRecordListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamBrowser2.this.browseTable.getSelectedRow() >= 0) {
                String[] content = Gui_StreamBrowser2.this.getStreamInfo();
                if (content[0] == null || content[0].equals("")) {
                    JOptionPane.showMessageDialog(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.trans.getString("Message.emptyString"));
                    SRSOutput.getInstance().logE("Error while fetching streamaddress\n");
                } else {
                    Gui_StreamOptions tmpAddStream = new Gui_StreamOptions(null, Gui_StreamBrowser2.this.StreamRipStar, true, false, false);
                    tmpAddStream.setBasics(content);
                    tmpAddStream.save();
                    Stream tmpStream = tmpAddStream.getStream();
                    if (tmpStream != null) {
                        Gui_StreamBrowser2.this.StreamRipStar.startRippingUnselected(tmpStream);
                        SRSOutput.getInstance().log("Debug: Adding stream from Streambrowserand start recording");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.trans.getString("select"));
            }
        }
    }

    class AddToStreamRipStarListener
    implements ActionListener {
        AddToStreamRipStarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamBrowser2.this.browseTable.getSelectedRow() >= 0) {
                String[] content = Gui_StreamBrowser2.this.getStreamInfo();
                if (content == null || content[0].equals("")) {
                    SRSOutput.getInstance().logE("Error while fetching streamaddress\n");
                } else {
                    Gui_StreamOptions dialog = new Gui_StreamOptions(null, Gui_StreamBrowser2.this.StreamRipStar, true, true, false);
                    dialog.setBasics(content);
                }
            } else {
                JOptionPane.showMessageDialog(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.trans.getString("select"));
            }
        }
    }

    public class BrowseMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && Gui_StreamBrowser2.this.browseModel.getColumnCount() > 0) {
                Gui_StreamBrowser2.this.playStream();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            if (e.getButton() == 3 && (row = Gui_StreamBrowser2.this.browseTable.rowAtPoint(e.getPoint())) >= 0) {
                Gui_StreamBrowser2.this.browseTable.setRowSelectionInterval(row, row);
                Gui_StreamBrowser2.this.tablePopup.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            }
        }
    }

    class FilterListener
    implements ActionListener {
        FilterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamBrowser2.this.filter.isVisible()) {
                Gui_StreamBrowser2.this.filter.setVisible(false);
            } else {
                Gui_StreamBrowser2.this.filter.setVisible(true);
            }
        }
    }

    public class LastPageListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (Gui_StreamBrowser2.this.controlHttp.getCurrentPage() <= 1) {
                SRSOutput.getInstance().log("Can load the previous page, because the current page is the first one");
                Gui_StreamBrowser2.this.setStatusText("Can load the previous page, because the current page is the first one", false);
            } else if (Gui_StreamBrowser2.this.lastSearchWasASearch) {
                Gui_StreamBrowser2.this.getStreams = new Thread_GetStreams_FromShoutcast(Gui_StreamBrowser2.this.getMe(), "", Gui_StreamBrowser2.this.selectedGenre, Gui_StreamBrowser2.this.trans, false, true);
                Gui_StreamBrowser2.this.getStreams.start();
            } else {
                Gui_StreamBrowser2.this.getStreams = new Thread_GetStreams_FromShoutcast(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.selectedGenre, "", Gui_StreamBrowser2.this.trans, false, true);
                Gui_StreamBrowser2.this.getStreams.start();
            }
        }
    }

    public class NextPageListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_StreamBrowser2.this.controlHttp.getCurrentPage() >= Gui_StreamBrowser2.this.controlHttp.getTotalPages()) {
                SRSOutput.getInstance().log("Can load the next page, because the current page is the last one");
                Gui_StreamBrowser2.this.setStatusText("Can load the next page, because the current page is the last one", false);
            } else if (Gui_StreamBrowser2.this.lastSearchWasASearch) {
                Gui_StreamBrowser2.this.getStreams = new Thread_GetStreams_FromShoutcast(Gui_StreamBrowser2.this.getMe(), "", Gui_StreamBrowser2.this.selectedGenre, Gui_StreamBrowser2.this.trans, true, false);
                Gui_StreamBrowser2.this.getStreams.start();
            } else {
                Gui_StreamBrowser2.this.getStreams = new Thread_GetStreams_FromShoutcast(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.selectedGenre, "", Gui_StreamBrowser2.this.trans, true, false);
                Gui_StreamBrowser2.this.getStreams.start();
            }
        }
    }

    class PlayMusikListener
    implements ActionListener {
        PlayMusikListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamBrowser2.this.playStream();
        }
    }

    class ReloadListener
    implements ActionListener {
        ReloadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamBrowser2.this.abortLoadingGenresAndStreams();
            Gui_StreamBrowser2.this.root.removeAllChildren();
            Gui_StreamBrowser2.this.updateUITree();
            Gui_StreamBrowser2.this.createBrowseTree();
        }
    }

    private class SearchKeyDispatcher
    implements KeyEventDispatcher {
        private SearchKeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 83 && e.isControlDown() && !Gui_StreamBrowser2.this.isOpen.booleanValue()) {
                Gui_StreamBrowser2.this.showSearchInputField();
                return true;
            }
            return false;
        }
    }

    public class SearchKeyListener
    extends KeyAdapter {
        public void keyPressesd(KeyEvent e) {
            if (e.getKeyCode() == 83 && e.isControlDown()) {
                Gui_StreamBrowser2.this.showSearchInputField();
            }
        }
    }

    class ShowRightColumnOrder
    implements ActionListener {
        int index = 0;

        public ShowRightColumnOrder(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.changeStatus(this.index);
            Gui_StreamBrowser2.this.sortColumns();
            Gui_StreamBrowser2.this.save();
        }

        public void changeStatus(int index) {
            ((Gui_StreamBrowser2)Gui_StreamBrowser2.this).isColumnShow[index] = !Gui_StreamBrowser2.this.isColumnShow[index];
        }
    }

    class StopPlayingMusikListener
    implements ActionListener {
        StopPlayingMusikListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_StreamBrowser2.this.StreamRipStar.getTabel().stopInternalAudioPlayer();
        }
    }

    public class TreeListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            boolean stop = false;
            if (e.getClickCount() == 2 && !Gui_StreamBrowser2.this.disableClick && Gui_StreamBrowser2.this.browseTree.getSelectionPath() != null) {
                Gui_StreamBrowser2.this.selectedGenre = Gui_StreamBrowser2.this.browseTree.getSelectionPath().getLastPathComponent().toString();
                if (Gui_StreamBrowser2.this.selectedGenre.equals(Gui_StreamBrowser2.this.trans.getObject("GetGenres.search"))) {
                    Gui_StreamBrowser2.this.showSearchInputField();
                } else if (!stop) {
                    Gui_StreamBrowser2.this.getStreams = new Thread_GetStreams_FromShoutcast(Gui_StreamBrowser2.this.getMe(), Gui_StreamBrowser2.this.selectedGenre, "", Gui_StreamBrowser2.this.trans, false, false);
                    Gui_StreamBrowser2.this.getStreams.start();
                    Gui_StreamBrowser2.this.lastSearchWasASearch = false;
                }
            }
        }
    }
}

