/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_GetPath;
import control.Control_TestStartFirst;
import control.SRSOutput;
import gui.Gui_StreamRipStar;
import gui.Gui_searchUpdatePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;

public class Gui_Settings2
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JList<Object> list;
    private ImageIcon commonPrefIcon = new ImageIcon(this.getClass().getResource("/Icons/preferences/LookAndFeel1.png"));
    private ImageIcon pathPrefIcon = new ImageIcon(this.getClass().getResource("/Icons/preferences/AudioAndPrograms1.png"));
    private ImageIcon audioPlayerPrefIcon = new ImageIcon(this.getClass().getResource("/Icons/preferences/Language1.png"));
    private ImageIcon udpatePrefIcon = new ImageIcon(this.getClass().getResource("/Icons/preferences/update.png"));
    private OnlyOneActivePanel mainPanel = new OnlyOneActivePanel();
    private JScrollPane mainSP = new JScrollPane(this.mainPanel);
    private JPanel pathAudioPanel = new JPanel();
    private JPanel pathPanel = new JPanel();
    private JPanel internalaudioPanel = new JPanel();
    private JPanel lookAndFeelPanel = new JPanel();
    private JPanel sysTrayIconPanel = new JPanel();
    private JPanel otherLookAndFeelPanel = new JPanel();
    private JPanel actionPanel = new JPanel();
    private JPanel programStartPanel = new JPanel();
    private JPanel langLogPanel = new JPanel();
    private JPanel languagePanel = new JPanel();
    private JPanel logPanel = new JPanel();
    private JPanel updatePanel = new JPanel();
    private JPanel autoUpdatePanel = new JPanel();
    private JPanel searchUpdatePanel;
    private JPanel buttonPanel = new JPanel();
    private JPanel commonPanel = new JPanel();
    private JTextField ripperPathField = new JTextField("", 30);
    private JTextField shoutcastPlayer = new JTextField("", 30);
    private JTextField generellPathField = new JTextField("", 30);
    private JTextField fileBrowserField = new JTextField("", 30);
    private JTextField webBrowserField = new JTextField("", 30);
    private ImageIcon findIcon = new ImageIcon(this.getClass().getResource("/Icons/open_small.png"));
    private ImageIcon saveAndExitIcon = new ImageIcon(this.getClass().getResource("/Icons/ok_small.png"));
    private ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/Icons/save_small.png"));
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/abort_small.png"));
    private JLabel ripLabel = new JLabel("Path to streamripper: ");
    private JLabel mediaPlayer = new JLabel("Path to mp3 player: ");
    private JLabel generellPathLabel = new JLabel("Generell Save : ");
    private JLabel fileBrowserLabel = new JLabel("Path to filemanager");
    private JLabel webBrowserLabel = new JLabel("Path to webbrowser");
    private JLabel reqRestart = new JLabel("Chances require programmrestart");
    private JLabel explainActionLabel = new JLabel("What to to, when doubleclicking on a Field: ");
    private JLabel statusLabel = new JLabel("Status :");
    private JLabel nameLabel = new JLabel("Name :");
    private JLabel currentTrackLabel = new JLabel("Current Track: ");
    private JLabel windowClosing = new JLabel("Action when clicking on closing window");
    private JLabel lnfLabel = new JLabel("All installed Look and Feels");
    private JLabel logLabel = new JLabel("How much do you want to log?");
    private JTextArea translationTA = new JTextArea();
    private JScrollPane translationSP = new JScrollPane(this.translationTA);
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JButton saveAndExitButton = new JButton("OK", this.saveAndExitIcon);
    private JButton saveButton = new JButton("Save", this.saveIcon);
    private JButton browseRipper = new JButton(this.findIcon);
    private JButton browseMP3Player = new JButton(this.findIcon);
    private JButton browseGenerellPath = new JButton(this.findIcon);
    private JButton browseFileBrowserPath = new JButton(this.findIcon);
    private JButton browseWebBrowserPath = new JButton(this.findIcon);
    private JFileChooser dirChooser;
    private String[] languages = new String[]{"English", "German", "System", "French"};
    private String[] actions = new String[]{"none", "Open Browser", "edit Stream", "start/stop", "play Stream"};
    private String[] windowActions = new String[]{"do nothing", "Exit StreamRipStar", "Send in Systemtray"};
    private String[] logLevel = new String[]{"Nothing", "Error", "Normal", "Everything"};
    private String[] lookAndFeelList;
    private String lookAndFeelBox_className = null;
    private JComboBox<String> langMenu = new JComboBox<String>(this.languages);
    private JComboBox<String> statusBox = new JComboBox<String>(this.actions);
    private JComboBox<String> nameBox = new JComboBox<String>(this.actions);
    private JComboBox<String> currentTrackBox = new JComboBox<String>(this.actions);
    private JComboBox<String> windowActionBox = new JComboBox<String>(this.windowActions);
    private JComboBox<String> LookAndFeelBox = new JComboBox();
    private JComboBox<String> logLevelBox = new JComboBox<String>(this.logLevel);
    private boolean activeTrayIconTMP = false;
    private JCheckBox activeTrayIcon = new JCheckBox("Show Systemtray (requires restart)");
    private JCheckBox showTextCheckBox = new JCheckBox("Show Text under Icons", true);
    private JCheckBox useInternalAudioPlayerCB = new JCheckBox("Use internal check box (Requires gstreamer installed");
    private JCheckBox useAnotherLnfBox = new JCheckBox("Use another Look and Feel");
    private JCheckBox startInSystemTrayCB = new JCheckBox("Start in system tray (minimized)");
    private JCheckBox checkForUpdatesOnStartCB = new JCheckBox("Automatically check for updates on start", true);
    private JCheckBox hideUpateWindowCB = new JCheckBox("Hide update window until a new update is available", true);
    private TitledBorder sysTrayTabTitle = BorderFactory.createTitledBorder("System Tray Icon");
    private TitledBorder lookAndFeelTabTitle = BorderFactory.createTitledBorder("Look And Feel");
    private TitledBorder actionsTabTitle = BorderFactory.createTitledBorder("Actions On Columns");
    private TitledBorder languageTabTitle = BorderFactory.createTitledBorder("Language");
    private TitledBorder logTabTitle = BorderFactory.createTitledBorder("Logging");
    private TitledBorder internalAudioTitle = BorderFactory.createTitledBorder("Audio");
    private TitledBorder pathTitle = BorderFactory.createTitledBorder("Path To Programs");
    private TitledBorder programStartTitle = BorderFactory.createTitledBorder("Path To Programs");
    private TitledBorder autoSearchUpdateTitle = BorderFactory.createTitledBorder("Auto update configuration");
    private TitledBorder searchNowUpdatesTitle = BorderFactory.createTitledBorder("Search for updates");
    private UIManager.LookAndFeelInfo[] lookAndFeelInfos;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Gui_StreamRipStar mainGui = null;

    public Gui_Settings2(Gui_StreamRipStar mainGui) {
        super((Frame)mainGui, "Preferences");
        this.mainGui = mainGui;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        Object[][] elements = new Object[][]{{"Look And Feel", this.commonPrefIcon}, {"Audio and Programs", this.pathPrefIcon}, {"Language and Log", this.audioPlayerPrefIcon}, {"Updates", this.udpatePrefIcon}};
        this.list = new JList((E[])elements);
        this.list.setCellRenderer(new IconCellRenderer());
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new ClickOnListListener());
        this.lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelList = new String[this.lookAndFeelInfos.length];
        int i = 0;
        while (i < this.lookAndFeelInfos.length) {
            this.lookAndFeelList[i] = this.lookAndFeelInfos[i].getName();
            ++i;
        }
        this.LookAndFeelBox = new JComboBox<String>(this.lookAndFeelList);
        this.translationTA.setEditable(false);
        this.searchUpdatePanel = new Gui_searchUpdatePanel(mainGui.getControlStream(), false);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.list), "West");
        this.add((Component)this.mainSP, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.pathAudioPanel.setLayout(new GridBagLayout());
        this.pathPanel.setLayout(new GridBagLayout());
        this.internalaudioPanel.setLayout(new GridBagLayout());
        this.lookAndFeelPanel.setLayout(new GridBagLayout());
        this.sysTrayIconPanel.setLayout(new GridBagLayout());
        this.otherLookAndFeelPanel.setLayout(new GridBagLayout());
        this.actionPanel.setLayout(new GridBagLayout());
        this.programStartPanel.setLayout(new GridBagLayout());
        this.langLogPanel.setLayout(new GridBagLayout());
        this.languagePanel.setLayout(new GridBagLayout());
        this.logPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.commonPanel.setLayout(new GridBagLayout());
        this.updatePanel.setLayout(new GridBagLayout());
        this.autoUpdatePanel.setLayout(new GridBagLayout());
        this.searchUpdatePanel.setLayout(new GridBagLayout());
        this.sysTrayIconPanel.setBorder(this.sysTrayTabTitle);
        this.otherLookAndFeelPanel.setBorder(this.lookAndFeelTabTitle);
        this.actionPanel.setBorder(this.actionsTabTitle);
        this.programStartPanel.setBorder(this.programStartTitle);
        this.languagePanel.setBorder(this.languageTabTitle);
        this.logPanel.setBorder(this.logTabTitle);
        this.internalaudioPanel.setBorder(this.internalAudioTitle);
        this.pathPanel.setBorder(this.pathTitle);
        this.autoUpdatePanel.setBorder(this.autoSearchUpdateTitle);
        this.searchUpdatePanel.setBorder(this.searchNowUpdatesTitle);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.lookAndFeelPanel.add((Component)this.sysTrayIconPanel, c);
        c.gridy = 1;
        this.lookAndFeelPanel.add((Component)this.otherLookAndFeelPanel, c);
        c.gridy = 2;
        this.lookAndFeelPanel.add((Component)this.actionPanel, c);
        c.gridy = 3;
        this.lookAndFeelPanel.add((Component)this.programStartPanel, c);
        c.gridy = 4;
        c.weighty = 1.0;
        this.lookAndFeelPanel.add((Component)new JLabel(""), c);
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 0.0;
        this.sysTrayIconPanel.add((Component)this.activeTrayIcon, c);
        c.gridy = 1;
        this.sysTrayIconPanel.add((Component)this.windowClosing, c);
        c.gridy = 2;
        c.gridx = 1;
        c.gridwidth = 2;
        this.sysTrayIconPanel.add(this.windowActionBox, c);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        this.otherLookAndFeelPanel.add((Component)this.useAnotherLnfBox, c);
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.otherLookAndFeelPanel.add((Component)this.lnfLabel, c);
        c.gridx = 1;
        this.otherLookAndFeelPanel.add(this.LookAndFeelBox, c);
        c.gridy = 2;
        c.gridx = 0;
        this.otherLookAndFeelPanel.add((Component)this.showTextCheckBox, c);
        c.insets = new Insets(5, 5, 10, 5);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 7;
        this.actionPanel.add((Component)this.explainActionLabel, c);
        c.gridx = 0;
        c.weightx = 1.0;
        this.actionPanel.add((Component)new JLabel(""), c);
        c.insets = new Insets(2, 30, 2, 5);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = 0;
        this.actionPanel.add((Component)this.statusLabel, c);
        c.gridx = 1;
        this.actionPanel.add(this.statusBox, c);
        c.gridy = 2;
        c.gridx = 0;
        this.actionPanel.add((Component)this.nameLabel, c);
        c.gridx = 1;
        this.actionPanel.add(this.nameBox, c);
        c.gridy = 3;
        c.gridx = 0;
        this.actionPanel.add((Component)this.currentTrackLabel, c);
        c.gridx = 1;
        this.actionPanel.add(this.currentTrackBox, c);
        c.insets = new Insets(5, 5, 10, 5);
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.programStartPanel.add(this.startInSystemTrayCB);
        c.gridx = 1;
        c.weightx = 1.0;
        this.programStartPanel.add((Component)new JLabel(""), c);
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.pathAudioPanel.add((Component)this.internalaudioPanel, c);
        c.weightx = 0.0;
        c.gridy = 1;
        this.pathAudioPanel.add((Component)this.pathPanel, c);
        c.gridy = 2;
        c.weighty = 1.0;
        this.pathAudioPanel.add((Component)new JLabel(""), c);
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.insets = new Insets(1, 1, 4, 1);
        this.internalaudioPanel.add((Component)this.useInternalAudioPlayerCB, c);
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = 0;
        this.internalaudioPanel.add((Component)this.mediaPlayer, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.internalaudioPanel.add((Component)this.shoutcastPlayer, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.internalaudioPanel.add((Component)this.browseMP3Player, c);
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 0.0;
        this.pathPanel.add((Component)this.ripLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.pathPanel.add((Component)this.ripperPathField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.pathPanel.add((Component)this.browseRipper, c);
        c.gridy = 1;
        c.gridx = 0;
        this.pathPanel.add((Component)this.generellPathLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.pathPanel.add((Component)this.generellPathField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.pathPanel.add((Component)this.browseGenerellPath, c);
        c.gridy = 2;
        c.gridx = 0;
        this.pathPanel.add((Component)this.webBrowserLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.pathPanel.add((Component)this.webBrowserField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.pathPanel.add((Component)this.browseWebBrowserPath, c);
        c.gridy = 3;
        c.gridx = 0;
        this.pathPanel.add((Component)this.fileBrowserLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.pathPanel.add((Component)this.fileBrowserField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.pathPanel.add((Component)this.browseFileBrowserPath, c);
        c.gridy = 0;
        c.weighty = 0.0;
        this.langLogPanel.add((Component)this.languagePanel, c);
        c.gridy = 1;
        c.weightx = 1.0;
        this.langLogPanel.add((Component)this.logPanel, c);
        c.gridy = 2;
        c.weighty = 1.0;
        this.langLogPanel.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        this.languagePanel.add(this.langMenu, c);
        c.weightx = 1.0;
        c.gridx = 1;
        this.languagePanel.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        this.languagePanel.add((Component)this.reqRestart, c);
        c.weightx = 0.0;
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 2;
        this.languagePanel.add((Component)new JLabel(" "), c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridy = 3;
        c.gridx = 0;
        c.gridwidth = 2;
        this.languagePanel.add((Component)this.translationSP, c);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        this.logPanel.add((Component)this.logLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.logPanel.add(this.logLevelBox, c);
        c.insets = new Insets(15, 5, 5, 5);
        c.gridy = 0;
        c.weighty = 0.0;
        this.updatePanel.add((Component)this.autoUpdatePanel, c);
        c.gridy = 1;
        c.weightx = 1.0;
        this.updatePanel.add((Component)this.searchUpdatePanel, c);
        c.gridy = 2;
        c.weighty = 1.0;
        this.updatePanel.add((Component)new JLabel(""), c);
        c.insets = new Insets(5, 5, 0, 5);
        c.gridy = 0;
        c.weighty = 0.0;
        this.autoUpdatePanel.add((Component)this.checkForUpdatesOnStartCB, c);
        c.insets = new Insets(0, 5, 5, 5);
        c.gridy = 1;
        c.weighty = 0.0;
        this.autoUpdatePanel.add((Component)this.hideUpateWindowCB, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        this.buttonPanel.add((Component)this.saveAndExitButton, c);
        c.gridx = 1;
        this.buttonPanel.add((Component)this.saveButton, c);
        c.weightx = 1.0;
        c.gridx = 2;
        this.buttonPanel.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        c.gridx = 3;
        this.buttonPanel.add((Component)this.abortButton, c);
        this.dirChooser = new JFileChooser();
        this.dirChooser.setFileSelectionMode(1);
        this.abortButton.addActionListener(new ExitListener());
        this.saveButton.addActionListener(new SaveListener());
        this.saveAndExitButton.addActionListener(new SaveAndExitListener());
        this.browseMP3Player.addActionListener(new MP3Listener());
        this.browseRipper.addActionListener(new RipperPathListener());
        this.browseGenerellPath.addActionListener(new BrowseListener());
        this.browseWebBrowserPath.addActionListener(new WebBrowserListener());
        this.browseFileBrowserPath.addActionListener(new FileBrowserListener());
        this.activeTrayIcon.addActionListener(new ChangeTrayFields());
        this.useAnotherLnfBox.addActionListener(new ChangeTrayFields());
        this.useInternalAudioPlayerCB.addActionListener(new ChangeTrayFields());
        this.startInSystemTrayCB.addActionListener(new StartProgrammChangeListener());
        this.setLanguage();
        this.load();
        if (this.lookAndFeelBox_className != null) {
            int i2 = 0;
            while (i2 < this.lookAndFeelInfos.length) {
                if (this.lookAndFeelInfos[i2].getClassName().equals(this.lookAndFeelBox_className)) {
                    this.LookAndFeelBox.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
        }
        this.statusBox.setSelectedIndex(4);
        this.nameBox.setSelectedIndex(4);
        this.currentTrackBox.setSelectedIndex(4);
        this.mainPanel.add(this.lookAndFeelPanel);
        this.list.setSelectedIndex(0);
        this.repaintCommon();
        Dimension frameDim = new Dimension(900, 550);
        this.setSize(frameDim);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().registerKeyboardAction(new ExitListener(), escStroke, 2);
    }

    public void setLanguage() {
        try {
            this.setTitle(this.trans.getString("pref"));
            this.activeTrayIcon.setText(this.trans.getString("showSysTray"));
            this.showTextCheckBox.setText(this.trans.getString("showTextUnderIcons"));
            this.useInternalAudioPlayerCB.setText(this.trans.getString("settings.useInternalAudioPlayer"));
            this.windowClosing.setText(this.trans.getString("actionX"));
            this.windowActionBox.removeAllItems();
            this.windowActionBox.addItem(this.trans.getString("X.doNothing"));
            this.windowActionBox.addItem(this.trans.getString("X.Exit"));
            this.windowActionBox.addItem(this.trans.getString("X.inTray"));
            this.explainActionLabel.setText(this.trans.getString("whenClickAction"));
            this.actions[0] = this.trans.getString("X.doNothing");
            this.actions[1] = this.trans.getString("action.OpenBrowser");
            this.actions[2] = this.trans.getString("action.editStream");
            this.actions[3] = this.trans.getString("action.startStop");
            this.actions[4] = this.trans.getString("action.playStream");
            this.statusBox.removeAllItems();
            this.statusBox.addItem(this.actions[0]);
            this.statusBox.addItem(this.actions[1]);
            this.statusBox.addItem(this.actions[2]);
            this.statusBox.addItem(this.actions[3]);
            this.statusBox.addItem(this.actions[4]);
            this.nameBox.removeAllItems();
            this.nameBox.addItem(this.actions[0]);
            this.nameBox.addItem(this.actions[1]);
            this.nameBox.addItem(this.actions[2]);
            this.nameBox.addItem(this.actions[3]);
            this.nameBox.addItem(this.actions[4]);
            this.currentTrackBox.removeAllItems();
            this.currentTrackBox.addItem(this.actions[0]);
            this.currentTrackBox.addItem(this.actions[1]);
            this.currentTrackBox.addItem(this.actions[2]);
            this.currentTrackBox.addItem(this.actions[3]);
            this.currentTrackBox.addItem(this.actions[4]);
            this.logLevelBox.removeAllItems();
            this.logLevel[0] = this.trans.getString("Settings.LogString.Nothing");
            this.logLevel[1] = this.trans.getString("Settings.LogString.Error");
            this.logLevel[2] = this.trans.getString("Settings.LogString.Normal");
            this.logLevel[3] = this.trans.getString("Settings.LogString.Everything");
            this.logLevelBox.addItem(this.logLevel[0]);
            this.logLevelBox.addItem(this.logLevel[1]);
            this.logLevelBox.addItem(this.logLevel[2]);
            this.logLevelBox.addItem(this.logLevel[3]);
            this.ripLabel.setText(this.trans.getString("pathStreamripper"));
            this.mediaPlayer.setText(this.trans.getString("pathToMp3Player"));
            this.generellPathLabel.setText(this.trans.getString("genSavePath"));
            this.fileBrowserLabel.setText(this.trans.getString("filebrowserPath"));
            this.webBrowserLabel.setText(this.trans.getString("webBrowserPath"));
            this.reqRestart.setText(this.trans.getString("reqRestart"));
            this.translationTA.setText(this.trans.getString("settings.translationTA"));
            this.abortButton.setText(this.trans.getString("abortButton"));
            this.saveAndExitButton.setText(this.trans.getString("okButton"));
            this.saveButton.setText(this.trans.getString("save"));
            this.statusLabel.setText(this.trans.getString("status"));
            this.nameLabel.setText(this.trans.getString("streamname"));
            this.currentTrackLabel.setText(this.trans.getString("curTitle"));
            this.lnfLabel.setText(this.trans.getString("Settings.lnfLabel"));
            this.useAnotherLnfBox.setText(this.trans.getString("Settings.useAnotherLnfBox"));
            this.startInSystemTrayCB.setText(this.trans.getString("Settings.startInSystemTray"));
            this.logLabel.setText(this.trans.getString("Settings.logLabel"));
            this.sysTrayTabTitle.setTitle(this.trans.getString("Settings.title.SysTray"));
            this.lookAndFeelTabTitle.setTitle(this.trans.getString("Settings.title.LookAndFeel"));
            this.actionsTabTitle.setTitle(this.trans.getString("Settings.title.Actions"));
            this.languageTabTitle.setTitle(this.trans.getString("Settings.title.Language"));
            this.logTabTitle.setTitle(this.trans.getString("Settings.title.Log"));
            this.internalAudioTitle.setTitle(this.trans.getString("Settings.title.InternalAudio"));
            this.pathTitle.setTitle(this.trans.getString("Settings.title.Paths"));
            this.programStartTitle.setTitle(this.trans.getString("Settings.title.ProgramStart"));
            this.autoSearchUpdateTitle.setTitle(this.trans.getString("Settings.Updates.Header.AutoUpdate"));
            this.searchNowUpdatesTitle.setTitle(this.trans.getString("Settings.Updates.Header.UpdateSearch"));
            this.checkForUpdatesOnStartCB.setText(this.trans.getString("Settings.Updates.CheckStartup"));
            this.hideUpateWindowCB.setText(this.trans.getString("Settings.Updates.HideUpdateWindow"));
            Object[][] elements = new Object[][]{{this.trans.getString("Settings.Panel.LookAndFeel"), this.commonPrefIcon}, {this.trans.getString("Settings.Panel.AudioAndPrograms"), this.pathPrefIcon}, {this.trans.getString("Settings.Panel.LanguageAndLog"), this.audioPlayerPrefIcon}, {this.trans.getString("Settings.Panel.Update"), this.udpatePrefIcon}};
            this.list.setListData((Object[])elements);
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE("Error in Translation for the Settings: \n" + e.getStackTrace().toString());
        }
    }

    private Gui_Settings2 gimme() {
        return this;
    }

    public void save() {
        String savePath = new Control_GetPath().getStreamRipStarPath();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(new FileOutputStream(String.valueOf(savePath) + "/Settings-StreamRipStar.xml"));
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            StartDocument header = eventFactory.createStartDocument();
            StartElement startRootSettings = eventFactory.createStartElement("", "", "Settings");
            Attribute checkForUpdatesOnStartCB_S = eventFactory.createAttribute("checkForUpdatesOnStartCB", String.valueOf(this.checkForUpdatesOnStartCB.isSelected()));
            Attribute hideUpateWindowCB_S = eventFactory.createAttribute("hideUpateWindowCB", String.valueOf(this.hideUpateWindowCB.isSelected()));
            Attribute startInSystTrayCB_S = eventFactory.createAttribute("startInSysTray", String.valueOf(this.startInSystemTrayCB.isSelected()));
            Attribute activeIconCB_S = eventFactory.createAttribute("activeTrayIcon", String.valueOf(this.activeTrayIcon.isSelected()));
            Attribute lookAndFeelCB_S = eventFactory.createAttribute("useAnotherLnfBox", String.valueOf(this.useAnotherLnfBox.isSelected()));
            Attribute showTextCB_S = eventFactory.createAttribute("showTextCB", String.valueOf(this.showTextCheckBox.isSelected()));
            Attribute useInternalAudioPlayerCB_S = eventFactory.createAttribute("useInternalAudioPlayerCB", String.valueOf(this.useInternalAudioPlayerCB.isSelected()));
            Attribute ripperPathTF_S = eventFactory.createAttribute("ripperPathTF", this.ripperPathField.getText());
            Attribute shoutcastTF_S = eventFactory.createAttribute("shoutcastTF", this.shoutcastPlayer.getText());
            Attribute generellPathTF_S = eventFactory.createAttribute("generellPathTF", this.generellPathField.getText());
            Attribute fileBrowserTF_S = eventFactory.createAttribute("fileBrowserTF", this.fileBrowserField.getText());
            Attribute webBrowserTF_S = eventFactory.createAttribute("webBrowserTF", this.webBrowserField.getText());
            Attribute statusBox_index = eventFactory.createAttribute("statusBox_index", String.valueOf(this.statusBox.getSelectedIndex()));
            Attribute nameBox_inde = eventFactory.createAttribute("nameBox_index", String.valueOf(this.nameBox.getSelectedIndex()));
            Attribute currentTrackBox_index = eventFactory.createAttribute("currentTrackBox_index", String.valueOf(this.currentTrackBox.getSelectedIndex()));
            Attribute langMenu_index = eventFactory.createAttribute("langMenu_index", String.valueOf(this.langMenu.getSelectedIndex()));
            Attribute windowActionBox_index = eventFactory.createAttribute("windowActionBox_index", "1");
            if (this.activeTrayIcon.isSelected()) {
                windowActionBox_index = eventFactory.createAttribute("windowActionBox_index", String.valueOf(this.windowActionBox.getSelectedIndex()));
            }
            Attribute lookAndFeel_index = eventFactory.createAttribute("LookAndFeelBox_className", "null");
            if (this.useAnotherLnfBox.isSelected()) {
                lookAndFeel_index = eventFactory.createAttribute("LookAndFeelBox_className", this.lookAndFeelInfos[this.LookAndFeelBox.getSelectedIndex()].getClassName());
            }
            Attribute logLevel_index = eventFactory.createAttribute("logLevel_index", String.valueOf(this.logLevelBox.getSelectedIndex()));
            EndElement endRoot = eventFactory.createEndElement("", "", "Settings");
            EndDocument endDocument = eventFactory.createEndDocument();
            writer.add(header);
            writer.add(startRootSettings);
            writer.add(checkForUpdatesOnStartCB_S);
            writer.add(hideUpateWindowCB_S);
            writer.add(activeIconCB_S);
            writer.add(startInSystTrayCB_S);
            writer.add(lookAndFeelCB_S);
            writer.add(showTextCB_S);
            writer.add(useInternalAudioPlayerCB_S);
            writer.add(ripperPathTF_S);
            writer.add(shoutcastTF_S);
            writer.add(generellPathTF_S);
            writer.add(fileBrowserTF_S);
            writer.add(webBrowserTF_S);
            writer.add(statusBox_index);
            writer.add(nameBox_inde);
            writer.add(currentTrackBox_index);
            writer.add(langMenu_index);
            writer.add(windowActionBox_index);
            writer.add(lookAndFeel_index);
            writer.add(logLevel_index);
            writer.add(endRoot);
            writer.add(endDocument);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        String[] path = new String[]{this.ripperPathField.getText(), this.shoutcastPlayer.getText(), this.generellPathField.getText(), this.webBrowserField.getText(), this.fileBrowserField.getText()};
        String newlnfClassName = null;
        if (this.useAnotherLnfBox.isSelected()) {
            newlnfClassName = this.lookAndFeelInfos[this.LookAndFeelBox.getSelectedIndex()].getClassName();
        }
        int[] actions = new int[]{this.statusBox.getSelectedIndex(), this.nameBox.getSelectedIndex(), this.currentTrackBox.getSelectedIndex(), this.windowActionBox.getSelectedIndex()};
        this.mainGui.setNewRuntimePrefs(actions, this.showTextCheckBox.isSelected(), this.activeTrayIcon.isSelected(), newlnfClassName, this.useInternalAudioPlayerCB.isSelected(), this.checkForUpdatesOnStartCB.isSelected(), this.hideUpateWindowCB.isSelected());
        this.mainGui.getControlStream().setPaths(path);
        int level = this.logLevelBox.getSelectedIndex();
        switch (level) {
            case 0: {
                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Nothing);
                break;
            }
            case 1: {
                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Error);
                break;
            }
            case 2: {
                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Normal);
                break;
            }
            case 3: {
                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Debug);
                break;
            }
            default: {
                SRSOutput.getInstance().setLoglevel(SRSOutput.LOGLEVEL.Normal);
            }
        }
    }

    public void load() {
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/Settings-StreamRipStar.xml"));
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Settings-StreamRipStar.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (parser.getAttributeLocalName(i).equals("activeTrayIcon")) {
                                this.activeTrayIcon.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("checkForUpdatesOnStartCB")) {
                                this.checkForUpdatesOnStartCB.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("hideUpateWindowCB")) {
                                this.hideUpateWindowCB.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("showTextCB")) {
                                this.showTextCheckBox.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("startInSysTray")) {
                                this.startInSystemTrayCB.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("useInternalAudioPlayerCB")) {
                                this.useInternalAudioPlayerCB.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("ripperPathTF")) {
                                this.ripperPathField.setText(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("shoutcastTF")) {
                                this.shoutcastPlayer.setText(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("generellPathTF")) {
                                this.generellPathField.setText(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("fileBrowserTF")) {
                                this.fileBrowserField.setText(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("webBrowserTF")) {
                                this.webBrowserField.setText(parser.getAttributeValue(i));
                            } else if (parser.getAttributeLocalName(i).equals("statusBox_index")) {
                                this.statusBox.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("nameBox_index")) {
                                this.nameBox.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("currentTrackBox_index")) {
                                this.currentTrackBox.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("langMenu_index")) {
                                this.langMenu.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("windowActionBox_index")) {
                                this.windowActionBox.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("useAnotherLnfBox")) {
                                this.useAnotherLnfBox.setSelected(Boolean.valueOf(parser.getAttributeValue(i)));
                            } else if (parser.getAttributeLocalName(i).equals("LookAndFeelBox_className")) {
                                String tmp = parser.getAttributeValue(i);
                                this.lookAndFeelBox_className = tmp.equals("null") ? null : parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("logLevel_index")) {
                                this.logLevelBox.setSelectedIndex(Integer.valueOf(parser.getAttributeValue(i)));
                            }
                            ++i;
                        }
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: Settings-StreamRipStar.xml");
            this.fillWithFoundPrograms();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void fillWithFoundPrograms() {
        String[][] programms = new Control_TestStartFirst().searchPrograms();
        if (programms != null) {
            this.ripperPathField.setText(programms[3][0]);
            this.shoutcastPlayer.setText(programms[2][0]);
            this.webBrowserField.setText(programms[1][0]);
            this.fileBrowserField.setText(programms[0][0]);
        }
    }

    public void repaintCommon() {
        if (this.activeTrayIcon.isSelected()) {
            this.windowActionBox.setEnabled(true);
            this.windowClosing.setEnabled(true);
        } else {
            this.windowActionBox.setEnabled(false);
            this.windowClosing.setEnabled(false);
            this.windowActionBox.setSelectedIndex(1);
            this.startInSystemTrayCB.setSelected(false);
        }
        if (this.useAnotherLnfBox.isSelected()) {
            this.LookAndFeelBox.setEnabled(true);
            this.lnfLabel.setEnabled(true);
        } else {
            this.LookAndFeelBox.setEnabled(false);
            this.lnfLabel.setEnabled(false);
        }
        if (this.useInternalAudioPlayerCB.isSelected()) {
            this.mediaPlayer.setEnabled(false);
            this.shoutcastPlayer.setEnabled(false);
            this.browseMP3Player.setEnabled(false);
        } else {
            this.mediaPlayer.setEnabled(true);
            this.shoutcastPlayer.setEnabled(true);
            this.browseMP3Player.setEnabled(true);
        }
    }

    public Gui_Settings2 getMe() {
        return this;
    }

    public class BrowseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dirChooser.setFileSelectionMode(1);
            int i = Gui_Settings2.this.dirChooser.showOpenDialog(Gui_Settings2.this.gimme());
            if (i == 0) {
                Gui_Settings2.this.generellPathField.setText(Gui_Settings2.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    public class ChangeTrayFields
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.repaintCommon();
        }
    }

    public class ClickOnListListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (Gui_Settings2.this.list != null & Gui_Settings2.this.list.getSelectedIndex() > -1) {
                switch (Gui_Settings2.this.list.getSelectedIndex()) {
                    case 0: {
                        Gui_Settings2.this.mainPanel.add(Gui_Settings2.this.lookAndFeelPanel);
                        break;
                    }
                    case 1: {
                        Gui_Settings2.this.mainPanel.add(Gui_Settings2.this.pathAudioPanel);
                        break;
                    }
                    case 2: {
                        Gui_Settings2.this.mainPanel.add(Gui_Settings2.this.langLogPanel);
                        break;
                    }
                    case 3: {
                        Gui_Settings2.this.mainPanel.add(Gui_Settings2.this.updatePanel);
                        break;
                    }
                    default: {
                        Gui_Settings2.this.mainPanel.add(Gui_Settings2.this.lookAndFeelPanel);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    public class ExitListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dispose();
        }
    }

    public class FileBrowserListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dirChooser.setFileSelectionMode(2);
            int i = Gui_Settings2.this.dirChooser.showOpenDialog(Gui_Settings2.this.gimme());
            if (i == 0) {
                Gui_Settings2.this.fileBrowserField.setText(Gui_Settings2.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    private class IconCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private IconCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = null;
            String theText = null;
            JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                theText = (String)values[0];
                icon = (Icon)values[1];
            }
            label.setText(theText);
            label.setIcon(icon);
            return label;
        }
    }

    public class MP3Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dirChooser.setFileSelectionMode(2);
            int i = Gui_Settings2.this.dirChooser.showOpenDialog(Gui_Settings2.this.gimme());
            if (i == 0) {
                Gui_Settings2.this.shoutcastPlayer.setText(Gui_Settings2.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    private class OnlyOneActivePanel
    extends JPanel {
        private static final long serialVersionUID = -2917467613922489238L;
        public JPanel activePanel = null;

        public OnlyOneActivePanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
        }

        public void add(JPanel newPanel) {
            if (this.activePanel != null) {
                this.remove(this.activePanel);
            }
            this.activePanel = newPanel;
            super.add((Component)newPanel, "Center");
            this.repaint();
            this.updateUI();
        }
    }

    public class RipperPathListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dirChooser.setFileSelectionMode(2);
            int i = Gui_Settings2.this.dirChooser.showOpenDialog(Gui_Settings2.this.gimme());
            if (i == 0) {
                Gui_Settings2.this.ripperPathField.setText(Gui_Settings2.this.dirChooser.getSelectedFile().toString());
            }
        }
    }

    public class SaveAndExitListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.save();
            Gui_Settings2.this.dispose();
        }
    }

    public class SaveListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.save();
        }
    }

    public class StartProgrammChangeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_Settings2.this.startInSystemTrayCB.isSelected()) {
                Gui_Settings2.this.activeTrayIconTMP = Gui_Settings2.this.activeTrayIcon.isSelected();
                Gui_Settings2.this.activeTrayIcon.setSelected(true);
                Gui_Settings2.this.repaintCommon();
            } else {
                Gui_Settings2.this.activeTrayIcon.setSelected(Gui_Settings2.this.activeTrayIconTMP);
                Gui_Settings2.this.startInSystemTrayCB.setSelected(false);
                Gui_Settings2.this.repaintCommon();
            }
        }
    }

    public class WebBrowserListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Settings2.this.dirChooser.setFileSelectionMode(2);
            int i = Gui_Settings2.this.dirChooser.showOpenDialog(Gui_Settings2.this.gimme());
            if (i == 0) {
                Gui_Settings2.this.webBrowserField.setText(Gui_Settings2.this.dirChooser.getSelectedFile().toString());
            }
        }
    }
}

