/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_GetPath;
import control.Control_Stream;
import control.SRSOutput;
import gui.Add_Schedule_Task;
import gui.Gui_JTTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import misc.SchedulJob;
import thread.Thread_Control_Schedules;
import thread.Thread_KeepTableSchedulUpdated;

public class Gui_SchedulManager
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/Icons/add_small.png"));
    private ImageIcon editIcon = new ImageIcon(this.getClass().getResource("/Icons/edit_small.png"));
    private ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("/Icons/delete_small.png"));
    private ImageIcon closeIcon = new ImageIcon(this.getClass().getResource("/Icons/ok_small.png"));
    private JPanel tablePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton addButton = new JButton("Add Task", this.addIcon);
    private JButton editButton = new JButton("Edit Task", this.editIcon);
    private JButton removeButton = new JButton("Remove Task", this.deleteIcon);
    private JButton closeButton = new JButton("Close", this.closeIcon);
    private Object[][] allData = new Object[0][];
    private Object[] schedulHeader = new Object[]{"ID", "StreamID", "Enabled", "Stream Name", "Start Time", "End Time", "Comment"};
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem addItem = new JMenuItem("Add Schedule Job");
    private JMenuItem removeItem = new JMenuItem("Remove Schedule Job");
    private JMenuItem editItem = new JMenuItem("Edit Schedul Job");
    private DefaultTableModel model = new DefaultTableModel(this.allData, this.schedulHeader){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 4: {
                    return TimeColumn.class;
                }
                case 5: {
                    return TimeColumn.class;
                }
            }
            return String.class;
        }
    };
    private Thread_KeepTableSchedulUpdated keepUpdate;
    private Gui_JTTable table = new Gui_JTTable(this.model);
    private JScrollPane scrollPane = new JScrollPane(this.table);
    private Control_Stream controlStreams = null;
    private Thread_Control_Schedules controlJob = null;

    public Gui_SchedulManager(Control_Stream controlStreams, Thread_Control_Schedules controlJob) {
        super("Schedul Manager");
        this.controlStreams = controlStreams;
        this.controlJob = controlJob;
        this.setLanguage();
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.tablePanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(7, 7, 7, 7);
        this.popup.add(this.addItem);
        this.popup.add(this.editItem);
        this.popup.add(this.removeItem);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        this.buttonPanel.add((Component)this.addButton, c);
        c.gridx = 1;
        this.buttonPanel.add((Component)this.editButton, c);
        c.gridx = 2;
        this.buttonPanel.add((Component)this.removeButton, c);
        c.weightx = 1.0;
        c.gridx = 3;
        this.buttonPanel.add((Component)new JLabel(" "), c);
        c.weightx = 0.0;
        c.gridx = 4;
        this.buttonPanel.add((Component)this.closeButton, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.tablePanel.add((Component)this.scrollPane, c);
        this.table.setAutoResizeMode(1);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(4);
        this.table.getColumn(this.schedulHeader[0]).setMinWidth(0);
        this.table.getColumn(this.schedulHeader[0]).setMaxWidth(0);
        this.table.getColumn(this.schedulHeader[1]).setMinWidth(0);
        this.table.getColumn(this.schedulHeader[1]).setMaxWidth(0);
        this.addButton.addActionListener(new AddListener());
        this.editButton.addActionListener(new EditListener());
        this.removeButton.addActionListener(new RemoveListener());
        this.closeButton.addActionListener(new CloseListener());
        this.addItem.addActionListener(new AddListener());
        this.editItem.addActionListener(new EditListener());
        this.removeItem.addActionListener(new RemoveListener());
        this.table.addMouseListener(new CellMouseListener());
        this.scrollPane.addMouseListener(new CellMouseListener());
        this.setDefaultCloseOperation(0);
        this.pack();
        this.load();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - Integer.valueOf(this.getSize().width)) / 2;
        int y = (screenDim.height - Integer.valueOf(this.getSize().height)) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
        this.fillTableWithSchedulJobs();
        this.keepUpdate = new Thread_KeepTableSchedulUpdated(this, controlJob);
        this.keepUpdate.start();
    }

    public void setLanguage() {
        try {
            this.setTitle(this.trans.getString("JobMan.Title"));
            this.addButton.setText(this.trans.getString("JobMan.AddButton"));
            this.editButton.setText(this.trans.getString("JobMan.editButton"));
            this.removeButton.setText(this.trans.getString("JobMan.removeButton"));
            this.closeButton.setText(this.trans.getString("JobMan.closeButton"));
            this.addItem.setText(this.trans.getString("JobMan.AddButton"));
            this.editItem.setText(this.trans.getString("JobMan.editButton"));
            this.removeItem.setText(this.trans.getString("JobMan.removeButton"));
            this.schedulHeader[2] = this.trans.getString("JobMan.table.enable");
            this.schedulHeader[3] = this.trans.getString("JobMan.table.name");
            this.schedulHeader[4] = this.trans.getString("JobMan.table.start");
            this.schedulHeader[5] = this.trans.getString("JobMan.table.end");
            this.schedulHeader[6] = this.trans.getString("JobMan.table.comment");
            this.model.setColumnIdentifiers(this.schedulHeader);
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void addSchedulJobToTable(SchedulJob job) {
        try {
            Object[] x = new Object[7];
            x[0] = job.getSchedulID();
            x[1] = job.getStreamID();
            x[2] = job.isJobenabled();
            x[3] = this.controlStreams.getStreamByID((int)job.getStreamID()).name;
            TimeColumn[] timeColumn = this.getTimeColumns(job);
            x[4] = timeColumn[0];
            x[5] = timeColumn[1];
            x[6] = job.getComment();
            this.model.addRow(x);
            this.model.fireTableDataChanged();
        }
        catch (NullPointerException e) {
            SRSOutput.getInstance().logE("Corrupt schedulJob found. ignore it");
        }
    }

    public Gui_SchedulManager getMe() {
        return this;
    }

    public void fillTableWithSchedulJobs() {
        Vector<SchedulJob> schedulVector = this.controlJob.getScheduleVector();
        int i = 0;
        while (i < schedulVector.capacity()) {
            this.addSchedulJobToTable(schedulVector.get(i));
            ++i;
        }
    }

    public void updateTable(SchedulJob job) {
        int row = -1;
        int i = 0;
        while (i < this.table.getRowCount()) {
            int x = Integer.valueOf(this.table.getValueAt(this.table.convertRowIndexToModel(i), 0).toString());
            if (job.getSchedulID() == x) {
                row = this.table.convertRowIndexToModel(i);
                break;
            }
            ++i;
        }
        this.table.setValueAt(job.isJobenabled(), row, 2);
        this.table.setValueAt(this.controlStreams.getStreamByID((int)job.getStreamID()).name, row, 3);
        TimeColumn[] timeColumn = this.getTimeColumns(job);
        this.table.setValueAt(timeColumn[0], row, 4);
        this.table.setValueAt(timeColumn[1], row, 5);
        this.table.setValueAt(job.getComment(), row, 6);
        this.model.fireTableDataChanged();
    }

    private TimeColumn[] getTimeColumns(SchedulJob job) {
        TimeColumn[] timeColum = new TimeColumn[]{new TimeColumn(), new TimeColumn()};
        if (job.getJobCount() != 3) {
            timeColum[0].time = job.getStartTime();
            timeColum[0].display = job.getStartTimeAsLocaleTime();
            timeColum[1].time = job.getStopTime();
            timeColum[1].display = job.getStopTimeAsLocaleTime();
        } else {
            try {
                timeColum[0].display = this.trans.getString("JobMan.AtStart");
                timeColum[1].display = this.trans.getString("JobMan.Never");
            }
            catch (MissingResourceException e) {
                SRSOutput.getInstance().logE("Schedulmanager Gui: " + e.getMessage());
                timeColum[0].display = "At Start";
                timeColum[1].display = "Never";
            }
            catch (NullPointerException e) {
                SRSOutput.getInstance().logE("Schedulmanager Gui: " + e.getMessage());
                timeColum[0].display = "At Start";
                timeColum[1].display = "Never";
            }
        }
        return timeColum;
    }

    private void editSchedulJob() {
        if (this.table.getSelectedRow() >= 0) {
            int x = Integer.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 0).toString());
            new Add_Schedule_Task(this.getMe(), false, this.controlStreams, this.controlJob, this.controlJob.getSchedulJobByID(x));
        }
    }

    private void toggleScheduleJob() {
        if (this.table.getSelectedRow() >= 0) {
            int x = Integer.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 0).toString());
            this.controlJob.getSchedulJobByID(x).toggleEnableJob();
        }
    }

    public void updateTable() {
        int i = this.table.getRowCount();
        while (i > 0) {
            this.model.removeRow(i - 1);
            --i;
        }
        this.fillTableWithSchedulJobs();
    }

    public int getSelectedRowNumber() {
        return this.table.getSelectedRow();
    }

    public void setSelectedRow(int row) {
        if (this.table.getRowCount() > row) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    public void save() {
        String savePath = new Control_GetPath().getStreamRipStarPath();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        int[] intOptions = new int[5];
        try {
            XMLEventWriter writer = outputFactory.createXMLEventWriter(new FileOutputStream(String.valueOf(savePath) + "/ScheduleManager.xml"), "UTF-8");
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            int i = 0;
            while (i < intOptions.length) {
                intOptions[i] = this.table.getColumn(this.schedulHeader[i + 2]).getWidth();
                ++i;
            }
            StartDocument header = eventFactory.createStartDocument();
            StartElement startRootSettings = eventFactory.createStartElement("", "", "Settings");
            Attribute height = eventFactory.createAttribute("height", String.valueOf(this.getSize().height));
            Attribute width = eventFactory.createAttribute("width", String.valueOf(this.getSize().width));
            Attribute i0 = eventFactory.createAttribute("i0", String.valueOf(intOptions[0]));
            Attribute i1 = eventFactory.createAttribute("i1", String.valueOf(intOptions[1]));
            Attribute i2 = eventFactory.createAttribute("i2", String.valueOf(intOptions[2]));
            Attribute i3 = eventFactory.createAttribute("i3", String.valueOf(intOptions[3]));
            Attribute i4 = eventFactory.createAttribute("i4", String.valueOf(intOptions[4]));
            EndElement endRoot = eventFactory.createEndElement("", "", "Settings");
            EndDocument endDocument = eventFactory.createEndDocument();
            writer.add(header);
            writer.add(startRootSettings);
            writer.add(height);
            writer.add(width);
            writer.add(i0);
            writer.add(i1);
            writer.add(i2);
            writer.add(i3);
            writer.add(i4);
            writer.add(endRoot);
            writer.add(endDocument);
            writer.close();
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("Gui_ScheduleManager: Can't find file ScheduleManager.xml");
        }
        catch (XMLStreamException e) {
            SRSOutput.getInstance().logE("Gui_ScheduleManager:" + e.getMessage());
        }
    }

    public void load() {
        int[] columnWidths = new int[5];
        int high = 400;
        int width = 600;
        String loadPath = new Control_GetPath().getStreamRipStarPath();
        try {
            int i;
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new FileInputStream(String.valueOf(loadPath) + "/ScheduleManager.xml"), "UTF-8");
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 7: {
                        SRSOutput.getInstance().log("Loading file Streambrowser.xml");
                        break;
                    }
                    case 8: {
                        SRSOutput.getInstance().log("End of read settings ");
                        parser.close();
                        break;
                    }
                    case 1: {
                        i = 0;
                        while (i < parser.getAttributeCount()) {
                            if (!parser.getAttributeLocalName(i).equals("")) {
                                if (parser.getAttributeLocalName(i).equals("height")) {
                                    high = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("width")) {
                                    width = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i0")) {
                                    columnWidths[0] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i1")) {
                                    columnWidths[1] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i2")) {
                                    columnWidths[2] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i3")) {
                                    columnWidths[3] = Integer.valueOf(parser.getAttributeValue(i));
                                } else if (parser.getAttributeLocalName(i).equals("i4")) {
                                    columnWidths[4] = Integer.valueOf(parser.getAttributeValue(i));
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                }
                parser.next();
            }
            this.setSize(width, high);
            try {
                i = 0;
                while (i < columnWidths.length) {
                    this.table.getColumn(this.schedulHeader[i + 2]).setPreferredWidth(columnWidths[i]);
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                SRSOutput.getInstance().logE("ScheduleManager: Error while setting the columns width:\n" + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            SRSOutput.getInstance().logE("No configuartion file found: ScheduleManager.xml");
        }
        catch (XMLStreamException e) {
            if (e.getMessage().startsWith("Message: Premature end of file.")) {
                SRSOutput.getInstance().logE("ScheduleManager: XML file had an unexpected end");
            }
            SRSOutput.getInstance().logE("ScheduleManager: Error while reading the Schedule Manager settings");
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.keepUpdate != null) {
            this.keepUpdate.stopThread();
        }
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public class AddListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            new Add_Schedule_Task(Gui_SchedulManager.this.getMe(), true, Gui_SchedulManager.this.controlStreams, Gui_SchedulManager.this.controlJob, null);
        }
    }

    public class CellMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                int row = Gui_SchedulManager.this.table.getSelectedRow();
                int column = Gui_SchedulManager.this.table.getSelectedColumn();
                if (row > -1) {
                    if (column == 2) {
                        Gui_SchedulManager.this.toggleScheduleJob();
                        Gui_SchedulManager.this.updateTable();
                    } else {
                        Gui_SchedulManager.this.editSchedulJob();
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                int row = Gui_SchedulManager.this.table.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    Gui_SchedulManager.this.table.setRowSelectionInterval(row, row);
                    Gui_SchedulManager.this.editItem.setEnabled(true);
                    Gui_SchedulManager.this.removeItem.setEnabled(true);
                    Gui_SchedulManager.this.popup.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                } else {
                    Gui_SchedulManager.this.editItem.setEnabled(false);
                    Gui_SchedulManager.this.removeItem.setEnabled(false);
                    Gui_SchedulManager.this.popup.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        }
    }

    public class CloseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_SchedulManager.this.save();
            Gui_SchedulManager.this.dispose();
        }
    }

    public class EditListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_SchedulManager.this.editSchedulJob();
        }
    }

    public class RemoveListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_SchedulManager.this.table.getSelectedRowCount() > 0) {
                int id = Integer.valueOf(Gui_SchedulManager.this.table.getValueAt(Gui_SchedulManager.this.table.getSelectedRow(), 0).toString());
                int i = JOptionPane.showConfirmDialog(Gui_SchedulManager.this.getMe(), Gui_SchedulManager.this.trans.getString("JobMan.requestDelete"), Gui_SchedulManager.this.trans.getString("JobMan.reallyDelete"), 0);
                if (i == 0) {
                    if (Gui_SchedulManager.this.controlJob.jobStillExist(id).booleanValue()) {
                        int selRow = Gui_SchedulManager.this.table.convertRowIndexToModel(Gui_SchedulManager.this.table.getSelectedRow());
                        Gui_SchedulManager.this.model.removeRow(selRow);
                        Gui_SchedulManager.this.controlJob.removeJobFromVector(id);
                        Gui_SchedulManager.this.controlJob.saveScheduleVector();
                    } else {
                        JOptionPane.showMessageDialog(Gui_SchedulManager.this.getMe(), Gui_SchedulManager.this.trans.getString("jobDoesntExistAnymore"));
                    }
                }
            }
        }
    }

    public class TimeColumn
    implements Comparable<TimeColumn> {
        String display;
        long time;

        public String toString() {
            return this.display;
        }

        @Override
        public int compareTo(TimeColumn other) {
            long t1 = this.time;
            long t2 = other.time;
            return t1 < t2 ? -1 : (t1 == t2 ? 0 : 1);
        }
    }
}

