/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_http_Playlist;
import control.SRSOutput;
import gui.Gui_StreamRipStar;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import misc.Stream;

public class Gui_Infodialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Control_http_Playlist getLastTrack;
    private Stream stream = null;
    private JLabel streamRipStarName = new JLabel("StreamRipStar Stream Name :");
    private JLabel streamName = new JLabel("Stream Name :");
    private JLabel serverName = new JLabel("Server Name :");
    private JLabel bitrate = new JLabel("Bitrate :");
    private JLabel metaVall = new JLabel("Metaintervall :");
    private JLabel commandExe = new JLabel("Execute Command :");
    private JLabel lastTrackLabel = new JLabel("Loading...");
    private JTextField streamRipStarNameField = new JTextField("");
    private JTextField streamNameField = new JTextField("");
    private JTextField serverNameField = new JTextField("");
    private JTextField bitrateField = new JTextField("");
    private JTextField metaVallField = new JTextField("");
    private JTextField commandExeField = new JTextField("");
    private JButton okButton = new JButton("ok");

    public Gui_Infodialog(Gui_StreamRipStar mainWin, Stream ownStream) {
        super((Frame)mainWin, "Information about " + ownStream.name);
        this.stream = ownStream;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLanguage();
        this.fillWithData();
        this.buildGui();
        this.getLastTrack = new Control_http_Playlist(this.stream.address, this);
        this.getLastTrack.start();
        this.setVisible(true);
    }

    public void setLanguage() {
        try {
            this.streamRipStarName.setText(this.trans.getString("Info.streamRipStarName"));
            this.streamName.setText(this.trans.getString("Info.streamName"));
            this.serverName.setText(this.trans.getString("Info.serverName"));
            this.bitrate.setText(this.trans.getString("Info.bitrate"));
            this.metaVall.setText(this.trans.getString("Info.metaVall"));
            this.commandExe.setText(this.trans.getString("Info.commandExe"));
            this.lastTrackLabel.setText(this.trans.getString("Info.Loading"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void buildGui() {
        JPanel panel = new JPanel();
        this.add(panel);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)this.streamRipStarName, c);
        c.gridx = 1;
        panel.add((Component)this.streamRipStarNameField, c);
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)this.streamName, c);
        c.gridx = 1;
        panel.add((Component)this.streamNameField, c);
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)this.serverName, c);
        c.gridx = 1;
        panel.add((Component)this.serverNameField, c);
        c.gridx = 0;
        c.gridy = 3;
        panel.add((Component)this.bitrate, c);
        c.gridx = 1;
        panel.add((Component)this.bitrateField, c);
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)this.metaVall, c);
        c.gridx = 1;
        panel.add((Component)this.metaVallField, c);
        c.gridx = 0;
        c.gridy = 5;
        panel.add((Component)this.commandExe, c);
        c.gridx = 1;
        panel.add((Component)this.commandExeField, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 3;
        panel.add((Component)this.lastTrackLabel, c);
        c.insets = new Insets(10, 10, 5, 10);
        c.weightx = 2.0;
        c.gridy = 7;
        c.gridx = 0;
        c.gridwidth = 2;
        panel.add((Component)this.okButton, c);
        this.okButton.addActionListener(new OKListener());
        this.pack();
        Dimension frameDim = this.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.setDefaultCloseOperation(2);
    }

    public void fillWithData() {
        this.streamRipStarNameField.setText(this.stream.name);
        this.streamNameField.setText(this.stream.getMetaData()[0]);
        this.serverNameField.setText(this.stream.getMetaData()[1]);
        this.bitrateField.setText(this.stream.getMetaData()[2]);
        this.metaVallField.setText(this.stream.getMetaData()[3]);
        this.commandExeField.setText(this.stream.getExeCommand());
        this.streamRipStarNameField.setEditable(false);
        this.streamNameField.setEditable(false);
        this.serverNameField.setEditable(false);
        this.bitrateField.setEditable(false);
        this.metaVallField.setEditable(false);
        this.commandExeField.setEditable(false);
    }

    public void setLastTrackLabelText(String text) {
        this.lastTrackLabel.setText(text);
        this.pack();
        Dimension frameDim = this.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (ClassCastException e) {
            this.lastTrackLabel.setText(this.trans.getString("Info.error.setOldTracks"));
        }
    }

    public class OKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Gui_Infodialog.this.getLastTrack != null) {
                Gui_Infodialog.this.getLastTrack.killThread();
            }
            Gui_Infodialog.this.dispose();
        }
    }
}

