/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.SRSOutput;
import gui.Gui_StreamBrowser2;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class Gui_Filter
extends JPanel {
    private boolean DEBUG = false;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private JTextField minBitrateTF = new JTextField("128", 4);
    private JTextField maxBitrateTF = new JTextField("999", 4);
    private JCheckBox filterBitrateCB = new JCheckBox("Filter Bitrates");
    private JCheckBox filterTypeCB = new JCheckBox("Filter Types");
    private JCheckBox showMP3Streams = new JCheckBox("Show MP3 Streams");
    private JCheckBox showAACStreams = new JCheckBox("Show AAC+ Streams");
    private JCheckBox showUnknownStreams = new JCheckBox("Show Unknown Streams");
    private JLabel minBitrateLabel = new JLabel("min bitrate: ");
    private JLabel maxBitrateCBLabel = new JLabel("max bitrate: ");
    private JButton filterNowButton = new JButton("Filter Now");
    private JPanel bitratePanel = new JPanel();
    private JPanel typePanel = new JPanel();
    private TitledBorder bitrateTitle = BorderFactory.createTitledBorder("Filter Bitrates");
    private TitledBorder typeTitle = BorderFactory.createTitledBorder("Filter Types");
    private boolean visible = false;
    private boolean isFiltered = false;
    private Vector<String[]> streamsPG = null;
    Gui_StreamBrowser2 streamBrowser = null;

    public Gui_Filter(Gui_StreamBrowser2 streamBrowser, boolean visible) {
        this.visible = visible;
        this.streamBrowser = streamBrowser;
        this.init();
        this.updateGuis();
        this.setLanguage();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.bitratePanel.setLayout(new GridBagLayout());
        this.typePanel.setLayout(new GridBagLayout());
        this.bitratePanel.setBorder(this.bitrateTitle);
        this.typePanel.setBorder(this.typeTitle);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.bitratePanel, c);
        c.gridy = 1;
        this.add((Component)this.typePanel, c);
        c.gridy = 2;
        c.weighty = 0.0;
        this.add((Component)this.filterNowButton, c);
        c.gridy = 3;
        c.weighty = 1.0;
        this.add((Component)new JLabel(), c);
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.bitratePanel.add((Component)this.filterBitrateCB, c);
        c.insets = new Insets(0, 10, 0, 0);
        c.gridwidth = 1;
        c.gridy = 1;
        this.bitratePanel.add((Component)this.minBitrateLabel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        this.bitratePanel.add((Component)this.minBitrateTF, c);
        c.gridy = 2;
        c.gridx = 0;
        c.insets = new Insets(0, 10, 0, 0);
        this.bitratePanel.add((Component)this.maxBitrateCBLabel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        this.bitratePanel.add((Component)this.maxBitrateTF, c);
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        this.typePanel.add((Component)this.filterTypeCB, c);
        c.gridy = 1;
        c.insets = new Insets(0, 10, 0, 0);
        this.typePanel.add((Component)this.showMP3Streams, c);
        c.gridy = 2;
        this.typePanel.add((Component)this.showAACStreams, c);
        c.gridy = 3;
        this.typePanel.add((Component)this.showUnknownStreams, c);
        this.filterBitrateCB.addActionListener(new ChangeStatusListener());
        this.filterTypeCB.addActionListener(new ChangeStatusListener());
        this.filterNowButton.addActionListener(new FilterListener());
        this.setVisible(this.visible);
    }

    private void setLanguage() {
        try {
            this.filterBitrateCB.setText(this.trans.getString("Filter.enableBitrateFilter"));
            this.filterTypeCB.setText(this.trans.getString("Filter.enableTypeFilter"));
            this.showMP3Streams.setText(this.trans.getString("Filter.StreamMP3"));
            this.showAACStreams.setText(this.trans.getString("Filter.StreamAAc"));
            this.showUnknownStreams.setText(this.trans.getString("Filter.StreamUnk"));
            this.minBitrateLabel.setText(this.trans.getString("Filter.minBit"));
            this.maxBitrateCBLabel.setText(this.trans.getString("Filter.maxBit"));
            this.filterNowButton.setText(this.trans.getString("Filter.FilterButton"));
            this.bitrateTitle.setTitle(this.trans.getString("Filter.Title.Bitrates"));
            this.typeTitle.setTitle(this.trans.getString("Filter.Title.Types"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public void updateGuis() {
        if (this.filterBitrateCB.isSelected()) {
            this.minBitrateLabel.setEnabled(true);
            this.maxBitrateCBLabel.setEnabled(true);
            this.maxBitrateTF.setEnabled(true);
            this.minBitrateTF.setEnabled(true);
        } else {
            this.minBitrateLabel.setEnabled(false);
            this.maxBitrateCBLabel.setEnabled(false);
            this.maxBitrateTF.setEnabled(false);
            this.minBitrateTF.setEnabled(false);
        }
        if (this.filterTypeCB.isSelected()) {
            this.showMP3Streams.setEnabled(true);
            this.showAACStreams.setEnabled(true);
            this.showUnknownStreams.setEnabled(true);
        } else {
            this.showMP3Streams.setEnabled(false);
            this.showAACStreams.setEnabled(false);
            this.showUnknownStreams.setEnabled(false);
        }
    }

    public void setFiltered(boolean newFilterStatus) {
        this.isFiltered = newFilterStatus;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public Vector<String[]> getFilteredStreamVector() {
        return this.streamsPG;
    }

    public void setFilterdStreamVector(Vector<String[]> vector) {
        this.streamsPG = vector;
    }

    public boolean filterBitratesIsEnabled() {
        return this.filterBitrateCB.isSelected();
    }

    public boolean filterTypesIsEnabled() {
        return this.filterTypeCB.isSelected();
    }

    public Vector<String[]> filterBitrates(Vector<String[]> oldStreams) {
        Vector<String[]> newStreams = new Vector<String[]>(0, 1);
        int minVal = 0;
        int maxVal = 0;
        int streamBitrate = -1;
        try {
            minVal = Integer.valueOf(this.minBitrateTF.getText());
            maxVal = Integer.valueOf(this.maxBitrateTF.getText());
            if (minVal < 0) {
                throw new NumberFormatException();
            }
            if (oldStreams.capacity() > 0) {
                int i = 0;
                while (i < oldStreams.capacity()) {
                    try {
                        streamBitrate = Integer.valueOf(oldStreams.get(i)[3]);
                    }
                    catch (NumberFormatException e) {
                        if (this.DEBUG) {
                            SRSOutput.getInstance().log("Wrong Bitrate in Stream");
                        }
                        streamBitrate = -1;
                    }
                    if (streamBitrate >= minVal && streamBitrate <= maxVal) {
                        newStreams.add(oldStreams.get(i));
                    }
                    ++i;
                }
            }
            return newStreams;
        }
        catch (NumberFormatException e) {
            if (this.DEBUG) {
                SRSOutput.getInstance().log("Wrong Bitrate in Stream");
            }
            JOptionPane.showMessageDialog(this.streamBrowser, "Wrong Value in a bitrate field");
            return null;
        }
    }

    public Vector<String[]> filterTypes(Vector<String[]> oldStreams) {
        Vector<String[]> newStreams = new Vector<String[]>(0, 1);
        if (oldStreams.capacity() > 0) {
            int i = 0;
            while (i < oldStreams.capacity()) {
                if (this.showMP3Streams.isSelected() && oldStreams.get(i)[4].toLowerCase().startsWith("mp3")) {
                    newStreams.add(oldStreams.get(i));
                } else if (this.showAACStreams.isSelected() && oldStreams.get(i)[4].startsWith("AAC+")) {
                    newStreams.add(oldStreams.get(i));
                } else if (this.showUnknownStreams.isSelected() && oldStreams.get(i)[4].trim().equals("")) {
                    newStreams.add(oldStreams.get(i));
                }
                ++i;
            }
        }
        return newStreams;
    }

    public String[] getSaveSettings() {
        String[] save = new String[]{String.valueOf(this.filterBitrateCB.isSelected()), String.valueOf(this.filterTypeCB.isSelected()), String.valueOf(this.showMP3Streams.isSelected()), String.valueOf(this.showAACStreams.isSelected()), String.valueOf(this.showUnknownStreams.isSelected()), String.valueOf(this.minBitrateTF.getText()), String.valueOf(this.maxBitrateTF.getText())};
        return save;
    }

    public void loadSettings(String[] settings) {
        this.filterBitrateCB.setSelected(Boolean.valueOf(settings[0]));
        this.filterTypeCB.setSelected(Boolean.valueOf(settings[1]));
        this.showMP3Streams.setSelected(Boolean.valueOf(settings[2]));
        this.showAACStreams.setSelected(Boolean.valueOf(settings[3]));
        this.showUnknownStreams.setSelected(Boolean.valueOf(settings[4]));
        this.minBitrateTF.setText(settings[5]);
        this.maxBitrateTF.setText(settings[6]);
    }

    class ChangeStatusListener
    implements ActionListener {
        ChangeStatusListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui_Filter.this.updateGuis();
        }
    }

    class FilterListener
    implements ActionListener {
        FilterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector<String[]> streamTmp = null;
            Gui_Filter.this.streamBrowser.setStatusText("Filter streams", false);
            Gui_Filter.this.streamsPG = Gui_Filter.this.streamBrowser.getControlHttp().getStreams();
            if (Gui_Filter.this.streamsPG != null && Gui_Filter.this.streamsPG.capacity() > 0) {
                if (Gui_Filter.this.streamBrowser.getFilterGui().filterBitratesIsEnabled() && (streamTmp = Gui_Filter.this.streamBrowser.getFilterGui().filterBitrates(Gui_Filter.this.streamsPG)) != null) {
                    Gui_Filter.this.streamsPG = streamTmp;
                }
                if (Gui_Filter.this.streamBrowser.getFilterGui().filterTypesIsEnabled() && Gui_Filter.this.streamBrowser.getFilterGui().filterTypesIsEnabled()) {
                    streamTmp = Gui_Filter.this.streamBrowser.getFilterGui().filterTypes(Gui_Filter.this.streamsPG);
                    Gui_Filter.this.streamsPG = streamTmp;
                }
                Gui_Filter.this.streamBrowser.removeAllFromTable(Gui_Filter.this.streamBrowser.getBrowseModel());
                if (Gui_Filter.this.streamBrowser.getFilterGui().filterTypesIsEnabled() || Gui_Filter.this.streamBrowser.getFilterGui().filterBitratesIsEnabled()) {
                    Gui_Filter.this.setFiltered(true);
                } else {
                    Gui_Filter.this.setFiltered(false);
                }
                int i = 0;
                while (i < Gui_Filter.this.streamsPG.capacity()) {
                    Object[] tmp = new Object[8];
                    tmp[0] = i;
                    tmp[1] = ((String[])Gui_Filter.this.streamsPG.get(i))[0];
                    tmp[2] = ((String[])Gui_Filter.this.streamsPG.get(i))[1];
                    tmp[3] = ((String[])Gui_Filter.this.streamsPG.get(i))[6];
                    try {
                        tmp[4] = Integer.valueOf(((String[])Gui_Filter.this.streamsPG.get(i))[2]);
                    }
                    catch (NumberFormatException f) {
                        tmp[4] = -1;
                    }
                    try {
                        tmp[5] = Integer.valueOf(((String[])Gui_Filter.this.streamsPG.get(i))[3]);
                    }
                    catch (NumberFormatException f) {
                        tmp[5] = -1;
                    }
                    tmp[6] = ((String[])Gui_Filter.this.streamsPG.get(i))[4];
                    tmp[7] = ((String[])Gui_Filter.this.streamsPG.get(i))[7];
                    Gui_Filter.this.streamBrowser.getBrowseModel().addRow(tmp);
                    ++i;
                }
                Gui_Filter.this.streamBrowser.setStatusText("Filter done!. Ready for new Action", false);
            }
        }
    }
}

