/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_PlayList;
import control.Control_Stream;
import control.SRSOutput;
import gui.Gui_JTTable;
import gui.Gui_StreamRipStar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import misc.Stream;

public class Export_Streams
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle toolTips = ResourceBundle.getBundle("translations.ToolTips");
    private JPanel mainPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private JPanel buttomPanel = new JPanel();
    private Object[] allHeader = new Object[]{"Available Streams", "ID"};
    private String[][] allData = new String[0][];
    private Object[] tableheader = new Object[]{"Streams to export", "ID"};
    private String[][] exportData = new String[0][];
    private DefaultTableModel allModel = new DefaultTableModel(this.allData, this.allHeader){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    };
    private DefaultTableModel exportModel = new DefaultTableModel(this.exportData, this.tableheader){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    };
    private Gui_JTTable allTable = new Gui_JTTable(this.allModel);
    private Gui_JTTable exportTable = new Gui_JTTable(this.exportModel);
    private JScrollPane allPane = new JScrollPane(this.allTable);
    private JScrollPane exportPane = new JScrollPane(this.exportTable);
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/abort_small.png"));
    private ImageIcon browseIcon = new ImageIcon(this.getClass().getResource("/Icons/open_small.png"));
    private ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/Icons/addmarked_small.png"));
    private ImageIcon addAllIcon = new ImageIcon(this.getClass().getResource("/Icons/addAll_small.png"));
    private ImageIcon removeIcon = new ImageIcon(this.getClass().getResource("/Icons/deletemarked_small.png"));
    private ImageIcon removeAllIcon = new ImageIcon(this.getClass().getResource("/Icons/deleteAll_small.png"));
    private ImageIcon exportIcon = new ImageIcon(this.getClass().getResource("/Icons/export_small.png"));
    private JButton addButton = new JButton(this.addIcon);
    private JButton addAllButton = new JButton(this.addAllIcon);
    private JButton removeButton = new JButton(this.removeIcon);
    private JButton removeAllButton = new JButton(this.removeAllIcon);
    private JButton browseButton = new JButton("Browse", this.browseIcon);
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JButton exportButton = new JButton("Export", this.exportIcon);
    private JLabel destLabel = new JLabel("Destination :");
    private JTextField exportPathField = new JTextField("myPlayList.pls");
    private JFileChooser dirChooser = new JFileChooser();
    private Control_Stream controlStream = null;
    private Gui_StreamRipStar mainGui;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");

    public Export_Streams(Control_Stream controlStream, Gui_StreamRipStar mainGui) {
        super((Frame)mainGui, "Exportiere Stream");
        this.controlStream = controlStream;
        this.mainGui = mainGui;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
        this.setLanguage();
        this.setToolTips();
        this.fillWithNames(this.allModel);
        this.allTable.getColumn(this.tableheader[1]).setMinWidth(0);
        this.allTable.getColumn(this.tableheader[1]).setMaxWidth(0);
        this.exportTable.getColumn(this.tableheader[1]).setMinWidth(0);
        this.exportTable.getColumn(this.tableheader[1]).setMaxWidth(0);
        this.setVisible(true);
    }

    private void init() {
        this.mainPanel.setLayout(new BorderLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.buttomPanel.setLayout(new GridBagLayout());
        this.add(this.mainPanel);
        this.mainPanel.add((Component)this.topPanel, "Center");
        this.mainPanel.add((Component)this.buttomPanel, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridheight = 5;
        c.gridy = 0;
        c.gridx = 0;
        this.topPanel.add((Component)this.allPane, c);
        c.weightx = 0.5;
        c.gridy = 0;
        c.gridx = 2;
        this.topPanel.add((Component)this.exportPane, c);
        c.insets = new Insets(50, 5, 5, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 1;
        this.topPanel.add((Component)this.addButton, c);
        c.insets = new Insets(5, 5, 25, 5);
        c.gridy = 1;
        this.topPanel.add((Component)this.addAllButton, c);
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 2;
        this.topPanel.add((Component)this.removeButton, c);
        c.gridy = 3;
        this.topPanel.add((Component)this.removeAllButton, c);
        c.weighty = 1.0;
        c.gridy = 4;
        this.topPanel.add((Component)new Label(""), c);
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        this.buttomPanel.add((Component)this.destLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.buttomPanel.add((Component)this.exportPathField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttomPanel.add((Component)this.browseButton, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        this.buttomPanel.add((Component)this.exportButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.buttomPanel.add((Component)new JLabel(""), c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttomPanel.add((Component)this.abortButton, c);
        this.addAllButton.addActionListener(new AddAllListener());
        this.removeAllButton.addActionListener(new RemoveAllListener());
        this.addButton.addActionListener(new AddSelectedListener());
        this.removeButton.addActionListener(new removeSelectedListener());
        this.abortButton.addActionListener(new AbortListener());
        this.browseButton.addActionListener(new BrowseListener());
        this.exportButton.addActionListener(new ExportListener());
        this.dirChooser.setFileFilter(new PlayListFilter());
        this.setDefaultCloseOperation(2);
        Dimension frameDim = new Dimension(600, 500);
        this.setSize(frameDim);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().registerKeyboardAction(new AbortListener(), escStroke, 2);
    }

    private void setLanguage() {
        try {
            this.setTitle(this.trans.getString("exportStream"));
            this.browseButton.setText(this.trans.getString("browse"));
            this.abortButton.setText(this.trans.getString("abortButton"));
            this.exportButton.setText(this.trans.getString("export"));
            this.destLabel.setText(this.trans.getString("destination"));
            this.exportPathField.setText(this.trans.getString("myPlayList"));
            this.allHeader[0] = this.trans.getString("exportAVHeader");
            this.tableheader[0] = this.trans.getString("exportHeader");
            this.allModel.setColumnIdentifiers(this.allHeader);
            this.exportModel.setColumnIdentifiers(this.tableheader);
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    private void setToolTips() {
        this.addButton.setToolTipText(this.toolTips.getString("Export.addButton"));
        this.addAllButton.setToolTipText(this.toolTips.getString("Export.addAllButton"));
        this.removeButton.setToolTipText(this.toolTips.getString("Export.removeButton"));
        this.removeAllButton.setToolTipText(this.toolTips.getString("Export.removeAllButton"));
        this.browseButton.setToolTipText(this.toolTips.getString("Export.browseButton"));
        this.abortButton.setToolTipText(this.toolTips.getString("Export.abortButton"));
        this.exportButton.setToolTipText(this.toolTips.getString("Export.exportButton"));
    }

    private void fillWithNames(DefaultTableModel model) {
        Vector<Stream> streamVector = this.controlStream.getStreamVector();
        int i = 0;
        while (i < streamVector.capacity()) {
            model.addRow(streamVector.get(i).getNameAsObject());
            ++i;
        }
    }

    private void removeAllNames(DefaultTableModel model) {
        int rowCount;
        int i = rowCount = model.getRowCount();
        while (i > 0) {
            model.removeRow(i - 1);
            --i;
        }
    }

    private void moveSelectedNames(DefaultTableModel removeModel, DefaultTableModel addModel, Gui_JTTable removeTable) {
        int i = removeTable.getSelectedRowCount();
        while (i > 0) {
            Object[] a = new Object[21];
            a[0] = removeModel.getValueAt(removeTable.getSelectedRows()[i - 1], 0);
            a[1] = removeModel.getValueAt(removeTable.getSelectedRows()[i - 1], 1);
            addModel.addRow(a);
            removeModel.removeRow(removeTable.getSelectedRows()[i - 1]);
            --i;
        }
    }

    private Export_Streams getMe() {
        return this;
    }

    class AbortListener
    implements ActionListener {
        AbortListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Export_Streams.this.dispose();
        }
    }

    class AddAllListener
    implements ActionListener {
        AddAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Export_Streams.this.allModel.getRowCount() > 0) {
                Export_Streams.this.removeAllNames(Export_Streams.this.allModel);
                Export_Streams.this.removeAllNames(Export_Streams.this.exportModel);
                Export_Streams.this.fillWithNames(Export_Streams.this.exportModel);
            }
        }
    }

    class AddSelectedListener
    implements ActionListener {
        AddSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Export_Streams.this.moveSelectedNames(Export_Streams.this.allModel, Export_Streams.this.exportModel, Export_Streams.this.allTable);
        }
    }

    class BrowseListener
    implements ActionListener {
        BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Export_Streams.this.dirChooser.setFileSelectionMode(0);
            int i = Export_Streams.this.dirChooser.showOpenDialog(Export_Streams.this.getMe());
            if (i == 0) {
                if (Export_Streams.this.dirChooser.getSelectedFile().toString().toLowerCase().endsWith(".pls")) {
                    Export_Streams.this.exportPathField.setText(Export_Streams.this.dirChooser.getSelectedFile().toString());
                } else if (Export_Streams.this.dirChooser.getSelectedFile().toString().toLowerCase().endsWith(".m3u")) {
                    Export_Streams.this.exportPathField.setText(Export_Streams.this.dirChooser.getSelectedFile().toString());
                } else {
                    Export_Streams.this.exportPathField.setText(String.valueOf(Export_Streams.this.dirChooser.getSelectedFile().toString()) + ".pls");
                }
            }
        }
    }

    class ExportListener
    implements ActionListener {
        ExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int streamCount = Export_Streams.this.exportModel.getRowCount();
            if (streamCount > 0) {
                String path = Export_Streams.this.exportPathField.getText();
                String[][] exportData = new String[streamCount][3];
                String writePlayList = "";
                int i = 0;
                while (i < streamCount) {
                    int streamID = Integer.valueOf(Export_Streams.this.exportModel.getValueAt(i, 1).toString());
                    Stream stream = Export_Streams.this.mainGui.getTabel().getStreamByID(streamID);
                    exportData[i][0] = stream.name;
                    exportData[i][1] = stream.address;
                    exportData[i][2] = stream.website;
                    ++i;
                }
                if (Export_Streams.this.exportPathField.getText().toLowerCase().endsWith(".pls")) {
                    writePlayList = new Control_PlayList().getPLSData(exportData);
                }
                if (Export_Streams.this.exportPathField.getText().toLowerCase().endsWith(".m3u")) {
                    writePlayList = new Control_PlayList().getM3UData(exportData);
                }
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(path));
                    bw.write(writePlayList);
                    bw.close();
                }
                catch (FileNotFoundException f) {
                    SRSOutput.getInstance().logE(f.getMessage());
                }
                catch (IOException g) {
                    SRSOutput.getInstance().logE(g.getMessage());
                }
                JOptionPane.showMessageDialog(Export_Streams.this.getMe(), Export_Streams.this.trans.getString("succExport"));
                Export_Streams.this.dispose();
            } else {
                JOptionPane.showMessageDialog(Export_Streams.this.getMe(), Export_Streams.this.trans.getString("lowExportCount"));
            }
        }
    }

    class PlayListFilter
    extends FileFilter {
        PlayListFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".pls") || f.getName().toLowerCase().endsWith(".m3u");
        }

        @Override
        public String getDescription() {
            return ".pls .m3u";
        }
    }

    class RemoveAllListener
    implements ActionListener {
        RemoveAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Export_Streams.this.exportModel.getRowCount() > 0) {
                Export_Streams.this.removeAllNames(Export_Streams.this.exportModel);
                Export_Streams.this.removeAllNames(Export_Streams.this.allModel);
                Export_Streams.this.fillWithNames(Export_Streams.this.allModel);
            }
        }
    }

    class removeSelectedListener
    implements ActionListener {
        removeSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Export_Streams.this.moveSelectedNames(Export_Streams.this.exportModel, Export_Streams.this.allModel, Export_Streams.this.exportTable);
        }
    }
}

