/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_Stream;
import control.SRSOutput;
import gui.Gui_SchedulManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.DateFormatter;
import misc.SchedulJob;
import misc.Stream;
import thread.Thread_Control_Schedules;

public class Add_Schedule_Task
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private ImageIcon abortIcon = new ImageIcon(this.getClass().getResource("/Icons/abort_small.png"));
    private ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/Icons/ok_small.png"));
    private JPanel datePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JFormattedTextField startTimeTF = null;
    private JFormattedTextField stopTimeTF = null;
    private JFormattedTextField startDateTF = null;
    private JFormattedTextField stopDateTF = null;
    private JTextField commentTF = new JTextField();
    private JButton addButton = new JButton("OK", this.addIcon);
    private JButton abortButton = new JButton("Abort", this.abortIcon);
    private JLabel startTimeLabel = new JLabel("Start Time:  At");
    private JLabel stopTimeLabel = new JLabel("Stop Time:   At");
    private JLabel atStartTime = new JLabel("  At");
    private JLabel atStopTime = new JLabel("  At");
    private JLabel commentLabel = new JLabel("Comment");
    private JCheckBox enableCB = new JCheckBox("Enable this job", true);
    private JCheckBox onceCB = new JCheckBox("once", true);
    private JCheckBox dailyCB = new JCheckBox("daily");
    private JCheckBox weeklyCB = new JCheckBox("weekly");
    private JCheckBox atStartCB = new JCheckBox("at Start");
    private JComboBox<String> nameBox;
    private String[] streamNames;
    private String[] streamNames_short;
    private final int MAX_STREAM_NAME_LENGTH = 40;
    private Vector<Stream> streams;
    private boolean createNew = false;
    private SchedulJob oldJob = null;
    private Thread_Control_Schedules controlJob = null;
    private Gui_SchedulManager schedulManager = null;

    public Add_Schedule_Task(Gui_SchedulManager schedulManager, boolean createNew, Control_Stream controlStreams, Thread_Control_Schedules controlJob, SchedulJob oldJob) {
        super((Frame)schedulManager, "Add Schedule Job");
        DateFormat df3;
        this.schedulManager = schedulManager;
        this.createNew = createNew;
        this.controlJob = controlJob;
        this.oldJob = oldJob;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLanguage();
        this.addWindowListener(this);
        ButtonGroup howOftenGroup = new ButtonGroup();
        howOftenGroup.add(this.onceCB);
        howOftenGroup.add(this.dailyCB);
        howOftenGroup.add(this.weeklyCB);
        howOftenGroup.add(this.atStartCB);
        if (createNew) {
            Calendar now = Calendar.getInstance();
            now.setTimeInMillis(System.currentTimeMillis());
            DateFormat df = DateFormat.getDateInstance(3);
            this.startDateTF = new JFormattedTextField(new DateFormatter(df));
            this.startDateTF.setText(DateFormat.getDateInstance(3).format(now.getTime()));
            DateFormat df2 = DateFormat.getDateInstance(3);
            this.stopDateTF = new JFormattedTextField(new DateFormatter(df2));
            this.stopDateTF.setText(DateFormat.getDateInstance(3).format(now.getTime()));
            df3 = DateFormat.getTimeInstance(3);
            this.startTimeTF = new JFormattedTextField(new DateFormatter(df3));
            this.startTimeTF.setText(DateFormat.getTimeInstance(3).format(now.getTime()));
            DateFormat df4 = DateFormat.getTimeInstance(3);
            this.stopTimeTF = new JFormattedTextField(new DateFormatter(df4));
            this.stopTimeTF.setText(DateFormat.getTimeInstance(3).format(now.getTime()));
            this.streams = controlStreams.getStreamVector();
            this.streamNames = new String[this.streams.capacity()];
            this.streamNames_short = new String[this.streams.capacity()];
            int i = 0;
            while (i < this.streams.capacity()) {
                this.streamNames[i] = this.streams.get((int)i).name;
                this.streamNames_short[i] = this.streamNames[i].length() >= 40 ? String.valueOf(this.streamNames[i].substring(0, 40)) + "..." : this.streamNames[i];
                ++i;
            }
            this.nameBox = new JComboBox<String>(this.streamNames_short);
        } else {
            int howOften = oldJob.getJobCount();
            if (howOften == 0) {
                this.dailyCB.setSelected(true);
            } else if (howOften == 1) {
                this.weeklyCB.setSelected(true);
            } else if (howOften == 3) {
                this.atStartCB.setSelected(true);
            }
            this.commentTF.setText(oldJob.getComment());
            Calendar now = Calendar.getInstance();
            now.setTimeInMillis(oldJob.getStartTime());
            DateFormat df = DateFormat.getDateInstance(3);
            this.startDateTF = new JFormattedTextField(new DateFormatter(df));
            this.startDateTF.setText(DateFormat.getDateInstance(3).format(now.getTime()));
            df3 = DateFormat.getTimeInstance(3);
            this.startTimeTF = new JFormattedTextField(new DateFormatter(df3));
            this.startTimeTF.setText(DateFormat.getTimeInstance(3).format(now.getTime()));
            now.setTimeInMillis(oldJob.getStopTime());
            DateFormat df2 = DateFormat.getDateInstance(3);
            this.stopDateTF = new JFormattedTextField(new DateFormatter(df2));
            this.stopDateTF.setText(DateFormat.getDateInstance(3).format(now.getTime()));
            DateFormat df4 = DateFormat.getTimeInstance(3);
            this.stopTimeTF = new JFormattedTextField(new DateFormatter(df4));
            this.stopTimeTF.setText(DateFormat.getTimeInstance(3).format(now.getTime()));
            this.streams = controlStreams.getStreamVector();
            this.streamNames = new String[this.streams.capacity()];
            this.streamNames_short = new String[this.streams.capacity()];
            int i = 0;
            while (i < this.streams.capacity()) {
                this.streamNames[i] = this.streams.get((int)i).name;
                this.streamNames_short[i] = this.streamNames[i].length() >= 40 ? String.valueOf(this.streamNames[i].substring(0, 40)) + "..." : this.streamNames[i];
                ++i;
            }
            this.nameBox = new JComboBox<String>(this.streamNames_short);
            i = 0;
            while (i < this.streams.capacity()) {
                if (this.streams.get((int)i).id == oldJob.getStreamID()) {
                    this.nameBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            this.enableCB.setSelected(oldJob.isJobenabled());
        }
        this.setLayout(new BorderLayout());
        this.datePanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.add((Component)this.datePanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.datePanel.add(this.nameBox, c);
        c.gridy = 1;
        c.weightx = 0.0;
        this.datePanel.add((Component)new JLabel(" "), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridy = 2;
        c.gridx = 0;
        this.datePanel.add((Component)this.startTimeLabel, c);
        c.gridx = 1;
        this.datePanel.add((Component)this.startDateTF, c);
        c.gridx = 2;
        this.datePanel.add((Component)this.atStartTime, c);
        c.gridx = 3;
        this.datePanel.add((Component)this.startTimeTF, c);
        c.gridy = 3;
        c.gridx = 0;
        this.datePanel.add((Component)this.stopTimeLabel, c);
        c.gridx = 1;
        this.datePanel.add((Component)this.stopDateTF, c);
        c.gridx = 2;
        this.datePanel.add((Component)this.atStopTime, c);
        c.gridx = 3;
        this.datePanel.add((Component)this.stopTimeTF, c);
        c.gridy = 4;
        this.datePanel.add((Component)new JLabel(" "), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 5;
        c.gridx = 0;
        c.gridwidth = 5;
        this.datePanel.add((Component)this.onceCB, c);
        c.gridy = 6;
        this.datePanel.add((Component)this.dailyCB, c);
        c.gridy = 7;
        this.datePanel.add((Component)this.weeklyCB, c);
        c.gridy = 8;
        this.datePanel.add((Component)this.atStartCB, c);
        c.gridwidth = 1;
        c.gridy = 8;
        this.datePanel.add((Component)new JLabel(" "), c);
        c.gridy = 9;
        this.datePanel.add((Component)this.commentLabel, c);
        c.gridwidth = 5;
        c.gridx = 1;
        this.datePanel.add((Component)this.commentTF, c);
        c.gridy = 10;
        c.gridx = 0;
        this.datePanel.add((Component)new JLabel(" "), c);
        c.gridy = 11;
        this.datePanel.add((Component)this.enableCB, c);
        c.insets = new Insets(7, 7, 7, 7);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        this.buttonPanel.add((Component)this.addButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.buttonPanel.add((Component)new JLabel(" "), c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttonPanel.add((Component)this.abortButton, c);
        this.nameBox.setRenderer(new MyComboBoxRenderer());
        this.addButton.addActionListener(new AddListener());
        this.abortButton.addActionListener(new AbortListener());
        this.atStartCB.addChangeListener(new AtStartChangeListener());
        this.checkAtStartStatus();
        this.setDefaultCloseOperation(0);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        Dimension windowDim = this.getSize();
        int x = (screenDim.width - windowDim.width) / 2;
        int y = (screenDim.height - windowDim.height) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void setLanguage() {
        try {
            this.setTitle(this.trans.getString("AddJob.Title"));
            this.addButton.setText(this.trans.getString("AddJob.addButton"));
            this.abortButton.setText(this.trans.getString("AddJob.abortButton"));
            this.startTimeLabel.setText(this.trans.getString("AddJob.startTimeLabel"));
            this.stopTimeLabel.setText(this.trans.getString("AddJob.stopTimeLabel"));
            this.atStartTime.setText("   " + this.trans.getString("AddJob.atStartTime"));
            this.atStopTime.setText("   " + this.trans.getString("AddJob.atStopTime"));
            this.commentLabel.setText(this.trans.getString("AddJob.commentLabel"));
            this.enableCB.setText(this.trans.getString("AddJob.enableCB"));
            this.onceCB.setText(this.trans.getString("AddJob.onceCB"));
            this.dailyCB.setText(this.trans.getString("AddJob.dailyCB"));
            this.weeklyCB.setText(this.trans.getString("AddJob.weeklyCB"));
            this.atStartCB.setText(this.trans.getString("AddJob.atStartCB"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void checkAtStartStatus() {
        if (this.atStartCB.isSelected()) {
            this.startTimeLabel.setEnabled(false);
            this.stopTimeLabel.setEnabled(false);
            this.atStartTime.setEnabled(false);
            this.atStopTime.setEnabled(false);
            this.startTimeTF.setEnabled(false);
            this.stopTimeTF.setEnabled(false);
            this.startDateTF.setEnabled(false);
            this.stopDateTF.setEnabled(false);
        } else {
            this.startTimeLabel.setEnabled(true);
            this.stopTimeLabel.setEnabled(true);
            this.atStartTime.setEnabled(true);
            this.atStopTime.setEnabled(true);
            this.startTimeTF.setEnabled(true);
            this.stopTimeTF.setEnabled(true);
            this.startDateTF.setEnabled(true);
            this.stopDateTF.setEnabled(true);
        }
    }

    public class AbortListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Add_Schedule_Task.this.dispose();
        }
    }

    public class AddListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            DateFormat df = DateFormat.getDateInstance(3);
            DateFormat tf = DateFormat.getTimeInstance(3);
            try {
                Calendar now = Calendar.getInstance();
                Calendar now2 = Calendar.getInstance();
                Date recDate = df.parse(Add_Schedule_Task.this.startDateTF.getText());
                Date recTime = tf.parse(Add_Schedule_Task.this.startTimeTF.getText());
                now.setTime(recDate);
                now2.setTime(recTime);
                now.set(11, now2.get(11));
                now.set(12, now2.get(12));
                Calendar now3 = Calendar.getInstance();
                Calendar now4 = Calendar.getInstance();
                Date stopRecDate = df.parse(Add_Schedule_Task.this.stopDateTF.getText());
                Date stopRecTime = tf.parse(Add_Schedule_Task.this.stopTimeTF.getText());
                now3.setTime(stopRecDate);
                now4.setTime(stopRecTime);
                now3.set(11, now4.get(11));
                now3.set(12, now4.get(12));
                int howOften = -1;
                if (Add_Schedule_Task.this.dailyCB.isSelected()) {
                    howOften = 0;
                } else if (Add_Schedule_Task.this.weeklyCB.isSelected()) {
                    howOften = 1;
                } else if (Add_Schedule_Task.this.atStartCB.isSelected()) {
                    howOften = 3;
                }
                int index = ((Stream)((Add_Schedule_Task)Add_Schedule_Task.this).streams.get((int)((Add_Schedule_Task)Add_Schedule_Task.this).nameBox.getSelectedIndex())).id;
                if (Add_Schedule_Task.this.createNew) {
                    if (!Add_Schedule_Task.this.controlJob.testOverlappingRecordTime(index, now.getTimeInMillis(), now3.getTimeInMillis())) {
                        SchedulJob job = new SchedulJob(SchedulJob.getNewID(), index, now.getTimeInMillis(), now3.getTimeInMillis(), howOften, Add_Schedule_Task.this.enableCB.isSelected(), Add_Schedule_Task.this.commentTF.getText());
                        Add_Schedule_Task.this.controlJob.addToSchedulVector(job);
                        Add_Schedule_Task.this.schedulManager.addSchedulJobToTable(job);
                        Add_Schedule_Task.this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(Add_Schedule_Task.this, Add_Schedule_Task.this.trans.getString("AddJob.AlreadyExist"));
                    }
                } else if (Add_Schedule_Task.this.controlJob.jobStillExist(Add_Schedule_Task.this.oldJob.getSchedulID()).booleanValue()) {
                    Add_Schedule_Task.this.oldJob.setComment(Add_Schedule_Task.this.commentTF.getText());
                    Add_Schedule_Task.this.oldJob.setJobCounts(howOften);
                    Add_Schedule_Task.this.oldJob.setJobEnabled(Add_Schedule_Task.this.enableCB.isSelected());
                    Add_Schedule_Task.this.oldJob.setStartTime(now.getTimeInMillis());
                    Add_Schedule_Task.this.oldJob.setStopTime(now3.getTimeInMillis());
                    Add_Schedule_Task.this.oldJob.setStreamID(index);
                    Add_Schedule_Task.this.controlJob.saveScheduleVector();
                    Add_Schedule_Task.this.schedulManager.updateTable(Add_Schedule_Task.this.oldJob);
                    Add_Schedule_Task.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(Add_Schedule_Task.this, Add_Schedule_Task.this.trans.getString("jobDoesntExistAnymore"));
                }
            }
            catch (ParseException e1) {
                SRSOutput.getInstance().logE(e1.getStackTrace().toString());
            }
            catch (MissingResourceException f) {
                SRSOutput.getInstance().logE(f.getStackTrace().toString());
            }
        }
    }

    private class AtStartChangeListener
    implements ChangeListener {
        private AtStartChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Add_Schedule_Task.this.checkAtStartStatus();
        }
    }

    private class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 8399268144344845430L;

        private MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(Add_Schedule_Task.this.streamNames[index]);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

