/*
 * Decompiled with CFR 0.152.
 */
package gui;

import control.Control_Stream;
import control.SRSOutput;
import guiPrefs.SRSButton;
import guiPrefs.SRSLabel;
import guiPrefs.SRSPanel;
import guiPrefs.SRSTextArea;
import guiPrefs.SRSTextfield;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class About_StreamRipStar
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle trans = ResourceBundle.getBundle("translations.StreamRipStar");
    private Control_Stream controlStreams = null;
    private SRSLabel programming = new SRSLabel("Programming :");
    private SRSTextfield programmerName = new SRSTextfield("Johannes Putzke (die_eule@gmx.net");
    private SRSLabel IconsAndGrap = new SRSLabel("Icons and Graphics :");
    private SRSTextArea iconAndGrapName = new SRSTextArea("Christian Putzke (EdMolf) - Icons Mainwindow,\nLogo and other graphics\nOxygen Icon Projekt - Streambrowser, Updatedialog");
    private SRSLabel license = new SRSLabel("License :");
    private SRSTextfield licenceName = new SRSTextfield("GPLV3");
    private SRSLabel version = new SRSLabel("Version :");
    private SRSTextfield versionName = new SRSTextfield("0.6.10");
    private SRSLabel frenchTranslation = new SRSLabel("French Translation :");
    private SRSTextfield frenchTranslationName = new SRSTextfield("Philippe Augustin");
    private SRSLabel streamRipStarSourceforgeSite = new SRSLabel("StreamRipStars Projektpage :");
    private SRSTextfield streamRipStarSourceforgeAddress = new SRSTextfield("https://github.com/Eule/StreamRipStar");
    private SRSLabel streamRipStarHomepage = new SRSLabel("StreamRipStars Wiki :");
    private SRSTextfield streamRipStarHomepageAddress = new SRSTextfield("https://github.com/Eule/StreamRipStar/wiki");
    private SRSLabel edmolfHomepage = new SRSLabel("EdMolfs Homepage");
    private SRSTextfield edmolfHomepageAddress = new SRSTextfield("http://www.edmolf.net");
    private SRSLabel streamripperHomepage = new SRSLabel("Streamrippers Homepage");
    private SRSTextfield streamripperHomepageAddress = new SRSTextfield("https://github.com/Eule/StreamRipStar");
    private SRSLabel externPrograms = new SRSLabel("Extern Programms");
    private SRSTextArea externProgramsTA = new SRSTextArea("gstreamer-java (GPL)\nsimple JSON (Apache 2.0)");
    private SRSLabel copyRight = new SRSLabel("Copyright @ Johannes Putzke");
    private SRSLabel BannerLabel = new SRSLabel(new ImageIcon(this.getClass().getResource("/Icons/aboutDialog/logo.png")), 0);
    private SRSButton OKButton = new SRSButton("OK");

    public About_StreamRipStar(Control_Stream controlStreams, JFrame mainWindow) {
        super(mainWindow);
        this.controlStreams = controlStreams;
        ImageIcon tmpIcon = new ImageIcon(this.getClass().getResource("/Icons/aboutDialog/hintergrund.png"));
        SRSPanel panel = new SRSPanel(tmpIcon.getImage());
        this.add(panel);
        panel.setLayout(new GridBagLayout());
        Dimension frameDim = new Dimension(tmpIcon.getIconWidth(), tmpIcon.getIconHeight());
        this.setSize(frameDim);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weighty = 0.0;
        panel.add((Component)this.BannerLabel, c);
        c.weighty = 0.5;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)new SRSLabel(""), c);
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        panel.add((Component)this.programming, c);
        c.gridx = 1;
        panel.add((Component)this.programmerName, c);
        c.gridx = 0;
        c.gridy = 3;
        panel.add((Component)this.IconsAndGrap, c);
        c.gridx = 1;
        panel.add((Component)this.iconAndGrapName, c);
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)this.license, c);
        c.gridx = 1;
        panel.add((Component)this.licenceName, c);
        c.gridx = 0;
        c.gridy = 5;
        panel.add((Component)this.version, c);
        c.gridx = 1;
        panel.add((Component)this.versionName, c);
        c.gridx = 0;
        c.gridy = 6;
        panel.add((Component)this.frenchTranslation, c);
        c.gridx = 1;
        panel.add((Component)this.frenchTranslationName, c);
        c.gridx = 0;
        c.gridy = 7;
        panel.add((Component)this.streamRipStarSourceforgeSite, c);
        c.gridx = 1;
        panel.add((Component)this.streamRipStarSourceforgeAddress, c);
        c.gridx = 0;
        c.gridy = 8;
        panel.add((Component)this.streamRipStarHomepage, c);
        c.gridx = 1;
        panel.add((Component)this.streamRipStarHomepageAddress, c);
        c.gridx = 0;
        c.gridy = 9;
        panel.add((Component)this.streamripperHomepage, c);
        c.gridx = 1;
        panel.add((Component)this.streamripperHomepageAddress, c);
        c.gridx = 0;
        c.gridy = 10;
        panel.add((Component)this.edmolfHomepage, c);
        c.gridx = 1;
        panel.add((Component)this.edmolfHomepageAddress, c);
        c.gridy = 11;
        c.gridx = 0;
        panel.add((Component)this.externPrograms, c);
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.externProgramsTA, c);
        c.gridy = 12;
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.copyRight, c);
        c.gridx = 0;
        c.gridy = 13;
        c.weighty = 0.5;
        panel.add((Component)new SRSLabel(""), c);
        c.insets = new Insets(10, 10, 10, 10);
        c.weighty = 0.0;
        c.gridy = 14;
        panel.add((Component)this.OKButton, c);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().registerKeyboardAction(new OKListener(), escStroke, 2);
        this.OKButton.addActionListener(new OKListener());
        this.streamRipStarSourceforgeAddress.addMouseListener(new OpenWebSiteListener());
        this.streamRipStarHomepageAddress.addMouseListener(new OpenWebSiteListener());
        this.edmolfHomepageAddress.addMouseListener(new OpenWebSiteListener());
        this.streamripperHomepageAddress.addMouseListener(new OpenWebSiteListener());
        this.setLanguage();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - frameDim.width) / 2;
        int y = (screenDim.height - frameDim.height) / 2;
        this.setLocation(x, y);
        this.makeEditable(false);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void makeEditable(Boolean edit) {
        this.programmerName.setEditable(edit);
        this.iconAndGrapName.setEditable(edit);
        this.licenceName.setEditable(edit);
        this.versionName.setEditable(edit);
        this.streamRipStarSourceforgeAddress.setEditable(edit);
        this.streamRipStarHomepageAddress.setEditable(edit);
        this.edmolfHomepageAddress.setEditable(edit);
        this.streamripperHomepageAddress.setEditable(edit);
        this.externProgramsTA.setEditable(edit);
    }

    public void setLanguage() {
        try {
            this.setTitle(this.trans.getString("about"));
            this.programming.setText(this.trans.getString("programming"));
            this.IconsAndGrap.setText(this.trans.getString("IconsAndGrap"));
            this.license.setText(this.trans.getString("license"));
            this.version.setText(this.trans.getString("version"));
            this.frenchTranslation.setText(this.trans.getString("frenchTranslation"));
            this.streamRipStarSourceforgeSite.setText(this.trans.getString("streamRipStarSourceforgeSite"));
            this.streamRipStarHomepage.setText(this.trans.getString("streamRipStarHomepage"));
            this.externPrograms.setText(this.trans.getString("about.externPrograms"));
        }
        catch (MissingResourceException e) {
            SRSOutput.getInstance().logE(e.getMessage());
        }
    }

    public class OKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            About_StreamRipStar.this.dispose();
        }
    }

    public class OpenWebSiteListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            About_StreamRipStar.this.controlStreams.startWebBrowser(((SRSTextfield)e.getSource()).getText());
        }
    }
}

