/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Control_GetPath;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class SRSOutput {
    private int logLevel = 1;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd '-' HH:mm:ss ");
    private static SRSOutput instance = null;
    private BufferedWriter writer = null;
    private String path = "";
    private Vector<String> tmpMessages = new Vector(0, 1);
    private boolean hasInitDone = false;

    private SRSOutput() {
    }

    private void init() {
        try {
            Boolean append = true;
            this.path = String.valueOf(new Control_GetPath().getStreamRipStarPath()) + "/output.log";
            File logFile = new File(this.path);
            if (logFile.length() > 500000L) {
                append = false;
            }
            this.writer = new BufferedWriter(new FileWriter(this.path, (boolean)append));
            this.log("StreamRipStar in version 0.6.10 and revision 613 has been started");
            this.log("\n\n=== now the old messages from start ====\n\n");
            int i = 0;
            while (i < this.tmpMessages.capacity()) {
                this.log(this.tmpMessages.get(i));
                ++i;
            }
            this.log("\n\n=== old messages done! ====\n\n");
            this.tmpMessages.removeAllElements();
            this.tmpMessages.setSize(0);
            this.tmpMessages.trimToSize();
            this.hasInitDone = true;
        }
        catch (IOException e) {
            System.err.println("Error in SRSOutput: Can't open the file for StreamRipStar");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Error in SRSOutput: Unkown error");
            e.printStackTrace();
        }
    }

    private void deInit() {
        try {
            this.writer.close();
            this.hasInitDone = false;
        }
        catch (IOException e) {
            System.err.println("Error in SRSOutput: Can't close writer: " + this.path);
            e.printStackTrace();
        }
    }

    public static SRSOutput getInstance() {
        if (instance == null) {
            instance = new SRSOutput();
        }
        if (!SRSOutput.instance.hasInitDone) {
            instance.init();
        }
        return instance;
    }

    public void setLoglevel(LOGLEVEL loglevel) {
        this.logLevel = loglevel == LOGLEVEL.Nothing ? -1 : (loglevel == LOGLEVEL.Error ? 0 : (loglevel == LOGLEVEL.Normal ? 1 : (loglevel == LOGLEVEL.Debug ? 2 : 1)));
    }

    public LOGLEVEL getLoglevel() {
        if (this.logLevel == -1) {
            return LOGLEVEL.Nothing;
        }
        if (this.logLevel == 0) {
            return LOGLEVEL.Error;
        }
        if (this.logLevel == 1) {
            return LOGLEVEL.Normal;
        }
        if (this.logLevel == 2) {
            return LOGLEVEL.Debug;
        }
        return LOGLEVEL.Normal;
    }

    public synchronized boolean log(String logMessage) {
        if (this.logLevel >= 1) {
            try {
                System.out.println(logMessage);
                this.writer.write(String.valueOf(this.formatter.format(new Date())) + ":\n" + logMessage + "\n\n");
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public synchronized boolean logE(String logMessage) {
        if (this.logLevel >= 0) {
            try {
                System.err.println("Error: " + logMessage);
                this.writer.write("Error: " + this.formatter.format(new Date()) + ":\n" + logMessage + "\n\n");
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public synchronized boolean logD(String logMessage) {
        if (this.logLevel >= 2) {
            try {
                System.out.println("Debug: " + logMessage);
                this.writer.write("Debug: " + this.formatter.format(new Date()) + ":\n" + logMessage + "\n\n");
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public synchronized void deleteLogFile() {
        this.deInit();
        try {
            File outPutFile = new File(this.path);
            outPutFile.delete();
        }
        catch (NullPointerException e) {
            SRSOutput.logTemp("SRSOutput: NullpointerException while deleting the old log file");
        }
        this.init();
    }

    public static synchronized void logTemp(String logMessage) {
        if (instance == null) {
            instance = new SRSOutput();
        }
        System.err.println("Error: " + logMessage);
        SRSOutput.instance.tmpMessages.add(logMessage);
    }

    public static enum LOGLEVEL {
        Nothing,
        Error,
        Normal,
        Debug;

    }
}

