/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.SRSOutput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Control_http_Shoutcast_3 {
    private BufferedReader bw = null;
    private InputStream readGenresStream = null;
    private InputStream readStream = null;
    private String text = "";
    private Vector<String[]> streams = new Vector(0, 1);
    private Boolean stopSearching = false;
    private int currentPage = 0;
    private int totalPages = 0;

    public void resetPages() {
        this.currentPage = 0;
        this.totalPages = 0;
    }

    public void nextPage() {
        if (this.totalPages > this.currentPage) {
            ++this.currentPage;
        }
    }

    public void prevoiousPage() {
        if (this.currentPage >= 1) {
            --this.currentPage;
        }
    }

    public int getCurrentPage() {
        return this.currentPage + 1;
    }

    public int getTotalPages() {
        return this.totalPages + 1;
    }

    public int[] getPages() {
        int[] pages = new int[]{this.currentPage, this.totalPages};
        return pages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getfirstStreamFromURL(String streamURL) {
        String url = "";
        String tmp = "";
        Boolean breakLook = false;
        try {
            try {
                URL stream = new URL(streamURL);
                this.readStream = stream.openStream();
                this.bw = new BufferedReader(new InputStreamReader(this.readStream));
                while (breakLook == false) {
                    tmp = this.bw.readLine();
                    if (tmp == null) {
                        return url;
                    }
                    if (tmp.contains("File")) {
                        int startAddress = tmp.indexOf("=");
                        url = tmp.substring(startAddress + 1);
                        breakLook = true;
                        continue;
                    }
                    if (!tmp.contains("http://")) continue;
                    url = tmp;
                    breakLook = true;
                }
                return url;
            }
            catch (Exception e) {
                SRSOutput.getInstance().log("Could not get the playlist file from server");
                if (this.readStream == null) return null;
                try {
                    this.readStream.close();
                    return null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            if (this.readStream != null) {
                try {
                    this.readStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void getStreamsPerGenre(String genre, String keyword) {
        this.streams.removeAllElements();
        this.streams.trimToSize();
        try {
            try {
                URL url;
                String data = "";
                if (!genre.trim().equals("") || genre == null) {
                    data = String.valueOf(data) + URLEncoder.encode("genrename", "UTF-8") + "=" + URLEncoder.encode(genre, "UTF-8");
                    url = new URL("https://directory.shoutcast.com/Home/BrowseByGenre");
                } else {
                    data = String.valueOf(data) + URLEncoder.encode("query", "UTF-8") + "=" + URLEncoder.encode(keyword, "UTF-8");
                    url = new URL("https://directory.shoutcast.com/Search/UpdateSearch");
                }
                SRSOutput.getInstance().logD("Shoutcast query for genres: " + url);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
                wr.close();
                this.bw = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                JSONArray jsonStreams = (JSONArray)new JSONParser().parse(this.bw);
                SRSOutput.getInstance().logD("SIZE: " + jsonStreams.size());
                int i = 0;
                while (i < jsonStreams.size()) {
                    try {
                        if (this.stopSearching.booleanValue()) {
                            break;
                        }
                        String[] streamInfo = new String[8];
                        streamInfo[0] = (String)((JSONObject)jsonStreams.get(i)).get("Name");
                        streamInfo[1] = (String)((JSONObject)jsonStreams.get(i)).get("CurrentTrack");
                        streamInfo[2] = String.valueOf((Long)((JSONObject)jsonStreams.get(i)).get("Listeners"));
                        streamInfo[3] = String.valueOf((Long)((JSONObject)jsonStreams.get(i)).get("Bitrate"));
                        streamInfo[4] = (String)((JSONObject)jsonStreams.get(i)).get("Format");
                        streamInfo[5] = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=" + String.valueOf((Long)((JSONObject)jsonStreams.get(i)).get("ID"));
                        streamInfo[6] = (String)((JSONObject)jsonStreams.get(i)).get("Genre");
                        if (streamInfo[4].equals("audio/mpeg")) {
                            streamInfo[4] = "MP3";
                        } else if (streamInfo[4].equals("audio/aacp")) {
                            streamInfo[4] = "AAC+";
                        }
                        this.streams.add(streamInfo);
                    }
                    catch (NullPointerException e) {
                        SRSOutput.getInstance().logE("Error while loading from shoutcast website: NullPointer");
                        SRSOutput.getInstance().logE("Current text string was: " + this.text);
                        e.printStackTrace();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        SRSOutput.getInstance().logE("Error while loading from shoutcast website: IndexOutOfBoundsException");
                        SRSOutput.getInstance().logE("Current text string was: " + this.text);
                        e.printStackTrace();
                    }
                    catch (NumberFormatException e) {
                        SRSOutput.getInstance().logE("Controled Crash in StreamBrowser");
                        SRSOutput.getInstance().logE("Current text string was: " + this.text);
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (ParseException e) {
                SRSOutput.getInstance().logE("Error while parsing the shoutcast website");
                SRSOutput.getInstance().logE("Current text string was: " + this.text);
                e.printStackTrace();
                this.stopSearching = false;
                if (this.readGenresStream != null) {
                    try {
                        this.readGenresStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                block31: {
                    if (e.getMessage().startsWith("stream is closed")) {
                        this.stopSearching = true;
                        break block31;
                    }
                    e.printStackTrace();
                }
                this.stopSearching = false;
                if (this.readGenresStream != null) {
                    try {
                        this.readGenresStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            this.stopSearching = false;
            if (this.readGenresStream != null) {
                try {
                    this.readGenresStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Vector<String[]> getStreams() {
        return this.streams;
    }

    public String getBaseAddress() {
        String shoutcast = "http://yp.shoutcast.com/sbin/tunein-station.pls?id=";
        return shoutcast;
    }
}

