/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.SRSOutput;
import java.io.File;

public class Control_TestStartFirst {
    public String[][] searchPrograms() {
        String opsys = System.getProperty("os.name");
        if (opsys.startsWith("Linux")) {
            return this.searchProgrammsLinux();
        }
        if (opsys.startsWith("Windows")) {
            return this.searchProgrammsWindows();
        }
        return null;
    }

    public String[][] searchProgrammsLinux() {
        String[][] programNames = new String[][]{{"thunar", "konqueror", "nautilus", "dolphin"}, {"firefox", "firefox-bin", "iceweasel", "opera", "epiphany", "galeon"}, {"audacious", "qmmp", "beep-media-player", "xmms", "amarok", "mplayer"}, {"streamripper"}};
        String[] binPath = this.getPathBinLinux();
        if (binPath == null) {
            SRSOutput.getInstance().logE("No executable bin path found on the linux system");
            return null;
        }
        String[][] foundPrograms = new String[programNames.length][6];
        int i = 0;
        while (i < programNames.length) {
            int k = 0;
            int l = 0;
            while (l < programNames[i].length) {
                int j = 0;
                while (j < binPath.length) {
                    File temp = new File(String.valueOf(binPath[j]) + "/" + programNames[i][l]);
                    if (temp.exists()) {
                        foundPrograms[i][k] = String.valueOf(binPath[j]) + "/" + programNames[i][l];
                        ++k;
                    }
                    ++j;
                }
                ++l;
            }
            ++i;
        }
        return foundPrograms;
    }

    public String[] getPathBinLinux() {
        String pathBin = System.getenv("PATH");
        int countDoublePoint = 0;
        int i = 0;
        while (i < pathBin.length()) {
            if (pathBin.charAt(i) == ':') {
                ++countDoublePoint;
            }
            ++i;
        }
        i = 0;
        String[] pathArray = new String[countDoublePoint + 1];
        int g = 0;
        while (g < countDoublePoint + 1) {
            pathArray[g] = "";
            ++g;
        }
        countDoublePoint = 0;
        while (i < pathBin.length()) {
            if (pathBin.charAt(i) == ':') {
                ++countDoublePoint;
            } else {
                int n = countDoublePoint;
                pathArray[n] = String.valueOf(pathArray[n]) + pathBin.substring(i, i + 1);
            }
            ++i;
        }
        return pathArray;
    }

    public String[] getPathBinWindows() {
        String binPath = System.getenv("PATH");
        int countCommata = 0;
        int i = 0;
        while (i < binPath.length()) {
            if (binPath.charAt(i) == ';') {
                ++countCommata;
            }
            ++i;
        }
        i = 0;
        String[] pathArray = new String[countCommata + 2];
        int j = 0;
        while (j < countCommata + 2) {
            pathArray[j] = "";
            ++j;
        }
        int array = countCommata + 2;
        countCommata = 0;
        while (i < binPath.length()) {
            if (binPath.charAt(i) == ';') {
                ++countCommata;
            } else {
                int n = countCommata;
                pathArray[n] = String.valueOf(pathArray[n]) + binPath.substring(i, i + 1);
            }
            ++i;
        }
        pathArray[array - 1] = System.getenv("ProgramFiles");
        return pathArray;
    }

    public String[][] searchProgrammsWindows() {
        String[] exePath = this.getPathBinWindows();
        String[][] programNames = new String[][]{{"\\zabkat\\xplorer2", "\\explorer.exe"}, {"\\Mozilla Firefox\\firefox.exe", "\\Opera\\Opera.exe"}, {"\\Winamp\\winamp.exe", "\\Windows Media Player\\wmplayer.exe", "VideoLAN\\VLC\\vlc.exe"}, {"\\Streamripper\\streamripper.exe"}};
        String[][] foundPrograms = new String[programNames.length][4];
        int i = 0;
        while (i < programNames.length) {
            int k = 0;
            int l = 0;
            while (l < programNames[i].length) {
                int j = 0;
                while (j < exePath.length) {
                    File temp = new File(String.valueOf(exePath[j]) + programNames[i][l]);
                    if (temp.exists()) {
                        foundPrograms[i][k] = String.valueOf(exePath[j]) + programNames[i][l];
                        ++k;
                    }
                    ++j;
                }
                ++l;
            }
            ++i;
        }
        return foundPrograms;
    }
}

