/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.SRSOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Control_PlayList {
    public String[][] anlyseFile(String path) {
        File x = new File(path);
        SRSOutput.getInstance().log("Loading file ....");
        String[][] streams = null;
        Vector<String> titleVector = new Vector<String>(0, 1);
        Vector<String> addressVector = new Vector<String>(0, 1);
        Vector<String> websiteVector = new Vector<String>(0, 1);
        if (x.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(path));
                SRSOutput.getInstance().log("Successful loaded ....");
                String readBuffer = "";
                String address = "";
                String title = "";
                String website = "";
                if (path.endsWith(".pls")) {
                    while ((readBuffer = br.readLine()) != null) {
                        if (!address.equals("") && readBuffer.startsWith("File")) {
                            titleVector.addElement(address);
                            addressVector.addElement(title);
                            websiteVector.addElement(website);
                            address = "";
                            title = "";
                            website = "";
                        }
                        if (readBuffer.trim().startsWith("File")) {
                            address = readBuffer.substring(readBuffer.indexOf("=") + 1, readBuffer.length());
                        }
                        if (readBuffer.trim().startsWith("Title")) {
                            title = readBuffer.substring(readBuffer.indexOf("=") + 1, readBuffer.length());
                        }
                        if (!readBuffer.trim().startsWith("Website")) continue;
                        website = readBuffer.substring(readBuffer.indexOf("=") + 1, readBuffer.length());
                    }
                    titleVector.addElement(address);
                    addressVector.addElement(title);
                    websiteVector.addElement(website);
                    streams = new String[titleVector.capacity()][3];
                    int i = 0;
                    while (i < streams.length) {
                        streams[i][0] = ((String)titleVector.get(i)).toString();
                        streams[i][1] = ((String)addressVector.get(i)).toString();
                        streams[i][2] = ((String)websiteVector.get(i)).toString();
                        ++i;
                    }
                    return streams;
                }
                if (path.endsWith("m3u")) {
                    readBuffer = br.readLine();
                    if (readBuffer.trim().equals("#EXTM3U")) {
                        while ((readBuffer = br.readLine()) != null) {
                            if (!readBuffer.trim().startsWith("#EXTINF:")) continue;
                            address = readBuffer.substring(readBuffer.indexOf(",") + 1, readBuffer.length());
                            while ((readBuffer = br.readLine()) != null) {
                                if (readBuffer.trim().startsWith("#EXTSTREAMRIPSTAR:")) {
                                    website = readBuffer.substring(readBuffer.indexOf("=") + 1, readBuffer.length());
                                }
                                if (readBuffer.trim().startsWith("#")) continue;
                                title = readBuffer;
                                break;
                            }
                            titleVector.add(title);
                            addressVector.add(address);
                            websiteVector.add(website);
                            title = "";
                            address = "";
                            website = "";
                        }
                        streams = new String[titleVector.capacity()][3];
                        int i = 0;
                        while (i < streams.length) {
                            streams[i][0] = ((String)titleVector.get(i)).toString();
                            streams[i][1] = ((String)addressVector.get(i)).toString();
                            streams[i][2] = ((String)websiteVector.get(i)).toString();
                            ++i;
                        }
                        return streams;
                    }
                    if (!readBuffer.startsWith("#") || !readBuffer.trim().equals("")) {
                        titleVector.add("");
                        addressVector.add(readBuffer);
                        websiteVector.add("");
                    }
                    while ((readBuffer = br.readLine()) != null) {
                        if (!readBuffer.startsWith("#") || !readBuffer.trim().equals("")) {
                            titleVector.add("");
                            addressVector.add(readBuffer);
                            websiteVector.add("");
                        }
                        while ((readBuffer = br.readLine()) != null) {
                            if (readBuffer.startsWith("#") && readBuffer.trim().equals("")) continue;
                            titleVector.add("");
                            addressVector.add(readBuffer);
                            websiteVector.add("");
                        }
                    }
                    streams = new String[titleVector.capacity()][3];
                    int i = 0;
                    while (i < streams.length) {
                        streams[i][1] = ((String)titleVector.get(i)).toString();
                        streams[i][0] = ((String)addressVector.get(i)).toString();
                        streams[i][2] = ((String)websiteVector.get(i)).toString();
                        ++i;
                    }
                    return streams;
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                SRSOutput.getInstance().logE("Datei nicht gefunden");
            }
            catch (IOException e) {
                SRSOutput.getInstance().logE("I/O failed.");
            }
        } else {
            SRSOutput.getInstance().log("Could not find file");
        }
        return streams;
    }

    public String getPLSData(String[][] data) {
        String filteredData = "";
        filteredData = String.valueOf(filteredData) + "[playlist]\n";
        filteredData = String.valueOf(filteredData) + "NumberOfEntries=" + data.length + "\n";
        int i = 0;
        while (i < data.length) {
            filteredData = String.valueOf(filteredData) + "File" + (i + 1) + "=" + data[i][1] + "\n";
            filteredData = String.valueOf(filteredData) + "Title" + (i + 1) + "=" + data[i][0] + "\n";
            filteredData = String.valueOf(filteredData) + "Website" + (i + 1) + "=" + data[i][2] + "\n";
            ++i;
        }
        return filteredData;
    }

    public String getM3UData(String[][] data) {
        String filteredData = "";
        filteredData = String.valueOf(filteredData) + "#EXTM3U\n";
        int i = 0;
        while (i < data.length) {
            filteredData = String.valueOf(filteredData) + "#EXTINF:0," + data[i][0] + "\n";
            filteredData = String.valueOf(filteredData) + "#EXTSTREAMRIPSTAR:Website=" + data[i][2] + "\n";
            filteredData = String.valueOf(filteredData) + data[i][1] + "\n";
            ++i;
        }
        return filteredData;
    }
}

